"""
ExploitResult.py

Copyright 2007 Andres Riancho

This file is part of w3af, http://w3af.org/ .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
from w3af.core.controllers.misc.common_attack_methods import CommonAttackMethods


class ExploitResult(CommonAttackMethods):
    """
    This class represents the output of an attack plugin.

    :author: Andres Riancho (andres.riancho@gmail.com)
    """

    def __init__(self):
        super(ExploitResult, self).__init__()
        self._id = None

    def set_exploit_result_id(self, _id):
        """
        Each ExploitResult is identified by an unique number.
        :param id: The integer that identifies the ExploitResult
        """
        self._id = _id

    def get_exploit_result_id(self):
        return self._id

    def __repr__(self):
        msg = 'Need to implement __repr__ if you inherit from ExploitResult.'
        raise NotImplementedError(msg)

    __str__ = __repr__
