/*
 * make vf which simulates vert-BKfont-dvi by hor-BKfont-dvi
 * mkbkv2hjvf rml 10 rmlv /.../rmlv.tfm vch rmlvsy [VFDIR]
 *	rmlv.vf
 */
#include	<stdio.h>
#include	"defs.h"
#include	"vfcodes.h"
#include	"vchar.h"
#include	"bifont.h"

char *horfont;
char *vertfont;
int vfds;
char *vsy;
char *vfdir;
FILE *jfm, *vf;
int lastku;

/* set by readvchar */
extern struct vchar vchar[];
extern int depthratio;
extern int rdisp, ddisp, vdisp;

/* set by readjfm */
extern char header[];
extern char width[];
extern int id, nt, lh, bc, ec, nw, ds;
extern struct jfmfntinfo *jfmfi;

main(ac, av)
int ac;
char *av[];
{
    char name[64];

    if (av[1][0] == '-') {
	lastku = atoi(av[1]+1);
	--ac, av++;
    } else
	lastku = 5;
    horfont = av[1];
    vfds = atoi(av[2])<<20;
    vertfont = av[3];
    if ((jfm = fopen(av[4], "r")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[4]);
	exit(1);
    }
    if (!readjfm(jfm)) {
	fprintf(stderr, "%s is not jfm\n", av[4]);
	exit(1);
    }

    readvchar(av[5]);
    vsy = av[6];

    vfdir = (ac > 7) ? av[7] : "";
    sprintf(name, "%s%s.vf", vfdir, vertfont);
    if ((vf = fopen(name, "w")) == NULL) {
	fprintf(stderr, "cannot write %s\n", name);
	exit(1);
    }
    vertvf();
    fclose(vf);

    exit(0);
}

#define	makejis(k,t)	((k+0x20)*256+t+0x20)

vertvf()
{
    int ku, ten;
    long len;
    int i;

    putuint(vf, VF_PRE, 1);
    putuint(vf, VF_ID, 1);
    putuint(vf, 0, 1);	/* no comment */
    putbytes(vf, header, 2*4);	/* check sum & design size */

    fontdef(1, horfont);
    fontdef(VSY, vsy);

    vfchar0();
    for (ku = 1; ku <= lastku; ku++)
	for (ten = 1; ten <= 94; ten++)
	    vfchar(makejis(ku, ten));

    len = ftell(vf);
    for (i = 0; i < 4 - len%4; i++)
	putuint(vf, VF_POST, 1);
}

fontdef(f, fn)
int f;
char *fn;
{
    putuint(vf, FNT_DEF1, 1);
    putuint(vf, f, 1);
    putuint(vf, 0, 4);
    putuint(vf, VFRATIO, 4);
    putuint(vf, vfds, 4);
    putuint(vf, 0, 1);
    putuint(vf, strlen(fn), 1);
    putbytes(vf, fn, strlen(fn));
}

vfchar0()
{
    int pl = 0;
    int ct;
    int rn, dn;
    byte rb[sizeof(int)], db[sizeof(int)];

    rn = inttob(rb, rdisp, TRUE);
    pl += 1+rn;
    dn = inttob(db, ddisp, TRUE);
    pl += 1+dn;
    pl += 5;	/* DIR 3, SET2 jis */

    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, pl, 4);
    putuint(vf, 0, 4);	/* char 0 */
    putuint(vf, jfmfi->ch[0].tfmw, 4);
    putuint(vf, RIGHT1+rn-1, 1);
    putbytes(vf, rb, rn);
    putuint(vf, DOWN1+dn-1, 1);
    putbytes(vf, db, dn);
    putuint(vf, DIR, 1);
    putuint(vf, 3, 1);
    putuint(vf, SET2, 1);
    putuint(vf, 0x2121, 2);
}

vfchar(jis)
int jis;
{
    int pl = 0;
    int ct, n;
    int rd, dd;
    int rn, dn;
    byte rb[sizeof(int)], db[sizeof(int)];
    struct vchar *vc;

    ct = getctype(jis, jfmfi);
    for (vc = vchar; vc->cc != 0; vc++)
	if (vc->cc == jis)
	    break;
    if (vc->cc == 0)
	return;
    rn = inttob(rb, rdisp-vc->y, TRUE);
    pl += 1+rn;
    dn = inttob(db, ddisp-vc->x, TRUE);
    pl += 1+dn;
    if (vc->op != vop_shift)
	pl += 1;	/* FONT_00+f */
    pl += 2;	/* DIR 3 */
    if (vc->op == vop_shift)	/* SET2 jis */
	pl += 3;
    else	/* SETC_??? or SET1 c */
	pl += (vc->c <= SETC_127) ? 1 : 2;

    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, pl, 4);
    putuint(vf, jis, 4);
    putuint(vf, jfmfi->ch[ct].tfmw, 4);
    putuint(vf, RIGHT1+rn-1, 1);
    putbytes(vf, rb, rn);
    putuint(vf, DOWN1+dn-1, 1);
    putbytes(vf, db, dn);
    if (vc->op != vop_shift)
	putuint(vf, FONT_00+vc->f, 1);
    putuint(vf, DIR, 1);
    putuint(vf, 3, 1);
    if (vc->op == vop_shift) {
	putuint(vf, SET2, 1);
	putuint(vf, jis, 2);
    } else if (vc->c <= SETC_127)
	putuint(vf, vc->c, 1);
    else {
	putuint(vf, SET1, 1);
	putuint(vf, vc->c, 1);
    }
}
