/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is messagingmenu-extension
 *
 * The Initial Developer of the Original Code is
 * Canonical Ltd.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    Chris Coulson <chris.coulson@canonical.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

const Cu = Components.utils;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://ubuntuone/ctypes-utils.jsm");
Cu.import("resource://ubuntuone/glib.jsm");

var EXPORTED_SYMBOLS = [ "edataserver" ];

const EDATASERVER_LIBNAME = "edataserver-1.2";
const EDATASERVER_ABIS = [ 15, 14 ];

function edataserver_defines(lib) {
  this.ESourceList = ctypes.StructType("ESourceList");
  this.ESourceGroup = ctypes.StructType("ESourceGroup");
  this.ESource = ctypes.StructType("ESource");

  lib.lazy_bind("e_source_list_new_for_gconf_default", this.ESourceList.ptr, ctypes.char.ptr);
  lib.lazy_bind("e_source_list_ensure_group", this.ESourceGroup.ptr, this.ESourceList.ptr, ctypes.char.ptr, ctypes.char.ptr, glib.gboolean);
  lib.lazy_bind("e_source_group_peek_sources", glib.GSList.ptr, this.ESourceGroup.ptr);
  lib.lazy_bind("e_source_new", this.ESource.ptr, ctypes.char.ptr, ctypes.char.ptr);
  lib.lazy_bind("e_source_set_property", ctypes.void_t, this.ESource.ptr, ctypes.char.ptr, ctypes.char.ptr);
  lib.lazy_bind("e_source_group_add_source", glib.gboolean, this.ESourceGroup.ptr, this.ESource.ptr, ctypes.int);
  lib.lazy_bind("e_source_list_peek_group_by_base_uri", this.ESourceGroup.ptr, this.ESourceList.ptr, ctypes.char.ptr);
}

if (!edataserver)
  var edataserver = new ctypes_library(EDATASERVER_LIBNAME, EDATASERVER_ABIS, edataserver_defines);
