/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef COVMAT_SEEN
#define COVMAT_SEEN

#include "pdbMalloc.h"

void
PrintCovMatGnuPlot(const double **mat, const int dim, char *outfile);

void
SetupCovWeighting(CdsArray *cdsA);

int
CheckZeroVariances(CdsArray *cdsA);

void
CalcBfactC(CdsArray *cdsA);

void
CalcCovariances(CdsArray *scratchA);

void
MVCovMat(CdsArray *cdsA);

void
CalcCovMat(CdsArray *cdsA);

void
CalcCovMatOcc(CdsArray *cdsA);

void
CalcStructCovMat(CdsArray *cdsA);

void
CalcFullCovMat(CdsArray *cdsA);

void
CalcCovCds(Cds *cds, const double **covmat);

int
CovInvWeightLAPACK(CdsArray *cdsA);

void
CovMat2CorMat(double **CovMat, const int size);

void
CorMat2CovMat(double **CovMat, const double *vars, const int size);

double
NormalizeCovMat(double **mat, const int size);

void
PrintCovMat(CdsArray *cdsA);

void
InvgaussFitVars(CdsArray *cdsA, double *mean, double *lambda);

void
InvgaussAdjustVars(CdsArray *cdsA,
                   const double mean, const double lambda);

void
LognormalFitVars(CdsArray *cdsA, double *zeta, double *sigma);

void
LognormalAdjustVars(CdsArray *cdsA, double zeta, double sigma);

void
InvGammaFitVars(CdsArray *cdsA, int iterate);

void
InvGammaFitVars_c1(CdsArray *cdsA, double *b, double *c);

void
InvGammaFitVars_GaussVarVar(CdsArray *cdsA, double *b, double *c);

void
InvGammaFitVars_Mode(CdsArray *cdsA, double *b, double *c, const double mode);

void
InvGammaStacyFitVars(CdsArray *cdsA, double *b, double *c);

void
InvGammaMMFitVars(CdsArray *cdsA, double *b, double *c);

void
InvGammaAdjustVars(CdsArray *cdsA, const double b, const double c);

void
InvGammaAdjustCov(CdsArray *cdsA, const double b, const double c);

void
RecipInvGaussFitVars(CdsArray *cdsA, double *mu, double *lambda);

void
RecipInvGaussAdjustVars(CdsArray *cdsA,
                            const double mu, const double lambda);

#endif
