# -*- coding: utf-8 -*-
"""
This module contains code generation tools for the ufc::interior_integral class.
"""

# Copyright (C) 2008 Martin Sandve Alnes and Simula Resarch Laboratory
#
# This file is part of SyFi.
#
# SyFi is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# SyFi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SyFi. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2008-08-13
# Last changed: 2008-12-18

from sfc.common.output import sfc_error
from sfc.codegeneration.integralcg import IntegralCG

class InteriorFacetIntegralCG(IntegralCG):
    def __init__(self, itgrep):
        IntegralCG.__init__(self, itgrep)

    def gen_constructor(self):
        return ""
    
    def gen_destructor(self):
        return ""

    def gen_members(self):
        return ""
    
    def gen_tabulate_tensor_symbolic(self):
        return 'throw std::runtime_error("tabulate_tensor for interior facet integrals not implemented");'
    
    def gen_tabulate_tensor_quadrature(self):
        return 'throw std::runtime_error("tabulate_tensor for interior facet integrals not implemented");'
