# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # App certificate
    #
    class Certificate < MsRestAzure::Resource

      include MsRestAzure

      # @return [String] Friendly name of the certificate
      attr_accessor :friendly_name

      # @return [String] Subject name of the certificate
      attr_accessor :subject_name

      # @return [Array<String>] Host names the certificate applies to
      attr_accessor :host_names

      # @return [String] Pfx blob
      attr_accessor :pfx_blob

      # @return [String] App name
      attr_accessor :site_name

      # @return [String] Self link
      attr_accessor :self_link

      # @return [String] Certificate issuer
      attr_accessor :issuer

      # @return [DateTime] Certificate issue Date
      attr_accessor :issue_date

      # @return [DateTime] Certificate expriration date
      attr_accessor :expiration_date

      # @return [String] Certificate password
      attr_accessor :password

      # @return [String] Certificate thumbprint
      attr_accessor :thumbprint

      # @return [Boolean] Is the certificate valid?
      attr_accessor :valid

      # @return [String] Raw bytes of .cer file
      attr_accessor :cer_blob

      # @return [String] Public key hash
      attr_accessor :public_key_hash

      # @return [HostingEnvironmentProfile] Specification for the hosting
      # environment (App Service Environment) to use for the certificate
      attr_accessor :hosting_environment_profile


      #
      # Mapper for Certificate class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'Certificate',
          type: {
            name: 'Composite',
            class_name: 'Certificate',
            model_properties: {
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              kind: {
                required: false,
                serialized_name: 'kind',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              friendly_name: {
                required: false,
                serialized_name: 'properties.friendlyName',
                type: {
                  name: 'String'
                }
              },
              subject_name: {
                required: false,
                serialized_name: 'properties.subjectName',
                type: {
                  name: 'String'
                }
              },
              host_names: {
                required: false,
                serialized_name: 'properties.hostNames',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              pfx_blob: {
                required: false,
                serialized_name: 'properties.pfxBlob',
                type: {
                  name: 'String'
                }
              },
              site_name: {
                required: false,
                serialized_name: 'properties.siteName',
                type: {
                  name: 'String'
                }
              },
              self_link: {
                required: false,
                serialized_name: 'properties.selfLink',
                type: {
                  name: 'String'
                }
              },
              issuer: {
                required: false,
                serialized_name: 'properties.issuer',
                type: {
                  name: 'String'
                }
              },
              issue_date: {
                required: false,
                serialized_name: 'properties.issueDate',
                type: {
                  name: 'DateTime'
                }
              },
              expiration_date: {
                required: false,
                serialized_name: 'properties.expirationDate',
                type: {
                  name: 'DateTime'
                }
              },
              password: {
                required: false,
                serialized_name: 'properties.password',
                type: {
                  name: 'String'
                }
              },
              thumbprint: {
                required: false,
                serialized_name: 'properties.thumbprint',
                type: {
                  name: 'String'
                }
              },
              valid: {
                required: false,
                serialized_name: 'properties.valid',
                type: {
                  name: 'Boolean'
                }
              },
              cer_blob: {
                required: false,
                serialized_name: 'properties.cerBlob',
                type: {
                  name: 'String'
                }
              },
              public_key_hash: {
                required: false,
                serialized_name: 'properties.publicKeyHash',
                type: {
                  name: 'String'
                }
              },
              hosting_environment_profile: {
                required: false,
                serialized_name: 'properties.hostingEnvironmentProfile',
                type: {
                  name: 'Composite',
                  class_name: 'HostingEnvironmentProfile'
                }
              }
            }
          }
        }
      end
    end
  end
end
