# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # Description of a restore request
    #
    class RestoreRequest < MsRestAzure::Resource

      include MsRestAzure

      # @return [String] SAS URL to the container
      attr_accessor :storage_account_url

      # @return [String] Name of a blob which contains the backup
      attr_accessor :blob_name

      # @return [Boolean] True if the restore operation can overwrite target
      # site. "True" needed if trying to restore over an existing site.
      attr_accessor :overwrite

      # @return [String] Name of a site (Web App)
      attr_accessor :site_name

      # @return [Array<DatabaseBackupSetting>] Collection of databses which
      # should be restored. This list has to match the list of databases
      # included in the backup.
      attr_accessor :databases

      # @return [Boolean] Changes a logic when restoring a site with custom
      # domains. If "true", custom domains are removed automatically. If
      # "false", custom domains are added to
      # the site object when it is being restored, but that might
      # fail due to conflicts during the operation.
      attr_accessor :ignore_conflicting_host_names

      # @return [BackupRestoreOperationType] Operation type. Possible values
      # include: 'Default', 'Clone', 'Relocation'
      attr_accessor :operation_type

      # @return [Boolean] Gets or sets a flag showing if
      # SiteConfig.ConnectionStrings should be set in new site
      attr_accessor :adjust_connection_strings

      # @return [String] App Service Environment name, if needed (only when
      # restoring a site to an App Service Environment)
      attr_accessor :hosting_environment


      #
      # Mapper for RestoreRequest class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'RestoreRequest',
          type: {
            name: 'Composite',
            class_name: 'RestoreRequest',
            model_properties: {
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              kind: {
                required: false,
                serialized_name: 'kind',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              storage_account_url: {
                required: false,
                serialized_name: 'properties.storageAccountUrl',
                type: {
                  name: 'String'
                }
              },
              blob_name: {
                required: false,
                serialized_name: 'properties.blobName',
                type: {
                  name: 'String'
                }
              },
              overwrite: {
                required: false,
                serialized_name: 'properties.overwrite',
                type: {
                  name: 'Boolean'
                }
              },
              site_name: {
                required: false,
                serialized_name: 'properties.siteName',
                type: {
                  name: 'String'
                }
              },
              databases: {
                required: false,
                serialized_name: 'properties.databases',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'DatabaseBackupSettingElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'DatabaseBackupSetting'
                      }
                  }
                }
              },
              ignore_conflicting_host_names: {
                required: false,
                serialized_name: 'properties.ignoreConflictingHostNames',
                type: {
                  name: 'Boolean'
                }
              },
              operation_type: {
                required: false,
                serialized_name: 'properties.operationType',
                type: {
                  name: 'Enum',
                  module: 'BackupRestoreOperationType'
                }
              },
              adjust_connection_strings: {
                required: false,
                serialized_name: 'properties.adjustConnectionStrings',
                type: {
                  name: 'Boolean'
                }
              },
              hosting_environment: {
                required: false,
                serialized_name: 'properties.hostingEnvironment',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
