# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # This is an object used to store a full view of network features
    # (presently VNET integration and Hybrid Connections)
    # for a web app.
    #
    class NetworkFeatures < MsRestAzure::Resource

      include MsRestAzure

      # @return [String] The Vnet Name
      attr_accessor :virtual_network_name

      # @return [VnetInfo] The Vnet Summary view
      attr_accessor :virtual_network_connection

      # @return [Array<RelayServiceConnectionEntity>] The Hybrid Connections
      # Summary view
      attr_accessor :hybrid_connections


      #
      # Mapper for NetworkFeatures class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'NetworkFeatures',
          type: {
            name: 'Composite',
            class_name: 'NetworkFeatures',
            model_properties: {
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              kind: {
                required: false,
                serialized_name: 'kind',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              virtual_network_name: {
                required: false,
                serialized_name: 'properties.virtualNetworkName',
                type: {
                  name: 'String'
                }
              },
              virtual_network_connection: {
                required: false,
                serialized_name: 'properties.virtualNetworkConnection',
                type: {
                  name: 'Composite',
                  class_name: 'VnetInfo'
                }
              },
              hybrid_connections: {
                required: false,
                serialized_name: 'properties.hybridConnections',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'RelayServiceConnectionEntityElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'RelayServiceConnectionEntity'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
