# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Network
  #
  # A service client - single point of access to the REST API.
  #
  class NetworkManagementClient < MsRestAzure::AzureServiceClient
    include MsRestAzure
    include MsRestAzure::Serialization

    # @return [String] the base URI of the service.
    attr_accessor :base_url

    # @return Credentials needed for the client to connect to Azure.
    attr_reader :credentials

    # @return [String] Gets subscription credentials which uniquely identify
    # Microsoft Azure subscription. The subscription ID forms part of the URI
    # for every service call.
    attr_accessor :subscription_id

    # @return [String] Client Api Version.
    attr_reader :api_version

    # @return [String] Gets or sets the preferred language for the response.
    attr_accessor :accept_language

    # @return [Integer] Gets or sets the retry timeout in seconds for Long
    # Running Operations. Default value is 30.
    attr_accessor :long_running_operation_retry_timeout

    # @return [Boolean] When set to true a unique x-ms-client-request-id value
    # is generated and included in each request. Default is true.
    attr_accessor :generate_client_request_id

    # @return Subscription credentials which uniquely identify client
    # subscription.
    attr_accessor :credentials

    # @return [ApplicationGateways] application_gateways
    attr_reader :application_gateways

    # @return [ExpressRouteCircuitAuthorizations]
    # express_route_circuit_authorizations
    attr_reader :express_route_circuit_authorizations

    # @return [ExpressRouteCircuitPeerings] express_route_circuit_peerings
    attr_reader :express_route_circuit_peerings

    # @return [ExpressRouteCircuits] express_route_circuits
    attr_reader :express_route_circuits

    # @return [ExpressRouteServiceProviders] express_route_service_providers
    attr_reader :express_route_service_providers

    # @return [LoadBalancers] load_balancers
    attr_reader :load_balancers

    # @return [LocalNetworkGateways] local_network_gateways
    attr_reader :local_network_gateways

    # @return [NetworkInterfaces] network_interfaces
    attr_reader :network_interfaces

    # @return [NetworkSecurityGroups] network_security_groups
    attr_reader :network_security_groups

    # @return [PublicIPAddresses] public_ipaddresses
    attr_reader :public_ipaddresses

    # @return [RouteTables] route_tables
    attr_reader :route_tables

    # @return [Routes] routes
    attr_reader :routes

    # @return [SecurityRules] security_rules
    attr_reader :security_rules

    # @return [Subnets] subnets
    attr_reader :subnets

    # @return [VirtualNetworkPeerings] virtual_network_peerings
    attr_reader :virtual_network_peerings

    # @return [Usages] usages
    attr_reader :usages

    # @return [VirtualNetworkGatewayConnections]
    # virtual_network_gateway_connections
    attr_reader :virtual_network_gateway_connections

    # @return [VirtualNetworkGateways] virtual_network_gateways
    attr_reader :virtual_network_gateways

    # @return [VirtualNetworks] virtual_networks
    attr_reader :virtual_networks

    #
    # Creates initializes a new instance of the NetworkManagementClient class.
    # @param credentials [MsRest::ServiceClientCredentials] credentials to authorize HTTP requests made by the service client.
    # @param base_url [String] the base URI of the service.
    # @param options [Array] filters to be applied to the HTTP requests.
    #
    def initialize(credentials, base_url = nil, options = nil)
      super(credentials, options)
      @base_url = base_url || 'https://management.azure.com'

      fail ArgumentError, 'credentials is nil' if credentials.nil?
      fail ArgumentError, 'invalid type of credentials input parameter' unless credentials.is_a?(MsRest::ServiceClientCredentials)
      @credentials = credentials

      @application_gateways = ApplicationGateways.new(self)
      @express_route_circuit_authorizations = ExpressRouteCircuitAuthorizations.new(self)
      @express_route_circuit_peerings = ExpressRouteCircuitPeerings.new(self)
      @express_route_circuits = ExpressRouteCircuits.new(self)
      @express_route_service_providers = ExpressRouteServiceProviders.new(self)
      @load_balancers = LoadBalancers.new(self)
      @local_network_gateways = LocalNetworkGateways.new(self)
      @network_interfaces = NetworkInterfaces.new(self)
      @network_security_groups = NetworkSecurityGroups.new(self)
      @public_ipaddresses = PublicIPAddresses.new(self)
      @route_tables = RouteTables.new(self)
      @routes = Routes.new(self)
      @security_rules = SecurityRules.new(self)
      @subnets = Subnets.new(self)
      @virtual_network_peerings = VirtualNetworkPeerings.new(self)
      @usages = Usages.new(self)
      @virtual_network_gateway_connections = VirtualNetworkGatewayConnections.new(self)
      @virtual_network_gateways = VirtualNetworkGateways.new(self)
      @virtual_networks = VirtualNetworks.new(self)
      @api_version = '2016-06-01'
      @accept_language = 'en-US'
      @long_running_operation_retry_timeout = 30
      @generate_client_request_id = true
    end

    #
    # Checks whether a domain name in the cloudapp.net zone is available for use.
    #
    # @param location [String] The location of the domain name
    # @param domain_name_label [String] The domain name to be verified. It must
    # conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DnsNameAvailabilityResult] operation results.
    #
    def check_dns_name_availability(location, domain_name_label = nil, custom_headers = nil)
      response = check_dns_name_availability_async(location, domain_name_label, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Checks whether a domain name in the cloudapp.net zone is available for use.
    #
    # @param location [String] The location of the domain name
    # @param domain_name_label [String] The domain name to be verified. It must
    # conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def check_dns_name_availability_with_http_info(location, domain_name_label = nil, custom_headers = nil)
      check_dns_name_availability_async(location, domain_name_label, custom_headers).value!
    end

    #
    # Checks whether a domain name in the cloudapp.net zone is available for use.
    #
    # @param location [String] The location of the domain name
    # @param domain_name_label [String] The domain name to be verified. It must
    # conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def check_dns_name_availability_async(location, domain_name_label = nil, custom_headers = nil)
      fail ArgumentError, 'location is nil' if location.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'subscription_id is nil' if subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/CheckDnsNameAvailability'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'location' => location,'subscriptionId' => subscription_id},
          query_params: {'domainNameLabel' => domain_name_label,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || self.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        self.credentials.sign_request(req) unless self.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DnsNameAvailabilityResult.mapper()
            result.body = self.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
