/**
 * Provides the javascript to help during the uploading of images in
 * Horde_Form.
 *
 * @author     Marko Djukic <marko@oblo.com>
 * @copyright  2003-2014 Horde LLC
 * @license    LGPL-2.1 (http://www.horde.org/licenses/lgpl21)
 */

/**
 * Changes the src of an image target, optionally attaching a time value to the
 * URL to make sure that the image does update and not use the browser cache.
 *
 * @param string src              The source to insert into the image element.
 * @param string target           The target element.
 * @param optional bool no_cache  If set to true will append the time.
 *
 * @return bool  False to stop the browser loading anything.
 */
function showImage(src, target, no_cache)
{
    var img = document.getElementById(target), now;
    if (typeof no_cache == 'undefined') {
        no_cache = false;
    }

    if (no_cache) {
        now = new Date();
        src = src + '&' + now.getTime();
    }

    img.src = src;

    return false;
}

/**
 * Adds to the given source the height/width field values for the given target.
 *
 * @param string src           The source to append the resize params to.
 * @param string target        The target element.
 * @param optional bool ratio  If set to true will append fix the ratio.
 *
 * @return string  The modified source to include the resize data.
 */
function getResizeSrc(src, target, ratio)
{
    var width = document.getElementById('_w_' + target).value,
        height = document.getElementById('_h_' + target).value;
    if (typeof ratio == 'undefined') {
        ratio = 0;
    }

    src = src + '&' + 'v=' + width + '.' + height + '.' + ratio;

    return src;
}
