class puppet-cloudconfig ( $mycloudzone = 'test' , $snapshot = false, $volsize = '10', $volname = '', $clustername = '' ) {
    # Copy credentials first
    file { "/etc/cloudconfig":
        ensure  => directory,
        owner   => root,
        group   => root,
        mode    => 755,
    }
    # Installing cloudtype facter plugin
    file { facter-cloudtype:
        path    => "/usr/lib/ruby/1.8/facter/cloudtype.rb",
        owner   => root,
        group   => root,
        mode    => 444,
        source  => "puppet:///puppet-cloudconfig/cloudtype.rb",
    }
    # Installing volumeid facter plugin
    file { facter-volumeid:
        path    => "/usr/lib/ruby/1.8/facter/volumeid.rb",
        owner   => root,
        group   => root,
        mode    => 444,
        source  => "puppet:///puppet-cloudconfig/volumeid.rb",
    }

    # We call our custom function to determine what credentials we have in the puppetmaster
    $clustercloudtype = servercloudtype()

    if ( $clustercloudtype == "UEC" ) {
        $describe_instance = "/usr/bin/euca-describe-instances"
        $describe_volume = "/usr/bin/euca-describe-volumes"
        $create_volume = "/usr/bin/euca-create-volume"
        $attach_volume = "/usr/bin/euca-attach-volume"
        $describe_snapshot = "/usr/bin/euca-describe-snapshots"
        $tools_name = "euca2ools"
		$cloudsource = "/etc/cloudconfig/eucarc"
		$sourcecloud = ". /etc/cloudconfig/eucarc ; "
        # Installing required package
        package { "euca2ools": ensure => installed }
        # Copy auxiliary files
        file { cloudrc:
            path    => "/etc/cloudconfig/eucarc",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/eucarc",
        }
        file { "cloud-cert.pem":
            path    => "/etc/cloudconfig/cloud-cert.pem",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/cloud-cert.pem",
        }
        file { "euca-cert.pem":
            path    => "/etc/cloudconfig/euca-cert.pem",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/euca-cert.pem",
        }
        file { "euca-pk.pem":
            path    => "/etc/cloudconfig/euca-pk.pem",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/euca-pk.pem",
        }
    }
    elsif ( $clustercloudtype == "EC2" ) {
        $describe_instance = "/usr/bin/ec2-describe-instances"
        $describe_volume = "/usr/bin/ec2-describe-volumes"
        $create_volume = "/usr/bin/ec2-create-volume"
        $attach_volume = "/usr/bin/ec2-attach-volume"
        $describe_snapshot = "/usr/bin/ec2-describe-snapshots"
        $tools_name = "ec2-api-tools"
		$cloudsource = "/etc/cloudconfig/ec2rc"
		$sourcecloud = ". /etc/cloudconfig/ec2rc ; "
        # Installing required package
        package { "ec2-api-tools": ensure => installed }
        # Copy auxiliary files
        file { ec2rc:
            path    => "/etc/cloudconfig/ec2rc",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/ec2rc",
        }
        file { "ec2-cert.pem":
            path    => "/etc/cloudconfig/ec2-cert.pem",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/ec2-cert.pem",
        }
        file { "ec2-pk.pem":
            path    => "/etc/cloudconfig/ec2-pk.pem",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/ec2-pk.pem",
        }
    if ( $clustercloudtype == "NOVA" ) {
        $describe_instance = "/usr/bin/euca-describe-instances"
        $describe_volume = "/usr/bin/euca-describe-volumes"
        $create_volume = "/usr/bin/euca-create-volume"
        $attach_volume = "/usr/bin/euca-attach-volume"
        $describe_snapshot = "/usr/bin/euca-describe-snapshots"
        $tools_name = "euca2ools"
		$cloudsource = "/etc/cloudconfig/novarc"
		$sourcecloud = ". /etc/cloudconfig/novarc ; "
        # Installing required package
        package { "euca2ools": ensure => installed }
        # Copy auxiliary files
        file { cloudrc:
            path    => "/etc/cloudconfig/novarc",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/novarc",
        }
        file { "cloud-cert.pem":
            path    => "/etc/cloudconfig/cloud-cert.pem",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/cloud-cert.pem",
        }
        file { "nova-cert.pem":
            path    => "/etc/cloudconfig/nova-cert.pem",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/nova-cert.pem",
        }
        file { "nova-pk.pem":
            path    => "/etc/cloudconfig/nova-pk.pem",
            owner   => root,
            group   => root,
            mode    => 444,
            source  => "puppet:///puppet-cloudconfig/nova-pk.pem",
        }
    } else {
	alert("Cant perform cloud configuration without cloud credentials on the puppetmaster, please copy credentials at /etc/puppet/modules/puppet-cloudconfig/files")
    }

	exec { "cloudtype-var":
		path => "/bin:/usr/bin:/sbin",
		command => "echo '$clustercloudtype' > /tmp/.cloudtype",
		unless => "test -f /tmp/.cloudtype",
	}
	exec { "cloudsource-var":
		path => "/bin:/usr/bin:/sbin",
		command => "echo '$cloudsource' > /tmp/.cloudsource",
		unless => "test -f /tmp/.cloudsource",
	}

	package { "xfsprogs":
		ensure => installed,
        require => Package [$tools_name],
	}

	if ( $snapshot == false ) {
		if ( $volname == '' ) {
			exec { "create-volume":
				path => "/bin:/usr/bin:/sbin",
				command => "$sourcecloud $create_volume -s $volsize -z $mycloudzone | awk '{print \$2}' > /tmp/volumeid ; while [ \$($sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | grep -i creating | wc -l) -eq 1 ]; do sleep 2; done",
				require => Package["xfsprogs"],
				onlyif => "$sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | wc -l",
			}
			exec{"attach-volume":
				command => "touch /tmp/.start ; while [ \$($sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | grep -i creating | wc -l) -eq 1 ]; do sleep 2; done; $sourcecloud $attach_volume -i \$($describe_instance | grep $ipaddress | awk '{print \$2}' | head -n1) -d /dev/sdb \$(cat /tmp/volumeid) ; while [ \$(/sbin/fdisk -l /dev/sdb 2>/dev/null | wc -l) -eq 0 ]; do sleep 2; done",
				require => Exec["create-volume"],
				unless => "$sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | grep $ipaddress",
			}
			exec { "format-volume-master":
                path => "/bin:/usr/bin:/sbin",
                command => "mkfs.xfs /dev/sdb",
                unless => "df -T /dev/sdb 2> /dev/null | grep xfs",
                require => Exec["attach-volume"],
            }
		} else {
			exec{"attach-volume":
				command => "echo '$volname' > /tmp/volumeid ; while [ \$($sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | grep -i creating | wc -l) -eq 1 ]; do sleep 2; done; $sourcecloud $attach_volume -i \$($describe_instance | grep $ipaddress | awk '{print \$2}' | head -n1) -d /dev/sdb \$(cat /tmp/volumeid) ; while [ \$(/sbin/fdisk -l /dev/sdb 2>/dev/null | wc -l) -eq 0 ]; do sleep 2; done",
				require => Package["xfsprogs"],
				unless => "$sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | grep $ipaddress",
			}
            exec { "format-volume-master":
                path => "/bin:/usr/bin:/sbin",
                command => "true",
                unless => "df -T /dev/sdb 2> /dev/null | grep xfs",
                require => Exec["attach-volume"],
            }
    	}
		exec { "mount-mysql-volume-master":
			path => "/bin:/usr/bin",
			command => "mv /var/lib/mysql /var/lib/mysql.old ; mkdir /var/lib/mysql && echo '/dev/sdb /var/lib/mysql xfs noatime 0 0' | tee -a /etc/fstab && mount /var/lib/mysql",
			unless => "cat /etc/fstab | grep mysql",
			require => Exec["format-volume-master"],
		}
		# Exported resources
		@@file { "/tmp/${clustername}_master_volumeid":
			content => "$volumeid",
			tag => "ebs_${clustername}",
			require => File["facter-volumeid"],
			ensure => present,
		}

	}

	if ( $snapshot == true ) {
		File <<| tag == "ebs_${clustername}" |>> { require => Package["xfsprogs"] }
		exec { "recover-snapshot-id":
			path => "/bin:/usr/bin:/sbin",
			command => "$sourcecloud $describe_snapshot | grep \$(cat /tmp/${clustername}_master_volumeid) | grep -i complete | head -n1 | awk '{print \$2}' > /tmp/snapshotid",
			require => Exec["get_clusterinfo"],
			unless => "test -f /tmp/snapshotid",
		}
		exec { "create-volume-from-snapshot":
			path => "/bin:/usr/bin:/sbin",
			command => "$sourcecloud $create_volume --snapshot \$(cat /tmp/snapshotid) -z $mycloudzone | awk '{print \$2}' > /tmp/volumeid ; while [ \$($sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | grep -i creating | wc -l) -eq 1 ]; do sleep 2; done",
			require => Exec["recover-snapshot-id"],
			unless => "test -f /tmp/volumeid",
		}
		exec{"attach-volume":
			command => "touch /tmp/.start ; while [ \$($sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | grep -i creating | wc -l) -eq 1 ]; do sleep 2; done; $sourcecloud $attach_volume -i \$($describe_instance | grep $ipaddress | awk '{print \$2}' | head -n1) -d /dev/sdb \$(cat /tmp/volumeid) ; while [ \$(/sbin/fdisk -l /dev/sdb 2>/dev/null | wc -l) -eq 0 ]; do sleep 2; done",
			require => Exec["create-volume-from-snapshot"],
			unless => "$sourcecloud $describe_volume | grep \$(cat /tmp/volumeid) | grep $ipaddress",
		}
		exec { "mount-mysql-volume-slave":
			path => "/bin:/usr/bin",
			command => "mv /var/lib/mysql /var/lib/mysql.old ; mkdir /var/lib/mysql && echo '/dev/sdb /var/lib/mysql xfs noatime 0 0' | tee -a /etc/fstab && mount /var/lib/mysql",
			unless => "cat /etc/fstab | grep mysql",
			require => Exec["attach-volume"],
		}

	}
}
