class mpi_master( $clustername = $uniqueid, $mpd_listenport = "50071" )
{
  apt::ppa{"ppa:canonical-sig/thirdparty":}
  package{ "john": ensure => installed, require => Apt::Ppa["ppa:canonical-sig/thirdparty"] }
  package{ "mpich2": ensure => installed }
  package{ "openssh-client": ensure => installed }
  package{ "build-essential": ensure => installed }
  package{ "libmpich2-dev": ensure => installed }

  exec{"create_mpi_dir":
    command => "mkdir -p /etc/mpi",
    require => Package["mpich2"],
    unless => "test -d /etc/mpi",
  }

#   exec{"generate_${clustername}_ssh_keypair":
#     command => "/usr/bin/ssh-keygen -q -t rsa -N '' -f /etc/mpi/${clustername}_key",
#     require => [ Package["openssh-client"], Exec["create_mpi_dir"] ],
#     unless => "test -e /etc/mpi/${clustername}_key",
#   }
# 
#   @@file{"${clustername}_private_key":
#     name => "/etc/mpi/${clustername}_key",
#     require => Exec["generate_${clustername}_ssh_keypair"],
#     tag => "mpi_${clustername}",
#   }
# 
#   @@file{"${clustername}_public_key":
#     name => "/etc/mpi/${clustername}_key.pub",
#     require => Exec["generate_${clustername}_ssh_keypair"],
#     tag => "mpi_${clustername}",
#   }

  file{"${clustername}_mpd_master_config":
    name => "/etc/mpd.conf",
    content => template("/etc/puppet/modules/orchestra-mpi/templates/mpd.conf.master.erb"),
    ensure => present,
    owner => root,
    group => root,
    mode => 0600,
    #require => File["${clustername}_public_key", "${clustername}_private_key"],
  }
  
  @@file{"${clustername}_mpd_config":
    name => "/etc/mpi/mpd.conf",
    content => template("/etc/puppet/modules/orchestra-mpi/templates/mpd.conf.erb"),
    ensure => present,
    owner => root,
    group => root,
    mode => 0600,
    #require => Exec["create_mpi_dir"],
    tag => "mpi_${clustername}",
  }

  exec{"/usr/bin/mpd --daemon":
    require => File["${clustername}_mpd_master_config"],
    unless => "/bin/ps axf | /bin/grep \"/usr/bin/mpd --daemon\" | /bin/grep -v grep",
  }

} 
