define apt::source(
	$location = '',
	$release = 'natty',
	$repos = 'main',
	$key = false,
	$key_server = 'keyserver.ubuntu.com'
) {

	file { "${name}.list":
		name => "/etc/apt/sources.list.d/${name}.list",
		ensure => file,
		owner => root,
		group => root,
		mode => 644,
		content => template("/etc/puppet/modules/orchestra-apt/templates/source.list.erb"),
	}
	
	exec { "${name} apt update":
		command => "/usr/bin/apt-get update",
		subscribe => File["${name}.list"],
		refreshonly => true,
	}
	
	if $key != false {
		exec { "apt-key adv --keyserver ${key_server} --recv-keys ${key}":
			unless => "apt-key list | grep ${key}",
			before => File["${name}.list"],
		}
	}

}
