/*
 * myproxy.h
 *
 * Main public header for MyProxy library
 *
 */

#ifndef __MYPROXY_H
#define __MYPROXY_H

#define MYPROXY_VERSION "MYPROXYv2"	/* protocol version string */

/* compilation options */
#if defined(HAVE_LIBPAM)
#define MYPROXY_VERSION_PAM " PAM"
#else
#define MYPROXY_VERSION_PAM ""
#endif
#if defined(HAVE_LIBSASL2)
#define MYPROXY_VERSION_SASL " SASL"
#else
#define MYPROXY_VERSION_SASL ""
#endif
#if defined(BUILD_GSSAPI_PLUGIN)
#define MYPROXY_VERSION_KRB5 " KRB5"
#else
#define MYPROXY_VERSION_KRB5 ""
#endif
#if defined(HAVE_LIBLDAP)
#define MYPROXY_VERSION_LDAP " LDAP"
#else
#define MYPROXY_VERSION_LDAP ""
#endif
#if defined(HAVE_VOMS)
#define MYPROXY_VERSION_VOMS " VOMS"
#else
#define MYPROXY_VERSION_VOMS ""
#endif
#if defined(HAVE_OCSP)
#define MYPROXY_VERSION_OCSP " OCSP"
#else
#define MYPROXY_VERSION_OCSP ""
#endif

/* software version constants */
#define MYPROXY_VERSION_MAJOR 5
#define MYPROXY_VERSION_MINOR 5
#define MYPROXY_VERSION_MICRO 0
#define MYPROXY_VERSION_DATE "v5.5 5 Sep 2011"                        \
        MYPROXY_VERSION_PAM MYPROXY_VERSION_SASL MYPROXY_VERSION_KRB5 \
        MYPROXY_VERSION_LDAP MYPROXY_VERSION_VOMS MYPROXY_VERSION_OCSP

/*
 * myproxy_version()
 *
 * Returns a static string indicating the MyProxy library version.
 * Also sets major, minor, and micro version numbers if non-NULL.
 */
char *myproxy_version(int *major, int *minor, int *micro);

/*
 * myproxy_check_version()
 *
 * Returns 0 if MyProxy library version matches this header.
 * Returns 1 if major version number differs.
 * Returns 2 if minor version number differs.
 * Returns 3 if micro version number differs.
 *
 * Note: Requiring header and library version to match is recommended,
 * as the MyProxy struct types sometimes change.
 */
int myproxy_check_version_ex(int major, int minor, int micro);
#define myproxy_check_version() \
  myproxy_check_version_ex(MYPROXY_VERSION_MAJOR, MYPROXY_VERSION_MINOR, \
			   MYPROXY_VERSION_MICRO)

#include "myproxy_constants.h"
#include "myproxy_authorization.h"
#include "myproxy_protocol.h"
#include "myproxy_creds.h"
#include "myproxy_delegation.h"
#include "myproxy_log.h"
#include "myproxy_read_pass.h"
#include "myproxy_sasl_client.h"
#include "myproxy_sasl_server.h"
#include "myproxy_server.h"
#include "verror.h"

#endif /* __MYPROXY_H */
