import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, Distribution, build_po

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)

setup(name='elisa-plugin-base',
    version='0.16',
    description='Base Moovida components',
    long_description='Base Moovida components.',
    license='GPLv3', 
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'elisa.plugins.base.i18n': ['*.po', '*/LC_MESSAGES/*.mo', '*.pot']},
    entry_points="""
    [elisa.core.components.resource_provider]
    LocalResource = elisa.plugins.base.local_resource:LocalResource
    """,
    cmdclass=cmdclass,
    distclass=Distribution)
