# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
A base option screen.
"""

from elisa.plugins.poblesec.configuration.option_screen import OptionScreen

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.text import Text


class BaseScreenWidget(Widget):

    """
    A widget that contains a title and a summary for option screens.
    """

    def __init__(self):
        super(BaseScreenWidget, self).__init__()

        self.title = Text()
        self.add(self.title)
        self.title.visible = True

        self.summary = Text()
        self.add(self.summary)
        self.summary.visible = True

        self.update_style_properties(self.style.get_items())

    def clean(self):
        self.summary.clean()
        self.summary = None
        self.title.clean()
        self.title = None
        return super(BaseScreenWidget, self).clean()


class BaseScreen(OptionScreen):

    """
    A base option screen that displays a title and a short text to describe its
    purpose.

    This base class should be inherited and enriched to build more complex
    option screens.
    """

    def initialize(self):
        dfr = super(BaseScreen, self).initialize()
        dfr.addCallback(self._create_widget)
        dfr.addCallback(lambda x: self)
        return dfr

    def _create_widget(self, screen):
        self._base_widget = BaseScreenWidget()
        self.widget.add(self._base_widget)
        self._base_widget.size = (1.0, 1.0)
        self._base_widget.position = (0.0, 0.0, 0.0)
        self._base_widget.visible = True

    def clean(self):
        self._base_widget.clean()
        self._base_widget = None
        return super(BaseScreen, self).clean()

    def title__get(self):
        return self._base_widget.title.label

    def title__set(self, label):
        self._base_widget.title.label = label

    title = property(title__get, title__set)

    def summary__get(self):
        return self._base_widget.summary.label

    def summary__set(self, label):
        self._base_widget.summary.label = label

    summary = property(summary__get, summary__set)
