
; pao_pos.scm

(display"
Begin of pao_pos.scm

")


(display"
First some boolean RW-rules and THMS:

")


; (load "./boole.scm")

(load
 (string-append minlogpath
		"/examples/ordinals/boole.scm"))





(begin

(add-alg "pos"
	 '("One" "pos")
	 '("SZero" "pos=>pos")
	 '("SOne" "pos=>pos"))
(display-constructors "pos")

;   M A K E - N U M E R I C - T E R M

(define (make-numeric-term k)
  (cond ((= k 1)
	 (pt "One"))
	((even? k)
	 (make-term-in-app-form
	  (pt "SZero")
	  (make-numeric-term (/ k 2))))
	((odd? k)
	 (make-term-in-app-form
	  (pt "SOne")
	  (make-numeric-term (/ (- k 1) 2))))
	(else
	 (myerror "make-numeric-term"
		  "positive integer expected"
		  k))))


(begin
(display"
Test of (make-numeric-term)

")
(display "  42 = ")
(pp (pt"42"))
(display "1024 = ")
(pp (pt"1024"))
)



(define (is-numeric-term? term)
  (or
   (and (term-in-const-form? term)
	(string=? "One"
		  (const-to-name
		   (term-in-const-form-to-const term))))
   (and (term-in-app-form? term)
	(let ((op (term-in-app-form-to-op term)))
	  (and (term-in-const-form? op)
	       (let ((name (const-to-name (term-in-const-form-to-const op))))
		 (or (string=? "SZero" name) (string=? "SOne" name)))
	       (is-numeric-term? (term-in-app-form-to-arg term)))))))

(define (numeric-term-to-number term)
  (if (equal? term (pt "One"))
      1
      (let* ((op (term-in-app-form-to-op term))
	     (arg (term-in-app-form-to-arg term))
	     (name (const-to-name (term-in-const-form-to-const op))))
	(if (string=? "SZero" name)
	    (* 2 (numeric-term-to-number arg))
	    (+ 1 (* 2 (numeric-term-to-number arg)))))))



(begin
(display"
Test of (numeric-term-to-number)

")
(display(string-append"  42 = "
(number-to-string(numeric-term-to-number(pt "42")))))
(display(string-append"
1024 = "
(number-to-string(numeric-term-to-number (pt "1024")))"

"))
)
)



(begin

(add-program-constant
 "PosLESS"
 (mk-arrow (py "pos") (py "pos") (py "boole"))
 1 'const 2
)

(add-token
 "<"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (pconst-name-to-pconst "PosLESS")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "PosLESS"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "<"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules For PosLESS

(add-computation-rule (pt "pos < 1")(pt "False"))

(add-computation-rule
 (pt "1 < SZero pos")(pt "True"))
(add-computation-rule
 (pt "SZero pos1 < SZero pos2")
 (pt "pos1<pos2"))
(add-computation-rule
 (pt "SOne pos1 < SZero pos2")
 (pt "pos1<pos2"))

(add-computation-rule
 (pt "1 < SOne pos")
 (pt "True"))
(add-computation-rule
 (pt "SZero pos1 < SOne pos2")
 (pt "(pos2<pos1)=False"))
(add-computation-rule
 (pt "SOne pos1  < SOne pos2")
 (pt "pos1<pos2"))

(display-program-constants "PosLESS")

(display "
1023<1022  ")
(pp(nt(pt"1023<1022")))

)


(display "
< is irrflexsive

")

(set! COMMENT-FLAG #f)

(set-goal(pf"(pos<pos)=False"))

(ind)
(auto)

; Proof finished.

(add-rewrite-rule (pt"pos<pos") (pt "False"))



(display "
< is antisymmetric

")
(set-goal(pf"(pos1<pos2 and pos2<pos1)=False"))
(begin
(ind)
  (search)
(assume "pos1" "IH1")
(cases)
  (search)
(search)
(assume "pos2")
(ng)
(cases (pt"pos2<pos1"))
(auto)

(assume "pos1" "IH1")
(cases)
  (search)
(assume "pos2")
(ng)
(cases (pt"pos1<pos2"))
(auto)
)

; Proof finished.

(add-rewrite-rule
 (pt"(pos1<pos2 and pos2<pos1)")
 (pt "False"))

(begin
(display-program-constants "AndConst")
)





(display "
< is linear

")

(set-goal
 (pf"((pos1<pos2)=False
       and (pos2<pos1)=False
       and (pos1=pos2)=False) = F"))
(begin
(ind)
   (cases)
   (auto)
(assume "pos1" "IH1")
(cases)
  (auto)
(assume "pos1" "IH1")
(cases)
   (auto)
)
; Proof finished.

(add-rewrite-rule
 (pt"(pos1<pos2)=False
      and (pos2<pos1)=False
      and (pos1=pos2)=False")
 (pt "False"))

(display-program-constants "AndConst")


(display"
An often used form
of <-linearity

")


(set-goal
 (pf"(pos1<pos2->F)
      -> (pos2<pos1->F)
      -> pos1=pos2"))
(begin
(assume "pos1" "pos2" "2<=1" "1<=2")
(simp (pf"(pos1=pos2)=(((pos1=pos2)=False)=False)"))
(cut
 (pf"((pos1=pos2)=False)=((pos1<pos2)=False
  and (pos2<pos1)=False and (pos1=pos2)=False)"))
(auto)
(simp "1<=2")
(simp "2<=1")
(use "Truth-Axiom")
(cases (pt"pos1=pos2"))
(auto)
)
; Proof finished.

(save "PosLESSlin")
(display-theorems "PosLESSlin")


(display"
We extract a decision function
pos@pos -> boole
from the linerity theorem'
")

(set-goal
 (pf"ex boole1.
       (boole1=False -> ex boole2.
                      (boole2=False -> pos1<pos2)
                     &(boole2   -> pos2<pos1))
      &(boole1 -> pos1=pos2)"))
(begin
(assume "pos1" "pos2")
(use"BooleOr2")
(use "Truth-Axiom")

; Proof finished.
)

(save "PosLESSlinear")
(display-theorems "PosLESSlinear")



(animate "BooleOr2")
(animate "PosLESSlinear")
(set-goal
 (pf"right(cPosLESSlinear pos1 pos2)
     = (pos2<pos1)"))
(begin
  (assume "pos2" "pos1")
  (ng #t)
  (cases(pt"pos2=pos1"))
  (assume "2=1")
  (simp "2=1")
  (auto)
; Proof finished.
)
(save "Rlinear")
(deanimate "PosLESSlinear")
(deanimate "BooleOr2")
(display-theorems "Rlinear")



(begin
(deanimate "PosLESSlinear")
(deanimate"BooleOr2")
(animate"BooleOr2")
(animate "PosLESSlinear")
(display"

Test of cPosLESSlinear:

")
(display "
cPosLESSlinear     3     1    ")
(pp(nt(pt"cPosLESSlinear     3     1")))
(display "
cPosLESSlinear    42    42    ")
(pp(nt(pt"cPosLESSlinear    42    42")))
(display "
cPosLESSlinear  1023  1024   ")
(pp(nt(pt"cPosLESSlinear  1023  1024")))
(deanimate "PosLESSlinear")
(deanimate"BooleOr2")
)




(display "


Extraction of cposMAX: ord@ord -> ord

")
(animate "BooleOr2")
(animate "PosLESSlinear")
(set-goal
 (pf"ex pos.
     ((pos1<pos)=False and (pos1=pos)=False)=False
 and (     (pos2<pos and pos1=pos)=False
       and (pos=pos2)=False              )=False"))
(begin
(assume "pos1" "pos2")
(cases (pt "right(cPosLESSlinear pos1 pos2)"))
(assume "r")
(ex-intro(pt"pos1"))
(ng #t)
(simp "<-" "Rlinear")
(simp "r")
(use "Truth-Axiom")
(assume "not r")
(ex-intro(pt"pos2"))
(ng #t)
(cases(pt"pos1<pos2"))
  (auto)
(assume "not1<2")
(ng #t)
(simp"BooleStab")
(use "PosLESSlin")
(use "not1<2")
(simp "<-" "Rlinear")
(use "not r")
; ok, ?_20 is proved.  Proof finished.
)
(save "posMAX")
(deanimate "PosLESSlinear")
(deanimate "BooleOr2")
(display-theorems "posMAX")




(begin
(deanimate "posMAX")
(deanimate "PosLESSlinear")
(deanimate"BooleOr2")
(animate"BooleOr2")
(animate "PosLESSlinear")
(animate "posMAX")
(display"

Test of cposMAX:

")
(display "
cposMAX     3     1    ")
(pp(nt(pt"cposMAX     3     1")))
(display "
cposMAX    42    42    ")
(pp(nt(pt"cposMAX    42    42")))
(display "
cposMAX  1023  1024   ")
(pp(nt(pt"cposMAX  1023  1024")))
(deanimate "posMAX")
(deanimate "PosLESSlinear")
(deanimate"BooleOr2")
)







(animate"posMAX")
(set-goal(pf "cposMAX 1 pos = pos"))
(begin
(assume "pos")
(ng #t)
(simp (pf"right(cPosLESSlinear 1 pos)=False"))
(use "Truth-Axiom")
(simp "Rlinear")
(use "Truth-Axiom")
; Proof finished.
)

(save "posMAX1n")
(deanimate"posMAX")
(display-theorems "posMAX1n")




(display "


< is transitive

(takes a while !)
")



(set-goal
 (pf"((pos1<pos2 and pos2<pos3 and ((pos1<pos3)=False))=False)
  and((pos3<pos1 and pos1<pos2 and ((pos3<pos2)=False))=False)
  and((pos2<pos3 and pos3<pos1 and ((pos2<pos1)=False))=False)"))
(time(begin
(ind)
(cases)
  (ng)
  (search)
(assume "pos2")
(cases)
(auto)
(assume "pos2")
(cases)
(auto)

(assume "pos1" "IH1")
(cases)
  (search)
(assume "pos2")
(cases)
(auto)
(assume "pos3")
(ng)
(cases(pt"pos1<pos3"))
(drop "IH1")
(assume "1<3")
(ng)
(simp (pf"(pos3<pos1)=False"))
(simp (pf"(pos3<pos1)=False"))
(ng)
(use "Truth-Axiom")
(simp (pf"F=(pos1<pos3 and pos3<pos1)"))
(simp "1<3")
(use "Truth-Axiom")
(use "Truth-Axiom")
(simp (pf"F=(pos1<pos3 and pos3<pos1)"))
(simp "1<3")
(use "Truth-Axiom")
(use "Truth-Axiom")

; ?_28: (pos1<pos3 -> F) ->...

(assume "3<=1")
(simp
 (pf"(pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False
  -> (pos1<pos2 and (pos3<pos2)=False and ((pos3<pos1)=False)=False)=False"))
(cut
 (pf"((pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False)
 and ((pos3<pos1 and pos1<pos2 and (pos3<pos2)=False)=False)
 and ((pos2<pos3 and pos3<pos1 and (pos2<pos1)=False)=False)"))
(drop "IH1")
(simp(pf"(pos1<pos3)=False"))
(ng)
(cases(pt"pos3<pos1"))
(assume "3<1")
(ng)
(cases (pt"pos2<pos3"))
(assume "2<3")
(ng)
(simp(pf"(pos3<pos2)=False"))
(ng)
(auto)
(simp(pf"F=(pos2<pos3 and pos3<pos2)"))
(simp "2<3")
(auto)
(assume "3<=2")
(ng)
(cases (pt"pos3<pos2"))
   (auto)
(assume "2<=3")
(ng)
(simp(pf"pos2=pos3"))
(simp "3<1")
(auto)
(use "PosLESSlin")
(auto)
(simp "3<=1")
(use "Truth-Axiom")
(use "IH1")
(cut
 (pf"((pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False)
 and ((pos3<pos1 and pos1<pos2 and (pos3<pos2)=False)=False)
 and ((pos2<pos3 and pos3<pos1 and (pos2<pos1)=False)=False)"))
(cases (pt"(pos3<pos1 and pos1<pos2 and (pos3<pos2)=False)"))
(strip 1)
(use "Efq-Atom")
(strip 1)
(cases
 (pt"(     pos2<pos3
      and  pos3<pos1
      and (pos2<pos1)=False)"))
(strip 1)
(use "Efq-Atom")
(auto)
(simp "3<=1")
(ng)
(cases (pt "pos3<pos1"))
(assume "3<1")
(cases (pt"pos3<pos2"))
(auto)
(assume "2<=3")
(ng)
(cases (pt"pos2<pos3"))
(auto)
(assume "3<=2")
(ng)
(simp (pf"pos2=pos3"))
(simp "3<=1")
(auto)
(use "PosLESSlin")
(auto)

(assume "pos2")
(ng)
(cases(pt"pos2<pos1"))
  (auto)
(assume "1<=2")
(ng)
(cases)
   (auto)
(assume "pos3")
(ng)
(simp (pf "(((pos2<pos3)=False)=False)=(pos2<pos3)"))
(cut
 (pf"((pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False)
 and ((pos3<pos1 and pos1<pos2 and (pos3<pos2)=False)=False)
 and ((pos2<pos3 and pos3<pos1 and (pos2<pos1)=False)=False)"))
(drop "IH1")
(simp "1<=2")
(ng)
(cases (pt"pos1<pos2"))
(assume "1<2")
(ng)
(cases (pt"pos3<pos2"))
(assume "3<2")
(simp(pf"(pos2<pos3)=False"))
(auto)
(simp(pf"F=(pos2<pos3 and pos3<pos2)"))
(simp "3<2")
(auto)
(assume "2<=3")
(cases (pt"pos2<pos3"))
   (auto)
(assume "2<=1")
(ng)
(simp(pf"pos1=pos2"))
(ng)
(assume "T")
(cases(pt"pos2<pos3"))
(auto)
(use "PosLESSlin")
(auto)
(cases(pt"pos2<pos3"))
(auto)

(ng)
(assume "pos3")
(simp (pf "(((pos3<pos1)=False)=False)=(pos3<pos1)"))
(cut
 (pf"((pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False)
 and ((pos3<pos1 and pos1<pos2 and (pos3<pos2)=False)=False)
 and ((pos2<pos3 and pos3<pos1 and (pos2<pos1)=False)=False)"))
(drop "IH1")
(simp "1<=2")
(ng)
(cases(pt"pos1<pos2"))
(assume "1<2")
(ng)
(cases(pt"(pos2<pos3 and (pos1<pos3)=False)"))
(strip 1)
(use "Efq-Atom")
(strip 1)
(ng)
(cases(pt"(pos2<pos3 and pos3<pos1)"))
(auto)
(assume "2<=1")
(ng)
(cases (pt"pos2<pos3"))
(assume "2<3")
(simp(pf"(pos3<pos2)=False"))
(auto)
(simp(pf"F=(pos2<pos3 and pos3<pos2)"))
(simp "2<3")
(auto)
(ng)
(assume "3<=2" "T")
(cases (pt"pos3<pos2"))
   (auto)
(assume "2<=3")
(ng)
(simp(pf"pos3=pos2"))
(simp "1<=2")
(use "Truth-Axiom")
(use "PosLESSlin")
(auto)
(cases(pt"pos3<pos1"))
(auto)

(ng)
(assume "pos1" "IH1")
(cases)
  (auto)
(assume "pos2")
(ng)
(simp(pf"(((pos1<pos2)=False)=False)=(pos1<pos2)"))
(cases)
  (auto)
(assume "pos3")
(ng)
(cases(pt"pos1<pos3"))
   (auto)
(assume "3<=1")
(cut
 (pf"((pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False)
 and ((pos3<pos1 and pos1<pos2 and (pos3<pos2)=False)=False)
 and ((pos2<pos3 and pos3<pos1 and (pos2<pos1)=False)=False)"))
(simp "3<=1")
(ng)
(cases(pt"pos3<pos1"))
(assume "3<1")
(ng)
(cases(pt"pos1<pos2"))
(assume "1<2")
(simp(pf"(pos2<pos1)=False"))
(auto)
(simp(pf"F=(pos2<pos1 and pos1<pos2)"))
(simp "1<2")
(auto)
(assume "1<=3")
(ng)
(simp(pf"pos3=pos1"))
(ng)
(cases(pt"pos1<pos2"))
(auto)
(use "PosLESSlin")
(auto)

(assume "pos3")
(ng)
(cases(pt"pos3<pos2"))
   (auto)
(assume "2<=3")
(cut
 (pf"((pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False)
 and ((pos3<pos1 and pos1<pos2 and (pos3<pos2)=False)=False)
 and ((pos2<pos3 and pos3<pos1 and (pos2<pos1)=False)=False)"))
(simp "2<=3")
(ng)
(cases(pt"pos2<pos3"))
(assume "2<3")
(ng)
(cases(pt"pos2<pos1"))
(assume "2<1")
(simp(pf"(pos1<pos2)=False"))
(auto)
(simp(pf"F=(pos2<pos1 and pos1<pos2)"))
(simp "2<1")
(auto)
(assume "1<=2")
(ng)
(cases(pt"pos1<pos2"))
(assume "1<2")
(auto)
(assume "3<=2")
(ng)
(simp(pf"pos3=pos2"))
(ng)
(cases(pt"pos1<pos2"))
(auto)
(use"PosLESSlin")
(auto)
(cases(pt"pos1<pos2"))
(auto)

(ng)
(assume "pos2")
(cases)
   (auto)
(assume "pos3")
(ng)
(cases(pt"pos1<pos3"))
   (auto)
(assume "3<=1")
(simp(pf"(((pos2<pos3)=False)=False)=(pos2<pos3)"))
(cut
 (pf"((pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False)
 and ((pos3<pos1 and pos1<pos2 and (pos3<pos2)=False)=False)
 and ((pos2<pos3 and pos3<pos1 and (pos2<pos1)=False)=False)"))
(simp "3<=1")
(ng)
(cases(pt"pos3<pos1"))
(assume "3<1")
(ng)
(cases(pt"pos3<pos2"))
   (auto)
(assume "2<=3")
(ng)
(cases(pt"pos1<pos2"))
(assume "1<2")
(use "Efq-Atom")
(auto)
(assume "1<=3")
(ng)
(simp(pf"pos1=pos3"))
(ng)
(cases(pt"pos2<pos3"))
(auto)
(use "PosLESSlin")
(auto)
(cases(pt"pos2<pos3"))
(auto)
))
; Proof finished.

(save "PosLESSbigtrans")
(display-theorems "PosLESSbigtrans")


(display"

We want to add the Thm as rewrite-rule:

")

(set-goal
 (pf"((pos1<pos2 and pos2<pos3 and ((pos1<pos3)=False))=False)"))
(begin
(assume "pos1" "pos2" "pos3")
(cut
 (pf"((pos1<pos2 and pos2<pos3 and ((pos1<pos3)=False))=False)
 and ((pos3<pos1 and pos1<pos2 and ((pos3<pos2)=False))=False)
 and ((pos2<pos3 and pos3<pos1 and ((pos2<pos1)=False))=False)"))
(cases
 (pt"pos3<pos1 and pos1<pos2 and (pos3<pos2)=False"))
(strip 1)
(use "Efq-Atom")
(strip 1)
(cases
 (pt"pos2<pos3 and pos3<pos1 and (pos2<pos1)=False"))
(strip 1)
(use "Efq-Atom")
(auto)
(use "PosLESSbigtrans")
)
; Proof finished.


(add-rewrite-rule
 (pt "pos1<pos2 and pos2<pos3 and ((pos1<pos3)=False)")
 (pt "False"))
(display-program-constants "AndConst")





(display"
An often used form
of <-transitivity

")


(set-goal (pf"pos1<pos2->pos2<pos3->pos1<pos3"))
(begin
(assume "pos1" "pos2" "pos3" "1<2" "2<3")
(cases(pt"pos1<pos3"))
(auto)
(assume "3<=1")
(simp "<-" (pf"(pos1<pos2 and pos2<pos3 and (pos1<pos3)=False)=False"))
(simp "1<2")
(simp "2<3")
(simp "3<=1")
(auto)
)
; Proof finished.

(save "PosLESStrans")
(display-theorems "PosLESStrans")





(display"


For every pos,
there exists a successor !

PROOF:
")

(set-goal
 (pf"ex pos2.all pos3.(             pos1<pos2
                        and (pos1<pos3 and pos3<pos2)=False)"))
(time(begin
(ind)
  (ex-intro(pt"2"))
  (cases)
  (auto)

; n -> 2n
(assume "pos1" "IH1")
(drop "IH1")
(ex-intro(pt"SOne pos1"))
(cases)
(auto)

; n -> 2n+1
(assume "pos1" "IH1")
(ex-elim "IH1")
(assume "pos" "IHpos")
(ex-intro(pt"SZero pos"))
(cases)
(use-with "IHpos" (pt"pos"))
(auto)
))
; Proof finished.

(save "posS")
(display-theorems "posS")

;(add-theorem "posS_Soundness"
;	     (np(proof-to-soundness-proof 
;		 (theorem-name-to-proof "posS"))))
;(display-theorems "posS_Soundness")



(begin
(deanimate "posS")
(animate "posS")
; (show-output)
(display"

Test of cposS:

")
(display "
cposS    1 ")
(pp(nt(pt"cposS 1")))
(display "
cposS   42 ")
(pp(nt(pt"cposS 42")))
(display "
cposS 1023 ")
(pp(nt(pt"cposS 1023")))
(display "
cposS 123456789098765432123456789   ")
(pp(nt(pt"cposS 123456789098765432123456789")))
; (hide-output)
(deanimate "posS")
)




(animate "posS")
(set-goal(pf"cposS 1=2"))
(use"Truth-Axiom")
(save"S1")
(deanimate "posS")
(display-theorems"S1")




(animate "posS")
(set-goal(pf"(cposS pos=1)=False"))
(cases)
(auto)
; Proof finished
(save "OneNonSucS")
(deanimate "posS")
(display-theorems "OneNonSucS")









(display"


For every pos,
there exists a predecessor !

PROOF:
")

(animate "posS")
(set-goal
 (pf"ex pos2.
      ((pos1=1 and pos2=1)=False and (pos1=cposS pos2)=False)=False"))
(time(begin
(ind)
  (ex-intro(pt"1"))
  (auto)
(assume "pos1" "IH1")
(cases(pt"pos1=1"))
(assume "1=1")
(simp "1=1")
(drop "IH1")
(ex-intro(pt"1"))
(auto)
(assume "1>1")
(ex-elim "IH1")
(drop "IH1")
(assume "pos" "IH")
(ex-intro(pt"SOne pos"))
(cut(pf"((pos1=1 and pos=1)=False and (pos1=cposS pos)=False)=False"))
(ng)
(simp "1>1")
(auto)

(assume "pos1" "IH1")
(drop "IH1")
(ex-intro(pt"SZero pos1"))
(auto)
; Proof finished.
))

(save "posP")
(display-theorems "posP")

(add-theorem "posP_Soundness"
	     (np(proof-to-soundness-proof 
		 (theorem-name-to-proof "posP"))))
(display-theorems "posP_Soundness")
(deanimate "posS")




(begin
(deanimate "posP")
(animate "posP")
; (show-output)
(display"

Test of cposP:

")

(display "
cposP    1 ")
(pp(nt(pt"cposP 1")))
(display "
cposP   42 ")
(pp(nt(pt"cposP 42")))
(display "
cposP 1023 ")
(pp(nt(pt"cposP 1023")))
(display "
cposP 123456789098765432123456789   ")
(pp(nt(pt"cposP 123456789098765432123456789")))
; (hide-output)
(deanimate "posP")
)




(animate "posS")
(animate "posP")
(set-goal
 (pf"SZero pos=cposS(cposP(SZero pos))"))
(begin
(assume "pos")
(inst-with-to "posP_Soundness"
	      (pt"SZero pos") "P_Sound2pos")
(ng)
(simp-with "<-" "BooleStab"
   (pt"SZero pos=
       (Rec pos=>pos)2([pos0,pos1]SOne pos0)([pos0]SZero)[if (pos=1) 1 (SOne((Rec pos=>pos)1([pos0,pos1][if (pos0=1) 1 (SOne pos1)])([pos0,pos1]SZero pos0)pos))]"))
(use  "P_Sound2pos")
; Proof finished.
)
(save "SP2n")
(display-theorems  "SP2n")


(set-goal
 (pf"SOne pos=cposS(cposP(SOne pos))"))
(auto)

; Proof finished.

(save "SP2n+1")
(display-theorems  "SP2n+1")
(deanimate "posS")
(deanimate "posP")






(animate"posS")
(animate"posP")
(set-goal (pf"all pos.cposP(cposS pos)=pos"))
(begin
(ind)
  (auto)
(cases)
(auto)
)
; Proof finished.
(save"posPS")
(deanimate"posS")
(deanimate"posP")
(display-theorems "posPS")






(display"

ADDITION

")




(add-ids
  (list
   (list "PosADD"
	 (make-arity (py "pos") (py "pos") (py "pos"))))
  '("allnc pos.PosADD pos 1 (cposS pos)")
  '("allnc pos1,pos2,pos3.
       PosADD pos1 pos2 pos3
    -> PosADD pos1 (cposS pos2) (cposS pos3)"))


(display"
n+1=k -> k=Sn

PROOF:
")

(animate "posS")
(set-goal
 (pf"PosADD pos1 pos2 pos3 -> pos2=1 -> pos3=cposS pos1"))
(begin
(assume "pos2" "pos1" "pos3")
(elim)
(auto)
(assume "pos4" "pos5" "pos6" "+" "IH")
(simp "OneNonSucS")
(use "Efq-Atom")
; ok, ?_6 is proved.  Proof finished.
)
(save "posPlusOne")
(display-theorems "posPlusOne")
(deanimate "posS")





(display"
n+k=1 -> F

")

(set-goal
 (pf"PosADD pos1 pos2 pos3->pos3=1->F"))
(begin
(assume "pos1" "pos2" "pos3")
(elim)
(assume "pos4")
(simp "OneNonSucS")
(auto)
(strip 5)
(simp "OneNonSucS")
(auto)

; Proof finished.
)
(save "PosOneNoSum")
(display-theorems "PosOneNoSum")




(set-goal(pf"PosADD pos1 pos2 1->F"))
(begin
(assume "pos1" "pos2")
(inst-with-to "PosOneNoSum"
	      (pt"pos1")
	      (pt"pos2")
	      (pt "1") "PosOneNoSum121")
(auto)

; Proof finished.
)
(save "PosOneNoSum1")
(display-theorems "PosOneNoSum1")





(display"
k+l=m -> m+l=n -> k+2l=n

PROOF:
")

(begin

(display "
Left as an exercise
for the MiNLOG newcomer.
")

(aga "posPlusDouble" (pf "all pos1,pos2,pos3,pos4.
                           PosADD pos1 pos2 pos3
                        -> PosADD pos3 pos2 pos4
                        -> PosADD pos1 (SZero pos2) pos4"))
(display-global-assumptions  "posPlusDouble")

;(set-goal
; (pf"all pos1.PosADD pos1 pos2 pos3
;           -> PosADD pos3 pos2 pos4
;           -> PosADD pos1 (SZero pos2) pos4"))
; (cases)
; (simp(pf"2=cposS 1"))
; (assume "pos3" "pos4" "pos1")
; (assume "S1" "SS1")
; (simp(pf"pos4=cposS pos3"))
; (intro 1)
; (auto)
; (use "posPlusOne" (pt"1"))
; (use "SS1")
; (auto)

; (assume "pos2" "pos3" "pos4" "pos1" "1+2*2=3" "3+2*2=4")


; (display"

; Until here !!!
; ")


; (simp
;  (pf"SZero (SZero pos2)
;      = cposS(cposP (SZero (SZero pos2)))"))
; (simp(pf"pos4=cposS(cposP pos4)"))
; (intro 1)
; (ng #t)
; (cases(pt"pos2=1"))
; (assume "2=1")
; (ng #t)
; (simp (pf"3=cposS 2"))
)


(display"
n = k+2l -> Sn = k+(2l+1)

PROOF"
)
(animate "posS")
(set-goal
 (pf"PosADD pos1 (SZero pos2) pos3
  -> PosADD pos1 (SOne pos2) (cposS pos3)"))
(begin
(assume "pos1" "pos2" "pos3" "3=1+2*2")
(simp (pf"SOne pos2 = cposS(SZero pos2)"))
(intro 1)
(auto)

; Proof finished.
)
(save"posPlusDoubleToDouble1")
(display-theorems"posPlusDoubleToDouble1")
(deanimate "posS")




(begin

(add-program-constant
 "PosPlus"
 (mk-arrow (py "pos") (py "pos") (py "pos"))
 1 'const 2
)

; Computation Rules For PosPlus

(add-computation-rule
 (pt "PosPlus 1 1")
 (pt "2"))
(add-computation-rule
 (pt "PosPlus (SZero pos) 1")
 (pt "SOne pos"))
(add-computation-rule
 (pt "PosPlus (SOne pos) 1")
 (pt "SZero (PosPlus pos 1)"))

(add-computation-rule
 (pt "PosPlus 1 (SZero pos2)")
 (pt "SOne pos2"))
(add-computation-rule
 (pt "PosPlus (SZero pos1) (SZero pos2)")
 (pt "SZero(PosPlus pos1 pos2)"))
(add-computation-rule
 (pt "PosPlus (SOne pos1) (SZero pos2)")
 (pt "SOne(PosPlus pos1 pos2)"))

(add-computation-rule
 (pt "PosPlus 1 (SOne pos2)")
 (pt "SZero (PosPlus pos2 1)"))
(add-computation-rule
 (pt "PosPlus (SZero pos1) (SOne pos2)")
 (pt "SOne(PosPlus pos1 pos2)"))
(add-computation-rule
 (pt "PosPlus (SOne pos1) (SOne pos2)")
 (pt "SZero(PosPlus(PosPlus pos1 pos2) 1)"))
; (show-output)
(display-program-constants "PosPlus")

(display"

Test of PosPlus:

")

(display "
PosPlus     3     1    ")
(pp(nt(pt"PosPlus     3     1")))
(display "
PosPlus    42    42    ")
(pp(nt(pt"PosPlus    42    42")))
(display "
PosPlus  1024  1023   ")
(pp(nt(pt"PosPlus  1024  1023")))
; (hide-output)
)




(begin
(display"


We favour defined function PosPlus:

")
(add-token
 "+"
 'add-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (pconst-name-to-pconst "PosPlus")) x y)))

(add-display
 (py "pos")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
          (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
              (string=? "PosPlus"
                        (const-to-name (term-in-const-form-to-const op)))
              (= 2 (length args)))
         (list 'add-op "+"
               (term-to-token-tree (car args))
               (term-to-token-tree (cadr args)))
         #f))))
; (show-output)
(display-program-constants "PosPlus")
; (hide-output)
)


(display"
 1 < pos+1

PROOF:
")
(set-goal(pf"1<(pos+1)"))
(cases)
(auto)
; Proof finished.

(add-rewrite-rule(pt"1<(pos+1)")(pt "True"))





(display"
not n+1=1

PROOF:
")

(set-goal(pf"(pos+1=1)=False"))
(begin
  (ind)
  (auto)
)
; Proof finished.
(save"posOneNonSuc")
(display-theorems"posOneNonSuc")


(display"
Sn = n+1

PROOF:
")

(animate "posS")
(set-goal(pf"cposS pos=pos+1"))
(begin
  (ind)
  (auto)
)
; Proof finished.

(save "pos+1")
(display-theorems "pos+1")




(display"
Sn = 1+n

PROOF:
")
(set-goal(pf"cposS pos=1+pos"))
(begin
  (ind)
  (auto)
  (cases)
  (auto)

; Proof finished.
)
(save "1+pos")
(deanimate "posS")
(display-theorems "1+pos")




(display"

n=1 or n=1+Pn

PROOF:
")
(set-goal
 (pf"((pos=1)=False and (pos=1+(cposP pos))=False)=False"))
(begin
(cases)
   (auto)
(assume "pos")
(simp "<-" "1+pos")
(ng #t)
(simp "SP2n")
(use "Truth-Axiom")

(assume "pos")
(simp "<-" "1+pos")
(ng #t)
(simp "SP2n+1")
(use "Truth-Axiom")

; Proof finished.
)

(add-rewrite-rule(pt"(pos=1)=False and (pos=(1+cposP pos))=False")(pt "False"))
(add-rewrite-rule
 (pt"(pos=1)=False and (pos=1+(Rec pos=>pos)1([pos0,pos1][if (pos0=1) 1 (SOne pos1)]) ([pos0,pos1]SZero pos0) pos)=False")
 (pt "False"))





; (deanimate "posS")
; (animate "posS")
(display"

As justification for our choice
one needs to show:

PosADD k l (k+l)

PROOF:
Left as an exercise for the MINLOG-newcomer.
It should not be too hard to copy the
proof of cposplus-Extraction.
")

(begin
; (set-goal(pf"PosADD pos1 pos2 (pos1+pos2)"))
; (ind)
; (ind)
;   (simp "<-" "1+pos")
;   (intro 0)
; (assume "pos2")
; (simp "<-" "1+pos")
; (assume "1+2=S2")
; (use "posPlusDouble" (pt "cposS pos2"))
; (auto)

; (set-goal(pf"all pos1.PosADD pos1 pos2 (pos1+pos2)"))
; (ind)
; (assume "pos1")
; (simp "<-" "pos+1")
; (intro 0)

; (assume "pos2" "IH2")
; (cases)
; (use "posPlusDouble" (pt "1+pos2"))
; (use "IH2")
)
; (deanimate "posS")





(add-pvar-name "A" (make-arity (py "pos")))

(define(PROG var function Predicate)
  (string-append "(all "var"."Predicate"("var") -> "
                  Predicate"("function"))"))


(begin
(display"

Three more global assumptions to be shown:
")
(aga "k+2n"
     (pf"all pos1,pos2.
             pos1+SZero pos2 = (pos1+pos2)+pos2"))
(display-global-assumptions "k+2n")
(aga "S(k+2n)"
     (pf"all pos1,pos2.
             pos1+SOne  pos2 = cposS(pos1+SZero pos2)"))
(display-global-assumptions "S(k+2n)")
(aga "k+2n+1"
     (pf"all pos1,pos2.
             pos1+SOne  pos2 = (pos1+SZero pos2)+1"))
(display-global-assumptions "k+2n+1")
)

(display"


A(k) -> Prog(n,n+1,A) -> A(k+n)

PROOF:
")

(set-goal
 (pf
  (string-append
   "all pos0.A^ pos0 -> "
    (PROG "pos" "pos+1" "A^") "-> A^(pos0+pos1)" )))
(time(begin
(cut
 (pf"all pos0.A^pos0
     -> (all pos.A^pos -> A^(pos+1)) -> A^(pos0+1)"))
(assume "IH1base")
(cut
 (pf"all pos1.
       (all pos0.A^pos0
        -> (all pos.A^pos -> A^(pos+1))
        -> A^(pos0+pos1))
     -> all pos0. A^pos0
               -> (all pos.A^pos -> A^(pos+1))
               -> A^(pos0+SZero pos1)"))
(assume "IH1step0")
(ind)
(auto)

; IH1step1
(assume "pos1" "IH1" "pos0" "A0" "PROG")
(simp "k+2n+1")
(auto)

; IHstep0

(assume "pos1" "IH1" "pos0" "A0" "PROG")
(simp "k+2n")
(auto)

; Proof finished.
))
(save "posIndAdd")
(display-theorems "posIndAdd")







(display"
INDUCTION on pos
A(1) -> Prog(n,n+1,A) -> A(n)

PROOF:
")

(set-goal
 (pf
  (string-append
   "A^ 1 -> " (PROG "pos" "pos+1" "A^") "-> A^ pos" )))
(time(begin
(assume "pos")
(cases (pt"pos=1"))
  (assume "1")
  (simp "1")
  (search)
(assume "not1")
(simp (pf"pos = 1+(cposP pos)"))
(use "posIndAdd")
(cut
 (pf"((pos=1)=False and (pos=1+(cposP pos))=False)=False"))
(simp"not1")
(ng #t)
(simp"BooleStab")
(auto)

; Proof finished.
))
(save "posInd")
(display-theorems "posInd")







(begin

(add-alg "upos"
	 '("Unum" "upos")
	 '("SUCC" "upos=>upos"))
(display-constructors "upos")
)




(begin
;(remove-program-constant "uposP")

(display "

uposP : upos -> upos

")

 
(add-program-constant
 "uposP"
 (mk-arrow (py "upos") (py "upos"))
 1 'const 1
)



(add-computation-rule (pt "uposP Unum")(pt "Unum"))
(add-computation-rule (pt "uposP (SUCC upos)")(pt "upos"))

(display-program-constants "uposP")


(display"

Test of uposP:

")

(display "
uposP     Unum              ")
(pp(nt(pt"uposP     Unum")))
(display "
uposP     SUCC(SUCC(Unum))  ")
(pp(nt(pt"uposP    (SUCC(SUCC(Unum)))")))

)






(begin

(add-program-constant
 "uposLESS"
 (mk-arrow (py "upos") (py "upos") (py "boole"))
 1 'const 2
)

(add-token
 "◁"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (pconst-name-to-pconst "uposLESS")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "uposLESS"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "◁"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules For uposLESS

(add-computation-rule (pt "upos ◁ Unum")(pt "False"))

(add-computation-rule (pt "Unum ◁ SUCC upos")(pt "True"))
(add-computation-rule (pt "SUCC upos1 ◁ SUCC upos2")(pt "upos1◁upos2"))

(display-program-constants "uposLESS")

)





(set-goal(pf "upos◁SUCC upos"))
(ind)
(auto)

; Proof finished.

(add-rewrite-rule(pt"upos◁SUCC upos")(pt"True"))






(begin

(add-program-constant
 "UposPlus"
 (mk-arrow (py "upos") (py "upos") (py "upos"))
 1 'const 2
)


; Computation Rules For UposPlus

(add-computation-rule
 (pt "UposPlus upos Unum")
 (pt "SUCC upos"))
(add-computation-rule
 (pt "UposPlus upos1 (SUCC upos2)")
 (pt "SUCC (UposPlus upos1 upos2)"))
; (show-output)
(display-program-constants "UposPlus")

(display"

Test of UposPlus:

")

(display "
UposPlus            Unum            Unum   =   ")
(pp(nt(pt"UposPlus            Unum            Unum")))
(display "
UposPlus  SUCC(SUCC Unum)     SUCC  Unum   =   ")
(pp(nt(pt"UposPlus  (SUCC(SUCC Unum))   (SUCC Unum)")))
; (hide-output)
)





(set-goal(pf "(UposPlus upos1 upos2 = Unum)=False"))
(assume "upos1")
(cases)
(auto)
; Proof finished.
(save "UnumNonSum")
(display-theorems "UnumNonSum")



(begin

(add-program-constant
 "Upostopos"
 (mk-arrow (py "upos") (py "pos"))
 1 'const 1
)


; Computation Rules For Upostopos

(add-computation-rule
 (pt "Upostopos Unum")
 (pt "1"))
(add-computation-rule
 (pt "Upostopos (SUCC upos)")
 (pt "(Upostopos upos)+1"))
; (show-output)
(display-program-constants "Upostopos")

(display"

Test of Upostopos:

")

(display "
Upostopos            Unum    =   ")
(pp(nt(pt"Upostopos            Unum")))
(display "
Upostopos  SUCC(SUCC Unum)   =   ")
(pp(nt(pt"Upostopos  (SUCC(SUCC Unum))")))
; (hide-output)
)

(begin
(display "
Remains to be shown
Upostopos(uposPuls k k) = SZero(Upostopos k)

")
(add-rewrite-rule(pt"Upostopos(UposPlus upos upos)")(pt"SZero(Upostopos upos)"))
)


(display"
Upostopos is surjective
exnc upos.pos=Upostopos upos

PROOF:
")
(set-goal(pf"ex upos.pos=Upostopos upos"))
(begin
(ind)
(ex-intro(pt "Unum"))
(use "Truth-Axiom")
(assume "pos" "IH")
(ex-elim "IH")
(drop "IH")
(assume "upos" "IHn")
(ex-intro(pt "UposPlus upos upos"))
(simp "IHn")
(use "Truth-Axiom")

(assume "pos" "IH")
(ex-elim "IH")
(drop "IH")
(assume "upos" "IHn")
(ex-intro(pt "SUCC(UposPlus upos upos)"))
(simp "IHn")
(use "Truth-Axiom")
; Proof finished.
)
(save "Upostopossurjective")
(display-theorems "Upostopossurjective")






(set-goal(pf"(all upos A^(Upostopos upos)) -> all pos.A^ pos"))
(begin
(assume "Aupos" "pos")
(inst-with-to "Upostopossurjective" (pt"pos") "preimg")
(ex-elim "preimg")
(assume "upos2" "equ")
(simp "equ")
(inst-with-to "Aupos" (pt"upos2") "Aupos2")
(use "Aupos2")
; Proof finished.
)
(save"FromUpostopos")
(display-theorems"FromUpostopos")



(begin

(add-program-constant
 "Postoupos"
 (mk-arrow (py "pos") (py "upos"))
 1 'const 1
)


; Computation Rules For Postoupos

(add-computation-rule
 (pt "Postoupos 1")
 (pt "Unum"))
(add-computation-rule
 (pt "Postoupos (SZero pos)")
 (pt "UposPlus(Postoupos pos)(Postoupos pos)"))
(add-computation-rule
 (pt "Postoupos (SOne pos)")
 (pt "SUCC(UposPlus(Postoupos pos)(Postoupos pos))"))
; (show-output)
(display-program-constants "Postoupos")

(display"

Test of Postoupos:

")

(display "
Postoupos   1    =   ")
(pp(nt(pt"Postoupos   1")))
(display "
Postoupos  13   =   ")
(pp(nt(pt"Postoupos  13")))
; (hide-output)
)


(begin
(display "
Remains to be shown
Postoupos(k+1) = SUCC(Postoupos k)

")
(add-rewrite-rule(pt"Postoupos(pos+1)")(pt"SUCC(Postoupos pos)"))
)


(display"
Postoupos is surjective
exnc pos.upos=Postoupos pos

PROOF:
")
(set-goal(pf"ex pos.upos=Postoupos pos"))
(begin
(ind)
(ex-intro(pt "1"))
(use "Truth-Axiom")
(assume "upos" "IH")
(ex-elim "IH")
(drop "IH")
(assume "pos" "IHn")
(ex-intro(pt "pos+1"))
(simp "IHn")
(use "Truth-Axiom")
; Proof finished.
)
(save "Postoupossurjective")
(display-theorems "Postoupossurjective")




(deanimate "Upostopossurjective")
(animate "Upostopossurjective")

(set-goal(pf "cUpostopossurjective pos = Postoupos pos"))
(begin
  (ind)
  (auto)
  (assume "pos" "hyp")
  (ng #t)
  (simp "hyp")
  (auto)
  (assume "pos" "hyp")
  (ng #t)
  (simp "hyp")
  (auto)
)
; Proof finished.
(save "UpostoposPreimg")
(deanimate "Upostopossurjective")
(display-theorems "UpostoposPreimg")





(add-pvar-name "B" (make-arity (py "upos")))


(set-goal(pf"(all pos B^(Postoupos pos)) -> all upos.B^ upos"))
(begin
(assume "Bupos" "upos")
(inst-with-to "Postoupossurjective" (pt"upos") "preimg")
(ex-elim "preimg")
(assume "pos2" "equ")
(simp "equ")
(use "Bupos")
; Proof finished.
)
(save"FromPostoupos")
(display-theorems"FromPostoupos")




(begin
(display "
Remains to be shown
Upostopos(Postoupos k) = k

")
(add-rewrite-rule(pt"Upostopos(Postoupos pos)")(pt"pos"))
)



(display"
INDUCTION on pos
A(1) -> Prog(n,n+1,A) -> A(n)

PROOF:
")

(set-goal
 (pf
  (string-append
   "A^ 1 -> " (PROG "pos" "pos+1" "A^") "-> A^ pos" )))
(begin
(assume "pos" "A1" "prog")
(use "FromUpostopos")
(ind)
  (use "A1")
(cut(pf"all pos.A^(Upostopos(Postoupos pos)) -> A^(Upostopos(SUCC(Postoupos pos)))"))
(use-with "FromPostoupos" (make-cterm (pv "upos") (pf "A^(Upostopos upos) -> A^(Upostopos(SUCC upos))")))
(use "prog")
; Proof finished.
)
(save "posuposInd")
(display-theorems "posuposInd")


(define (animate-posuposind)
  (begin
    (deanimate-posuposind)
    (animate "Postoupossurjective")
    (animate "Upostopossurjective")
    (animate "FromPostoupos")
    (animate "FromUpostopos")
    (animate "posuposInd")))


(define (deanimate-posuposind)
  (begin
    (deanimate "Postoupossurjective")
    (deanimate "Upostopossurjective")
    (deanimate "FromPostoupos")
    (deanimate "FromUpostopos")
    (deanimate "posuposInd")))


(begin
(animate-posuposind)
(deanimate "posuposInd")
(animate "posP")
(animate "posIndAdd")
; (show-output)
(display "
_______________

Comparing posInd with posSuccind .

posInd:
")
(animate "posInd")
(display "
_______________

posuposInd:
")

(animate "posuposInd")
(newline)
(display "_______________

")
; (hide-output)
(deanimate-posuposind)
(deanimate "posInd")
(deanimate "posIndAdd")
(deanimate "posP")
)




(begin
; (show-output)
(display"

Some RW-rules and GLOBAL ASSUMPTIONS

")

(add-rewrite-rule
 (pt"(upos1◁upos2)=False and upos1◁SUCC upos2")
 (pt"upos1=upos2"))
(add-rewrite-rule (pt"upos◁upos")(pt"False"))
(add-rewrite-rule (pt"Upostopos(UposPlus (Postoupos pos1) (Postoupos pos2))")(pt"pos1+pos2"))

(aga "SmallerposPlusOne"
     (pf"all pos1,pos2.(pos1<pos2+1)=((pos2<pos1)=False)"))
(display-global-assumptions "SmallerposPlusOne")
(aga "LargerposPlusOne"
     (pf"all pos1,pos2.(pos2+1<pos1)=(pos2<pos1 and (pos1=pos2+1)=False)"))
(display-global-assumptions "LargerposPlusOne")
(aga "uposlessS1"
     (pf "all upos1,upos2.(upos1◁SUCC upos2)=(((upos1◁upos2)=False and (upos1=upos2)=False)=False)"))
(display-global-assumptions "uposlessS1")
(aga "uposlessS2"
     (pf "all upos1,upos2.(upos1◁SUCC upos2)=(((upos1◁upos2)=False and (upos1=upos2)=False)=False)"))
(display-global-assumptions "uposlessS2")
(aga "poslessS1"
     (pf "all pos1,pos2.(pos1<pos2+1)=(((pos1<pos2)=False and (pos1=pos2)=False)=False)"))
(display-global-assumptions "poslessS1")
(aga "poslessS2"
     (pf "all pos1,pos2.(pos1<pos2+1)=(((pos1<pos2)=False and (pos2=pos1)=False)=False)"))
(display-global-assumptions "poslessS2")
(aga "n-1+1"
     (pf"all upos. Unum◁upos -> upos = SUCC(uposP upos)"))
(display-global-assumptions "n-1+1")
; (hide-output)
)





(display"
CV-Induction
A^ One -> (all pos.(all pos1.pos1<pos -> A^pos1) -> A^pos) -> all pos A^pos
PROOF:
")

(set-goal
 (pf "A^ One -> (all pos.(all pos1.pos1<pos -> A^pos1) -> A^pos) -> all pos A^pos"))
(begin
(assume "A1" "prog" "pos")
(use (pf "all pos1,pos2.(pos1<pos2)=False -> A^ pos2") (pt"pos"))
(assume "pos1")
(cut(pf"all pos.(all pos2.(pos<pos2)=False -> A^pos2) -> all pos2.(pos+1<pos2)=False -> A^pos2"))
(cut(pf"all pos2.(1<pos2)=False -> A^pos2"))
(use-with "posuposInd" (make-cterm (pv "pos1") (pf "all pos2.(pos1<pos2)=False -> A^pos2")) (pt "pos1"))

(cases)
(auto)
(assume "pos3")
(prop)
(assume "pos3")
(prop)

(assume "pos2" "A<2" "pos3")
(simp "LargerposPlusOne")
(cases(pt"pos3=pos2+1"))
(ng #t)
(assume "2=3+1" "T")
(simp "2=3+1")
(use "prog")
(assume "pos4")
(simp "SmallerposPlusOne")
(use "A<2")
(assume "not3=2+1")
(use "A<2")
(auto)
; Proof finished.
)

(save "posuposCVind")
(display-theorems "posuposCVind")





(set-goal
 (pf "A^ One -> (all pos.(all pos1.pos1<pos -> A^pos1) -> A^pos) -> all pos A^pos"))
(begin
(assume "A1" "prog" "pos")
(use (pf "all pos1,pos2.(pos1<pos2)=False -> A^ pos2") (pt"pos"))
(assume "pos1")
(cut(pf"all pos.(all pos2.(pos<pos2)=False -> A^pos2) -> all pos2.(pos+1<pos2)=False -> A^pos2"))
(cut(pf"all pos2.(1<pos2)=False -> A^pos2"))
(use-with "posInd" (make-cterm (pv "pos1") (pf "all pos2.(pos1<pos2)=False -> A^pos2")) (pt "pos1"))

(cases)
(auto)
(assume "pos3")
(prop)
(assume "pos3")
(prop)

(assume "pos2" "A<2" "pos3")
(simp "LargerposPlusOne")
(cases(pt"pos3=pos2+1"))
(ng #t)
(assume "2=3+1" "T")
(simp "2=3+1")
(use "prog")
(assume "pos4")
(simp "SmallerposPlusOne")
(use "A<2")
(assume "not3=2+1")
(use "A<2")
(auto)
; Proof finished.
)

(save "posCVind")
(display-theorems "posCVind")




(begin

(add-program-constant
 "PosMult"
 (mk-arrow (py "pos") (py "pos") (py "pos"))
 1 'const 2
)

(add-token
 "*"
 'add-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (pconst-name-to-pconst "PosMult")) x y)))

(add-display
 (py "pos")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
          (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
              (string=? "PosMult"
                        (const-to-name (term-in-const-form-to-const op)))
              (= 2 (length args)))
         (list 'add-op "*"
               (term-to-token-tree (car args))
               (term-to-token-tree (cadr args)))
         #f))))

(add-computation-rule (pt "pos*1") (pt "pos"))

(add-computation-rule (pt "pos1 * (SZero pos2)") (pt "SZero (pos1 * pos2)"))

(add-computation-rule (pt "pos1 * (SOne pos2)")  (pt "(pos1 * (SZero pos2)) + pos1"))
; (show-output)
(display-program-constants "PosMult")

(display"

Test of PosMult:

")

(display "
PosMult     3     1         ")
(pp(nt(pt"PosMult     3     1")))
(display "
PosMult    42    42      ")
(pp(nt(pt"PosMult    42    42")))
(display "
PosMult  1024  1023   ")
(pp(nt(pt"PosMult  1024  1023")))
; (hide-output)
)



(begin

; (show-output)

(display "

uposposTwoexp  ₂: upos -> pos

")


(add-program-constant
 "uposposTwoexp"
 (mk-arrow (py "upos") (py "pos"))
 1 'const 1
)


(add-token
 "₂"
 'prefix-op
 (lambda (x)
   (mk-term-in-app-form
    (make-term-in-const-form
     (pconst-name-to-pconst "uposposTwoexp")) x)))



(add-display
 (py "pos")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
          (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
              (string=? "uposposTwoexp"
                        (const-to-name (term-in-const-form-to-const op)))
              (= 1 (length args)))
         (list 'prefix-op "₂" (term-to-token-tree (car args)))
         #f))))


(add-computation-rule (pt "₂Unum")(pt "2"))
(add-computation-rule (pt "₂(SUCC upos)")(pt "SZero(₂upos)"))

(display-program-constants "uposposTwoexp")


(display"

Test of ₂ :

")

(display "
₂Unum             ")
(pp(nt(pt"₂Unum")))
(display "
₂(Postoupos 10)   ")
(pp(nt(pt"₂(Postoupos 10)")))
(display "
₂(Postoupos 32)   ")
(pp(nt(pt"₂(Postoupos 32)")))
)


(set-goal (pf"1< ₂upos"))
(cases)
(auto)
; Proof finished.
(add-rewrite-rule(pt"1< ₂upos")(pt"True"))





(set-goal(pf "(SOne pos< ₂upos) = (SZero pos< ₂upos)"))
(assume "pos")
(ind)
(auto)
; Proof finished.
(add-rewrite-rule(pt"SOne pos< ₂upos")(pt"SZero pos< ₂upos"))



; (show-output)

(set! COMMENT-FLAG #t)



(begin
(display"

Further RW-rules and global-assumptions

")

(add-rewrite-rule(pt"pos1<pos1+pos2")(pt"True"))
(add-rewrite-rule(pt"pos1+pos3<pos2+pos3")(pt"pos1<pos2"))
(add-rewrite-rule(pt"2<pos+1")(pt"(pos=1)=False"))
(add-rewrite-rule(pt"pos2<((cposMAX pos1 pos2)+1)")(pt"True"))
(add-rewrite-rule(pt"(cposMAX pos1 pos2)<pos2")(pt"False"))
(add-rewrite-rule(pt "cposMAX pos1 (pos2+1) < pos2")(pt "False"))
(add-rewrite-rule(pt"(cposMAX pos1 pos2)<pos3")(pt"(pos1<pos3 and pos2<pos3)"))
(add-rewrite-rule
 (pt"pos3<(cposMAX pos1 pos2)")
 (pt"((pos3<pos1)=False and (pos3<pos2)=False)=False"))
(add-rewrite-rule(pt"pos1<(cposMAX pos1 pos2)+1")(pt"True"))

(aga "posMAXn1"
     (pf"all pos. cposMAX pos 1=pos"))
(display-global-assumptions  "posMAXn1")
(aga "posMAX=1"
     (pf"all pos1,pos2.(cposMAX pos1 pos2 = 1)=(pos1=1  and pos2=1)"))
(display-global-assumptions "posMAX=1")
(aga "posMAXplus"
     (pf"all pos1,pos2,pos3.cposMAX(pos1+pos3)(pos2+pos3)=(cposMAX pos1 pos2)+pos3"))
(display-global-assumptions "posMAXplus")
(aga "posMAXless"
     (pf "all pos1,pos2,pos3.((cposMAX pos1 pos2)<pos3)=(pos1<pos3 and pos2<pos3)"))
(aga "lessposMAX"
     (pf "all pos1,pos2,pos3.(pos3<(cposMAX pos1 pos2))=(((pos3<pos1)=False and (pos3<pos2)=False)=False)"))
(display-global-assumptions "lessposMAX")
(aga "posMAX+"
     (pf"all pos1,pos2,pos3.cposMAX(pos1+pos3)(pos2+pos3)=(cposMAX pos1 pos2)+pos3"))
(display-global-assumptions "posMAX+")
(aga "posLESSEQUtrans2"
     (pf"all pos1,pos2,pos3.pos1<pos2->(pos3<pos2)=False->pos1<pos3"))
(display-global-assumptions "posLESSEQUtrans2")
(aga "posLESSEQUtrans1"
     (pf"all pos1,pos2,pos3.(pos1<pos2)=False->(pos3<pos2)->pos1<pos3"))
(display-global-assumptions "posLESSEQUtrans1")
(aga "posLEtrans" (pf"all pos1,pos2,pos3. (pos2<pos1)=False -> (pos3<pos2)=False -> (pos3<pos1)=False"))
(display-global-assumptions "posLEtrans")
)


(display"

End of pao_pos.scm

")



