/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mission_control.h"

#include <core/posix/exec.h>
#include <core/posix/this_process.h>
#include <core/posix/signal.h>
#include <core/posix/wait.h>

#include <map>
#include <string>
#include <thread>

namespace
{
std::map<std::string, std::string> copy_env()
{
    std::map<std::string, std::string> env;
    core::posix::this_process::env::for_each([&env](const std::string& k, const std::string& v)
                                             {
                                                 env.insert(std::make_pair(k, v));
                                             });
    return env;
}
}

testing::tp::MissionControl::MissionControl(const std::chrono::milliseconds& grace)
    : cp{core::posix::exec(mc, {}, copy_env(), core::posix::StandardStream::stdout)}
{
    std::this_thread::sleep_for(grace);
}

testing::tp::MissionControl::~MissionControl()
{
    try
    {
        cp.send_signal_or_throw(core::posix::Signal::sig_kill);
        cp.wait_for(core::posix::wait::Flags::untraced);
    }
    catch (...)
    {
        // Silently drop all issues here. We can hardly do anything
        // about them and we just try to be as clean as possible.
    }
}
