#include <gtest/gtest.h>

#include <messaging/flags.h>

namespace messaging
{
enum class TestEnum : uint
{
    Val1 = 1 << 1,
    Val2 = 1 << 2,
    Val3 = 1 << 4
};
}

namespace testing
{

TEST(FlagsTest, test_basic_operations)
{
    messaging::Flags<messaging::TestEnum> flags(messaging::TestEnum::Val1 | messaging::TestEnum::Val3);
    EXPECT_EQ(flags & messaging::TestEnum::Val1, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val1));
    EXPECT_NE(flags & messaging::TestEnum::Val2, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val2));
    EXPECT_EQ(flags & messaging::TestEnum::Val3, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val3));

    EXPECT_TRUE(flags.is_set(messaging::TestEnum::Val1));
    EXPECT_FALSE(flags.is_set(messaging::TestEnum::Val2));
    EXPECT_TRUE(flags.is_set(messaging::TestEnum::Val3));

    messaging::Flags<messaging::TestEnum> flags_post_adding;
    flags_post_adding |= messaging::TestEnum::Val2;
    flags_post_adding |= messaging::TestEnum::Val3;
    EXPECT_NE(flags_post_adding & messaging::TestEnum::Val1, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val1));
    EXPECT_EQ(flags_post_adding & messaging::TestEnum::Val2, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val2));
    EXPECT_EQ(flags_post_adding & messaging::TestEnum::Val3, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val3));

    EXPECT_FALSE(flags_post_adding.is_set(messaging::TestEnum::Val1));
    EXPECT_TRUE(flags_post_adding.is_set(messaging::TestEnum::Val2));
    EXPECT_TRUE(flags_post_adding.is_set(messaging::TestEnum::Val3));
}

TEST(FlagsTest, empty_flags)
{
    messaging::Flags<messaging::TestEnum> flags;
    EXPECT_NE(flags & messaging::TestEnum::Val1, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val1));
    EXPECT_NE(flags & messaging::TestEnum::Val2, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val2));
    EXPECT_NE(flags & messaging::TestEnum::Val3, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val3));

    EXPECT_FALSE(flags.is_set(messaging::TestEnum::Val1));
    EXPECT_FALSE(flags.is_set(messaging::TestEnum::Val2));
    EXPECT_FALSE(flags.is_set(messaging::TestEnum::Val3));
}

TEST(FlagsTest, all_flags)
{
    messaging::Flags<messaging::TestEnum> flags(messaging::TestEnum::Val1 | messaging::TestEnum::Val2 | messaging::TestEnum::Val3);
    EXPECT_EQ(flags & messaging::TestEnum::Val1, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val1));
    EXPECT_EQ(flags & messaging::TestEnum::Val2, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val2));
    EXPECT_EQ(flags & messaging::TestEnum::Val3, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val3));

    EXPECT_TRUE(flags.is_set(messaging::TestEnum::Val1));
    EXPECT_TRUE(flags.is_set(messaging::TestEnum::Val2));
    EXPECT_TRUE(flags.is_set(messaging::TestEnum::Val3));

    messaging::Flags<messaging::TestEnum> flags_post_adding;
    flags_post_adding |= messaging::TestEnum::Val1;
    flags_post_adding |= messaging::TestEnum::Val2;
    flags_post_adding |= messaging::TestEnum::Val3;
    EXPECT_EQ(flags_post_adding & messaging::TestEnum::Val1, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val1));
    EXPECT_EQ(flags_post_adding & messaging::TestEnum::Val2, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val2));
    EXPECT_EQ(flags_post_adding & messaging::TestEnum::Val3, static_cast<messaging::Flags<messaging::TestEnum>::UnderlyingType>(messaging::TestEnum::Val3));

    EXPECT_TRUE(flags_post_adding.is_set(messaging::TestEnum::Val1));
    EXPECT_TRUE(flags_post_adding.is_set(messaging::TestEnum::Val2));
    EXPECT_TRUE(flags_post_adding.is_set(messaging::TestEnum::Val3));
}


}
