/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_BLOCKING_CONNECTOR_H_
#define TESTING_BLOCKING_CONNECTOR_H_

#include <messaging/connector.h>
#include <messaging/enumerator.h>
#include <messaging/parameter.h>

#include <condition_variable>
#include <mutex>

namespace testing
{
/// @brief BlockingConnector is a messaging::Connector implementation
/// that simply blocks in its run() impl. until stop() is called.
class BlockingConnector : public messaging::Connector
{
public:
    const messaging::Enumerator<messaging::Parameter>& parameters() const override;
    std::shared_ptr<messaging::Connection> request_connection(
        const std::shared_ptr<messaging::Connection::Observer>& connection_observer,
        const std::shared_ptr<messaging::Messenger::Observer>& messaging_observer,
        const std::shared_ptr<messaging::PresenceManager::Observer>& presence_observer,
        const messaging::Dictionary<std::string, messaging::Variant>&) override;
    void run() override;
    void stop() override;

private:
    std::mutex m;
    std::condition_variable cv;
    bool stop_requested{false};

    messaging::StdVectorEnumerator<messaging::Parameter> params;
};
}

#endif  // TESTING_BLOCKING_CONNECTOR_H_
