/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MOCK_CONNECTOR_H_
#define MOCK_CONNECTOR_H_

#include <messaging/connector.h>

#include <messaging/enumerator.h>
#include <messaging/parameter.h>
#include <messaging/dictionary.h>

#include <gmock/gmock.h>

#include <map>

namespace testing
{

class MockConnector : public messaging::Connector
{
public:
    MockConnector();

    MOCK_CONST_METHOD0(parameters, const messaging::Enumerator<messaging::Parameter>&());
    MOCK_METHOD4(request_connection,
                 std::shared_ptr<messaging::Connection>(
                     const std::shared_ptr<messaging::Connection::Observer>& connection_observer,
                     const std::shared_ptr<messaging::Messenger::Observer>& messenger_observer,
                     const std::shared_ptr<messaging::PresenceManager::Observer>& presence_observer,
                     const messaging::Dictionary<std::string, messaging::Variant>&));
    MOCK_METHOD0(run, void());
    MOCK_METHOD0(stop, void());

private:
    messaging::StdVectorEnumerator<messaging::Parameter> params_;

    std::shared_ptr<messaging::Connection> fake_request_connection(
            const std::shared_ptr<messaging::Connection::Observer>& connection_observer,
            const std::shared_ptr<messaging::Messenger::Observer>& messenger_observer,
            const std::shared_ptr<messaging::PresenceManager::Observer>& presence_observer,
            const messaging::Dictionary<std::string, messaging::Variant>&);
};

}
#endif  // MOCK_CONNECTOR_H_
