/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mock_connection.h"

namespace testing
{

MockConnection::MockConnection(const std::shared_ptr<messaging::Connection::Observer>& connection_observer,
               const std::shared_ptr<messaging::Messenger::Observer>& messenger_observer,
               const std::shared_ptr<messaging::PresenceManager::Observer>& presence_observer)
    : messaging::Connection{connection_observer}
    , mock_messenger_{std::make_shared<NiceMock<MockMessenger>>(messenger_observer)}
    , mock_presence_manager_{std::make_shared<NiceMock<MockPresenceManager>>(presence_observer)}                                                                        
    , mock_group_starter_{std::make_shared<NiceMock<MockGroupStarter>>()}
{
    ON_CALL(*this, connect()).WillByDefault(Invoke(this, &MockConnection::fake_connect));
    ON_CALL(*this, presence_manager()).WillByDefault(Invoke(this, &MockConnection::fake_presence_manager));
    ON_CALL(*this, messenger()).WillByDefault(Invoke(this, &MockConnection::fake_messenger));
    ON_CALL(*this, group_starter()).WillByDefault(Invoke(this, &MockConnection::fake_group_starter));

    Mock::AllowLeak(mock_messenger_.get());
    Mock::AllowLeak(mock_presence_manager_.get());
    Mock::AllowLeak(mock_group_starter_.get());
}

void MockConnection::announce_status_connected()
{
    announce_status_changed(
        messaging::Connection::Status::connected,
        messaging::Connection::StatusChangedReason::not_specified);
}

void MockConnection::fake_connect()
{
    announce_status_changed(messaging::Connection::Status::connected, messaging::Connection::StatusChangedReason::requested);
}

std::shared_ptr<messaging::PresenceManager> MockConnection::fake_presence_manager()
{
    return mock_presence_manager_;
}

std::shared_ptr<messaging::Messenger> MockConnection::fake_messenger()
{
    return mock_messenger_;
}

std::shared_ptr<messaging::GroupStarter> MockConnection::fake_group_starter()
{
    return mock_group_starter_;
}

}
