/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/runner.h>

#include <messaging/associative_connector_factory.h>
#include <messaging/connector_factory_initializer.h>

#include <functional>
#include <iostream>
#include <memory>

/// @brief Executes the runner, consciously only catching HelpRequired and letting all other exceptions
/// propagate to the abort handler. With that, we receive a subsequent core dump that
/// can be used for post-mortem debugging.
int main(int argc, const char** argv)
{
    auto cf = messaging::ConnectorFactoryInitializer().initialize();

    try
    {
        return messaging::Runner::main(messaging::Runner::Configuration::from_command_line_args(argc, argv, *cf));
    }
    catch (const messaging::Runner::HelpRequired& e)
    {
        std::cout << e.help_text << std::endl;
        return EXIT_FAILURE;
    }

    // We actually should never reach here, but returning failure is
    // probably good enough.
    return EXIT_FAILURE;
}
