/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/broadcast.h>

struct messaging::Broadcast::Private
{
    messaging::Members members;
};

messaging::Broadcast::Broadcast(const std::string &id, const messaging::Members &members)
        : Recipient{id}, impl{new Private{members}}
{
}

messaging::RecipientType messaging::Broadcast::type() const
{
    return messaging::RecipientType::broadcast;
}

messaging::Members messaging::Broadcast::members() const
{
    return impl->members;
}
