/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_VARIANT_MAP_FACADE_H_
#define MESSAGING_QT_VARIANT_MAP_FACADE_H_

#include <messaging/dictionary.h>
#include <messaging/visibility.h>

#include <messaging/qt/variant.h>

#include <map>

namespace messaging
{
namespace qt
{
/// @brief VariantMapFacade implements Dictionary and maps QVariantMap to fw's world.
class MESSAGING_FW_PUBLIC VariantMapFacade : public Dictionary<std::string, messaging::Variant>
{
public:
    /// @brief Creates a new instance, taking a deep copy of the given map.
    VariantMapFacade(const QVariantMap& m);
    VariantMapFacade(const VariantMapFacade& rhs);

    /// @brief has_value_for_key returns true if there is a value known for the given key.
    bool has_value_for_key(const std::string& key) const override;

    /// @brief value_for_key returns the value known for the given key.
    const messaging::Variant& value_for_key(const std::string& key) const override;

    /// @brief data returns an immutable reference to the contained map.
    const std::map<std::string, qt::Variant>& data() const;

private:
    std::map<std::string, qt::Variant> vm;
};
}
}

#endif  // MESSAGING_QT_VARIANT_MAP_FACADE_H_
