/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_ROLES_INTERNAL_H
#define MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_ROLES_INTERNAL_H

#include <messaging/qt/tp/interfaces/base_channel_roles.h>
#include <messaging/qt/tp/interfaces/channel_interface_roles_adaptor.h>
#include <messaging/visibility.h>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

class MESSAGING_FW_LOCAL BaseChannelRolesInterface::Adaptee : public QObject
{
    Q_OBJECT
    Q_PROPERTY(HandleRolesMap roles READ roles)
    Q_PROPERTY(bool canUpdateRoles READ canUpdateRoles)
public:
    Adaptee(BaseChannelRolesInterface *interface);
    ~Adaptee();

    HandleRolesMap roles() const;
    bool canUpdateRoles() const;

private Q_SLOTS:
    void updateRoles(const HandleRolesMap &contactRoles, const ChannelInterfaceRolesAdaptor::UpdateRolesContextPtr &context);

Q_SIGNALS:
    void rolesChanged(const HandleRolesMap &added, const HandleRolesMap& removed);

public:
    BaseChannelRolesInterface *mInterface;
};

}
}
}
}

#endif // MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_ROLES_INTERNAL_H

