/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_DESTROYABLE_INTERNAL_H_
#define MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_DESTROYABLE_INTERNAL_H_

#include <TelepathyQt/_gen/svc-channel.h>
#include <messaging/qt/tp/interfaces/base_channel_destroyable.h>
#include <messaging/visibility.h>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

class MESSAGING_FW_LOCAL BaseChannelDestroyableInterface::Adaptee : public QObject
{
    Q_OBJECT
public:
    Adaptee(BaseChannelDestroyableInterface *interface);
    ~Adaptee();

public Q_SLOTS:
    void destroy(const Tp::Service::ChannelInterfaceDestroyableAdaptor::DestroyContextPtr &context);

public:
    BaseChannelDestroyableInterface *mInterface;
};

}
}
}
}

#endif // MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_DESTROYABLE_INTERNAL_H_

