/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INITIALIZER_H_
#define MESSAGING_QT_TP_INITIALIZER_H_

#include <messaging/visibility.h>

namespace messaging
{
namespace qt
{
namespace tp
{
/// @brief TelepathyInitializer takes care of calling setup procedures for TelepathyQt.
struct MESSAGING_FW_PUBLIC Initializer
{
    /// @brief Creation time parameters go here.
    struct Configuration
    {
        bool enable_debug_output{false};
        bool enable_warning_output{false};
    };

    /// @brief Sets up debugging/warning and initializes the type system.
    Initializer(const Configuration& configuration);
};
}
}
}

#endif  // MESSAGING_QT_TP_INITIALIZER_H_
