/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_ADAPTER_H_
#define MESSAGING_QT_TP_ADAPTER_H_

#include <messaging/visibility.h>

#include <messaging/qt/tp/initializer.h>

#include <TelepathyQt/BaseConnectionManager>
#include <TelepathyQt/BaseProtocol>

#include <memory>

namespace messaging
{
class Connector;
namespace qt
{
class Runtime;
namespace tp
{
/// @brief Adapter exposes the given connector instance to the
/// telepathy world, firing up a tp::ConnectionManager, with a pre-configured
/// protocol.
class MESSAGING_FW_PUBLIC Adapter
{
public:
    /// @brief TelepathyAdapter creates a new instance with the given parameters.
    /// @throws std::runtime_error if exposure to the bus fails.
    Adapter(const std::shared_ptr<qt::Runtime>& runtime,
            const std::shared_ptr<Connector>& connector,
            const std::string& connection_manager_name,
            const std::string& protocol_name);

    ~Adapter() = default;

private:
    Initializer ti;  ///< Initializer takes care of setting up global qt telepathy attributes.

    std::shared_ptr<qt::Runtime> runtime;  ///< Hold on to the overall qt runtime.
    std::shared_ptr<Connector> connector;  ///< The connector implementation that is exposed to telepathy.

    Tp::BaseProtocolPtr protocol;  ///< The protocol instance we are adding to the connection manager.
    Tp::BaseConnectionManagerPtr connection_manager;  ///< The connection manager instance we are exposing to the bus.
};
}
}
}

#endif  // MESSAGING_QT_TP_ADAPTER_H_
