/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_PARAMETER_H_
#define MESSAGING_PARAMETER_H_

#include <messaging/visibility.h>

#include <string>

namespace messaging
{
/// A handy fwd declaration.
template <typename, typename>
class Dictionary;
class Variant;

/// @brief Parameter models a named input.
struct MESSAGING_FW_PUBLIC Parameter
{
    /// @brief Flags enumerates all flags that can be set on a parameter
    enum class Flags
    {
        none = 0,
        required = 1 << 0,
        secret = 1 << 1,
        required_for_registration = 1 << 2
    };

    /// @brief can_extract_from returns true if this parameter can be extracted from
    /// the given dictionary.
    bool can_extract_from(const Dictionary<std::string, Variant>& dict) const;

    /// @brief extract_from tries to query the value of the parameter from the given dictionary.
    /// @throw std::runtime_error in case of issues.
    const Variant& extract_from(const Dictionary<std::string, Variant>& dict) const;

    std::string name;       ///< The name of the parameter.
    std::string signature;  ///< Has to be a dbus signature.
    Flags flags;            ///< Flags associated to the parameter.
};

// Define bitfield operations on Parameter::Flags
MESSAGING_FW_PUBLIC Parameter::Flags operator|(Parameter::Flags lhs, Parameter::Flags rhs);
MESSAGING_FW_PUBLIC Parameter::Flags operator&(Parameter::Flags lhs, Parameter::Flags rhs);
}

#endif  // MESSAGING_PARAMETER_H_
