/*
 * DialogSerienbrief.java
 *
 * Created on 17. August 2007, 20:50
 *
 *    Emma, Vereinsverwaltungsprorgamm
 *    Copyright (C) 2007
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package mediathek.gui.dialoge;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;

/**
 *
 * @author  emil
 */
public class DialogEditAbo extends javax.swing.JDialog {

    private Daten daten;
    private DatenAbo aktAbo;
    private JTextField[] textfeldListe;
    private JComboBox comboboxProgramm = new JComboBox();
    private JComboBox comboboxSender = new JComboBox();
    private JCheckBox checkBoxExakt = new JCheckBox();
    public boolean ok = false;

    /** Creates new form DialogSerienbrief
     * @param parent
     * @param modal
     * @param d Daten
     * @param aktA aktuelles Abo
     */
    public DialogEditAbo(java.awt.Frame parent, boolean modal, Daten d, DatenAbo aktA) {
        super(parent, modal);
        initComponents();
        daten = d;
        aktAbo = aktA;
        comboboxProgramm.setModel(new javax.swing.DefaultComboBoxModel(daten.listePgruppeAbo.getObjectDataCombo()));
        comboboxSender.setModel(new javax.swing.DefaultComboBoxModel(Funktionen.addLeerListe(Konstanten.SENDER_LISTE)));
        jButtonBeenden.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                check();
                beenden();
            }
        });
        jButtonAbbrechen.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                beenden();
            }
        });
        setExtra();
        this.pack();
    }

    private void setExtra() {
        textfeldListe = new JTextField[Konstanten.ABO_MAX_ELEM];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.HORIZONTAL;
        c.insets = new Insets(5, 10, 10, 5);
        jPanelExtra.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < Konstanten.ABO_MAX_ELEM; ++i) {
            addExtraFeld(i, gridbag, c, jPanelExtra, aktAbo.arr);
            ++zeile;
            c.gridy = zeile;
        }
    }

    private void addExtraFeld(int i, GridBagLayout gridbag, GridBagConstraints c,
            JPanel panel, String[] item) {
        //Label
        c.gridx = 0;
        c.weightx = 0;
        JLabel label = new JLabel(Konstanten.ABO_COLUMN_NAMES[i] + ": ");
        if (i == Konstanten.ABO_TITEL_NR || i == Konstanten.ABO_THEMA_NR || i == Konstanten.ABO_THEMA_EXAKT_NR || i == Konstanten.ABO_SENDER_NR) {
            label = new JLabel("  " + Konstanten.ABO_COLUMN_NAMES[i] + ": ");
            label.setForeground(Color.BLUE);
        } else {
            label = new JLabel(Konstanten.ABO_COLUMN_NAMES[i] + ": ");
        }
        gridbag.setConstraints(label, c);
        panel.add(label);
        //Textfeld
        c.gridx = 1;
        c.weightx = 10;
        if (i == Konstanten.ABO_PGRUPPE_NR) {
            comboboxProgramm.setSelectedItem(item[i]);
            //falls das Feld leer war, wird es jetzt auf den ersten Eintrag gesetzt
            aktAbo.arr[Konstanten.ABO_PGRUPPE_NR] =  comboboxProgramm.getSelectedItem().toString();
            comboboxProgramm.addActionListener(new BeobComboProgramm());
            gridbag.setConstraints(comboboxProgramm, c);
            panel.add(comboboxProgramm);
        } else if (i == Konstanten.ABO_SENDER_NR) {
            comboboxSender.setSelectedItem(item[i]);
            //falls das Feld leer war, wird es jetzt auf den ersten Eintrag gesetzt
            aktAbo.arr[Konstanten.ABO_SENDER_NR] =  comboboxSender.getSelectedItem().toString();
            comboboxSender.addActionListener(new BeobComboSender());
            gridbag.setConstraints(comboboxSender, c);
            panel.add(comboboxSender);
        } else if (i == Konstanten.ABO_THEMA_EXAKT_NR) {
            checkBoxExakt.setSelected(Boolean.parseBoolean(item[i]));
            checkBoxExakt.addActionListener(new BeobExakt());
            gridbag.setConstraints(checkBoxExakt, c);
            panel.add(checkBoxExakt);
        } else {
            JTextField textfeld = new JTextField();
            textfeldListe[i] = textfeld;
            if (i == Konstanten.ABO_NR_NR
                    || i == Konstanten.ABO_DOWN_DATUM_NR
                    || i == Konstanten.ABO_EINMAL_ERLEDIGT_NR
                    || i == Konstanten.ABO_EINMAL_URL_NR) {
                textfeld.setEditable(false);
            } else {
                textfeld.getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
            }
            textfeld.setText(item[i]);
            gridbag.setConstraints(textfeld, c);
            panel.add(textfeld);
        }
    }

    private void check() {
        aktAbo.arr[Konstanten.ABO_ZIELPFAD_NR] = Funktionen.replaceLeerDateiname(aktAbo.arr[Konstanten.ABO_ZIELPFAD_NR], false /*keinPfadTrenner*/);
        ok = true;
    }

    private void beenden() {
        this.dispose();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jPanelExtra = new javax.swing.JPanel();
        jButtonBeenden = new javax.swing.JButton();
        jButtonAbbrechen = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(500, 0));

        jPanel1.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

        jPanelExtra.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        javax.swing.GroupLayout jPanelExtraLayout = new javax.swing.GroupLayout(jPanelExtra);
        jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(
            jPanelExtraLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 541, Short.MAX_VALUE)
        );
        jPanelExtraLayout.setVerticalGroup(
            jPanelExtraLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 249, Short.MAX_VALUE)
        );

        jButtonBeenden.setText("Ok");

        jButtonAbbrechen.setText("Abbrechen");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jButtonBeenden, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonAbbrechen))
                    .addComponent(jPanelExtra, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanel1Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonAbbrechen, jButtonBeenden});

        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanelExtra, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonBeenden)
                    .addComponent(jButtonAbbrechen))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAbbrechen;
    private javax.swing.JButton jButtonBeenden;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanelExtra;
    // End of variables declaration//GEN-END:variables

    private class BeobachterDocumentTextfeld implements DocumentListener {

        int nr;

        public BeobachterDocumentTextfeld(int n) {
            nr = n;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            eingabe();
        }

        private void eingabe() {
            daten.setGeaendert();
            aktAbo.arr[nr] = textfeldListe[nr].getText().trim();
        }
    }

    private class BeobComboProgramm implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.setGeaendert();
            aktAbo.arr[Konstanten.ABO_PGRUPPE_NR] =  comboboxProgramm.getSelectedItem().toString();
        }
    }

    private class BeobComboSender implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.setGeaendert();
            aktAbo.arr[Konstanten.ABO_SENDER_NR] =  comboboxSender.getSelectedItem().toString();
        }
    }

    private class BeobExakt implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.setGeaendert();
            aktAbo.arr[Konstanten.ABO_THEMA_EXAKT_NR] = Boolean.toString(checkBoxExakt.isSelected());
        }
    }
//    private class BeobEinmal implements ActionListener {
//
//        @Override
//        public void actionPerformed(ActionEvent e) {
//            daten.setGeaendert();
//            aktAbo.arr[Konstanten.ABO_EINMAL_NR] = Boolean.toString(checkBoxEinmal.isSelected());
//        }
//    }
}
