/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.Funktionen;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.TModelFilm;
import mediathek.beobachter.DownloadCellRenderer;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.filme.DatenFilm;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.Datum;
import mediathek.daten.ListeAbo;
import mediathek.filme.BeobFilmeLaden;
import mediathek.filme.TimerListener;
import mediathek.gui.dialoge.DialogDatenFilm;
import mediathek.gui.menue.DialogImportFilme;
import mediathek.gui.dialoge.DialogPgruppen;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;
import mediathek.io.starter.Starts;

public class GuiFilme extends PanelVorlage {

    private TModelFilm tModel1;
    private JButton buttonArray[];
    private BeobachterLaden beobachterLaden;
    private DialogDatenFilm dialogDatenFilm;
    private JSpinner jSpinnerVerkuerzen = new JSpinner();
    private JCheckBox jCheckBoxVerkuerzen = new JCheckBox("Ansicht verkürzen");
    private JCheckBox jCheckBoxNurAbo = new JCheckBox("Nur Abos anzeigen");
    private JCheckBox jCheckBoxKeineGesehenen = new JCheckBox("Keine gesehenen Filme");
    private final String ABO_BUTTON_TEXT_NORMAL = "Abo";
    private final String ABO_BUTTON_TEXT_EINMAL = "Einmalabo";
    private DownloadCellRenderer downloadCellRenderer;
    private DefaultTableCellRenderer downloadCellRendererDefault;

    /**
     * Creates new form GuiFeed
     * @param d
     */
    public GuiFilme(Daten d) {
        super(d);
        initComponents();
        dialogDatenFilm = new DialogDatenFilm(null, false, daten);
        //init
        jProgressBar1.setVisible(false);
        jButtonStop.setVisible(false);
        jProgressBar1.setForeground(new java.awt.Color(102, 153, 255));
        jTable1.addMouseListener(new BeobMausTabelle());
        //film starten
        ActionMap am = jTable1.getActionMap();
        am.put("film_starten", new BeobAbstractAction());
        InputMap im = jTable1.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
        im.put(enter, "film_starten");
        //
        jTable1.getSelectionModel().addListSelectionListener(new BeobachterTableSelect1());
        jTable1.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        downloadCellRenderer = new DownloadCellRenderer(daten, true /*starts*/, true /*Abo*/, Starts.QUELLE_BUTTON, true /*gesehen*/);
        downloadCellRendererDefault = new DefaultTableCellRenderer();
        //beobachter Filter
        jButtonFilterLoeschen.addActionListener(new BeobFilterLoeschen());
        jComboBoxFilterSender.addActionListener(new BeobFilterSender());
        jComboBoxFilterThema.addActionListener(new BeobFilter());
        jComboBoxFilterThema.getEditor().getEditorComponent().addMouseListener(new BeobMausTextCombo());
        jComboBoxFilterThema.addMouseListener(new BeobMausTextCombo());
        jTextFieldFilterTitel.addActionListener(new BeobFilter());
        jTextFieldFilterTitel.getDocument().addDocumentListener(new BeobFilterTitelDoc());
        //restliche Filter
        jButtonLaden.addActionListener(new BeobachterNeuLaden());
        jButtonEinstellungen.addActionListener(new BeobImportDialog());
        jButtonStop.addActionListener(new BeobLoadStop());
        beobachterLaden = new BeobachterLaden();
        jButtonAboAnlegen.setVisible(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR]));
        jButtonAboAnlegen.addActionListener(new BeobAboAnlegen());
        jButtonAboAnlegen.addMouseListener(new BeobMausAboButton());
        jPanelExtra.addMouseListener(new BeobMausPgruppenDialog());
        jScrollPane1.addMouseListener(new BeobMausProgramme());
        daten.starterClass.addListener(new BeobachterStart());
        daten.filmeLaden.addAdListener(beobachterLaden);
        daten.timerLaden.addAdListener(new BeobTimerAlter());
        //starten
        extra();
        setInfo();
        filter();
    }
    //===================================
    // Public
    //===================================

    /**
     * Panel Neu laden
     */
    @Override
    public void neuLaden() {
        jButtonAboAnlegen.setVisible(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR]));
        extra();
        filter();
    }

    /**
     *
     */
    public void bildProgs() {
        extra();
    }

    @Override
    public void neuLadenSofort() {
        setInfo();
    }

    /**
     *
     * @param vis 
     */
    public void setExtraVisible(boolean vis) {
        jPanelExtra.setVisible(vis);
        extra();
    }

    public void filmListeLaden() {
        jButtonLaden.setEnabled(false);
        jButtonEinstellungen.setEnabled(false);
        daten.filmeLaden.filmeImportServer();
    }

    //===================================
    // Private
    //===================================
    private void setInfo() {
        jTextFieldGeladen.setText(" " + daten.filmeLaden.filmlisteMetaDaten[Konstanten.FILMLISTE_DATUM_NR] + " ");
        jTextFieldAlter.setForeground(null);
        jTextFieldAlter.setFont(null);
        if (Funktionen.getUpdateFilme(daten) == Konstanten.UPDATE_FILME_AUTO) {
            // Auto in ein
            jLabelAlter.setText("Neuladen in: ");
            String sek = String.valueOf(daten.neuLadenIn % 60);
            String min = String.valueOf(daten.neuLadenIn / 60);
            while (sek.length() < 2) {
                sek = "0" + sek;
            }
            while (min.length() < 2) {
                min = "0" + min;
            }
            jTextFieldAlter.setText(" " + min + ":" + sek + " ");
        } else {
            jLabelAlter.setText("Alter: ");
            jTextFieldAlter.setText(" ");
            String date = "";
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
            date = daten.filmeLaden.filmlisteMetaDaten[Konstanten.FILMLISTE_DATUM_NR];
            Date jetzt = new Date(System.currentTimeMillis());
            Date filmDate = null;
            try {
                filmDate = sdf.parse(date);
            } catch (ParseException ex) {
            }
            if (jetzt != null && filmDate != null) {
                int sekunden = Math.round((jetzt.getTime() - filmDate.getTime()) / (1000));
                int minuten = sekunden / 60;
                String sek = String.valueOf(sekunden % 60);
                String min = String.valueOf(minuten % 60);
                String stu = String.valueOf(minuten / 60);
                while (sek.length() < 2) {
                    sek = "0" + sek;
                }
                while (min.length() < 2) {
                    min = "0" + min;
                }
                while (stu.length() < 2) {
                    stu = "0" + stu;
                }
                jTextFieldAlter.setText(" " + stu + ":" + min + ":" + sek);
                if (sekunden >= Konstanten.NEU_LADEN_IN) {
//                    jTextFieldAlter.setForeground(Konstanten.DOWNLOAD_FARBE_ALTER_ALT);
                    jTextFieldAlter.setFont(new java.awt.Font("Dialog", 1, 12));
                } else {
//                    jTextFieldAlter.setForeground(Konstanten.DOWNLOAD_FARBE_ALTER_OK);
//                    jTextFieldAlter.setFont(new java.awt.Font("Dialog", 1, 12));
                }
            }
        }
    }

    private void extra() {
        //erst sauber machen
        //zum Anlegen der Button:
        //Programmgruppe ohne Namen: Leerfeld
        //Programmgruppe ohen Programme: Label
        //sonst ein Button
        jPanelExtra.removeAll();
        jPanelExtra.updateUI();
        int maxSpalten = 4; //Anzahl der Spalten der Schalter
        int max = daten.listePgruppeButton.size();
        buttonArray = new JButton[max];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.insets = new Insets(4, 10, 4, 10);
        jPanelExtra.setLayout(gridbag);
        int spalte = 0;
        int zeile = 0;
        for (int i = 0; i < max; ++i) {
            if (!daten.listePgruppeButton.freeLine(i)) {
                addExtraFeld(i, spalte, zeile, gridbag, c, jPanelExtra);
            }
            ++spalte;
            if (spalte > maxSpalten - 1) {
                spalte = 0;
                ++zeile;
            }
        }
        //zum zusammenschieben
        c.weightx = 10;
        c.gridx = maxSpalten + 1;
        c.gridy = 0;
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        jPanelExtra.add(label);
    }

    private Component addExtraFeld(int i, int spalte, int zeile, GridBagLayout gridbag, GridBagConstraints c, JPanel panel) {
        Component ret = null;
        JButton button;
        c.gridx = spalte;
        c.gridy = zeile;
        if (daten.listePgruppeButton.get(i).getListeProg().isEmpty()) {
            JLabel label = new JLabel(daten.listePgruppeButton.get(i).arr[Konstanten.PROGRAMMGRUPPE_NAME_NR]);
            Color col = daten.listePgruppeButton.get(i).getFarbe(daten);
            if (col != null) {
                label.setForeground(col);
            }
            gridbag.setConstraints(label, c);
            panel.add(label);
            ret = label;
        } else {
            button = new JButton(daten.listePgruppeButton.get(i).arr[Konstanten.PROGRAMMGRUPPE_NAME_NR]);
            button.addActionListener(new BeobOpen(i));
            Color col = daten.listePgruppeButton.get(i).getFarbe(daten);
            if (col != null) {
                button.setBackground(col);
            }
            buttonArray[i] = button;
            gridbag.setConstraints(button, c);
            panel.add(button);
            ret = button;
        }
        return ret;
    }

    //####################################
    // Tabelle
    //####################################
//    private void filmeGeladen() {
//        String setSender = "";
//        String setThema = "";
//        setInfo();
//        stopBeob = true;
//        setSender =  jComboBoxFilterSender.getSelectedItem().toString();
//        if (setSender == null) {
//            setSender = "";
//        }
//        setThema =  jComboBoxFilterThema.getSelectedItem().toString();
//        if (setThema == null) {
//            setThema = "";
//        }
//        //Combo Sender
//        jComboBoxFilterSender.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_SENDER_NR, "", 0)));
//        jComboBoxFilterSender.setSelectedIndex(0);
//        jComboBoxFilterSender.setSelectedItem(setSender);
//        //Combo Thema
//        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_THEMA_NR, "", 0)));
//        jComboBoxFilterThema.setSelectedIndex(0);
//        jComboBoxFilterThema.setSelectedItem(setThema);
//        stopBeob = false;
//        filter();
//    }
    private synchronized void filter() {
        filter(false);
    }

    private synchronized void filter(boolean loeschen) {
        try {
            stopBeob = true;
            jTable1.setDefaultRenderer(Object.class, downloadCellRendererDefault);
            if (daten.filmeLaden.listeFilme.isEmpty()) {
                tModel1 = null;
                tabelleLoeschen();
//            zeilenZahl();
            } else {
                setInfo();
                if (jComboBoxFilterSender.getItemCount() == 0) {
                    jComboBoxFilterSender.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_SENDER_NR, "", 0)));
                    jComboBoxFilterSender.setSelectedIndex(0);
                }
                if (jComboBoxFilterThema.getItemCount() == 0) {
                    jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_THEMA_NR, "", 0)));
                    jComboBoxFilterThema.setSelectedIndex(0);
                }
                boolean themaNichtDa = false;
                String thema = jComboBoxFilterThema.getSelectedItem().toString();
                String sender = jComboBoxFilterSender.getSelectedItem().toString();
                boolean themaOpen = jComboBoxFilterThema.isPopupVisible();
                boolean senderOpen = jComboBoxFilterSender.isPopupVisible();
                //neu laden
                getSpalten(jTable1);
                if ((tModel1 = daten.filmeLaden.listeFilme.getModelTabFilme(jComboBoxFilterSender.getSelectedItem().toString(),
                        jComboBoxFilterThema.getSelectedItem().toString(),
                        !jComboBoxFilterThema.isEditable(),
                        jTextFieldFilterTitel.getText())) != null) {
                    jTable1.setModel(tModel1);
                    jTable1.setDefaultRenderer(Object.class, downloadCellRenderer);
                    jTable1.setDefaultRenderer(Datum.class, downloadCellRenderer);


//                TableCellRenderer dateRenderer = new DateTableCellRenderer("dd.MM.yyyy");
//                jTable1.setDefaultRenderer(Datum.class, dateRenderer);
//                TModelFilm model = (TModelFilm) jTable1.getModel();
//                TableRowSorter<TModelFilm> sorter = new TableRowSorter<TModelFilm>();
//                jTable1.setRowSorter(sorter);
//                sorter.setModel(model);

                    //Spalten ausblenden
                    setSpalten(jTable1);
                } else {
                    tabelleLoeschen();
                }
                if (tModel1 != null) {
                    //verkürzen
                    if (jCheckBoxVerkuerzen.isSelected()) {
                        tModel1.verkuerzen(Konstanten.FILM_SENDER_NR, Konstanten.FILM_THEMA_NR,
                                ((Number) jSpinnerVerkuerzen.getModel().getValue()).intValue());
                    }
                    if (jCheckBoxNurAbo.isSelected()) {
                        tModel1.nurAbo();
                    }
                    if (jCheckBoxKeineGesehenen.isSelected()) {
                        tModel1.keineGesehenen(daten);
                    }
                    //Combo Sender
                    jComboBoxFilterSender.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_SENDER_NR, "", 0)));
                    jComboBoxFilterSender.setSelectedIndex(0);
                    if (!sender.equals("")) {
                        jComboBoxFilterSender.setSelectedItem(sender);
                    }
                    //Thema-Model aufbauen
                    if (sender.equals("")) {
                        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(
                                daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_THEMA_NR, "", 0)));
                    } else {
                        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(
                                daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_THEMA_NR, sender, Konstanten.FILM_SENDER_NR)));
                    }
                    //wenn Thema bei dem Sender vorhanden, dann wieder setzen
                    for (ActionListener l : jComboBoxFilterThema.getActionListeners()) {
                        jComboBoxFilterThema.removeActionListener(l);
                    }
                    jComboBoxFilterThema.setSelectedItem(thema);
                    if (!thema.equals("") && jComboBoxFilterThema.getSelectedIndex() == 0) {
                        // war wohl nix
                        themaNichtDa = true;
                    }
                    jComboBoxFilterThema.setPopupVisible(themaOpen);
                    jComboBoxFilterThema.addActionListener(new BeobFilter());
                    jComboBoxFilterSender.setPopupVisible(senderOpen);
                }
                this.updateUI();
                //filtern
                stopBeob = false;
                if (themaNichtDa) {
                    // nochmal filtern anschieben
                    jComboBoxFilterThema.setSelectedIndex(0);
                }
            }
            Funktionen.spaltenFilmSetzen(jTable1, daten, Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR]), false /*ziel*/, false /*prog*/);
            zeilenZahl();
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "Filter");
        }
    }

    private void filterLoeschen() {
        stopBeob = true;
        //Combo Sender
        jCheckBoxVerkuerzen.setSelected(false);
        jCheckBoxNurAbo.setSelected(false);
        jComboBoxFilterSender.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_SENDER_NR, "", 0)));
        //Combo Thema
        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_THEMA_NR, "", 0)));
        jTextFieldFilterTitel.setText("");
        jComboBoxFilterSender.setSelectedIndex(0);
        jComboBoxFilterThema.setSelectedIndex(0);
        jCheckBoxKeineGesehenen.setSelected(false);
        //neu laden
        filter(true);
        stopBeob = false;
    }

    private void tabelleLoeschen() {
        // tModel1==null
        stopBeob = true;
        //Combo Sender
        jComboBoxFilterSender.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_SENDER_NR, "", 0)));
        jComboBoxFilterSender.setSelectedIndex(0);
        //Combo Thema
        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(daten.filmeLaden.listeFilme.getModelOfField(Konstanten.FILM_THEMA_NR, "", 0)));
        jComboBoxFilterThema.setSelectedIndex(0);
        stopBeob = false;
        jTable1.setDefaultRenderer(Object.class, downloadCellRendererDefault);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
                new Object[][]{}, Konstanten.FILME_COLUMN_NAMES));
    }

    private void zeilenZahl() {
        String text = "";
        String leer = "   -   ";
        int runs = daten.starterClass.getStarts(Starts.QUELLE_BUTTON).size();
        if (tModel1 != null) {
            text = tModel1.getRowCount() + " Filme";
        } else {
            text = "0 Filme";
        }
        if (runs == 1) {
            text += (leer + runs + "    laufender Film");
        } else if (runs > 1) {
            text += (leer + runs + "    laufende Filme");
        }
        jScrollPane1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, text,
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.ABOVE_BOTTOM));
    }

    private void table1Select() {
        DatenFilm aktFilm = new DatenFilm(daten);
        int selectedTableRow = jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = jTable1.convertRowIndexToModel(selectedTableRow);
            for (int i = 0; i < Konstanten.FILME_MAX_ELEM; ++i) {
                //aktFilm.arr[i] =  tModel1.getValueAt(selectedModelRow, i).toString();
                aktFilm.arr[i] = tModel1.getValueAt(selectedModelRow, i).toString();
            }
            dialogDatenFilm.show(aktFilm);
        }
    }

    private void open(int open) {
        //Url mit Prognr. starten
        String url = "";
        DatenFilm ersterFilm = new DatenFilm(daten);
        int selectedTableRows[] = jTable1.getSelectedRows();
        for (int l = 0; l < selectedTableRows.length; ++l) {
            int selectedModelRow = jTable1.convertRowIndexToModel(selectedTableRows[l]);
            if (l == 0) {
                for (int i = 0; i < Konstanten.FILME_MAX_ELEM; ++i) {
                    ersterFilm.arr[i] = tModel1.getValueAt(selectedModelRow, i).toString();
                }
            }
            if (url.equals("")) {
                //erste Url
                url += tModel1.getValueAt(selectedModelRow, Konstanten.FILM_URL_NR).toString();
            } else {
                //die anderen anhängen
                url += " " + tModel1.getValueAt(selectedModelRow, Konstanten.FILM_URL_NR).toString();
            }
        }
        daten.starterClass.urlStarten(url, open, ersterFilm);
        daten.history.add(url);
        daten.setGeaendertOhnePanel();
    }

    private void aboAnlegen() {
        if (jButtonAboAnlegen.getText().equals(ABO_BUTTON_TEXT_NORMAL)) {
            String sender = jComboBoxFilterSender.getSelectedItem().toString();
            String thema = jComboBoxFilterThema.getSelectedItem().toString();
            String titel = jTextFieldFilterTitel.getText();
            boolean exakt = !jComboBoxFilterThema.isEditable();
            if (sender.equals("") && thema.equals("") & titel.equals("")) {
                JOptionPane.showMessageDialog(null, "der Filter darf nicht leer sein!",
                        "Abo anlegen", JOptionPane.INFORMATION_MESSAGE);
            } else {
                if (!daten.listeAbo.addAbo(sender, thema, exakt, titel)) {
                    JOptionPane.showMessageDialog(null, "Abo existiert bereits!",
                            "Abo anlegen", JOptionPane.INFORMATION_MESSAGE);
                    daten.setGeaendertOhnePanel();
                }
            }
        } else {
            int nr = jTable1.getSelectedRow();
            if (nr >= 0) {
                nr = jTable1.convertRowIndexToModel(nr);
                String thema = tModel1.getValueAt(nr, Konstanten.FILM_THEMA_NR).toString();
                String sender = tModel1.getValueAt(nr, Konstanten.FILM_SENDER_NR).toString();
                String titel = tModel1.getValueAt(nr, Konstanten.FILM_TITEL_NR).toString();
                String url = tModel1.getValueAt(nr, Konstanten.FILM_URL_NR).toString();
                daten.listeAbo.addEinmalAbo(sender, thema, titel, url);
                daten.setGeaendertOhnePanel();
                filter();
            } else {
                new HinweisKeineAuswahl();
            }
        }
    }

    private void loadStop() {
        daten.filmeLaden.setStop();
        progressBar(0, 0, "");
    }

    private void progressBar(int max, int progress, String text) {
        String was = ""; //was wird geladen
        was = "Filmen"; // vom Sender laden
        if (max == 0) {
            jProgressBar1.setString(Funktionen.textLaenge(text));
            jProgressBar1.setIndeterminate(false);
            jProgressBar1.setMaximum(0);
            jProgressBar1.setMinimum(0);
            jProgressBar1.setValue(0);
            //          jProgressBar1.setStringPainted(false);
            jProgressBar1.setVisible(false);
            jButtonStop.setVisible(false);
        } else if (max == 1) {
            jProgressBar1.setString(Funktionen.textLaenge(text));
            jProgressBar1.setIndeterminate(true);
            jProgressBar1.setMaximum(1);
            jProgressBar1.setMinimum(0);
            jProgressBar1.setValue(0);
//            jProgressBar1.setStringPainted(false);
            jProgressBar1.setVisible(true);
            jButtonStop.setVisible(true);
        } else {
            jProgressBar1.setIndeterminate(false);
            jProgressBar1.setVisible(true);
            jButtonStop.setVisible(true);
            jProgressBar1.setMaximum(max);
            jProgressBar1.setMinimum(0);
            int proz = 0;
            if (progress != 0) {
                proz = progress * 100 / max;
                if (proz >= 100) {
                    proz = 99;
                }
            }
            String seiten = "";
            if (daten.filmeLaden.getSeitenZaehlerLauf() != 0) {
                seiten = daten.filmeLaden.getSeitenZaehlerLauf() + " Seiten  /  ";
            }
//            String tmp = "( " + daten.seitenZaehler + " Seiten, " + proz + " % /  von " + max + " Themen )  " + textLaenge(text);
            jProgressBar1.setString("( " + seiten + proz + "% von " + max + " " + was + " )  " + Funktionen.textLaenge(text));
            //jProgressBar1.setAlignmentX(JProgressBar.LEFT_ALIGNMENT);
            jProgressBar1.setStringPainted(true);
            jProgressBar1.setValue(progress);
        }
        jProgressBar1.setStringPainted(true);
    }

    private void senderLaden() {
        int selectedTableRow = jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            int sel = jTable1.convertRowIndexToModel(selectedTableRow);
            daten.filmeLaden.senderLaden(tModel1.getValueAt(sel, Konstanten.FILM_SENDER_NR).toString());
        } else {
            JOptionPane.showMessageDialog(null, "Es ist keine Zeile (Thema) markiert!", "Fehler!", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void importFilme() {
        new DialogImportFilme(null, true, daten).setVisible(true);
//        setButtonLaden();
    }

    private void dialogPgruppen() {
        new DialogPgruppen(null, true, daten, true, this).setVisible(true);
        extra();
    }

    private void checkPattern(JTextField tf) {
        String text = tf.getText();
        if (ListeAbo.isPattern(text)) {
            if (ListeAbo.makePattern(text) == null) {
                //soll Pattern sein, ist aber falsch
                tf.setBackground(Color.RED);
            } else {
                tf.setBackground(Color.PINK);
            }
        } else {
            tf.setBackground(Color.WHITE);
        }
    }

    private void setAboButton() {
        if (jButtonAboAnlegen.getText().equals(ABO_BUTTON_TEXT_NORMAL)) {
            jButtonAboAnlegen.setText(ABO_BUTTON_TEXT_EINMAL);
            jButtonAboAnlegen.setToolTipText("Ausgewählten Film als Einmalabo anlegen");
        } else {
            jButtonAboAnlegen.setText(ABO_BUTTON_TEXT_NORMAL);
            jButtonAboAnlegen.setToolTipText("Filter als Abo anlegen");
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenu2 = new javax.swing.JMenu();
        jMenuBar2 = new javax.swing.JMenuBar();
        jMenu3 = new javax.swing.JMenu();
        jMenu4 = new javax.swing.JMenu();
        jPanelExtra = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jProgressBar1 = new javax.swing.JProgressBar();
        jPanel1 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxFilterSender = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jComboBoxFilterThema = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldFilterTitel = new javax.swing.JTextField();
        jButtonFilterLoeschen = new javax.swing.JButton();
        jButtonAboAnlegen = new javax.swing.JButton();
        jButtonStop = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jTextFieldGeladen = new javax.swing.JTextField();
        jLabelGeladen = new javax.swing.JLabel();
        jButtonLaden = new javax.swing.JButton();
        jButtonEinstellungen = new javax.swing.JButton();
        jLabelAlter = new javax.swing.JLabel();
        jTextFieldAlter = new javax.swing.JTextField();

        jMenu1.setText("File");
        jMenuBar1.add(jMenu1);

        jMenu2.setText("Edit");
        jMenuBar1.add(jMenu2);

        jMenu3.setText("File");
        jMenuBar2.add(jMenu3);

        jMenu4.setText("Edit");
        jMenuBar2.add(jMenu4);

        jPanelExtra.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        javax.swing.GroupLayout jPanelExtraLayout = new javax.swing.GroupLayout(jPanelExtra);
        jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(
            jPanelExtraLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 858, Short.MAX_VALUE)
        );
        jPanelExtraLayout.setVerticalGroup(
            jPanelExtraLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jScrollPane1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "0 Zeilen", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.ABOVE_BOTTOM));

        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        jTable1.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        jScrollPane1.setViewportView(jTable1);

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 834, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 267, Short.MAX_VALUE)
                .addContainerGap())
        );

        jProgressBar1.setFont(new java.awt.Font("Monospaced", 1, 12));

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Filter"));

        jLabel2.setText("Sender:");

        jComboBoxFilterSender.setMaximumRowCount(25);

        jLabel3.setText("Thema:");

        jComboBoxFilterThema.setMaximumRowCount(25);

        jLabel5.setText("Titel:");

        jButtonFilterLoeschen.setText("x");
        jButtonFilterLoeschen.setToolTipText("Filter löschen");

        jButtonAboAnlegen.setText("Abo");
        jButtonAboAnlegen.setToolTipText("Filter als Abo anlegen");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBoxFilterSender, 0, 169, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBoxFilterThema, 0, 169, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldFilterTitel, javax.swing.GroupLayout.DEFAULT_SIZE, 170, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonFilterLoeschen)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonAboAnlegen)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jTextFieldFilterTitel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxFilterThema, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxFilterSender, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(jLabel3)
                    .addComponent(jLabel5)
                    .addComponent(jButtonFilterLoeschen, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonAboAnlegen))
                .addContainerGap())
        );

        jPanel1Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonAboAnlegen, jButtonFilterLoeschen, jComboBoxFilterSender, jComboBoxFilterThema, jTextFieldFilterTitel});

        jButtonStop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/process-stop.png"))); // NOI18N
        jButtonStop.setText("Stop");

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jTextFieldGeladen.setEditable(false);

        jLabelGeladen.setText("geladen am: ");

        jButtonLaden.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/view-refresh.png"))); // NOI18N
        jButtonLaden.setText("alle Filme neu laden");
        jButtonLaden.setToolTipText("Neuladen aller Sender starten");

        jButtonEinstellungen.setText("::");

        jLabelAlter.setText("Alter: ");

        jTextFieldAlter.setEditable(false);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButtonLaden)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonEinstellungen)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 486, Short.MAX_VALUE)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabelGeladen)
                        .addComponent(jTextFieldGeladen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabelAlter)
                        .addComponent(jTextFieldAlter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jTextFieldAlter, jTextFieldGeladen});

        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                        .addComponent(jButtonLaden)
                        .addComponent(jButtonEinstellungen))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(jLabelGeladen)
                            .addComponent(jTextFieldGeladen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabelAlter)
                            .addComponent(jTextFieldAlter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonEinstellungen, jButtonLaden});

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel4, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelExtra, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jProgressBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 763, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonStop))
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelExtra, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jProgressBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonStop))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonStop, jProgressBar1});

    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAboAnlegen;
    private javax.swing.JButton jButtonEinstellungen;
    private javax.swing.JButton jButtonFilterLoeschen;
    private javax.swing.JButton jButtonLaden;
    private javax.swing.JButton jButtonStop;
    private javax.swing.JComboBox jComboBoxFilterSender;
    private javax.swing.JComboBox jComboBoxFilterThema;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabelAlter;
    private javax.swing.JLabel jLabelGeladen;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenu jMenu4;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuBar jMenuBar2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanelExtra;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextFieldAlter;
    private javax.swing.JTextField jTextFieldFilterTitel;
    private javax.swing.JTextField jTextFieldGeladen;
    // End of variables declaration//GEN-END:variables

    private class BeobOpen implements ActionListener {
        //ext. Programme starten

        int open;

        public BeobOpen(int op) {
            open = op;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            open(open);
        }
    }

    private class BeobAboAnlegen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            aboAnlegen();
        }
    }

    private class BeobFilterSender implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!stopBeob) {
                filter();
            }
        }
    }

    private class BeobFilter implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!stopBeob) {
                filter();
            }
        }
    }

    private class BeobFilterLoeschen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            filterLoeschen();
        }
    }

    private class BeobachterNeuLaden implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            filmListeLaden();
        }
    }

    private class BeobachterLaden extends BeobFilmeLaden {

        @Override
        public void starten() {
            jButtonLaden.setEnabled(false);
            jButtonEinstellungen.setEnabled(false);
        }

        @Override
        public void initProgressBar(String sender, int threads, int max, int progress, String text) {
            progressBar(max, progress, text);
        }

        @Override
        public void beenden() {
            filter();
            Funktionen.spaltenFilmSetzen(jTable1, daten, Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR]), false /*ziel*/, false /*prog*/);
            jButtonLaden.setEnabled(true);
            jButtonEinstellungen.setEnabled(true);
        }
    }

    private class BeobachterTableSelect1 implements ListSelectionListener {

        public int selectedModelRow = -1;

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                table1Select();
            }
        }
    }

    private class BeobLoadStop implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            loadStop();
            filter();
            jButtonLaden.setEnabled(true);
            jButtonEinstellungen.setEnabled(true);
        }
    }

    private class BeobSpinnerVerkuerzen implements ChangeListener {

        @Override
        public void stateChanged(ChangeEvent arg0) {
            filter();
        }
    }

    public class BeobMausProgramme extends MouseAdapter {
        //rechhte Maustaste im Rahmen um die Tabelle

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON3) {
                showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            LinkedList<Starts> liste = daten.starterClass.getStarts(Starts.QUELLE_BUTTON);
            if (liste.size() > 0) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem item;
                Iterator<Starts> it = liste.iterator();
                while (it.hasNext()) {
                    Starts s = it.next();
                    // dann läuft er noch
                    item = new JMenuItem("Beenden: [" + s.film.arr[Konstanten.FILM_SENDER_NR] + "]  " + s.film.arr[Konstanten.FILM_TITEL_NR]);
                    item.addActionListener(new BeobProgramm(s));
                    jPopupMenu.add(item);
                }
                //anzeigen
                jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        private class BeobProgramm implements ActionListener {

            Starts s;

            public BeobProgramm(Starts ss) {
                s = ss;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (s != null) {
                        s.stoppen = true;
                    }
                } catch (Exception ex) {
                }
            }
        }
    }

    public class BeobMausTabelle extends MouseAdapter {
        //rechhte Maustaste in der Tabelle

        private BeobUrl beobUrl = new BeobUrl();
        private BeobPrint beobPrint = new BeobPrint();
        private BeobInfo beobInfo = new BeobInfo();
        private BeobFilterLoeschen beobLoeschen = new BeobFilterLoeschen();
        private BeobAbo beobAbo = new BeobAbo(false);
        private BeobAbo beobAboMitTitel = new BeobAbo(true);
        private BeobAboEinmal beobAboEinmal = new BeobAboEinmal();
        private BeobFilterThema beobThema = new BeobFilterThema();
        private BeobFilterSender beobSender = new BeobFilterSender();
        private BeobFilterSenderThema beobSenderThema = new BeobFilterSenderThema();
        private BeobFilterSenderThemaTitel beobSenderThemaTitel = new BeobFilterSenderThemaTitel();
        private BeobSenderLaden beobSenderLaden = new BeobSenderLaden();
        private BeobBlacklist boeobBlacklistSender = new BeobBlacklist(true, false);
        private BeobBlacklist boeobBlacklistSenderThema = new BeobBlacklist(true, true);
        private Point p;
        JPanel panelVerkuerzen = new JPanel();
        JPanel panelNurAbo = new JPanel();
        JPanel panelKeineGesehenen = new JPanel();

        public BeobMausTabelle() {
            jCheckBoxVerkuerzen.setSelected(false);
            jSpinnerVerkuerzen.setModel(new javax.swing.SpinnerNumberModel(1, 1, 10, 1));
            jSpinnerVerkuerzen.addChangeListener(new BeobSpinnerVerkuerzen());
            jCheckBoxVerkuerzen.addActionListener(new BeobVerkuerzen());
            jCheckBoxNurAbo.setSelected(false);
            jCheckBoxNurAbo.addActionListener(new BeobVerkuerzen());
            jCheckBoxKeineGesehenen.addActionListener(new BeobVerkuerzen());
            jCheckBoxKeineGesehenen.setSelected(false);
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON3) {
                showMenu(arg0);
            }
            if (arg0.getButton() == MouseEvent.BUTTON1) {
                if (arg0.getClickCount() > 1) {
                    int nr = daten.listePgruppeButton.getDoppelklick();
                    if (nr >= 0) {
                        open(nr);
                    } else {
                        JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.",
                                "keine Standardbutton!", JOptionPane.INFORMATION_MESSAGE);
                    }
                }
            }
        }

        private void showMenu(MouseEvent evt) {
            p = evt.getPoint();
            int nr = jTable1.rowAtPoint(p);
            if (nr >= 0) {
                jTable1.setRowSelectionInterval(nr, nr);
            }
            String thema = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_THEMA_NR).toString();
            String sender = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_SENDER_NR).toString();
            String text = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_TITEL_NR).toString();
            String url = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_URL_NR).toString();
            JPopupMenu jPopupMenu = new JPopupMenu();
            //Thema laden
            JMenuItem item = new JMenuItem("Sender aktualisieren");
            item.addActionListener(beobSenderLaden);
            jPopupMenu.add(item);
            //##Trenner##
            jPopupMenu.addSeparator();
            //##Trenner##
            //Url
            item = new JMenuItem("URL kopieren");
            item.addActionListener(beobUrl);
            jPopupMenu.add(item);
            //Drucken
            item = new JMenuItem("Tabelle Drucken");
            item.addActionListener(beobPrint);
            jPopupMenu.add(item);
            //Infos
            item = new JMenuItem("Infos anzeigen");
            item.addActionListener(beobInfo);
            jPopupMenu.add(item);
            //##Trenner##
            jPopupMenu.addSeparator();
            //##Trenner##
            JMenu submenueFilter = new JMenu("Filter");
            jPopupMenu.add(submenueFilter);
            //Filter löschen
            item = new JMenuItem("Filter löschen");
            item.addActionListener(beobLoeschen);
            submenueFilter.add(item);
            //Sender
            item = new JMenuItem("nach Sender filtern");
            item.addActionListener(beobSender);
            submenueFilter.add(item);
            //Thema
            item = new JMenuItem("nach Thema filtern");
            item.addActionListener(beobThema);
            submenueFilter.add(item);
            //Thema+Sender
            item = new JMenuItem("nach Sender und Thema filtern");
            item.addActionListener(beobSenderThema);
            submenueFilter.add(item);
            //Thema+Sender+Titel
            item = new JMenuItem("nach Sender, Thema und Titel filtern");
            item.addActionListener(beobSenderThemaTitel);
            submenueFilter.add(item);
            //##Trenner##
            submenueFilter.addSeparator();
            //##Trenner##
            panelNurAbo.setLayout(new BorderLayout());
            panelNurAbo.add(jCheckBoxNurAbo, BorderLayout.WEST);
            submenueFilter.add(panelNurAbo);
            panelKeineGesehenen.setLayout(new BorderLayout());
            panelKeineGesehenen.add(jCheckBoxKeineGesehenen, BorderLayout.WEST);
            submenueFilter.add(panelKeineGesehenen);
            //
            panelVerkuerzen.setLayout(new BorderLayout());
            panelVerkuerzen.add(jCheckBoxVerkuerzen, BorderLayout.CENTER);
            panelVerkuerzen.add(jSpinnerVerkuerzen, BorderLayout.EAST);
            submenueFilter.add(panelVerkuerzen);
            if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR])) {
                JMenu submenueAbo = new JMenu("Abo");
                jPopupMenu.add(submenueAbo);
                //Abo anlegen
                JMenuItem itemAboLoeschen;
                JMenuItem itemAbo;
                JMenuItem itemAboMitTitel;
                JMenuItem itemAboEinmal;
                itemAboLoeschen = new JMenuItem("Abo Löschen");
                itemAbo = new JMenuItem("Abo mit Sender und Thema anlegen");
                itemAboMitTitel = new JMenuItem("Abo mit Sender und Thema und Titel anlegen");
                itemAboEinmal = new JMenuItem("Film zum einmaligem Download eintragen");
                if ((daten.listeAbo.getAbo(sender, thema, text, url)) != null) {
                    //gibts schon, dann löschen
                    itemAbo.setEnabled(false);
                    itemAboMitTitel.setEnabled(false);
                    itemAboLoeschen.addActionListener(beobAbo);
                    itemAboEinmal.setEnabled(false);
                } else {
                    itemAboLoeschen.setEnabled(false);
                    //neues Abo anlegen
                    itemAbo.addActionListener(beobAbo);
                    itemAboMitTitel.addActionListener(beobAboMitTitel);
                    itemAboEinmal.addActionListener(beobAboEinmal);
                }
                submenueAbo.add(itemAboEinmal);
                //##Trenner##
                submenueAbo.addSeparator();
                //##Trenner##
                submenueAbo.add(itemAboLoeschen);
                submenueAbo.add(itemAbo);
                submenueAbo.add(itemAboMitTitel);
            }
            //Programme einblenden
            JMenu submenue = new JMenu("Film mit Programm starten:");
            jPopupMenu.add(submenue);
            for (int i = 0; i < daten.listePgruppeButton.size(); ++i) {
                DatenPgruppe pgruppe = daten.listePgruppeButton.get(i);
                Color col = pgruppe.getFarbe(daten);
                item = new JMenuItem(pgruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR]);
                if (pgruppe.getListeProg().isEmpty()) {
                    if (col != null) {
                        item.setForeground(col);
                    }
                } else {
                    item.addActionListener(new BeobOpen(i));
                    if (col != null) {
                        item.setBackground(col);
                    }
                }
                submenue.add(item);
            }
            //##Trenner##
            submenueFilter.addSeparator();
            //##Trenner##
            JMenu submenueBlack = new JMenu("Blacklist");
            jPopupMenu.add(submenueBlack);
            //anlegen
            JMenuItem itemBlackSender;
            JMenuItem itemBlackSenderThema;
            itemBlackSender = new JMenuItem("Sender in die Blacklist einfügen");
            itemBlackSenderThema = new JMenuItem("Sender und Thema in die Blacklist einfügen");
            itemBlackSender.addActionListener(boeobBlacklistSender);
            itemBlackSenderThema.addActionListener(boeobBlacklistSenderThema);
            submenueBlack.add(itemBlackSender);
            submenueBlack.add(itemBlackSenderThema);
            //anzeigen
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobSenderLaden implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                senderLaden();
            }
        }

        private class BeobUrl implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = jTable1.rowAtPoint(p);
                if (nr >= 0) {
                    Funktionen.copyToClipboard(
                            jTable1.getModel().getValueAt(jTable1.convertRowIndexToModel(nr),
                            Konstanten.FILM_URL_NR).toString());
                }
            }
        }

        private class BeobPrint implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    jTable1.print();
                } catch (PrinterException ex) {
                    daten.fehler.fehlerMeldung(ex, "GuiFilme.BeobPrint - Fehler beim Drucken");
                }
            }
        }

        private class BeobInfo implements ActionListener {
            //Infos zum Film anzeigen

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogDatenFilm.setVisible(true);
                dialogDatenFilm.toFront();
            }
        }

        private class BeobVerkuerzen implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!stopBeob) {
                    filter();
                }
            }
        }

        private class BeobFilterThema implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = jTable1.rowAtPoint(p);
                if (nr >= 0) {
                    stopBeob = true;
                    String thema = "";
                    thema = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_THEMA_NR).toString();
                    jComboBoxFilterThema.setSelectedIndex(0);
                    jComboBoxFilterThema.setSelectedItem(thema);
                    stopBeob = false;
                    filter();
                }
            }
        }

        private class BeobFilterSender implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = jTable1.rowAtPoint(p);
                if (nr >= 0) {
                    stopBeob = true;
                    String sender = "";
                    sender = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_SENDER_NR).toString();
                    jComboBoxFilterSender.setSelectedIndex(0);
                    jComboBoxFilterSender.setSelectedItem(sender);
                    stopBeob = false;
                    filter();
                }
            }
        }

        private class BeobFilterSenderThema implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = jTable1.rowAtPoint(p);
                if (nr >= 0) {
                    stopBeob = true;
                    String sender = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_SENDER_NR).toString();
                    jComboBoxFilterSender.setSelectedIndex(0);
                    jComboBoxFilterSender.setSelectedItem(sender);
                    String thema = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_THEMA_NR).toString();
                    jComboBoxFilterThema.setSelectedIndex(0);
                    jComboBoxFilterThema.setSelectedItem(thema);
                    stopBeob = false;
                    filter();
                }
            }
        }

        private class BeobFilterSenderThemaTitel implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = jTable1.rowAtPoint(p);
                if (nr >= 0) {
                    stopBeob = true;
                    String sender = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_SENDER_NR).toString();
                    jComboBoxFilterSender.setSelectedIndex(0);
                    jComboBoxFilterSender.setSelectedItem(sender);
                    String thema = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_THEMA_NR).toString();
                    jComboBoxFilterThema.setSelectedIndex(0);
                    jComboBoxFilterThema.setSelectedItem(thema);
                    String titel = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_TITEL_NR).toString();
                    jTextFieldFilterTitel.setText(titel);
                    stopBeob = false;
                    filter();
                }
            }
        }

        private class BeobFilterLoeschen implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                filterLoeschen();
            }
        }

        private class BeobAbo implements ActionListener {

            boolean mitTitel = false;

            public BeobAbo(boolean mmitTitel) {
                mitTitel = mmitTitel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = jTable1.rowAtPoint(p);
                if (nr >= 0) {
                    stopBeob = true;
                    String thema = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_THEMA_NR).toString();
                    String sender = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_SENDER_NR).toString();
                    String titel = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_TITEL_NR).toString();
                    String url = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_URL_NR).toString();
                    DatenAbo datenAbo;
                    if ((datenAbo = daten.listeAbo.getAbo(sender, thema, titel, url)) != null) {
                        //gibts schon, dann löschen
                        daten.listeAbo.aboLoeschen(datenAbo);
                    } else {
                        //neues Abo anlegen
                        if (mitTitel) {
                            daten.listeAbo.addAbo(sender, thema, true, titel);
                        } else {
                            daten.listeAbo.addAbo(sender, thema, true, "");
                        }
                    }
                    daten.setGeaendertOhnePanel();
                    stopBeob = false;
                    filter();
                }
            }
        }

        private class BeobBlacklist implements ActionListener {

            boolean sender;
            boolean thema;

            public BeobBlacklist(boolean ssender, boolean tthema) {
                sender = ssender;
                thema = tthema;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = jTable1.rowAtPoint(p);
                if (nr >= 0) {
                    String th = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_THEMA_NR).toString();
                    String se = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_SENDER_NR).toString();
                    if (!sender) {
                        daten.listeBlacklist.add(new DatenBlacklist("", th));
                    } else if (!thema) {
                        daten.listeBlacklist.add(new DatenBlacklist(se, ""));
                    } else {
                        daten.listeBlacklist.add(new DatenBlacklist(se, th));
                    }
                    filter();
                    daten.setGeaendertOhnePanel();
                }
            }
        }

        private class BeobAboEinmal implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = jTable1.rowAtPoint(p);
                if (nr >= 0) {
                    stopBeob = true;
                    String thema = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_THEMA_NR).toString();
                    String sender = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_SENDER_NR).toString();
                    String titel = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_TITEL_NR).toString();
                    String url = tModel1.getValueAt(jTable1.convertRowIndexToModel(nr), Konstanten.FILM_URL_NR).toString();
                    daten.listeAbo.addEinmalAbo(sender, thema, titel, url);
                }
                daten.setGeaendertOhnePanel();
                stopBeob = false;
                filter();
            }
        }
    }

    private class BeobImportDialog implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            importFilme();
        }
    }

    private class BeobMausTextCombo extends MouseAdapter {

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON3) {
                boolean ed = jComboBoxFilterThema.isEditable();
                jComboBoxFilterThema.setEditable(!ed);
                filter();
            }
        }
    }

    private class BeobMausAboButton extends MouseAdapter {

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON3) {
                setAboButton();
            }
        }
    }

    private class BeobMausPgruppenDialog extends MouseAdapter {

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON3) {
                dialogPgruppen();
            }
        }
    }

    private class BeobAbstractAction extends AbstractAction {

        @Override
        public void actionPerformed(ActionEvent e) {
            int nr = daten.listePgruppeButton.getDoppelklick();
            if (nr >= 0) {
                open(nr);
            } else {
                JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.",
                        "keine Standardbutton!", JOptionPane.INFORMATION_MESSAGE);
            }
        }
    }

    private class BeobFilterTitelDoc implements DocumentListener {

        @Override
        public void insertUpdate(DocumentEvent e) {
            checkPattern(jTextFieldFilterTitel);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            checkPattern(jTextFieldFilterTitel);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            checkPattern(jTextFieldFilterTitel);
        }
    }

    private class BeobTimerAlter implements TimerListener {

        @Override
        public void ping() {
            setInfo();
        }

        @Override
        public void reset() {
        }
    }

    private class BeobachterStart implements StartListener {

        @Override
        public void starter(StartEvent ev) {
            zeilenZahl();
        }
    }
//    class DateTableCellRenderer extends DownloadCellRenderer {
//
//        private Format format;
//
//        public DateTableCellRenderer(final String pattern) {
//            super(daten, true /*starts*/, true /*Abo*/, Starts.QUELLE_BUTTON, true /*gesehen*/);
//            this.format = new SimpleDateFormat(pattern);
//        }
//
////        public void setValue(final Object value) {
////            setText(format.format(value));
////        }
//    }
}
