/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.daten;

import mediathek.Funktionen;
import mediathek.Konstanten;
import java.awt.Color;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import mediathek.io.starter.Starts;

public class DatenPgruppe {

    public String[] arr;
    private ListeProg listeProg = new ListeProg();

    public DatenPgruppe() {
        makeArray();
    }

    public DatenPgruppe(String name, String suffix, String farbe, String zielPfad, String zielDateiname) {
        makeArray();
        arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = name;
        arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = suffix;
        arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR] = farbe;
        arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = zielPfad;
        arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = zielDateiname;
    }

    // public
    public boolean addProg(DatenProg prog) {
        return listeProg.add(prog);
    }

    public ListeProg getListeProg() {
        return listeProg;
    }

    public DatenProg getProg(int i) {
        return listeProg.get(i);
    }

    public DatenProg getProgUrl(String url) {
        //mit einer Url das Passende Programm finden
        //passt nichts, wird das letzte Programm genommen
        //ist nur ein Programm in der Liste wird dieses genommen
        DatenProg ret = null;
        if (listeProg.size() == 0) {
            JOptionPane.showMessageDialog(null, "Programme einrichten!",
                                          "Kein Programm", JOptionPane.INFORMATION_MESSAGE);
        } else if (listeProg.size() == 1) {
            ret = listeProg.getFirst();
        } else {
            Iterator<DatenProg> it = listeProg.iterator();
            DatenProg prog;
            while (it.hasNext()) {
                prog = it.next();
                if (prog.urlTesten(url)) {
                    ret = prog;
                    break;
                }
            }
            if (listeProg.size() > 0 && ret == null) {
                ret = listeProg.getLast();
            }
        }
        return ret;
    }

    public String getZielDateiname() {
        //gibt den Zieldateinamen für den Film zurück
        return arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR];
    }

    public String getZielPfad() {
        //gibt den Zielpfad für den Film zurück
        return arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR];
    }

    public DatenPgruppe copy() {
        DatenPgruppe ret = new DatenPgruppe();
        for (int i = 0; i < arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        //es darf nur einen geben!
        arr[Konstanten.PROGRAMMGRUPPE_DOPPELKLICK_NR] = Boolean.toString(false);
        ListIterator<DatenProg> it = getListeProg().listIterator(0);
        while (it.hasNext()) {
            ret.addProg(it.next().copy());
        }
        return ret;
    }

    public Color getFarbe(Daten daten) {
        Color ret = null;
        String r, g, b;
        if (!arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR].equals("")) {
            r = arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR].substring(0, arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR].indexOf(","));
            g = arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR].substring(arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR].indexOf(",") + 1,
                                                                  arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR].lastIndexOf(","));
            b = arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR].substring(arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR].lastIndexOf(",") + 1);
            try {
                ret = new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
            } catch (Exception ex) {
                 daten.fehler.fehlerMeldung(ex, "DatenProg.getFarbe");
            }
        }
        return ret;
    }

    public void setFarbe(Color farbe) {
        arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR] =
        String.valueOf(farbe.getRed()) + "," + String.valueOf(farbe.getGreen()) + "," + String.valueOf(farbe.getBlue());
    }

    public int checkDownloadDirekt(Daten daten, String url) {
        //Starts.ART_ZDF_DIREKT     3   wenn die Url eine Datei zum direkten Download ist
        //Starts.ART_ZDF            2   sonst, normaler Stream
        int ret = Starts.ART_PROGRAMM;
        //auf direkte prüfen, pref oder suf: wenn angegeben dann muss es stimmen
        if (!this.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR].equals("")
            || !this.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR].equals("")) {
            if (Funktionen.praefixTesten(this.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR], url, true)
                && Funktionen.praefixTesten(this.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR], url, false)) {
                ret = Starts.ART_DOWNLOAD;
            }
        }
        return ret;
    }

    //===================================
    // Private
    //===================================
    private void makeArray() {
        arr = new String[Konstanten.PROGRAMMGRUPPE_MAX_ELEM];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new String("");
        }
    }

}
