/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.beobachter;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;

public class DownloadCellRendererAbo extends DefaultTableCellRenderer {

    Daten daten;

    public DownloadCellRendererAbo(Daten d) {
        daten = d;
    }

    @Override
    public Component getTableCellRendererComponent(
            JTable table,
            Object value,
            boolean isSelected,
            boolean hasFocus,
            int row,
            int column) {
        setBackground(null);
        setForeground(null);
        setFont(null);
        super.getTableCellRendererComponent(
                table, value, isSelected, hasFocus, row, column);
        try {
            int r = table.convertRowIndexToModel(row);
            DatenAbo abo = daten.listeAbo.getEinmalAbo( table.getModel().getValueAt(r, Konstanten.ABO_EINMAL_URL_NR).toString());
            if (abo != null /*enmal-Abo wenn schon gelöscht*/) {
                setForeground(Konstanten.DOWNLOAD_FARBE_ABO_EINMAL);
                setFont(new java.awt.Font("Dialog", 3, 12));
            }
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "DownloadCellRenderer.getTabeleCellRendererComponent: Kann eigentlich nicht sein!");
        }
        return this;
    }
}
