/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek;

import mediathek.daten.Daten;

public class Fehler {

    private boolean progress = false;

    public Fehler(Daten ddaten) {
        daten = ddaten;
    }
    private Daten daten;

    public synchronized void fehlerMeldung(Exception ex, String text) {
        progress();
        fehlerMeldung_("Fehler", new String[]{ex.getMessage(), text});
    }

    public synchronized void fehlerMeldung(String titel, String text) {
        progress();
        fehlerMeldung_(titel, new String[]{text});
    }

    public synchronized void fehlerMeldung(String titel, String[] text) {
        progress();
        fehlerMeldung_(titel, text);
    }

    public synchronized void systemMeldung(String titel, String[] text) {
        progress();
        if (daten.dialogFehler != null) {
            daten.dialogFehler.addTextMeldung(titel, text);
        }
        for (int i = 0; i < text.length; ++i) {
            System.out.println(titel + ": " + text[i]);
        }
    }

    public synchronized void progressMeldung(String text) {
        progress = true;
        System.out.print(text);
    }

    public synchronized void systemMeldung(String text) {
        progress();
        if (daten.dialogFehler != null) {
            daten.dialogFehler.addTextMeldung(text);
        }
        System.out.println(text);
    }

    public synchronized void playerMeldung(String titel, String text) {
        progress();
        if (daten.dialogFehler != null) {
            daten.dialogFehler.addTextPlayer(titel, text);
        }
        if (daten.progAusgabe) {
            System.out.println(titel + ": " + text);
        }
    }

    private void fehlerMeldung_(String titel, String[] texte) {
        if (!daten.keinFehlerFenster) {
            if (daten.dialogFehler != null) {
                if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_FEHLER_ANZEIGEN_NR])) {
                    daten.dialogFehler.setVisible(true);
                }
                daten.dialogFehler.addTextFehler(titel, texte);
            }
            System.out.println("**************************************************");
            System.out.println("Fehler:");
            for (int i = 0; i < texte.length; ++i) {
                System.out.println(texte[i]);
            }
            System.out.println("**************************************************" + "\n");
        }
    }

    private void progress() {
        if (progress) {
            // Zeile löschen
            progress = false;
            System.out.print("                                                                              \r");
        }
    }
}
