/* NullMouseHandler.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.mouse;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

/**
 * Mouse handler that does not perform any action. Usefull as a 'null object'
 * or as a superclass for handlers that only need to override a few methods.
 */
public class NullMouseHandler implements MouseHandler {
    
    // implements MouseHandler
    public void doMouseReleased(JComponent parent, MouseEvent mouseEvent, MouseEvent pressedEvent) {
        // trivial implementation
    }

    // implements MouseHandler
    public void doPopup(JComponent parent, MouseEvent mouseEvent) {
        // trivial implementation
    }

    // implements MouseHandler
    public void doMouseDragged(JComponent parent, MouseEvent mouseEvent, MouseEvent previousEvent, MouseEvent pressedEvent) {
        // trivial implementation
    }

    // implements MouseHandler
    public void doMousePressed(JComponent parent, MouseEvent mouseEvent) {
        // trivial implementation
    }

    // implements MouseHandler
    public void doMouseClicked(JComponent parent, MouseEvent mouseEvent) {
        // trivial implementation
    }

    // implements MouseHandler
    public void paintDragging(JComponent parent, Graphics g, MouseEvent mouseEvent, MouseEvent previousEvent, MouseEvent pressedEvent) {
        // trivial implementation
    }

    // implements MouseHandler
    public boolean canHandle(JComponent parent) {
        return false;
    }
    
}
