/* ToToolBar.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.menus;

import be.ugent.caagt.swirl.actions.Description;
import be.ugent.caagt.swirl.actions.ToolBarButton;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToggleButton;

/**
 * Builds menu items from configuration elements and adds them to
 * a given tool bar.<p> 
 * Currently does not allow submenus to appear in
 * a tool bar.
 */
class ToToolBar extends MenuBuilderVisitor {

    //
    private final JComponent parent;
    
    /**
     * Create an object of this type
     * @param ctm Visitor which is used for creating submenus
     */
    public ToToolBar(JComponent parent, MenuBuilder builder) {
        super(builder);
        this.parent = parent;
    }
    
    //
    private static final Dimension RIGID_AREA
            = new Dimension (10, 10);

    protected void addSeparator(boolean glue) {
        if (glue)
            parent.add (Box.createGlue());
        else
            parent.add (Box.createRigidArea(RIGID_AREA));
    }

    protected AbstractButton addAction(Action action) {
        AbstractButton button = new ToolBarButton(action);
        parent.add(button);
        return button;
    }
    protected AbstractButton addButton(Description description) {
        AbstractButton button = new JToggleButton();
        description.init(button);
        parent.add(button);
        return button;
    }

    protected AbstractButton addToggle(ButtonModel model, Description description) {
        AbstractButton button = new JToggleButton();
        button.setModel(model);
        description.init(button);
        parent.add(button);
        return button;
    }

    protected void addMenu(JMenu menu, Iterable<EntryConfiguration> entries) {
        throw new UnsupportedOperationException("Submenus are currently only allowed as part of other menus");
    }
}
