/*
 *  @(#)AsmblState.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.assembler;


import net.sourceforge.groboutils.mbtf.v1.IState;
import net.sourceforge.groboutils.mbtf.v1.IValidate;
import net.sourceforge.groboutils.mbtf.v1.ITransition;

import net.sourceforge.groboutils.mbtf.v1.engine.StateImpl;

import java.util.Vector;


/**
 * 
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 12, 2002
 */
public class AsmblState
{
    private String name;
    private Vector validates = new Vector();
    private Vector transNames = new Vector();
    private boolean startState;
    private boolean endState;
    
    /**
     * 
     */
    public AsmblState()
    {
        // do nothing
    }
    
    
    public void setName( String name )
    {
        if (name == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        this.name = name;
    }
    
    
    public String getName()
    {
        return this.name;
    }
    
    
    public void addValidate( IValidate v )
    {
        if (v != null)
        {
            this.validates.addElement( v );
        }
    }
    
    
    public void addTransitionName( String n )
    {
        if (n != null)
        {
            this.transNames.addElement( n );
        }
    }
    
    
    public IValidate[] getValidates()
    {
        IValidate v[] = new IValidate[ this.validates.size() ];
        this.validates.copyInto( v );
        return v;
    }
    
    
    public String[] getTransitionNames()
    {
        String s[] = new String[ this.transNames.size() ];
        this.transNames.copyInto( s );
        return s;
    }
    
    
    public void setIsStartState( boolean on )
    {
        this.startState = on;
    }
    
    
    public boolean isStartState()
    {
        return this.startState;
    }
    
    
    public void setIsFinalState( boolean on )
    {
        this.endState = on;
    }
    
    
    public boolean isFinalState()
    {
        return this.endState;
    }
    
    
    /**
     * Use the given transition set to create this state.
     *
     * @exception IllegalArgumentException if one of the transition names in
     *      this state is not in the transition set.
     */
    public IState createState( AsmblTransitionSet set )
    {
        // Find all the transitions
        String transNames[] = getTransitionNames();
        int len = transNames.length;
        ITransition t[] = new ITransition[ len ];
        
        for (int i = len; --i >= 0;)
        {
            AsmblTransition at = set.getTransition( transNames[i] );
            if (at == null)
            {
                throw new IllegalArgumentException("expecting transition '"+
                    transNames[i]+"'");
            }
            t[i] = at.getTransition();
        }
        
        return new StateImpl( getName(), t, getValidates() );
    }
}

