/*
 * @(#)FailOnReportStyleUTest.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.ant;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;

import org.apache.tools.ant.BuildException;


/**
 * Tests the FailOnReportStyle class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/07/07 09:39:12 $
 * @since     March 19, 2004
 */
public class FailOnReportStyleUTest extends AntTestA
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = FailOnReportStyleUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public FailOnReportStyleUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    //...........................
    // Non-ant tests
    
    public void testClassFilterConstructor1()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( null );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf( "Invalid class filter '" ) >= 0 );
        }
    }
    
    public void testClassFilterConstructor2()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( ".a" );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf( "Invalid class filter '" ) >= 0 );
        }
    }
    
    public void testClassFilterConstructor3()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( "" );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf( "Invalid class filter '" ) >= 0 );
        }
    }
    
    public void testClassFilterConstructor4()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( "a..b" );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf( "Invalid class filter '" ) >= 0 );
        }
    }
    
    public void testClassFilterConstructor5()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( "a//b" );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf( "Invalid class filter '" ) >= 0 );
        }
    }
    
    public void testClassFilterConstructor6()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( "a." );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf( "Invalid class filter '" ) >= 0 );
        }
    }
    
    public void testClassFilterConstructor7()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( "a.b*c" );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf(
                    "Invalid class filter: a wildcard may "+
                    "only be present before and after a text part." ) >= 0 );
        }
    }
    
    public void testClassFilterConstructor8()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( "a.b**.c" );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf( "Invalid class filter: "+
                    "only 1 wildcard may be present between delimiters." ) >= 0 );
        }
    }
    
    public void testClassFilterConstructor9()
    {
        try
        {
            FailOnReportStyle.ClassFilter cf =
                new FailOnReportStyle.ClassFilter( "a/" );
            fail( "Did not throw a BuildException." );
        }
        catch (BuildException be)
        {
            assertTrue(
                "Does not contain correct exception text.",
                be.getMessage().indexOf( "Invalid class filter '" ) >= 0 );
        }
    }
    
    public void testClassFilterMatch1()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.B" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.B$C" ) );
    }
    
    public void testClassFilterMatch2()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.B" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.B.c" ) );
    }
    
    public void testClassFilterMatch3()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.B" );
        assertTrue(
            "Should have matched the filter.",
            cf.match( "a.B" ) );
    }
    
    public void testClassFilterMatch4()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*" );
        assertTrue(
            "Should have matched the filter.",
            cf.match( "a.B" ) );
    }
    
    public void testClassFilterMatch5()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*" );
        assertTrue(
            "Should have matched the filter.",
            cf.match( "a.B$C" ) );
    }
    
    public void testClassFilterMatch6()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.B.C" ) );
    }
    
    public void testClassFilterMatch7()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.b.c.C" ) );
    }
    
    public void testClassFilterMatch8()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.b.C$" ) );
    }
    
    public void testClassFilterMatch9()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*.C" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.b.C" ) );
    }
    
    public void testClassFilterMatch10()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.b*.C" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.b.C" ) );
    }
    
    public void testClassFilterMatch11()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.b*.C" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.bc.C" ) );
    }
    
    public void testClassFilterMatch12()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.b*.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.ab.C" ) );
    }
    
    public void testClassFilterMatch13()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.b*.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.ba.D" ) );
    }
    
    public void testClassFilterMatch14()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*bc.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.bca.C" ) );
    }
    
    public void testClassFilterMatch15()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*bc.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.b.C" ) );
    }
    
    public void testClassFilterMatch16()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*bc.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.bc.D" ) );
    }
    
    public void testClassFilterMatch17()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*bc.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.bc.CD" ) );
    }
    
    public void testClassFilterMatch18()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*bc.C" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.bc.C" ) );
    }
    
    public void testClassFilterMatch19()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.*bc.C" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.adbbc.C" ) );
    }
    
    public void testClassFilterMatch20()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.**.C" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.adbbc.C" ) );
    }
    
    /**
     * Special case!!!!
     */
    public void testClassFilterMatch21()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.**.C" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.C" ) );
    }
    
    public void testClassFilterMatch22()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.**.C" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.B.a.a.a.a.a.a.a.a.a.a.C" ) );
    }
    
    public void testClassFilterMatch23()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.**.C" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a.B.a.C.a.a.a.a.a.a.a.a.C" ) );
    }
    
    public void testClassFilterMatch24()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.**" );
        assertTrue(
            "Did not matched the filter.",
            cf.match( "a.B.a.a.a.a.a.a.a.a.a.a.C" ) );
    }
    
    public void testClassFilterMatch25()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.**" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "b.C" ) );
    }
    
    public void testClassFilterMatch26()
    {
        FailOnReportStyle.ClassFilter cf =
            new FailOnReportStyle.ClassFilter( "a.**" );
        assertFalse(
            "Incorrectly matched the filter.",
            cf.match( "a" ) );
    }
    
    
    //...........................
    // Tests that pass
    
    
    public void testFailon1()
    {
        try
        {
            executeTarget( "failon-1" );
        }
        finally
        {
            System.out.println( "--------------------------------" );
            System.out.println( "failon-1:" );
            System.out.println( getFullLog() );
        }
    }
    
    public void testFailon2()
    {
        executeTarget( "failon-2" );
    }
    
    public void testFailon3()
    {
        executeTarget( "failon-3" );
    }
    
    public void testFailon4()
    {
        executeTarget( "failon-4" );
    }
    
    public void testFailon5()
    {
        try
        {
            executeTarget( "failon-5" );
        }
        finally
        {
            System.out.println( "--------------------------------" );
            System.out.println( "failon-5:" );
            System.out.println( getFullLog() );
        }
    }
    
    
    //...........................
    // Tests that fail
    
    
    public void testFFailon1()
    {
        expectBuildException( "f-failon-1",
            "Did not fail for below coverage numbers." );
    }
    
    public void testFFailon2()
    {
        expectBuildExceptionContaining( "f-failon-2",
            "Did not fail for invalid filter.",
            "Invalid class filter '" );
    }
    
    public void testFFailon3()
    {
        expectBuildExceptionContaining( "f-failon-3",
            "Did not fail for invalid filter.",
            "Invalid class filter '" );
    }
    
    public void testFFailon4()
    {
        expectBuildExceptionContaining( "f-failon-4",
            "Did not fail for invalid filter.",
            "Invalid class filter '" );
    }
    
    public void testFFailon5()
    {
        expectBuildExceptionContaining( "f-failon-5",
            "Did not fail for invalid filter.",
            "Invalid class filter '" );
    }
    
    public void testFFailon6()
    {
        expectBuildExceptionContaining( "f-failon-6",
            "Did not fail for invalid filter.",
            "Invalid class filter '" );
    }
    
    public void testFFailon7()
    {
        expectBuildExceptionContaining( "f-failon-7",
            "Did not fail for nothing specified.",
            "One of 'module' or 'class' attributes must be specified in an include element." );
    }
    
    public void testFFailon8()
    {
        expectBuildException( "f-failon-8",
            "Did not fail for below coverage numbers." );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected void assertEquals( String text, Properties expected,
            Properties actual )
    {
        PropertyCheckUtil.assertEquals( text, expected, actual );
    }
    

    protected Properties loadGroboProperties()
            throws IOException
    {
        return loadProperties(
            (new File( getCoverageDir(),
                "classes" + File.separator + "grobocoverage.properties")).
            getAbsolutePath() );
    }
    
    
    protected Properties loadProperties( String file )
            throws IOException
    {
        return PropertyCheckUtil.loadProperties( file );
    }
    
    
    protected File getCoverageDir()
    {
        return new File( getProjectDir(), "instrument" +
            File.separator + "coverage" );
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
        configureProject( "failon.xml" );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        executeTarget( "test-teardown" );
        
        super.tearDown();
    }
}

