/*
 * @(#)AnalysisModuleTypeUTest.java
 *
 * Copyright (C) 2002,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.ant;


import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.IAnalysisModule;
import net.sourceforge.groboutils.codecoverage.v2.IAnalysisModuleUTestI;
import net.sourceforge.groboutils.codecoverage.v2.module.LineCountMeasure;
import net.sourceforge.groboutils.junit.v1.SubTestTestCase;
import net.sourceforge.groboutils.junit.v1.iftc.CxFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;

import org.apache.tools.ant.BuildException;


/**
 * Tests the AnalysisModuleType class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     December 28, 2002
 */
public class AnalysisModuleTypeUTest extends SubTestTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AnalysisModuleTypeUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public AnalysisModuleTypeUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testSetName1()
    {
        AnalysisModuleType atm = createAnalysisModuleType();
        
        atm.setName( null );
    }


    
    public void testCreateModule1()
    {
        AnalysisModuleType atm = createAnalysisModuleType();
        try
        {
            atm.getAnalysisModule();
            fail( "Did not throw BuildException." );
        }
        catch (BuildException be)
        {
            // check exception?
        }
    }
    
    public void testCreateModule2()
    {
        AnalysisModuleType atm = createAnalysisModuleType();
        atm.setName( null );
        try
        {
            atm.getAnalysisModule();
            fail( "Did not throw BuildException." );
        }
        catch (BuildException be)
        {
            // check exception?
        }
    }
    
    public void testCreateModule3()
    {
        AnalysisModuleType atm = createAnalysisModuleType();
        atm.setName( "" );
        try
        {
            atm.getAnalysisModule();
            fail( "Did not throw BuildException." );
        }
        catch (BuildException be)
        {
            // check exception?
        }
    }
    
    
    public void testCreateModule4()
    {
        AnalysisModuleType atm = createAnalysisModuleType();
        atm.setName( "line" );
        IAnalysisModule am = atm.getAnalysisModule();
        assertNotNull(
            "returned null module.",
            am );
        assertTrue(
            "Not a LineCountMeasure module.",
            am instanceof LineCountMeasure );
        addAnalysisModuleTest( am, "CreateModule4" );
    }


    public void testCreateModule5()
    {
        AnalysisModuleType atm = createAnalysisModuleType();
        atm.setName( "linecount" );
        IAnalysisModule am = atm.getAnalysisModule();
        assertNotNull(
            "returned null module.",
            am );
        assertTrue(
            "Not a LineCountMeasure module.",
            am instanceof LineCountMeasure );
        addAnalysisModuleTest( am, "CreateModule5" );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers


    protected AnalysisModuleType createAnalysisModuleType()
    {
        return new AnalysisModuleType();
    }
    
    
    protected void addAnalysisModuleTest( final IAnalysisModule am,
            String testName )
    {
        InterfaceTestSuite its = IAnalysisModuleUTestI.suite();
        its.addFactory( new CxFactory( testName ) {
                public Object createImplObject() throws Exception
                {
                    return am;
                }
            } );
        addSubTest( its );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

