/*
 * @(#)AnalysisMetaDataIO.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.datastore;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

import net.sourceforge.groboutils.codecoverage.v2.IAnalysisMetaData;

/**
 * Knows how to read and write an IAnalysisMetaData object.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:25 $
 * @since     December 15, 2002
 */
class AnalysisMetaDataIO
{
    public AnalysisMetaDataIO()
    {
        // do nothing
    }
    
    
    private static class StaleAnalysisMetaData implements IAnalysisMetaData
    {
        private String covered;
        private String notCovered;
        private byte weight;
        
        public StaleAnalysisMetaData( String c, String n, byte w )
        {
            this.covered = c;
            this.notCovered = n;
            this.weight = w;
        }
        
        public String getCoveredFormattedText() { return this.covered; }
        public String getNotCoveredFormattedText() { return this.notCovered; }
        public byte getInstructionWeight() { return this.weight; }
    }
    
    public void writeAnalysisMetaData( IAnalysisMetaData ams, Writer out )
            throws IOException
    {
        StringBuffer sb = new StringBuffer();
        
        sb.append( ams.getCoveredFormattedText().length() ).
            append( ':' ).
            append( ams.getCoveredFormattedText() ).
            append( ',' ).
            append( ams.getNotCoveredFormattedText().length() ).
            append( ':' ).
            append( ams.getNotCoveredFormattedText() ).
            append( ',' ).
            append( ams.getInstructionWeight() ).
            append( ',' );
        
        out.write( sb.toString() );
    }
    
    
    public IAnalysisMetaData readAnalysisMetaData( Reader in )
            throws IOException
    {
        int count = ReadUtil.toInt(
            ReadUtil.readTo( in, ':' ) );
        String covered = ReadUtil.readCount( in, count );
        ReadUtil.readTo( in, ',' );
        
        count = ReadUtil.toInt(
            ReadUtil.readTo( in, ':' ) );
        String notCovered = ReadUtil.readCount( in, count );
        ReadUtil.readTo( in, ',' );
        
        int iweight = ReadUtil.toInt(
            ReadUtil.readTo( in, ',' ) );
        
        return new StaleAnalysisMetaData( covered, notCovered, (byte)iweight );
    }
}

