package tests::AttackCategoriserTest;

use strict;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::AttackCategoriser;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::AttackCategoriser();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../www-attack_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();
    $analyser->initialise();
    $self->assert_isa( 'Lire::WWW::Filename', $analyser->{'analyser'},  );

    my $dlf = { 'requested_page' => undef };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'attack'} );

    $dlf->{'requested_page'} = '/index.html';
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'attack'} );

    $dlf->{'requested_page'} = '/default.ida';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'Code Red', $dlf->{'attack'} );

    return;
}


1;
