## $Id: lr_superservice.mk,v 1.7 2006/07/23 13:16:35 vanbaal Exp $
##
## Copyright (C) 2000-2004 Stichting LogReport Foundation LogReport@LogReport.org
## 
##     This program is free software; you can redistribute it and/or modify
##     it under the terms of the GNU General Public License as published by
##     the Free Software Foundation; either version 2 of the License, or
##     (at your option) any later version.
## 
##     This program is distributed in the hope that it will be useful,
##     but WITHOUT ANY WARRANTY; without even the implied warranty of
##     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##     GNU General Public License for more details.
## 
##     You should have received a copy of the GNU General Public License
##     along with this program (see COPYING); if not, check with
##     http://www.gnu.org/copyleft/gpl.html. 
##
## These are the common rules for all the superservices Makefile.am
## 
## The Makefile.am should defines the following variables and
## then include this Makefile
##
## # The superservice's name
## superservice =
##
## # The XML schema definitions
## schema_DATA = $(superservice).xml
##
## # The XML report configuration templates
## templates_DATA = *_default.xml
##
## # The plugins initialization file
## plugins_DATA = *_init
##
## # The perl modules defined by the superservice. These can refers to 
## # a subdirectory
## perlmodules = $(srcdir)/lib/tests/*.pm
##
## # The XML report specifications. 
## reportspecs = $(srcdir)/reports/*.xml
##
## # The XML filter specifications. 
## filterspecs = $(srcdir)/reports/*.xml
##
## # Any Test::Unit::TestCase perl modules
## tests = $(srcdir)/lib/tests/*.pm
##
## include lr_superservice.mk

convertorsdir = $(libexecdir)/$(PACKAGE)/convertors
pluginsdir = $(sysconfdir)/$(PACKAGE)/plugins
schemadir = $(datadir)/$(PACKAGE)/schemas
templatesdir = $(datadir)/$(PACKAGE)/templates

EXTRA_DIST = $(templates_DATA) $(schema_DATA) $(plugins_DATA) \
	$(perlmodules) $(tests) $(reportspecs) $(filterspecs)

PERLMODULES_INSTALL_RULE = \
	@list='$(perlmodules)'; for p in $$list ; do \
	    f="`echo $$p | sed -e 's|^.*/lib/||'`" ; \
	    d="`dirname $$f`" ; \
	    if test ! -d $(DESTDIR)$(LR_PERL5LIBDIR)/$$d; then \
		$(mkinstalldirs) $(DESTDIR)$(LR_PERL5LIBDIR)/$$d ; \
	    fi ; \
	    echo " $(INSTALL_DATA) $$p $(DESTDIR)$(LR_PERL5LIBDIR)/$$f"; \
	    $(INSTALL_DATA) $$p $(DESTDIR)$(LR_PERL5LIBDIR)/$$f ; \
	done

PERLMODULES_UNINSTALL_RULE = \
	@list='$(perlmodules)'; for p in $$list; do \
	  f="`echo $$p | sed -e 's|^.*/lib/||'`"; \
	  echo " rm -f $(DESTDIR)$(LR_PERL5LIBDIR)/$$f"; \
	  rm -f $(DESTDIR)$(LR_PERL5LIBDIR)/$$f; \
	done

REPORTSPECS_INSTALL_RULE = \
	@list='$(reportspecs)'; for p in $$list; do \
	    f="`basename $$p`" ; \
	    d="$(pkgdatadir)/reports/$(superservice)" ; \
	    if test ! -d $(DESTDIR)$$d; then \
		$(mkinstalldirs) $(DESTDIR)$$d ; \
	    fi ; \
	    echo " $(INSTALL_DATA) $$p $(DESTDIR)$$d/$$f"; \
	    $(INSTALL_DATA) $$p $(DESTDIR)$$d/$$f ; \
	done

REPORTSPECS_UNINSTALL_RULE = \
	@list='$(reportspecs)'; for p in $$list; do \
	  f="`basename $$p`"; \
	  d="$(pkgdatadir)/reports/$(superservice)" ; \
	  echo " rm -f $(DESTDIR)$$d/$$f"; \
	  rm -f $(DESTDIR)$$d/$$f; \
	done

FILTERSPECS_INSTALL_RULE = \
	@list='$(filterspecs)'; for p in $$list; do \
	    f="`basename $$p`" ; \
	    d="$(pkgdatadir)/filters/$(superservice)" ; \
	    if test ! -d $(DESTDIR)$$d; then \
		$(mkinstalldirs) $(DESTDIR)$$d ; \
	    fi ; \
	    echo " $(INSTALL_DATA) $$p $(DESTDIR)$$d/$$f"; \
	    $(INSTALL_DATA) $$p $(DESTDIR)$$d/$$f ; \
	done


FILTERSPECS_UNINSTALL_RULE = \
	@list='$(filterspecs)'; for p in $$list; do \
	  f="`basename $$p`"; \
	  d="$(pkgdatadir)/filters/$(superservice)" ; \
	  echo " rm -f $(DESTDIR)$$d/$$f"; \
	  rm -f $(DESTDIR)$$d/$$f; \
	done


install-data-local:
	$(PERLMODULES_INSTALL_RULE)
	$(REPORTSPECS_INSTALL_RULE)
	$(FILTERSPECS_INSTALL_RULE)

uninstall-local:
	$(PERLMODULES_UNINSTALL_RULE)
	$(REPORTSPECS_UNINSTALL_RULE)
	$(FILTERSPECS_UNINSTALL_RULE)
