/***********************************************************************************

    Copyright (C) 2007-2012 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETTAGS_HEADER
#define LIFEOGRAPH_WIDGETTAGS_HEADER


#include <gtkmm/drawingarea.h>
#include <gtkmm/builder.h>

#include "entry.hpp"
#include "panel_extra.hpp"


namespace LIFEO
{

// TAGWIDGET FOR ENTERING TAG NAMES WITH AUTOCOMPLETION
class TagWidget : public EntryClear
{
    public:
                                    TagWidget( BaseObjectType*,
                                               const Glib::RefPtr< Gtk::Builder >& );

        void                        populate( const Tagset* );
        void                        populate();

    protected:

        bool                        compare_text( const Glib::ustring&,
                                                  const Gtk::TreeModel::const_iterator& );

        TreeStoreExtra::Colrec      colrec;
        Glib::RefPtr< Gtk::EntryCompletion >
                                    m_completion;
        Glib::RefPtr< Gtk::ListStore >
                                    m_liststore;
};

// TAG WIDGET FOR LISTING TAGS OF AN ENTRY
class WidgetTagList : public Gtk::DrawingArea
{
    public:
        typedef sigc::signal< void, const Tag* > Signal_void_Tag;
        typedef sigc::signal< void > Signal_void;

        WidgetTagList( BaseObjectType*, const Glib::RefPtr< Gtk::Builder >& );

        void                        set_entry( Entry* );
        void                        update();

        void                        set_editable( bool flag_editable )
        { m_flag_editable = flag_editable; }

        Signal_void                 signal_add_tag()
        { return m_signal_add_tag; }
        Signal_void_Tag             signal_tag_selected()
        { return m_signal_tag_selected; }

    protected:
        // CONSTANTS
        static const float          MARGIN = 18.0;
        static const float          HSPACING = 10.0;
        static const float          VSPACING = 14.0;
        static const float          LABEL_OFFSET = 2.0;
        static const float          TEXT_HEIGHT = 12.0;
        static const float          ITEM_BORDER = 4.0;  // must be < MARGIN
        static const int            ICON_SIZE = 16;
        static const float          ITEM_HEIGHT =  24.0; // ITEM_BORDER + ICON_SIZE + ITEM_BORDER
        static const float          HALF_HEIGHT = 12.0; // ITEM_HEIGHT / 2

        struct TagItem
        {
            const Tag *tag;
            float xl, xr, yl, yr;
        };
        typedef std::list< TagItem > TagItemList;

        class AddTagItem : public Tag
        {
            public:
                AddTagItem() : Tag( NULL ) {}
        };

        void                        on_size_allocate( Gtk::Allocation& );
        bool                        on_scroll_event( GdkEventScroll* );
        bool                        on_button_press_event( GdkEventButton* );
        //bool                        on_button_release_event( GdkEventButton* );
        bool                        on_motion_notify_event( GdkEventMotion* );
        bool                        on_leave_notify_event( GdkEventCrossing* );
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& );

        void                        add_item( const Cairo::RefPtr< Cairo::Context >&,
                                              const Glib::ustring&,
                                              const Tag* );

        // DATA
        Entry                       *m_ptr2entry;
        Gdk::RGBA                   m_color_text_default;

        // GEOMETRY
        int                         m_width;
        int                         m_height;
        float                       m_pos_x;
        float                       m_pos_y;

        TagItemList                 m_items;
        const Tag                   *m_hovered_tag;
        AddTagItem                  m_add_tag_item;

        Cairo::RefPtr< Cairo::ToyFontFace >
                                    m_font_theme;
        Cairo::RefPtr< Cairo::ToyFontFace >
                                    m_font_system;
        Cairo::RefPtr< Cairo::Context >
                                    m_image_context;
        Cairo::RefPtr< Cairo::ImageSurface >
                                    m_image_surface_add;

        bool                        m_flag_editable;    // not red-only

        Signal_void                 m_signal_add_tag;
        Signal_void_Tag             m_signal_tag_selected;
};

} // end of namespace LIFEO

#endif
