/***********************************************************************************

	Copyright (C) 2010 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include "dialog_preferences.hpp"

namespace LIFEO
{

// STATIC MEMBERS
DialogPreferences *DialogPreferences::ptr;


DialogPreferences::DialogPreferences(	BaseObjectType* cobject,
										const Glib::RefPtr< Gtk::Builder > &refbuilder )
	:	DialogEvent( cobject, refbuilder )
{
	Lifeobase::builder->get_widget( "hbox_max_idle_time", m_hbox_max_idle_time );
	Lifeobase::builder->get_widget( "checkbutton_autologout", m_chkbtn_autologout );
	Lifeobase::builder->get_widget( "spinbutton_max_idle_time", m_spinbutton_max_idle_time );
	Lifeobase::builder->get_widget( "chkbtn_formatting_toolbar", m_chkbtn_formatting_toolbar );

	m_chkbtn_autologout->set_active( Lifeobase::m_settings.autologout );
	m_hbox_max_idle_time->set_sensitive( Lifeobase::m_settings.autologout );
	m_spinbutton_max_idle_time->set_value( Lifeobase::m_settings.idletime );

	m_chkbtn_formatting_toolbar->set_active( Lifeobase::m_settings.show_formatting_toolbar );

	m_chkbtn_autologout->signal_toggled().connect(
			sigc::mem_fun( *this, &DialogPreferences::handle_chkbtn_autologout_toggled ) );

	m_chkbtn_formatting_toolbar->signal_toggled().connect(
			sigc::mem_fun( *this, &DialogPreferences::handle_chkbtn_ftoolbar_toggled ) );

	signal_response().connect(
			sigc::mem_fun( *this, &DialogPreferences::handle_response ) );
}

void
DialogPreferences::handle_chkbtn_autologout_toggled( void )
{
	m_hbox_max_idle_time->set_sensitive( m_chkbtn_autologout->get_active() );
}

void
DialogPreferences::handle_chkbtn_ftoolbar_toggled( void )
{
	Lifeobase::m_settings.show_formatting_toolbar =
			m_chkbtn_formatting_toolbar->get_active();
	Lifeobase::base->handle_settings_changed();
}

void
DialogPreferences::handle_response( int )
{
	// APPLY CHANGES
	Lifeobase::m_settings.autologout = m_chkbtn_autologout->get_active();
	Lifeobase::m_settings.idletime = m_spinbutton_max_idle_time->get_value_as_int();
}

void
DialogPreferences::create()
{
	// FIXME: for some reason subsequent usages of get_widget_derived causes an...
	// ...empty dialog to be shown
	if( ptr  == NULL )
		Lifeobase::builder->get_widget_derived( "dialog_preferences", ptr );
	ptr->run();
	ptr->hide();
}

}
