/*
  File autogenerated by gengetopt version 2.22.4
  generated with the following command:
  gengetopt --show-required --default-option -c cc -H hpp -F generate_sequence_cmdline -f generate_sequence_cmdline -a generate_sequence_args --unamed-opts=seed length

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "generate_sequence_cmdline.hpp"

const char *generate_sequence_args_purpose = "Generate randome sequence of given lengths.";

const char *generate_sequence_args_usage = "Usage: generate_sequence [OPTIONS]... [seed]...";

const char *generate_sequence_args_description = "";

const char *generate_sequence_args_help[] = {
  "  -h, --help             Print help and exit",
  "  -V, --version          Print version and exit",
  "  -s, --seed=LONG        Seed (mandatory)",
  "  -m, --mer=INT          Mer length. Generate matrix of size 2*length",
  "  -o, --output=STRING    Output prefix  (default=`output')",
  "  -q, --fastq            Generate fastq file  (default=off)",
  "  -r, --read-length=INT  Read length for fasta format (default=size of \n                           sequence)",
  "  -v, --verbose          Be verbose  (default=off)",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_LONG
} generate_sequence_cmdline_arg_type;

static
void clear_given (struct generate_sequence_args *args_info);
static
void clear_args (struct generate_sequence_args *args_info);

static int
generate_sequence_cmdline_internal (int argc, char **argv, struct generate_sequence_args *args_info,
                        struct generate_sequence_cmdline_params *params, const char *additional_error);

static int
generate_sequence_cmdline_required2 (struct generate_sequence_args *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct generate_sequence_args *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->seed_given = 0 ;
  args_info->mer_given = 0 ;
  args_info->output_given = 0 ;
  args_info->fastq_given = 0 ;
  args_info->read_length_given = 0 ;
  args_info->verbose_given = 0 ;
}

static
void clear_args (struct generate_sequence_args *args_info)
{
  FIX_UNUSED (args_info);
  args_info->seed_orig = NULL;
  args_info->mer_arg = NULL;
  args_info->mer_orig = NULL;
  args_info->output_arg = gengetopt_strdup ("output");
  args_info->output_orig = NULL;
  args_info->fastq_flag = 0;
  args_info->read_length_orig = NULL;
  args_info->verbose_flag = 0;
  
}

static
void init_args_info(struct generate_sequence_args *args_info)
{


  args_info->help_help = generate_sequence_args_help[0] ;
  args_info->version_help = generate_sequence_args_help[1] ;
  args_info->seed_help = generate_sequence_args_help[2] ;
  args_info->mer_help = generate_sequence_args_help[3] ;
  args_info->mer_min = 0;
  args_info->mer_max = 0;
  args_info->output_help = generate_sequence_args_help[4] ;
  args_info->fastq_help = generate_sequence_args_help[5] ;
  args_info->read_length_help = generate_sequence_args_help[6] ;
  args_info->verbose_help = generate_sequence_args_help[7] ;
  
}

void
generate_sequence_cmdline_print_version (void)
{
  printf ("%s %s\n",
     (strlen(GENERATE_SEQUENCE_CMDLINE_PACKAGE_NAME) ? GENERATE_SEQUENCE_CMDLINE_PACKAGE_NAME : GENERATE_SEQUENCE_CMDLINE_PACKAGE),
     GENERATE_SEQUENCE_CMDLINE_VERSION);
}

static void print_help_common(void) {
  generate_sequence_cmdline_print_version ();

  if (strlen(generate_sequence_args_purpose) > 0)
    printf("\n%s\n", generate_sequence_args_purpose);

  if (strlen(generate_sequence_args_usage) > 0)
    printf("\n%s\n", generate_sequence_args_usage);

  printf("\n");

  if (strlen(generate_sequence_args_description) > 0)
    printf("%s\n\n", generate_sequence_args_description);
}

void
generate_sequence_cmdline_print_help (void)
{
  int i = 0;
  print_help_common();
  while (generate_sequence_args_help[i])
    printf("%s\n", generate_sequence_args_help[i++]);
}

void
generate_sequence_cmdline_init (struct generate_sequence_args *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
generate_sequence_cmdline_params_init(struct generate_sequence_cmdline_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct generate_sequence_cmdline_params *
generate_sequence_cmdline_params_create(void)
{
  struct generate_sequence_cmdline_params *params = 
    (struct generate_sequence_cmdline_params *)malloc(sizeof(struct generate_sequence_cmdline_params));
  generate_sequence_cmdline_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    long long_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}

/**
 * The passed arg parameter is NOT set to 0 from this function
 */
static void
free_multiple_field(unsigned int len, void *arg, char ***orig)
{
  unsigned int i;
  if (arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*orig)[i]));
      }

    free (arg);
    free (*orig);
    *orig = 0;
  }
}


static void
generate_sequence_cmdline_release (struct generate_sequence_args *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->seed_orig));
  free_multiple_field (args_info->mer_given, (void *)(args_info->mer_arg), &(args_info->mer_orig));
  args_info->mer_arg = 0;
  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->read_length_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
generate_sequence_cmdline_dump(FILE *outfile, struct generate_sequence_args *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", GENERATE_SEQUENCE_CMDLINE_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->seed_given)
    write_into_file(outfile, "seed", args_info->seed_orig, 0);
  write_multiple_into_file(outfile, args_info->mer_given, "mer", args_info->mer_orig, 0);
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->fastq_given)
    write_into_file(outfile, "fastq", 0, 0 );
  if (args_info->read_length_given)
    write_into_file(outfile, "read-length", args_info->read_length_orig, 0);
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
generate_sequence_cmdline_file_save(const char *filename, struct generate_sequence_args *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", GENERATE_SEQUENCE_CMDLINE_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = generate_sequence_cmdline_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
generate_sequence_cmdline_free (struct generate_sequence_args *args_info)
{
  generate_sequence_cmdline_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error = 1;
            }
        }
    }
    
  return error;
}
int
generate_sequence_cmdline (int argc, char **argv, struct generate_sequence_args *args_info)
{
  return generate_sequence_cmdline2 (argc, argv, args_info, 0, 1, 1);
}

int
generate_sequence_cmdline_ext (int argc, char **argv, struct generate_sequence_args *args_info,
                   struct generate_sequence_cmdline_params *params)
{
  int result;
  result = generate_sequence_cmdline_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      generate_sequence_cmdline_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
generate_sequence_cmdline2 (int argc, char **argv, struct generate_sequence_args *args_info, int override, int initialize, int check_required)
{
  int result;
  struct generate_sequence_cmdline_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = generate_sequence_cmdline_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      generate_sequence_cmdline_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
generate_sequence_cmdline_required (struct generate_sequence_args *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (generate_sequence_cmdline_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      generate_sequence_cmdline_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
generate_sequence_cmdline_required2 (struct generate_sequence_args *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->seed_given)
    {
      fprintf (stderr, "%s: '--seed' ('-s') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (check_multiple_option_occurrences(prog_name, args_info->mer_given, args_info->mer_min, args_info->mer_max, "'--mer' ('-m')"))
     error = 1;
  
  
  /* checks for dependences among options */

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see generate_sequence_cmdline_params.check_ambiguity
 * @param override @see generate_sequence_cmdline_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               generate_sequence_cmdline_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_LONG:
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_LONG:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               generate_sequence_cmdline_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               generate_sequence_cmdline_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_LONG:
      *((long **)field) = (long *)realloc (*((long **)field), (field_given + prev_given) * sizeof (long)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_LONG:
          (*((long **)field))[i + field_given] = tmp->arg.long_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_LONG:
        if (! *((long **)field)) {
          *((long **)field) = (long *)malloc (sizeof (long));
          (*((long **)field))[0] = default_value->long_arg;
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
generate_sequence_cmdline_internal (
  int argc, char **argv, struct generate_sequence_args *args_info,
                        struct generate_sequence_cmdline_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * mer_list = NULL;
  int error = 0;
  struct generate_sequence_args local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    generate_sequence_cmdline_init (args_info);

  generate_sequence_cmdline_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "seed",	1, NULL, 's' },
        { "mer",	1, NULL, 'm' },
        { "output",	1, NULL, 'o' },
        { "fastq",	0, NULL, 'q' },
        { "read-length",	1, NULL, 'r' },
        { "verbose",	0, NULL, 'v' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVs:m:o:qr:v", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          generate_sequence_cmdline_print_help ();
          generate_sequence_cmdline_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          generate_sequence_cmdline_print_version ();
          generate_sequence_cmdline_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 's':	/* Seed.  */
        
        
          if (update_arg( (void *)&(args_info->seed_arg), 
               &(args_info->seed_orig), &(args_info->seed_given),
              &(local_args_info.seed_given), optarg, 0, 0, ARG_LONG,
              check_ambiguity, override, 0, 0,
              "seed", 's',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Mer length. Generate matrix of size 2*length.  */
        
          if (update_multiple_arg_temp(&mer_list, 
              &(local_args_info.mer_given), optarg, 0, 0, ARG_INT,
              "mer", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Output prefix.  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, "output", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* Generate fastq file.  */
        
        
          if (update_arg((void *)&(args_info->fastq_flag), 0, &(args_info->fastq_given),
              &(local_args_info.fastq_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "fastq", 'q',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Read length for fasta format (default=size of sequence).  */
        
        
          if (update_arg( (void *)&(args_info->read_length_arg), 
               &(args_info->read_length_orig), &(args_info->read_length_given),
              &(local_args_info.read_length_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "read-length", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Be verbose.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", GENERATE_SEQUENCE_CMDLINE_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->mer_arg),
    &(args_info->mer_orig), args_info->mer_given,
    local_args_info.mer_given, 0,
    ARG_INT, mer_list);

  args_info->mer_given += local_args_info.mer_given;
  local_args_info.mer_given = 0;
  
  if (check_required)
    {
      error += generate_sequence_cmdline_required2 (args_info, argv[0], additional_error);
    }

  generate_sequence_cmdline_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  free_list (mer_list, 0 );
  
  generate_sequence_cmdline_release (&local_args_info);
  return (EXIT_FAILURE);
}
