{-# LANGUAGE CPP, PatternSynonyms, ScopedTypeVariables #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -Wno-missing-pattern-synonym-signatures #-}
#endif
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.Tokens
-- Copyright   :  (c) Sven Panne 2016
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- All enumeration tokens from the
-- <http://www.opengl.org/registry/ OpenGL registry>.
--
--------------------------------------------------------------------------------

module Graphics.GL.Tokens where

import Graphics.GL.Types

pattern GL_1PASS_EXT = 0x80A1 :: GLenum

pattern GL_1PASS_SGIS = 0x80A1 :: GLenum

pattern GL_2D = 0x0600 :: GLenum

pattern GL_2PASS_0_EXT = 0x80A2 :: GLenum

pattern GL_2PASS_0_SGIS = 0x80A2 :: GLenum

pattern GL_2PASS_1_EXT = 0x80A3 :: GLenum

pattern GL_2PASS_1_SGIS = 0x80A3 :: GLenum

pattern GL_2X_BIT_ATI = 0x00000001 :: GLbitfield

pattern GL_2_BYTES = 0x1407 :: GLenum

pattern GL_2_BYTES_NV = 0x1407 :: GLenum

pattern GL_3D = 0x0601 :: GLenum

pattern GL_3DC_XY_AMD = 0x87FA :: GLenum

pattern GL_3DC_X_AMD = 0x87F9 :: GLenum

pattern GL_3D_COLOR = 0x0602 :: GLenum

pattern GL_3D_COLOR_TEXTURE = 0x0603 :: GLenum

pattern GL_3_BYTES = 0x1408 :: GLenum

pattern GL_3_BYTES_NV = 0x1408 :: GLenum

pattern GL_422_AVERAGE_EXT = 0x80CE :: GLenum

pattern GL_422_EXT = 0x80CC :: GLenum

pattern GL_422_REV_AVERAGE_EXT = 0x80CF :: GLenum

pattern GL_422_REV_EXT = 0x80CD :: GLenum

pattern GL_4D_COLOR_TEXTURE = 0x0604 :: GLenum

pattern GL_4PASS_0_EXT = 0x80A4 :: GLenum

pattern GL_4PASS_0_SGIS = 0x80A4 :: GLenum

pattern GL_4PASS_1_EXT = 0x80A5 :: GLenum

pattern GL_4PASS_1_SGIS = 0x80A5 :: GLenum

pattern GL_4PASS_2_EXT = 0x80A6 :: GLenum

pattern GL_4PASS_2_SGIS = 0x80A6 :: GLenum

pattern GL_4PASS_3_EXT = 0x80A7 :: GLenum

pattern GL_4PASS_3_SGIS = 0x80A7 :: GLenum

pattern GL_4X_BIT_ATI = 0x00000002 :: GLbitfield

pattern GL_4_BYTES = 0x1409 :: GLenum

pattern GL_4_BYTES_NV = 0x1409 :: GLenum

pattern GL_8X_BIT_ATI = 0x00000004 :: GLbitfield

pattern GL_ABGR_EXT = 0x8000 :: GLenum

pattern GL_ACCUM = 0x0100 :: GLenum

pattern GL_ACCUM_ADJACENT_PAIRS_NV = 0x90AD :: GLenum

pattern GL_ACCUM_ALPHA_BITS = 0x0D5B :: GLenum

pattern GL_ACCUM_BLUE_BITS = 0x0D5A :: GLenum

pattern GL_ACCUM_BUFFER_BIT = 0x00000200 :: GLbitfield

pattern GL_ACCUM_CLEAR_VALUE = 0x0B80 :: GLenum

pattern GL_ACCUM_GREEN_BITS = 0x0D59 :: GLenum

pattern GL_ACCUM_RED_BITS = 0x0D58 :: GLenum

pattern GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9 :: GLenum

pattern GL_ACTIVE_ATTRIBUTES = 0x8B89 :: GLenum

pattern GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A :: GLenum

pattern GL_ACTIVE_PROGRAM = 0x8259 :: GLenum

pattern GL_ACTIVE_PROGRAM_EXT = 0x8B8D :: GLenum

pattern GL_ACTIVE_RESOURCES = 0x92F5 :: GLenum

pattern GL_ACTIVE_STENCIL_FACE_EXT = 0x8911 :: GLenum

pattern GL_ACTIVE_SUBROUTINES = 0x8DE5 :: GLenum

pattern GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 0x8E48 :: GLenum

pattern GL_ACTIVE_SUBROUTINE_UNIFORMS = 0x8DE6 :: GLenum

pattern GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 0x8E47 :: GLenum

pattern GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 0x8E49 :: GLenum

pattern GL_ACTIVE_TEXTURE = 0x84E0 :: GLenum

pattern GL_ACTIVE_TEXTURE_ARB = 0x84E0 :: GLenum

pattern GL_ACTIVE_UNIFORMS = 0x8B86 :: GLenum

pattern GL_ACTIVE_UNIFORM_BLOCKS = 0x8A36 :: GLenum

pattern GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 0x8A35 :: GLenum

pattern GL_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87 :: GLenum

pattern GL_ACTIVE_VARIABLES = 0x9305 :: GLenum

pattern GL_ACTIVE_VARYINGS_NV = 0x8C81 :: GLenum

pattern GL_ACTIVE_VARYING_MAX_LENGTH_NV = 0x8C82 :: GLenum

pattern GL_ACTIVE_VERTEX_UNITS_ARB = 0x86A5 :: GLenum

pattern GL_ADD = 0x0104 :: GLenum

pattern GL_ADD_ATI = 0x8963 :: GLenum

pattern GL_ADD_BLEND_IMG = 0x8C09 :: GLenum

pattern GL_ADD_SIGNED = 0x8574 :: GLenum

pattern GL_ADD_SIGNED_ARB = 0x8574 :: GLenum

pattern GL_ADD_SIGNED_EXT = 0x8574 :: GLenum

pattern GL_ADJACENT_PAIRS_NV = 0x90AE :: GLenum

pattern GL_AFFINE_2D_NV = 0x9092 :: GLenum

pattern GL_AFFINE_3D_NV = 0x9094 :: GLenum

pattern GL_ALIASED_LINE_WIDTH_RANGE = 0x846E :: GLenum

pattern GL_ALIASED_POINT_SIZE_RANGE = 0x846D :: GLenum

pattern GL_ALLOW_DRAW_FRG_HINT_PGI = 0x1A210 :: GLenum

pattern GL_ALLOW_DRAW_MEM_HINT_PGI = 0x1A211 :: GLenum

pattern GL_ALLOW_DRAW_OBJ_HINT_PGI = 0x1A20E :: GLenum

pattern GL_ALLOW_DRAW_WIN_HINT_PGI = 0x1A20F :: GLenum

pattern GL_ALL_ATTRIB_BITS = 0xFFFFFFFF :: GLbitfield

pattern GL_ALL_BARRIER_BITS = 0xFFFFFFFF :: GLbitfield

pattern GL_ALL_BARRIER_BITS_EXT = 0xFFFFFFFF :: GLbitfield

pattern GL_ALL_COMPLETED_NV = 0x84F2 :: GLenum

pattern GL_ALL_SHADER_BITS = 0xFFFFFFFF :: GLbitfield

pattern GL_ALL_SHADER_BITS_EXT = 0xFFFFFFFF :: GLbitfield

pattern GL_ALL_STATIC_DATA_IBM = 103060 :: GLenum

pattern GL_ALPHA = 0x1906 :: GLenum

pattern GL_ALPHA12 = 0x803D :: GLenum

pattern GL_ALPHA12_EXT = 0x803D :: GLenum

pattern GL_ALPHA16 = 0x803E :: GLenum

pattern GL_ALPHA16F_ARB = 0x881C :: GLenum

pattern GL_ALPHA16F_EXT = 0x881C :: GLenum

pattern GL_ALPHA16I_EXT = 0x8D8A :: GLenum

pattern GL_ALPHA16UI_EXT = 0x8D78 :: GLenum

pattern GL_ALPHA16_EXT = 0x803E :: GLenum

pattern GL_ALPHA16_SNORM = 0x9018 :: GLenum

pattern GL_ALPHA32F_ARB = 0x8816 :: GLenum

pattern GL_ALPHA32F_EXT = 0x8816 :: GLenum

pattern GL_ALPHA32I_EXT = 0x8D84 :: GLenum

pattern GL_ALPHA32UI_EXT = 0x8D72 :: GLenum

pattern GL_ALPHA4 = 0x803B :: GLenum

pattern GL_ALPHA4_EXT = 0x803B :: GLenum

pattern GL_ALPHA8 = 0x803C :: GLenum

pattern GL_ALPHA8I_EXT = 0x8D90 :: GLenum

pattern GL_ALPHA8UI_EXT = 0x8D7E :: GLenum

pattern GL_ALPHA8_EXT = 0x803C :: GLenum

pattern GL_ALPHA8_OES = 0x803C :: GLenum

pattern GL_ALPHA8_SNORM = 0x9014 :: GLenum

pattern GL_ALPHA_BIAS = 0x0D1D :: GLenum

pattern GL_ALPHA_BITS = 0x0D55 :: GLenum

pattern GL_ALPHA_FLOAT16_APPLE = 0x881C :: GLenum

pattern GL_ALPHA_FLOAT16_ATI = 0x881C :: GLenum

pattern GL_ALPHA_FLOAT32_APPLE = 0x8816 :: GLenum

pattern GL_ALPHA_FLOAT32_ATI = 0x8816 :: GLenum

pattern GL_ALPHA_INTEGER = 0x8D97 :: GLenum

pattern GL_ALPHA_INTEGER_EXT = 0x8D97 :: GLenum

pattern GL_ALPHA_MAX_CLAMP_INGR = 0x8567 :: GLenum

pattern GL_ALPHA_MAX_SGIX = 0x8321 :: GLenum

pattern GL_ALPHA_MIN_CLAMP_INGR = 0x8563 :: GLenum

pattern GL_ALPHA_MIN_SGIX = 0x8320 :: GLenum

pattern GL_ALPHA_REF_COMMAND_NV = 0x000F :: GLenum

pattern GL_ALPHA_SCALE = 0x0D1C :: GLenum

pattern GL_ALPHA_SNORM = 0x9010 :: GLenum

pattern GL_ALPHA_TEST = 0x0BC0 :: GLenum

pattern GL_ALPHA_TEST_FUNC = 0x0BC1 :: GLenum

pattern GL_ALPHA_TEST_FUNC_QCOM = 0x0BC1 :: GLenum

pattern GL_ALPHA_TEST_QCOM = 0x0BC0 :: GLenum

pattern GL_ALPHA_TEST_REF = 0x0BC2 :: GLenum

pattern GL_ALPHA_TEST_REF_QCOM = 0x0BC2 :: GLenum

pattern GL_ALREADY_SIGNALED = 0x911A :: GLenum

pattern GL_ALREADY_SIGNALED_APPLE = 0x911A :: GLenum

pattern GL_ALWAYS = 0x0207 :: GLenum

pattern GL_ALWAYS_FAST_HINT_PGI = 0x1A20C :: GLenum

pattern GL_ALWAYS_SOFT_HINT_PGI = 0x1A20D :: GLenum

pattern GL_AMBIENT = 0x1200 :: GLenum

pattern GL_AMBIENT_AND_DIFFUSE = 0x1602 :: GLenum

pattern GL_AND = 0x1501 :: GLenum

pattern GL_AND_INVERTED = 0x1504 :: GLenum

pattern GL_AND_REVERSE = 0x1502 :: GLenum

pattern GL_ANY_SAMPLES_PASSED = 0x8C2F :: GLenum

pattern GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A :: GLenum

pattern GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT = 0x8D6A :: GLenum

pattern GL_ANY_SAMPLES_PASSED_EXT = 0x8C2F :: GLenum

pattern GL_ARC_TO_NV = 0xFE :: GLubyte

pattern GL_ARRAY_BUFFER = 0x8892 :: GLenum

pattern GL_ARRAY_BUFFER_ARB = 0x8892 :: GLenum

pattern GL_ARRAY_BUFFER_BINDING = 0x8894 :: GLenum

pattern GL_ARRAY_BUFFER_BINDING_ARB = 0x8894 :: GLenum

pattern GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = 0x81A9 :: GLenum

pattern GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = 0x81A8 :: GLenum

pattern GL_ARRAY_OBJECT_BUFFER_ATI = 0x8766 :: GLenum

pattern GL_ARRAY_OBJECT_OFFSET_ATI = 0x8767 :: GLenum

pattern GL_ARRAY_SIZE = 0x92FB :: GLenum

pattern GL_ARRAY_STRIDE = 0x92FE :: GLenum

pattern GL_ASYNC_DRAW_PIXELS_SGIX = 0x835D :: GLenum

pattern GL_ASYNC_HISTOGRAM_SGIX = 0x832C :: GLenum

pattern GL_ASYNC_MARKER_SGIX = 0x8329 :: GLenum

pattern GL_ASYNC_READ_PIXELS_SGIX = 0x835E :: GLenum

pattern GL_ASYNC_TEX_IMAGE_SGIX = 0x835C :: GLenum

pattern GL_ATC_RGBA_EXPLICIT_ALPHA_AMD = 0x8C93 :: GLenum

pattern GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD = 0x87EE :: GLenum

pattern GL_ATC_RGB_AMD = 0x8C92 :: GLenum

pattern GL_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000 :: GLbitfield

pattern GL_ATOMIC_COUNTER_BARRIER_BIT_EXT = 0x00001000 :: GLbitfield

pattern GL_ATOMIC_COUNTER_BUFFER = 0x92C0 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = 0x92C5 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = 0x92C6 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = 0x92C4 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 0x90ED :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = 0x92CB :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = 0x92CA :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = 0x92C8 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = 0x92C7 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3 :: GLenum

pattern GL_ATOMIC_COUNTER_BUFFER_START = 0x92C2 :: GLenum

pattern GL_ATTACHED_SHADERS = 0x8B85 :: GLenum

pattern GL_ATTENUATION_EXT = 0x834D :: GLenum

pattern GL_ATTRIBUTE_ADDRESS_COMMAND_NV = 0x0009 :: GLenum

pattern GL_ATTRIB_ARRAY_POINTER_NV = 0x8645 :: GLenum

pattern GL_ATTRIB_ARRAY_SIZE_NV = 0x8623 :: GLenum

pattern GL_ATTRIB_ARRAY_STRIDE_NV = 0x8624 :: GLenum

pattern GL_ATTRIB_ARRAY_TYPE_NV = 0x8625 :: GLenum

pattern GL_ATTRIB_STACK_DEPTH = 0x0BB0 :: GLenum

pattern GL_AUTO_GENERATE_MIPMAP = 0x8295 :: GLenum

pattern GL_AUTO_NORMAL = 0x0D80 :: GLenum

pattern GL_AUX0 = 0x0409 :: GLenum

pattern GL_AUX1 = 0x040A :: GLenum

pattern GL_AUX2 = 0x040B :: GLenum

pattern GL_AUX3 = 0x040C :: GLenum

pattern GL_AUX_BUFFERS = 0x0C00 :: GLenum

pattern GL_AUX_DEPTH_STENCIL_APPLE = 0x8A14 :: GLenum

pattern GL_AVERAGE_EXT = 0x8335 :: GLenum

pattern GL_AVERAGE_HP = 0x8160 :: GLenum

pattern GL_BACK = 0x0405 :: GLenum

pattern GL_BACK_LEFT = 0x0402 :: GLenum

pattern GL_BACK_NORMALS_HINT_PGI = 0x1A223 :: GLenum

pattern GL_BACK_PRIMARY_COLOR_NV = 0x8C77 :: GLenum

pattern GL_BACK_RIGHT = 0x0403 :: GLenum

pattern GL_BACK_SECONDARY_COLOR_NV = 0x8C78 :: GLenum

pattern GL_BEVEL_NV = 0x90A6 :: GLenum

pattern GL_BGR = 0x80E0 :: GLenum

pattern GL_BGRA = 0x80E1 :: GLenum

pattern GL_BGRA8_EXT = 0x93A1 :: GLenum

pattern GL_BGRA_EXT = 0x80E1 :: GLenum

pattern GL_BGRA_IMG = 0x80E1 :: GLenum

pattern GL_BGRA_INTEGER = 0x8D9B :: GLenum

pattern GL_BGRA_INTEGER_EXT = 0x8D9B :: GLenum

pattern GL_BGR_EXT = 0x80E0 :: GLenum

pattern GL_BGR_INTEGER = 0x8D9A :: GLenum

pattern GL_BGR_INTEGER_EXT = 0x8D9A :: GLenum

pattern GL_BIAS_BIT_ATI = 0x00000008 :: GLbitfield

pattern GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = 0x8541 :: GLenum

pattern GL_BINNING_CONTROL_HINT_QCOM = 0x8FB0 :: GLenum

pattern GL_BINORMAL_ARRAY_EXT = 0x843A :: GLenum

pattern GL_BINORMAL_ARRAY_POINTER_EXT = 0x8443 :: GLenum

pattern GL_BINORMAL_ARRAY_STRIDE_EXT = 0x8441 :: GLenum

pattern GL_BINORMAL_ARRAY_TYPE_EXT = 0x8440 :: GLenum

pattern GL_BITMAP = 0x1A00 :: GLenum

pattern GL_BITMAP_TOKEN = 0x0704 :: GLenum

pattern GL_BLEND = 0x0BE2 :: GLenum

pattern GL_BLEND_ADVANCED_COHERENT_KHR = 0x9285 :: GLenum

pattern GL_BLEND_ADVANCED_COHERENT_NV = 0x9285 :: GLenum

pattern GL_BLEND_COLOR = 0x8005 :: GLenum

pattern GL_BLEND_COLOR_COMMAND_NV = 0x000B :: GLenum

pattern GL_BLEND_COLOR_EXT = 0x8005 :: GLenum

pattern GL_BLEND_DST = 0x0BE0 :: GLenum

pattern GL_BLEND_DST_ALPHA = 0x80CA :: GLenum

pattern GL_BLEND_DST_ALPHA_EXT = 0x80CA :: GLenum

pattern GL_BLEND_DST_ALPHA_OES = 0x80CA :: GLenum

pattern GL_BLEND_DST_RGB = 0x80C8 :: GLenum

pattern GL_BLEND_DST_RGB_EXT = 0x80C8 :: GLenum

pattern GL_BLEND_DST_RGB_OES = 0x80C8 :: GLenum

pattern GL_BLEND_EQUATION = 0x8009 :: GLenum

pattern GL_BLEND_EQUATION_ALPHA = 0x883D :: GLenum

pattern GL_BLEND_EQUATION_ALPHA_EXT = 0x883D :: GLenum

pattern GL_BLEND_EQUATION_ALPHA_OES = 0x883D :: GLenum

pattern GL_BLEND_EQUATION_EXT = 0x8009 :: GLenum

pattern GL_BLEND_EQUATION_OES = 0x8009 :: GLenum

pattern GL_BLEND_EQUATION_RGB = 0x8009 :: GLenum

pattern GL_BLEND_EQUATION_RGB_EXT = 0x8009 :: GLenum

pattern GL_BLEND_EQUATION_RGB_OES = 0x8009 :: GLenum

pattern GL_BLEND_OVERLAP_NV = 0x9281 :: GLenum

pattern GL_BLEND_PREMULTIPLIED_SRC_NV = 0x9280 :: GLenum

pattern GL_BLEND_SRC = 0x0BE1 :: GLenum

pattern GL_BLEND_SRC_ALPHA = 0x80CB :: GLenum

pattern GL_BLEND_SRC_ALPHA_EXT = 0x80CB :: GLenum

pattern GL_BLEND_SRC_ALPHA_OES = 0x80CB :: GLenum

pattern GL_BLEND_SRC_RGB = 0x80C9 :: GLenum

pattern GL_BLEND_SRC_RGB_EXT = 0x80C9 :: GLenum

pattern GL_BLEND_SRC_RGB_OES = 0x80C9 :: GLenum

pattern GL_BLOCK_INDEX = 0x92FD :: GLenum

pattern GL_BLUE = 0x1905 :: GLenum

pattern GL_BLUE_BIAS = 0x0D1B :: GLenum

pattern GL_BLUE_BITS = 0x0D54 :: GLenum

pattern GL_BLUE_BIT_ATI = 0x00000004 :: GLbitfield

pattern GL_BLUE_INTEGER = 0x8D96 :: GLenum

pattern GL_BLUE_INTEGER_EXT = 0x8D96 :: GLenum

pattern GL_BLUE_MAX_CLAMP_INGR = 0x8566 :: GLenum

pattern GL_BLUE_MIN_CLAMP_INGR = 0x8562 :: GLenum

pattern GL_BLUE_NV = 0x1905 :: GLenum

pattern GL_BLUE_SCALE = 0x0D1A :: GLenum

pattern GL_BOLD_BIT_NV = 0x01 :: GLbitfield

pattern GL_BOOL = 0x8B56 :: GLenum

pattern GL_BOOL_ARB = 0x8B56 :: GLenum

pattern GL_BOOL_VEC2 = 0x8B57 :: GLenum

pattern GL_BOOL_VEC2_ARB = 0x8B57 :: GLenum

pattern GL_BOOL_VEC3 = 0x8B58 :: GLenum

pattern GL_BOOL_VEC3_ARB = 0x8B58 :: GLenum

pattern GL_BOOL_VEC4 = 0x8B59 :: GLenum

pattern GL_BOOL_VEC4_ARB = 0x8B59 :: GLenum

pattern GL_BOUNDING_BOX_NV = 0x908D :: GLenum

pattern GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = 0x909C :: GLenum

pattern GL_BROWSER_DEFAULT_WEBGL = 0x9244 :: GLenum

pattern GL_BUFFER = 0x82E0 :: GLenum

pattern GL_BUFFER_ACCESS = 0x88BB :: GLenum

pattern GL_BUFFER_ACCESS_ARB = 0x88BB :: GLenum

pattern GL_BUFFER_ACCESS_FLAGS = 0x911F :: GLenum

pattern GL_BUFFER_ACCESS_OES = 0x88BB :: GLenum

pattern GL_BUFFER_BINDING = 0x9302 :: GLenum

pattern GL_BUFFER_DATA_SIZE = 0x9303 :: GLenum

pattern GL_BUFFER_FLUSHING_UNMAP_APPLE = 0x8A13 :: GLenum

pattern GL_BUFFER_GPU_ADDRESS_NV = 0x8F1D :: GLenum

pattern GL_BUFFER_IMMUTABLE_STORAGE = 0x821F :: GLenum

pattern GL_BUFFER_IMMUTABLE_STORAGE_EXT = 0x821F :: GLenum

pattern GL_BUFFER_KHR = 0x82E0 :: GLenum

pattern GL_BUFFER_MAPPED = 0x88BC :: GLenum

pattern GL_BUFFER_MAPPED_ARB = 0x88BC :: GLenum

pattern GL_BUFFER_MAPPED_OES = 0x88BC :: GLenum

pattern GL_BUFFER_MAP_LENGTH = 0x9120 :: GLenum

pattern GL_BUFFER_MAP_OFFSET = 0x9121 :: GLenum

pattern GL_BUFFER_MAP_POINTER = 0x88BD :: GLenum

pattern GL_BUFFER_MAP_POINTER_ARB = 0x88BD :: GLenum

pattern GL_BUFFER_MAP_POINTER_OES = 0x88BD :: GLenum

pattern GL_BUFFER_OBJECT_APPLE = 0x85B3 :: GLenum

pattern GL_BUFFER_OBJECT_EXT = 0x9151 :: GLenum

pattern GL_BUFFER_SERIALIZED_MODIFY_APPLE = 0x8A12 :: GLenum

pattern GL_BUFFER_SIZE = 0x8764 :: GLenum

pattern GL_BUFFER_SIZE_ARB = 0x8764 :: GLenum

pattern GL_BUFFER_STORAGE_FLAGS = 0x8220 :: GLenum

pattern GL_BUFFER_STORAGE_FLAGS_EXT = 0x8220 :: GLenum

pattern GL_BUFFER_UPDATE_BARRIER_BIT = 0x00000200 :: GLbitfield

pattern GL_BUFFER_UPDATE_BARRIER_BIT_EXT = 0x00000200 :: GLbitfield

pattern GL_BUFFER_USAGE = 0x8765 :: GLenum

pattern GL_BUFFER_USAGE_ARB = 0x8765 :: GLenum

pattern GL_BUFFER_VARIABLE = 0x92E5 :: GLenum

pattern GL_BUMP_ENVMAP_ATI = 0x877B :: GLenum

pattern GL_BUMP_NUM_TEX_UNITS_ATI = 0x8777 :: GLenum

pattern GL_BUMP_ROT_MATRIX_ATI = 0x8775 :: GLenum

pattern GL_BUMP_ROT_MATRIX_SIZE_ATI = 0x8776 :: GLenum

pattern GL_BUMP_TARGET_ATI = 0x877C :: GLenum

pattern GL_BUMP_TEX_UNITS_ATI = 0x8778 :: GLenum

pattern GL_BYTE = 0x1400 :: GLenum

pattern GL_C3F_V3F = 0x2A24 :: GLenum

pattern GL_C4F_N3F_V3F = 0x2A26 :: GLenum

pattern GL_C4UB_V2F = 0x2A22 :: GLenum

pattern GL_C4UB_V3F = 0x2A23 :: GLenum

pattern GL_CALLIGRAPHIC_FRAGMENT_SGIX = 0x8183 :: GLenum

pattern GL_CAVEAT_SUPPORT = 0x82B8 :: GLenum

pattern GL_CCW = 0x0901 :: GLenum

pattern GL_CIRCULAR_CCW_ARC_TO_NV = 0xF8 :: GLubyte

pattern GL_CIRCULAR_CW_ARC_TO_NV = 0xFA :: GLubyte

pattern GL_CIRCULAR_TANGENT_ARC_TO_NV = 0xFC :: GLubyte

pattern GL_CLAMP = 0x2900 :: GLenum

pattern GL_CLAMP_FRAGMENT_COLOR = 0x891B :: GLenum

pattern GL_CLAMP_FRAGMENT_COLOR_ARB = 0x891B :: GLenum

pattern GL_CLAMP_READ_COLOR = 0x891C :: GLenum

pattern GL_CLAMP_READ_COLOR_ARB = 0x891C :: GLenum

pattern GL_CLAMP_TO_BORDER = 0x812D :: GLenum

pattern GL_CLAMP_TO_BORDER_ARB = 0x812D :: GLenum

pattern GL_CLAMP_TO_BORDER_EXT = 0x812D :: GLenum

pattern GL_CLAMP_TO_BORDER_NV = 0x812D :: GLenum

pattern GL_CLAMP_TO_BORDER_OES = 0x812D :: GLenum

pattern GL_CLAMP_TO_BORDER_SGIS = 0x812D :: GLenum

pattern GL_CLAMP_TO_EDGE = 0x812F :: GLenum

pattern GL_CLAMP_TO_EDGE_SGIS = 0x812F :: GLenum

pattern GL_CLAMP_VERTEX_COLOR = 0x891A :: GLenum

pattern GL_CLAMP_VERTEX_COLOR_ARB = 0x891A :: GLenum

pattern GL_CLEAR = 0x1500 :: GLenum

pattern GL_CLEAR_BUFFER = 0x82B4 :: GLenum

pattern GL_CLEAR_TEXTURE = 0x9365 :: GLenum

pattern GL_CLIENT_ACTIVE_TEXTURE = 0x84E1 :: GLenum

pattern GL_CLIENT_ACTIVE_TEXTURE_ARB = 0x84E1 :: GLenum

pattern GL_CLIENT_ALL_ATTRIB_BITS = 0xFFFFFFFF :: GLbitfield

pattern GL_CLIENT_ATTRIB_STACK_DEPTH = 0x0BB1 :: GLenum

pattern GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 0x00004000 :: GLbitfield

pattern GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT = 0x00004000 :: GLbitfield

pattern GL_CLIENT_PIXEL_STORE_BIT = 0x00000001 :: GLbitfield

pattern GL_CLIENT_STORAGE_BIT = 0x0200 :: GLbitfield

pattern GL_CLIENT_STORAGE_BIT_EXT = 0x0200 :: GLbitfield

pattern GL_CLIENT_VERTEX_ARRAY_BIT = 0x00000002 :: GLbitfield

pattern GL_CLIPPING_INPUT_PRIMITIVES_ARB = 0x82F6 :: GLenum

pattern GL_CLIPPING_OUTPUT_PRIMITIVES_ARB = 0x82F7 :: GLenum

pattern GL_CLIP_DEPTH_MODE = 0x935D :: GLenum

pattern GL_CLIP_DISTANCE0 = 0x3000 :: GLenum

pattern GL_CLIP_DISTANCE0_APPLE = 0x3000 :: GLenum

pattern GL_CLIP_DISTANCE0_EXT = 0x3000 :: GLenum

pattern GL_CLIP_DISTANCE1 = 0x3001 :: GLenum

pattern GL_CLIP_DISTANCE1_APPLE = 0x3001 :: GLenum

pattern GL_CLIP_DISTANCE1_EXT = 0x3001 :: GLenum

pattern GL_CLIP_DISTANCE2 = 0x3002 :: GLenum

pattern GL_CLIP_DISTANCE2_APPLE = 0x3002 :: GLenum

pattern GL_CLIP_DISTANCE2_EXT = 0x3002 :: GLenum

pattern GL_CLIP_DISTANCE3 = 0x3003 :: GLenum

pattern GL_CLIP_DISTANCE3_APPLE = 0x3003 :: GLenum

pattern GL_CLIP_DISTANCE3_EXT = 0x3003 :: GLenum

pattern GL_CLIP_DISTANCE4 = 0x3004 :: GLenum

pattern GL_CLIP_DISTANCE4_APPLE = 0x3004 :: GLenum

pattern GL_CLIP_DISTANCE4_EXT = 0x3004 :: GLenum

pattern GL_CLIP_DISTANCE5 = 0x3005 :: GLenum

pattern GL_CLIP_DISTANCE5_APPLE = 0x3005 :: GLenum

pattern GL_CLIP_DISTANCE5_EXT = 0x3005 :: GLenum

pattern GL_CLIP_DISTANCE6 = 0x3006 :: GLenum

pattern GL_CLIP_DISTANCE6_APPLE = 0x3006 :: GLenum

pattern GL_CLIP_DISTANCE6_EXT = 0x3006 :: GLenum

pattern GL_CLIP_DISTANCE7 = 0x3007 :: GLenum

pattern GL_CLIP_DISTANCE7_APPLE = 0x3007 :: GLenum

pattern GL_CLIP_DISTANCE7_EXT = 0x3007 :: GLenum

pattern GL_CLIP_DISTANCE_NV = 0x8C7A :: GLenum

pattern GL_CLIP_FAR_HINT_PGI = 0x1A221 :: GLenum

pattern GL_CLIP_NEAR_HINT_PGI = 0x1A220 :: GLenum

pattern GL_CLIP_ORIGIN = 0x935C :: GLenum

pattern GL_CLIP_PLANE0 = 0x3000 :: GLenum

pattern GL_CLIP_PLANE0_IMG = 0x3000 :: GLenum

pattern GL_CLIP_PLANE1 = 0x3001 :: GLenum

pattern GL_CLIP_PLANE1_IMG = 0x3001 :: GLenum

pattern GL_CLIP_PLANE2 = 0x3002 :: GLenum

pattern GL_CLIP_PLANE2_IMG = 0x3002 :: GLenum

pattern GL_CLIP_PLANE3 = 0x3003 :: GLenum

pattern GL_CLIP_PLANE3_IMG = 0x3003 :: GLenum

pattern GL_CLIP_PLANE4 = 0x3004 :: GLenum

pattern GL_CLIP_PLANE4_IMG = 0x3004 :: GLenum

pattern GL_CLIP_PLANE5 = 0x3005 :: GLenum

pattern GL_CLIP_PLANE5_IMG = 0x3005 :: GLenum

pattern GL_CLIP_VOLUME_CLIPPING_HINT_EXT = 0x80F0 :: GLenum

pattern GL_CLOSE_PATH_NV = 0x00 :: GLubyte

pattern GL_CMYKA_EXT = 0x800D :: GLenum

pattern GL_CMYK_EXT = 0x800C :: GLenum

pattern GL_CND0_ATI = 0x896B :: GLenum

pattern GL_CND_ATI = 0x896A :: GLenum

pattern GL_COEFF = 0x0A00 :: GLenum

pattern GL_COLOR = 0x1800 :: GLenum

pattern GL_COLOR3_BIT_PGI = 0x00010000 :: GLbitfield

pattern GL_COLOR4_BIT_PGI = 0x00020000 :: GLbitfield

pattern GL_COLORBURN = 0x929A :: GLenum

pattern GL_COLORBURN_KHR = 0x929A :: GLenum

pattern GL_COLORBURN_NV = 0x929A :: GLenum

pattern GL_COLORDODGE = 0x9299 :: GLenum

pattern GL_COLORDODGE_KHR = 0x9299 :: GLenum

pattern GL_COLORDODGE_NV = 0x9299 :: GLenum

pattern GL_COLOR_ALPHA_PAIRING_ATI = 0x8975 :: GLenum

pattern GL_COLOR_ARRAY = 0x8076 :: GLenum

pattern GL_COLOR_ARRAY_ADDRESS_NV = 0x8F23 :: GLenum

pattern GL_COLOR_ARRAY_BUFFER_BINDING = 0x8898 :: GLenum

pattern GL_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x8898 :: GLenum

pattern GL_COLOR_ARRAY_COUNT_EXT = 0x8084 :: GLenum

pattern GL_COLOR_ARRAY_EXT = 0x8076 :: GLenum

pattern GL_COLOR_ARRAY_LENGTH_NV = 0x8F2D :: GLenum

pattern GL_COLOR_ARRAY_LIST_IBM = 103072 :: GLenum

pattern GL_COLOR_ARRAY_LIST_STRIDE_IBM = 103082 :: GLenum

pattern GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F7 :: GLenum

pattern GL_COLOR_ARRAY_POINTER = 0x8090 :: GLenum

pattern GL_COLOR_ARRAY_POINTER_EXT = 0x8090 :: GLenum

pattern GL_COLOR_ARRAY_SIZE = 0x8081 :: GLenum

pattern GL_COLOR_ARRAY_SIZE_EXT = 0x8081 :: GLenum

pattern GL_COLOR_ARRAY_STRIDE = 0x8083 :: GLenum

pattern GL_COLOR_ARRAY_STRIDE_EXT = 0x8083 :: GLenum

pattern GL_COLOR_ARRAY_TYPE = 0x8082 :: GLenum

pattern GL_COLOR_ARRAY_TYPE_EXT = 0x8082 :: GLenum

pattern GL_COLOR_ATTACHMENT0 = 0x8CE0 :: GLenum

pattern GL_COLOR_ATTACHMENT0_EXT = 0x8CE0 :: GLenum

pattern GL_COLOR_ATTACHMENT0_NV = 0x8CE0 :: GLenum

pattern GL_COLOR_ATTACHMENT0_OES = 0x8CE0 :: GLenum

pattern GL_COLOR_ATTACHMENT1 = 0x8CE1 :: GLenum

pattern GL_COLOR_ATTACHMENT10 = 0x8CEA :: GLenum

pattern GL_COLOR_ATTACHMENT10_EXT = 0x8CEA :: GLenum

pattern GL_COLOR_ATTACHMENT10_NV = 0x8CEA :: GLenum

pattern GL_COLOR_ATTACHMENT11 = 0x8CEB :: GLenum

pattern GL_COLOR_ATTACHMENT11_EXT = 0x8CEB :: GLenum

pattern GL_COLOR_ATTACHMENT11_NV = 0x8CEB :: GLenum

pattern GL_COLOR_ATTACHMENT12 = 0x8CEC :: GLenum

pattern GL_COLOR_ATTACHMENT12_EXT = 0x8CEC :: GLenum

pattern GL_COLOR_ATTACHMENT12_NV = 0x8CEC :: GLenum

pattern GL_COLOR_ATTACHMENT13 = 0x8CED :: GLenum

pattern GL_COLOR_ATTACHMENT13_EXT = 0x8CED :: GLenum

pattern GL_COLOR_ATTACHMENT13_NV = 0x8CED :: GLenum

pattern GL_COLOR_ATTACHMENT14 = 0x8CEE :: GLenum

pattern GL_COLOR_ATTACHMENT14_EXT = 0x8CEE :: GLenum

pattern GL_COLOR_ATTACHMENT14_NV = 0x8CEE :: GLenum

pattern GL_COLOR_ATTACHMENT15 = 0x8CEF :: GLenum

pattern GL_COLOR_ATTACHMENT15_EXT = 0x8CEF :: GLenum

pattern GL_COLOR_ATTACHMENT15_NV = 0x8CEF :: GLenum

pattern GL_COLOR_ATTACHMENT16 = 0x8CF0 :: GLenum

pattern GL_COLOR_ATTACHMENT17 = 0x8CF1 :: GLenum

pattern GL_COLOR_ATTACHMENT18 = 0x8CF2 :: GLenum

pattern GL_COLOR_ATTACHMENT19 = 0x8CF3 :: GLenum

pattern GL_COLOR_ATTACHMENT1_EXT = 0x8CE1 :: GLenum

pattern GL_COLOR_ATTACHMENT1_NV = 0x8CE1 :: GLenum

pattern GL_COLOR_ATTACHMENT2 = 0x8CE2 :: GLenum

pattern GL_COLOR_ATTACHMENT20 = 0x8CF4 :: GLenum

pattern GL_COLOR_ATTACHMENT21 = 0x8CF5 :: GLenum

pattern GL_COLOR_ATTACHMENT22 = 0x8CF6 :: GLenum

pattern GL_COLOR_ATTACHMENT23 = 0x8CF7 :: GLenum

pattern GL_COLOR_ATTACHMENT24 = 0x8CF8 :: GLenum

pattern GL_COLOR_ATTACHMENT25 = 0x8CF9 :: GLenum

pattern GL_COLOR_ATTACHMENT26 = 0x8CFA :: GLenum

pattern GL_COLOR_ATTACHMENT27 = 0x8CFB :: GLenum

pattern GL_COLOR_ATTACHMENT28 = 0x8CFC :: GLenum

pattern GL_COLOR_ATTACHMENT29 = 0x8CFD :: GLenum

pattern GL_COLOR_ATTACHMENT2_EXT = 0x8CE2 :: GLenum

pattern GL_COLOR_ATTACHMENT2_NV = 0x8CE2 :: GLenum

pattern GL_COLOR_ATTACHMENT3 = 0x8CE3 :: GLenum

pattern GL_COLOR_ATTACHMENT30 = 0x8CFE :: GLenum

pattern GL_COLOR_ATTACHMENT31 = 0x8CFF :: GLenum

pattern GL_COLOR_ATTACHMENT3_EXT = 0x8CE3 :: GLenum

pattern GL_COLOR_ATTACHMENT3_NV = 0x8CE3 :: GLenum

pattern GL_COLOR_ATTACHMENT4 = 0x8CE4 :: GLenum

pattern GL_COLOR_ATTACHMENT4_EXT = 0x8CE4 :: GLenum

pattern GL_COLOR_ATTACHMENT4_NV = 0x8CE4 :: GLenum

pattern GL_COLOR_ATTACHMENT5 = 0x8CE5 :: GLenum

pattern GL_COLOR_ATTACHMENT5_EXT = 0x8CE5 :: GLenum

pattern GL_COLOR_ATTACHMENT5_NV = 0x8CE5 :: GLenum

pattern GL_COLOR_ATTACHMENT6 = 0x8CE6 :: GLenum

pattern GL_COLOR_ATTACHMENT6_EXT = 0x8CE6 :: GLenum

pattern GL_COLOR_ATTACHMENT6_NV = 0x8CE6 :: GLenum

pattern GL_COLOR_ATTACHMENT7 = 0x8CE7 :: GLenum

pattern GL_COLOR_ATTACHMENT7_EXT = 0x8CE7 :: GLenum

pattern GL_COLOR_ATTACHMENT7_NV = 0x8CE7 :: GLenum

pattern GL_COLOR_ATTACHMENT8 = 0x8CE8 :: GLenum

pattern GL_COLOR_ATTACHMENT8_EXT = 0x8CE8 :: GLenum

pattern GL_COLOR_ATTACHMENT8_NV = 0x8CE8 :: GLenum

pattern GL_COLOR_ATTACHMENT9 = 0x8CE9 :: GLenum

pattern GL_COLOR_ATTACHMENT9_EXT = 0x8CE9 :: GLenum

pattern GL_COLOR_ATTACHMENT9_NV = 0x8CE9 :: GLenum

pattern GL_COLOR_ATTACHMENT_EXT = 0x90F0 :: GLenum

pattern GL_COLOR_BUFFER_BIT = 0x00004000 :: GLbitfield

pattern GL_COLOR_BUFFER_BIT0_QCOM = 0x00000001 :: GLbitfield

pattern GL_COLOR_BUFFER_BIT1_QCOM = 0x00000002 :: GLbitfield

pattern GL_COLOR_BUFFER_BIT2_QCOM = 0x00000004 :: GLbitfield

pattern GL_COLOR_BUFFER_BIT3_QCOM = 0x00000008 :: GLbitfield

pattern GL_COLOR_BUFFER_BIT4_QCOM = 0x00000010 :: GLbitfield

pattern GL_COLOR_BUFFER_BIT5_QCOM = 0x00000020 :: GLbitfield

pattern GL_COLOR_BUFFER_BIT6_QCOM = 0x00000040 :: GLbitfield

pattern GL_COLOR_BUFFER_BIT7_QCOM = 0x00000080 :: GLbitfield

pattern GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI = 0x8835 :: GLenum

pattern GL_COLOR_CLEAR_VALUE = 0x0C22 :: GLenum

pattern GL_COLOR_COMPONENTS = 0x8283 :: GLenum

pattern GL_COLOR_ENCODING = 0x8296 :: GLenum

pattern GL_COLOR_EXT = 0x1800 :: GLenum

pattern GL_COLOR_FLOAT_APPLE = 0x8A0F :: GLenum

pattern GL_COLOR_INDEX = 0x1900 :: GLenum

pattern GL_COLOR_INDEX12_EXT = 0x80E6 :: GLenum

pattern GL_COLOR_INDEX16_EXT = 0x80E7 :: GLenum

pattern GL_COLOR_INDEX1_EXT = 0x80E2 :: GLenum

pattern GL_COLOR_INDEX2_EXT = 0x80E3 :: GLenum

pattern GL_COLOR_INDEX4_EXT = 0x80E4 :: GLenum

pattern GL_COLOR_INDEX8_EXT = 0x80E5 :: GLenum

pattern GL_COLOR_INDEXES = 0x1603 :: GLenum

pattern GL_COLOR_LOGIC_OP = 0x0BF2 :: GLenum

pattern GL_COLOR_MATERIAL = 0x0B57 :: GLenum

pattern GL_COLOR_MATERIAL_FACE = 0x0B55 :: GLenum

pattern GL_COLOR_MATERIAL_PARAMETER = 0x0B56 :: GLenum

pattern GL_COLOR_MATRIX = 0x80B1 :: GLenum

pattern GL_COLOR_MATRIX_SGI = 0x80B1 :: GLenum

pattern GL_COLOR_MATRIX_STACK_DEPTH = 0x80B2 :: GLenum

pattern GL_COLOR_MATRIX_STACK_DEPTH_SGI = 0x80B2 :: GLenum

pattern GL_COLOR_RENDERABLE = 0x8286 :: GLenum

pattern GL_COLOR_SAMPLES_NV = 0x8E20 :: GLenum

pattern GL_COLOR_SUM = 0x8458 :: GLenum

pattern GL_COLOR_SUM_ARB = 0x8458 :: GLenum

pattern GL_COLOR_SUM_CLAMP_NV = 0x854F :: GLenum

pattern GL_COLOR_SUM_EXT = 0x8458 :: GLenum

pattern GL_COLOR_TABLE = 0x80D0 :: GLenum

pattern GL_COLOR_TABLE_ALPHA_SIZE = 0x80DD :: GLenum

pattern GL_COLOR_TABLE_ALPHA_SIZE_SGI = 0x80DD :: GLenum

pattern GL_COLOR_TABLE_BIAS = 0x80D7 :: GLenum

pattern GL_COLOR_TABLE_BIAS_SGI = 0x80D7 :: GLenum

pattern GL_COLOR_TABLE_BLUE_SIZE = 0x80DC :: GLenum

pattern GL_COLOR_TABLE_BLUE_SIZE_SGI = 0x80DC :: GLenum

pattern GL_COLOR_TABLE_FORMAT = 0x80D8 :: GLenum

pattern GL_COLOR_TABLE_FORMAT_SGI = 0x80D8 :: GLenum

pattern GL_COLOR_TABLE_GREEN_SIZE = 0x80DB :: GLenum

pattern GL_COLOR_TABLE_GREEN_SIZE_SGI = 0x80DB :: GLenum

pattern GL_COLOR_TABLE_INTENSITY_SIZE = 0x80DF :: GLenum

pattern GL_COLOR_TABLE_INTENSITY_SIZE_SGI = 0x80DF :: GLenum

pattern GL_COLOR_TABLE_LUMINANCE_SIZE = 0x80DE :: GLenum

pattern GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = 0x80DE :: GLenum

pattern GL_COLOR_TABLE_RED_SIZE = 0x80DA :: GLenum

pattern GL_COLOR_TABLE_RED_SIZE_SGI = 0x80DA :: GLenum

pattern GL_COLOR_TABLE_SCALE = 0x80D6 :: GLenum

pattern GL_COLOR_TABLE_SCALE_SGI = 0x80D6 :: GLenum

pattern GL_COLOR_TABLE_SGI = 0x80D0 :: GLenum

pattern GL_COLOR_TABLE_WIDTH = 0x80D9 :: GLenum

pattern GL_COLOR_TABLE_WIDTH_SGI = 0x80D9 :: GLenum

pattern GL_COLOR_WRITEMASK = 0x0C23 :: GLenum

pattern GL_COMBINE = 0x8570 :: GLenum

pattern GL_COMBINE4_NV = 0x8503 :: GLenum

pattern GL_COMBINER0_NV = 0x8550 :: GLenum

pattern GL_COMBINER1_NV = 0x8551 :: GLenum

pattern GL_COMBINER2_NV = 0x8552 :: GLenum

pattern GL_COMBINER3_NV = 0x8553 :: GLenum

pattern GL_COMBINER4_NV = 0x8554 :: GLenum

pattern GL_COMBINER5_NV = 0x8555 :: GLenum

pattern GL_COMBINER6_NV = 0x8556 :: GLenum

pattern GL_COMBINER7_NV = 0x8557 :: GLenum

pattern GL_COMBINER_AB_DOT_PRODUCT_NV = 0x8545 :: GLenum

pattern GL_COMBINER_AB_OUTPUT_NV = 0x854A :: GLenum

pattern GL_COMBINER_BIAS_NV = 0x8549 :: GLenum

pattern GL_COMBINER_CD_DOT_PRODUCT_NV = 0x8546 :: GLenum

pattern GL_COMBINER_CD_OUTPUT_NV = 0x854B :: GLenum

pattern GL_COMBINER_COMPONENT_USAGE_NV = 0x8544 :: GLenum

pattern GL_COMBINER_INPUT_NV = 0x8542 :: GLenum

pattern GL_COMBINER_MAPPING_NV = 0x8543 :: GLenum

pattern GL_COMBINER_MUX_SUM_NV = 0x8547 :: GLenum

pattern GL_COMBINER_SCALE_NV = 0x8548 :: GLenum

pattern GL_COMBINER_SUM_OUTPUT_NV = 0x854C :: GLenum

pattern GL_COMBINE_ALPHA = 0x8572 :: GLenum

pattern GL_COMBINE_ALPHA_ARB = 0x8572 :: GLenum

pattern GL_COMBINE_ALPHA_EXT = 0x8572 :: GLenum

pattern GL_COMBINE_ARB = 0x8570 :: GLenum

pattern GL_COMBINE_EXT = 0x8570 :: GLenum

pattern GL_COMBINE_RGB = 0x8571 :: GLenum

pattern GL_COMBINE_RGB_ARB = 0x8571 :: GLenum

pattern GL_COMBINE_RGB_EXT = 0x8571 :: GLenum

pattern GL_COMMAND_BARRIER_BIT = 0x00000040 :: GLbitfield

pattern GL_COMMAND_BARRIER_BIT_EXT = 0x00000040 :: GLbitfield

pattern GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT = 0x884E :: GLenum

pattern GL_COMPARE_REF_TO_TEXTURE = 0x884E :: GLenum

pattern GL_COMPARE_REF_TO_TEXTURE_EXT = 0x884E :: GLenum

pattern GL_COMPARE_R_TO_TEXTURE = 0x884E :: GLenum

pattern GL_COMPARE_R_TO_TEXTURE_ARB = 0x884E :: GLenum

pattern GL_COMPATIBLE_SUBROUTINES = 0x8E4B :: GLenum

pattern GL_COMPILE = 0x1300 :: GLenum

pattern GL_COMPILE_AND_EXECUTE = 0x1301 :: GLenum

pattern GL_COMPILE_STATUS = 0x8B81 :: GLenum

pattern GL_COMPLETION_STATUS_ARB = 0x91B1 :: GLenum

pattern GL_COMPRESSED_ALPHA = 0x84E9 :: GLenum

pattern GL_COMPRESSED_ALPHA_ARB = 0x84E9 :: GLenum

pattern GL_COMPRESSED_INTENSITY = 0x84EC :: GLenum

pattern GL_COMPRESSED_INTENSITY_ARB = 0x84EC :: GLenum

pattern GL_COMPRESSED_LUMINANCE = 0x84EA :: GLenum

pattern GL_COMPRESSED_LUMINANCE_ALPHA = 0x84EB :: GLenum

pattern GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI = 0x8837 :: GLenum

pattern GL_COMPRESSED_LUMINANCE_ALPHA_ARB = 0x84EB :: GLenum

pattern GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C72 :: GLenum

pattern GL_COMPRESSED_LUMINANCE_ARB = 0x84EA :: GLenum

pattern GL_COMPRESSED_LUMINANCE_LATC1_EXT = 0x8C70 :: GLenum

pattern GL_COMPRESSED_R11_EAC = 0x9270 :: GLenum

pattern GL_COMPRESSED_R11_EAC_OES = 0x9270 :: GLenum

pattern GL_COMPRESSED_RED = 0x8225 :: GLenum

pattern GL_COMPRESSED_RED_GREEN_RGTC2_EXT = 0x8DBD :: GLenum

pattern GL_COMPRESSED_RED_RGTC1 = 0x8DBB :: GLenum

pattern GL_COMPRESSED_RED_RGTC1_EXT = 0x8DBB :: GLenum

pattern GL_COMPRESSED_RG = 0x8226 :: GLenum

pattern GL_COMPRESSED_RG11_EAC = 0x9272 :: GLenum

pattern GL_COMPRESSED_RG11_EAC_OES = 0x9272 :: GLenum

pattern GL_COMPRESSED_RGB = 0x84ED :: GLenum

pattern GL_COMPRESSED_RGB8_ETC2 = 0x9274 :: GLenum

pattern GL_COMPRESSED_RGB8_ETC2_OES = 0x9274 :: GLenum

pattern GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276 :: GLenum

pattern GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES = 0x9276 :: GLenum

pattern GL_COMPRESSED_RGBA = 0x84EE :: GLenum

pattern GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278 :: GLenum

pattern GL_COMPRESSED_RGBA8_ETC2_EAC_OES = 0x9278 :: GLenum

pattern GL_COMPRESSED_RGBA_ARB = 0x84EE :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_10x10 = 0x93BB :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_10x10_KHR = 0x93BB :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_10x5 = 0x93B8 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_10x5_KHR = 0x93B8 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_10x6 = 0x93B9 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_10x6_KHR = 0x93B9 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_10x8 = 0x93BA :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_10x8_KHR = 0x93BA :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_12x10 = 0x93BC :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_12x10_KHR = 0x93BC :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_12x12 = 0x93BD :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_12x12_KHR = 0x93BD :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_3x3x3_OES = 0x93C0 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_4x3x3_OES = 0x93C1 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_4x4 = 0x93B0 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_4x4_KHR = 0x93B0 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_4x4x3_OES = 0x93C2 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_4x4x4_OES = 0x93C3 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_5x4 = 0x93B1 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_5x4_KHR = 0x93B1 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_5x4x4_OES = 0x93C4 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_5x5 = 0x93B2 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_5x5_KHR = 0x93B2 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_5x5x4_OES = 0x93C5 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_5x5x5_OES = 0x93C6 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_6x5 = 0x93B3 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_6x5_KHR = 0x93B3 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_6x5x5_OES = 0x93C7 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_6x6 = 0x93B4 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_6x6_KHR = 0x93B4 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_6x6x5_OES = 0x93C8 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_6x6x6_OES = 0x93C9 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_8x5 = 0x93B5 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_8x5_KHR = 0x93B5 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_8x6 = 0x93B6 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_8x6_KHR = 0x93B6 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_8x8 = 0x93B7 :: GLenum

pattern GL_COMPRESSED_RGBA_ASTC_8x8_KHR = 0x93B7 :: GLenum

pattern GL_COMPRESSED_RGBA_BPTC_UNORM = 0x8E8C :: GLenum

pattern GL_COMPRESSED_RGBA_BPTC_UNORM_ARB = 0x8E8C :: GLenum

pattern GL_COMPRESSED_RGBA_FXT1_3DFX = 0x86B1 :: GLenum

pattern GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 0x8C03 :: GLenum

pattern GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG = 0x9137 :: GLenum

pattern GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 0x8C02 :: GLenum

pattern GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG = 0x9138 :: GLenum

pattern GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1 :: GLenum

pattern GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE = 0x83F2 :: GLenum

pattern GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2 :: GLenum

pattern GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE = 0x83F3 :: GLenum

pattern GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3 :: GLenum

pattern GL_COMPRESSED_RGB_ARB = 0x84ED :: GLenum

pattern GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = 0x8E8E :: GLenum

pattern GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = 0x8E8E :: GLenum

pattern GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = 0x8E8F :: GLenum

pattern GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = 0x8E8F :: GLenum

pattern GL_COMPRESSED_RGB_FXT1_3DFX = 0x86B0 :: GLenum

pattern GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 0x8C01 :: GLenum

pattern GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 0x8C00 :: GLenum

pattern GL_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0 :: GLenum

pattern GL_COMPRESSED_RG_RGTC2 = 0x8DBD :: GLenum

pattern GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C73 :: GLenum

pattern GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT = 0x8C71 :: GLenum

pattern GL_COMPRESSED_SIGNED_R11_EAC = 0x9271 :: GLenum

pattern GL_COMPRESSED_SIGNED_R11_EAC_OES = 0x9271 :: GLenum

pattern GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = 0x8DBE :: GLenum

pattern GL_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC :: GLenum

pattern GL_COMPRESSED_SIGNED_RED_RGTC1_EXT = 0x8DBC :: GLenum

pattern GL_COMPRESSED_SIGNED_RG11_EAC = 0x9273 :: GLenum

pattern GL_COMPRESSED_SIGNED_RG11_EAC_OES = 0x9273 :: GLenum

pattern GL_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE :: GLenum

pattern GL_COMPRESSED_SLUMINANCE = 0x8C4A :: GLenum

pattern GL_COMPRESSED_SLUMINANCE_ALPHA = 0x8C4B :: GLenum

pattern GL_COMPRESSED_SLUMINANCE_ALPHA_EXT = 0x8C4B :: GLenum

pattern GL_COMPRESSED_SLUMINANCE_EXT = 0x8C4A :: GLenum

pattern GL_COMPRESSED_SRGB = 0x8C48 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10 = 0x93DB :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = 0x93DB :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5 = 0x93D8 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = 0x93D8 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6 = 0x93D9 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = 0x93D9 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8 = 0x93DA :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = 0x93DA :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10 = 0x93DC :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = 0x93DC :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12 = 0x93DD :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = 0x93DD :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES = 0x93E0 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES = 0x93E1 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 = 0x93D0 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = 0x93D0 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES = 0x93E2 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES = 0x93E3 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4 = 0x93D1 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = 0x93D1 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES = 0x93E4 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5 = 0x93D2 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = 0x93D2 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES = 0x93E5 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES = 0x93E6 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5 = 0x93D3 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = 0x93D3 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES = 0x93E7 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6 = 0x93D4 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = 0x93D4 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES = 0x93E8 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES = 0x93E9 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5 = 0x93D5 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = 0x93D5 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6 = 0x93D6 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = 0x93D6 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8 = 0x93D7 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = 0x93D7 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279 :: GLenum

pattern GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC_OES = 0x9279 :: GLenum

pattern GL_COMPRESSED_SRGB8_ETC2 = 0x9275 :: GLenum

pattern GL_COMPRESSED_SRGB8_ETC2_OES = 0x9275 :: GLenum

pattern GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277 :: GLenum

pattern GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES = 0x9277 :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA = 0x8C49 :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = 0x8E8D :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = 0x8E8D :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_EXT = 0x8C49 :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT = 0x8A56 :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG = 0x93F0 :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT = 0x8A57 :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG = 0x93F1 :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = 0x8C4D :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV = 0x8C4D :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = 0x8C4E :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV = 0x8C4E :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = 0x8C4F :: GLenum

pattern GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV = 0x8C4F :: GLenum

pattern GL_COMPRESSED_SRGB_EXT = 0x8C48 :: GLenum

pattern GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT = 0x8A54 :: GLenum

pattern GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT = 0x8A55 :: GLenum

pattern GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = 0x8C4C :: GLenum

pattern GL_COMPRESSED_SRGB_S3TC_DXT1_NV = 0x8C4C :: GLenum

pattern GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3 :: GLenum

pattern GL_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A3 :: GLenum

pattern GL_COMPUTE_PROGRAM_NV = 0x90FB :: GLenum

pattern GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV = 0x90FC :: GLenum

pattern GL_COMPUTE_SHADER = 0x91B9 :: GLenum

pattern GL_COMPUTE_SHADER_BIT = 0x00000020 :: GLbitfield

pattern GL_COMPUTE_SHADER_INVOCATIONS_ARB = 0x82F5 :: GLenum

pattern GL_COMPUTE_SUBROUTINE = 0x92ED :: GLenum

pattern GL_COMPUTE_SUBROUTINE_UNIFORM = 0x92F3 :: GLenum

pattern GL_COMPUTE_TEXTURE = 0x82A0 :: GLenum

pattern GL_COMPUTE_WORK_GROUP_SIZE = 0x8267 :: GLenum

pattern GL_COMP_BIT_ATI = 0x00000002 :: GLbitfield

pattern GL_CONDITION_SATISFIED = 0x911C :: GLenum

pattern GL_CONDITION_SATISFIED_APPLE = 0x911C :: GLenum

pattern GL_CONFORMANT_NV = 0x9374 :: GLenum

pattern GL_CONIC_CURVE_TO_NV = 0x1A :: GLubyte

pattern GL_CONJOINT_NV = 0x9284 :: GLenum

pattern GL_CONSERVATIVE_RASTERIZATION_INTEL = 0x83FE :: GLenum

pattern GL_CONSERVATIVE_RASTERIZATION_NV = 0x9346 :: GLenum

pattern GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV = 0x937B :: GLenum

pattern GL_CONSERVATIVE_RASTER_DILATE_NV = 0x9379 :: GLenum

pattern GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV = 0x937A :: GLenum

pattern GL_CONSERVATIVE_RASTER_MODE_NV = 0x954D :: GLenum

pattern GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV = 0x954E :: GLenum

pattern GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV = 0x954F :: GLenum

pattern GL_CONSERVE_MEMORY_HINT_PGI = 0x1A1FD :: GLenum

pattern GL_CONSTANT = 0x8576 :: GLenum

pattern GL_CONSTANT_ALPHA = 0x8003 :: GLenum

pattern GL_CONSTANT_ALPHA_EXT = 0x8003 :: GLenum

pattern GL_CONSTANT_ARB = 0x8576 :: GLenum

pattern GL_CONSTANT_ATTENUATION = 0x1207 :: GLenum

pattern GL_CONSTANT_BORDER = 0x8151 :: GLenum

pattern GL_CONSTANT_BORDER_HP = 0x8151 :: GLenum

pattern GL_CONSTANT_COLOR = 0x8001 :: GLenum

pattern GL_CONSTANT_COLOR0_NV = 0x852A :: GLenum

pattern GL_CONSTANT_COLOR1_NV = 0x852B :: GLenum

pattern GL_CONSTANT_COLOR_EXT = 0x8001 :: GLenum

pattern GL_CONSTANT_EXT = 0x8576 :: GLenum

pattern GL_CONSTANT_NV = 0x8576 :: GLenum

pattern GL_CONST_EYE_NV = 0x86E5 :: GLenum

pattern GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 0x00000002 :: GLbitfield

pattern GL_CONTEXT_CORE_PROFILE_BIT = 0x00000001 :: GLbitfield

pattern GL_CONTEXT_FLAGS = 0x821E :: GLenum

pattern GL_CONTEXT_FLAG_DEBUG_BIT = 0x00000002 :: GLbitfield

pattern GL_CONTEXT_FLAG_DEBUG_BIT_KHR = 0x00000002 :: GLbitfield

pattern GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x00000001 :: GLbitfield

pattern GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR = 0x00000008 :: GLbitfield

pattern GL_CONTEXT_FLAG_PROTECTED_CONTENT_BIT_EXT = 0x00000010 :: GLbitfield

pattern GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT = 0x00000004 :: GLbitfield

pattern GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 0x00000004 :: GLbitfield

pattern GL_CONTEXT_LOST = 0x0507 :: GLenum

pattern GL_CONTEXT_LOST_KHR = 0x0507 :: GLenum

pattern GL_CONTEXT_LOST_WEBGL = 0x9242 :: GLenum

pattern GL_CONTEXT_PROFILE_MASK = 0x9126 :: GLenum

pattern GL_CONTEXT_RELEASE_BEHAVIOR = 0x82FB :: GLenum

pattern GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 0x82FC :: GLenum

pattern GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR = 0x82FC :: GLenum

pattern GL_CONTEXT_RELEASE_BEHAVIOR_KHR = 0x82FB :: GLenum

pattern GL_CONTEXT_ROBUST_ACCESS = 0x90F3 :: GLenum

pattern GL_CONTEXT_ROBUST_ACCESS_EXT = 0x90F3 :: GLenum

pattern GL_CONTEXT_ROBUST_ACCESS_KHR = 0x90F3 :: GLenum

pattern GL_CONTINUOUS_AMD = 0x9007 :: GLenum

pattern GL_CONTRAST_NV = 0x92A1 :: GLenum

pattern GL_CONVEX_HULL_NV = 0x908B :: GLenum

pattern GL_CONVOLUTION_1D = 0x8010 :: GLenum

pattern GL_CONVOLUTION_1D_EXT = 0x8010 :: GLenum

pattern GL_CONVOLUTION_2D = 0x8011 :: GLenum

pattern GL_CONVOLUTION_2D_EXT = 0x8011 :: GLenum

pattern GL_CONVOLUTION_BORDER_COLOR = 0x8154 :: GLenum

pattern GL_CONVOLUTION_BORDER_COLOR_HP = 0x8154 :: GLenum

pattern GL_CONVOLUTION_BORDER_MODE = 0x8013 :: GLenum

pattern GL_CONVOLUTION_BORDER_MODE_EXT = 0x8013 :: GLenum

pattern GL_CONVOLUTION_FILTER_BIAS = 0x8015 :: GLenum

pattern GL_CONVOLUTION_FILTER_BIAS_EXT = 0x8015 :: GLenum

pattern GL_CONVOLUTION_FILTER_SCALE = 0x8014 :: GLenum

pattern GL_CONVOLUTION_FILTER_SCALE_EXT = 0x8014 :: GLenum

pattern GL_CONVOLUTION_FORMAT = 0x8017 :: GLenum

pattern GL_CONVOLUTION_FORMAT_EXT = 0x8017 :: GLenum

pattern GL_CONVOLUTION_HEIGHT = 0x8019 :: GLenum

pattern GL_CONVOLUTION_HEIGHT_EXT = 0x8019 :: GLenum

pattern GL_CONVOLUTION_HINT_SGIX = 0x8316 :: GLenum

pattern GL_CONVOLUTION_WIDTH = 0x8018 :: GLenum

pattern GL_CONVOLUTION_WIDTH_EXT = 0x8018 :: GLenum

pattern GL_CON_0_ATI = 0x8941 :: GLenum

pattern GL_CON_10_ATI = 0x894B :: GLenum

pattern GL_CON_11_ATI = 0x894C :: GLenum

pattern GL_CON_12_ATI = 0x894D :: GLenum

pattern GL_CON_13_ATI = 0x894E :: GLenum

pattern GL_CON_14_ATI = 0x894F :: GLenum

pattern GL_CON_15_ATI = 0x8950 :: GLenum

pattern GL_CON_16_ATI = 0x8951 :: GLenum

pattern GL_CON_17_ATI = 0x8952 :: GLenum

pattern GL_CON_18_ATI = 0x8953 :: GLenum

pattern GL_CON_19_ATI = 0x8954 :: GLenum

pattern GL_CON_1_ATI = 0x8942 :: GLenum

pattern GL_CON_20_ATI = 0x8955 :: GLenum

pattern GL_CON_21_ATI = 0x8956 :: GLenum

pattern GL_CON_22_ATI = 0x8957 :: GLenum

pattern GL_CON_23_ATI = 0x8958 :: GLenum

pattern GL_CON_24_ATI = 0x8959 :: GLenum

pattern GL_CON_25_ATI = 0x895A :: GLenum

pattern GL_CON_26_ATI = 0x895B :: GLenum

pattern GL_CON_27_ATI = 0x895C :: GLenum

pattern GL_CON_28_ATI = 0x895D :: GLenum

pattern GL_CON_29_ATI = 0x895E :: GLenum

pattern GL_CON_2_ATI = 0x8943 :: GLenum

pattern GL_CON_30_ATI = 0x895F :: GLenum

pattern GL_CON_31_ATI = 0x8960 :: GLenum

pattern GL_CON_3_ATI = 0x8944 :: GLenum

pattern GL_CON_4_ATI = 0x8945 :: GLenum

pattern GL_CON_5_ATI = 0x8946 :: GLenum

pattern GL_CON_6_ATI = 0x8947 :: GLenum

pattern GL_CON_7_ATI = 0x8948 :: GLenum

pattern GL_CON_8_ATI = 0x8949 :: GLenum

pattern GL_CON_9_ATI = 0x894A :: GLenum

pattern GL_COORD_REPLACE = 0x8862 :: GLenum

pattern GL_COORD_REPLACE_ARB = 0x8862 :: GLenum

pattern GL_COORD_REPLACE_NV = 0x8862 :: GLenum

pattern GL_COORD_REPLACE_OES = 0x8862 :: GLenum

pattern GL_COPY = 0x1503 :: GLenum

pattern GL_COPY_INVERTED = 0x150C :: GLenum

pattern GL_COPY_PIXEL_TOKEN = 0x0706 :: GLenum

pattern GL_COPY_READ_BUFFER = 0x8F36 :: GLenum

pattern GL_COPY_READ_BUFFER_BINDING = 0x8F36 :: GLenum

pattern GL_COPY_READ_BUFFER_NV = 0x8F36 :: GLenum

pattern GL_COPY_WRITE_BUFFER = 0x8F37 :: GLenum

pattern GL_COPY_WRITE_BUFFER_BINDING = 0x8F37 :: GLenum

pattern GL_COPY_WRITE_BUFFER_NV = 0x8F37 :: GLenum

pattern GL_COUNTER_RANGE_AMD = 0x8BC1 :: GLenum

pattern GL_COUNTER_TYPE_AMD = 0x8BC0 :: GLenum

pattern GL_COUNT_DOWN_NV = 0x9089 :: GLenum

pattern GL_COUNT_UP_NV = 0x9088 :: GLenum

pattern GL_COVERAGE_ALL_FRAGMENTS_NV = 0x8ED5 :: GLenum

pattern GL_COVERAGE_ATTACHMENT_NV = 0x8ED2 :: GLenum

pattern GL_COVERAGE_AUTOMATIC_NV = 0x8ED7 :: GLenum

pattern GL_COVERAGE_BUFFERS_NV = 0x8ED3 :: GLenum

pattern GL_COVERAGE_BUFFER_BIT_NV = 0x00008000 :: GLbitfield

pattern GL_COVERAGE_COMPONENT4_NV = 0x8ED1 :: GLenum

pattern GL_COVERAGE_COMPONENT_NV = 0x8ED0 :: GLenum

pattern GL_COVERAGE_EDGE_FRAGMENTS_NV = 0x8ED6 :: GLenum

pattern GL_COVERAGE_MODULATION_NV = 0x9332 :: GLenum

pattern GL_COVERAGE_MODULATION_TABLE_NV = 0x9331 :: GLenum

pattern GL_COVERAGE_MODULATION_TABLE_SIZE_NV = 0x9333 :: GLenum

pattern GL_COVERAGE_SAMPLES_NV = 0x8ED4 :: GLenum

pattern GL_CPU_OPTIMIZED_QCOM = 0x8FB1 :: GLenum

pattern GL_CUBIC_CURVE_TO_NV = 0x0C :: GLubyte

pattern GL_CUBIC_EXT = 0x8334 :: GLenum

pattern GL_CUBIC_HP = 0x815F :: GLenum

pattern GL_CUBIC_IMG = 0x9139 :: GLenum

pattern GL_CUBIC_MIPMAP_LINEAR_IMG = 0x913B :: GLenum

pattern GL_CUBIC_MIPMAP_NEAREST_IMG = 0x913A :: GLenum

pattern GL_CULL_FACE = 0x0B44 :: GLenum

pattern GL_CULL_FACE_MODE = 0x0B45 :: GLenum

pattern GL_CULL_FRAGMENT_NV = 0x86E7 :: GLenum

pattern GL_CULL_MODES_NV = 0x86E0 :: GLenum

pattern GL_CULL_VERTEX_EXT = 0x81AA :: GLenum

pattern GL_CULL_VERTEX_EYE_POSITION_EXT = 0x81AB :: GLenum

pattern GL_CULL_VERTEX_IBM = 103050 :: GLenum

pattern GL_CULL_VERTEX_OBJECT_POSITION_EXT = 0x81AC :: GLenum

pattern GL_CURRENT_ATTRIB_NV = 0x8626 :: GLenum

pattern GL_CURRENT_BINORMAL_EXT = 0x843C :: GLenum

pattern GL_CURRENT_BIT = 0x00000001 :: GLbitfield

pattern GL_CURRENT_COLOR = 0x0B00 :: GLenum

pattern GL_CURRENT_FOG_COORD = 0x8453 :: GLenum

pattern GL_CURRENT_FOG_COORDINATE = 0x8453 :: GLenum

pattern GL_CURRENT_FOG_COORDINATE_EXT = 0x8453 :: GLenum

pattern GL_CURRENT_INDEX = 0x0B01 :: GLenum

pattern GL_CURRENT_MATRIX_ARB = 0x8641 :: GLenum

pattern GL_CURRENT_MATRIX_INDEX_ARB = 0x8845 :: GLenum

pattern GL_CURRENT_MATRIX_NV = 0x8641 :: GLenum

pattern GL_CURRENT_MATRIX_STACK_DEPTH_ARB = 0x8640 :: GLenum

pattern GL_CURRENT_MATRIX_STACK_DEPTH_NV = 0x8640 :: GLenum

pattern GL_CURRENT_NORMAL = 0x0B02 :: GLenum

pattern GL_CURRENT_OCCLUSION_QUERY_ID_NV = 0x8865 :: GLenum

pattern GL_CURRENT_PALETTE_MATRIX_ARB = 0x8843 :: GLenum

pattern GL_CURRENT_PALETTE_MATRIX_OES = 0x8843 :: GLenum

pattern GL_CURRENT_PROGRAM = 0x8B8D :: GLenum

pattern GL_CURRENT_QUERY = 0x8865 :: GLenum

pattern GL_CURRENT_QUERY_ARB = 0x8865 :: GLenum

pattern GL_CURRENT_QUERY_EXT = 0x8865 :: GLenum

pattern GL_CURRENT_RASTER_COLOR = 0x0B04 :: GLenum

pattern GL_CURRENT_RASTER_DISTANCE = 0x0B09 :: GLenum

pattern GL_CURRENT_RASTER_INDEX = 0x0B05 :: GLenum

pattern GL_CURRENT_RASTER_NORMAL_SGIX = 0x8406 :: GLenum

pattern GL_CURRENT_RASTER_POSITION = 0x0B07 :: GLenum

pattern GL_CURRENT_RASTER_POSITION_VALID = 0x0B08 :: GLenum

pattern GL_CURRENT_RASTER_SECONDARY_COLOR = 0x845F :: GLenum

pattern GL_CURRENT_RASTER_TEXTURE_COORDS = 0x0B06 :: GLenum

pattern GL_CURRENT_SECONDARY_COLOR = 0x8459 :: GLenum

pattern GL_CURRENT_SECONDARY_COLOR_EXT = 0x8459 :: GLenum

pattern GL_CURRENT_TANGENT_EXT = 0x843B :: GLenum

pattern GL_CURRENT_TEXTURE_COORDS = 0x0B03 :: GLenum

pattern GL_CURRENT_TIME_NV = 0x8E28 :: GLenum

pattern GL_CURRENT_VERTEX_ATTRIB = 0x8626 :: GLenum

pattern GL_CURRENT_VERTEX_ATTRIB_ARB = 0x8626 :: GLenum

pattern GL_CURRENT_VERTEX_EXT = 0x87E2 :: GLenum

pattern GL_CURRENT_VERTEX_WEIGHT_EXT = 0x850B :: GLenum

pattern GL_CURRENT_WEIGHT_ARB = 0x86A8 :: GLenum

pattern GL_CW = 0x0900 :: GLenum

pattern GL_DARKEN = 0x9297 :: GLenum

pattern GL_DARKEN_KHR = 0x9297 :: GLenum

pattern GL_DARKEN_NV = 0x9297 :: GLenum

pattern GL_DATA_BUFFER_AMD = 0x9151 :: GLenum

pattern GL_DEBUG_ASSERT_MESA = 0x875B :: GLenum

pattern GL_DEBUG_CALLBACK_FUNCTION = 0x8244 :: GLenum

pattern GL_DEBUG_CALLBACK_FUNCTION_ARB = 0x8244 :: GLenum

pattern GL_DEBUG_CALLBACK_FUNCTION_KHR = 0x8244 :: GLenum

pattern GL_DEBUG_CALLBACK_USER_PARAM = 0x8245 :: GLenum

pattern GL_DEBUG_CALLBACK_USER_PARAM_ARB = 0x8245 :: GLenum

pattern GL_DEBUG_CALLBACK_USER_PARAM_KHR = 0x8245 :: GLenum

pattern GL_DEBUG_CATEGORY_API_ERROR_AMD = 0x9149 :: GLenum

pattern GL_DEBUG_CATEGORY_APPLICATION_AMD = 0x914F :: GLenum

pattern GL_DEBUG_CATEGORY_DEPRECATION_AMD = 0x914B :: GLenum

pattern GL_DEBUG_CATEGORY_OTHER_AMD = 0x9150 :: GLenum

pattern GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 0x914D :: GLenum

pattern GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 0x914E :: GLenum

pattern GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 0x914C :: GLenum

pattern GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 0x914A :: GLenum

pattern GL_DEBUG_GROUP_STACK_DEPTH = 0x826D :: GLenum

pattern GL_DEBUG_GROUP_STACK_DEPTH_KHR = 0x826D :: GLenum

pattern GL_DEBUG_LOGGED_MESSAGES = 0x9145 :: GLenum

pattern GL_DEBUG_LOGGED_MESSAGES_AMD = 0x9145 :: GLenum

pattern GL_DEBUG_LOGGED_MESSAGES_ARB = 0x9145 :: GLenum

pattern GL_DEBUG_LOGGED_MESSAGES_KHR = 0x9145 :: GLenum

pattern GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 0x8243 :: GLenum

pattern GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 0x8243 :: GLenum

pattern GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 0x8243 :: GLenum

pattern GL_DEBUG_OBJECT_MESA = 0x8759 :: GLenum

pattern GL_DEBUG_OUTPUT = 0x92E0 :: GLenum

pattern GL_DEBUG_OUTPUT_KHR = 0x92E0 :: GLenum

pattern GL_DEBUG_OUTPUT_SYNCHRONOUS = 0x8242 :: GLenum

pattern GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 0x8242 :: GLenum

pattern GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 0x8242 :: GLenum

pattern GL_DEBUG_PRINT_MESA = 0x875A :: GLenum

pattern GL_DEBUG_SEVERITY_HIGH = 0x9146 :: GLenum

pattern GL_DEBUG_SEVERITY_HIGH_AMD = 0x9146 :: GLenum

pattern GL_DEBUG_SEVERITY_HIGH_ARB = 0x9146 :: GLenum

pattern GL_DEBUG_SEVERITY_HIGH_KHR = 0x9146 :: GLenum

pattern GL_DEBUG_SEVERITY_LOW = 0x9148 :: GLenum

pattern GL_DEBUG_SEVERITY_LOW_AMD = 0x9148 :: GLenum

pattern GL_DEBUG_SEVERITY_LOW_ARB = 0x9148 :: GLenum

pattern GL_DEBUG_SEVERITY_LOW_KHR = 0x9148 :: GLenum

pattern GL_DEBUG_SEVERITY_MEDIUM = 0x9147 :: GLenum

pattern GL_DEBUG_SEVERITY_MEDIUM_AMD = 0x9147 :: GLenum

pattern GL_DEBUG_SEVERITY_MEDIUM_ARB = 0x9147 :: GLenum

pattern GL_DEBUG_SEVERITY_MEDIUM_KHR = 0x9147 :: GLenum

pattern GL_DEBUG_SEVERITY_NOTIFICATION = 0x826B :: GLenum

pattern GL_DEBUG_SEVERITY_NOTIFICATION_KHR = 0x826B :: GLenum

pattern GL_DEBUG_SOURCE_API = 0x8246 :: GLenum

pattern GL_DEBUG_SOURCE_API_ARB = 0x8246 :: GLenum

pattern GL_DEBUG_SOURCE_API_KHR = 0x8246 :: GLenum

pattern GL_DEBUG_SOURCE_APPLICATION = 0x824A :: GLenum

pattern GL_DEBUG_SOURCE_APPLICATION_ARB = 0x824A :: GLenum

pattern GL_DEBUG_SOURCE_APPLICATION_KHR = 0x824A :: GLenum

pattern GL_DEBUG_SOURCE_OTHER = 0x824B :: GLenum

pattern GL_DEBUG_SOURCE_OTHER_ARB = 0x824B :: GLenum

pattern GL_DEBUG_SOURCE_OTHER_KHR = 0x824B :: GLenum

pattern GL_DEBUG_SOURCE_SHADER_COMPILER = 0x8248 :: GLenum

pattern GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 0x8248 :: GLenum

pattern GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = 0x8248 :: GLenum

pattern GL_DEBUG_SOURCE_THIRD_PARTY = 0x8249 :: GLenum

pattern GL_DEBUG_SOURCE_THIRD_PARTY_ARB = 0x8249 :: GLenum

pattern GL_DEBUG_SOURCE_THIRD_PARTY_KHR = 0x8249 :: GLenum

pattern GL_DEBUG_SOURCE_WINDOW_SYSTEM = 0x8247 :: GLenum

pattern GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 0x8247 :: GLenum

pattern GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 0x8247 :: GLenum

pattern GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 0x824D :: GLenum

pattern GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 0x824D :: GLenum

pattern GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 0x824D :: GLenum

pattern GL_DEBUG_TYPE_ERROR = 0x824C :: GLenum

pattern GL_DEBUG_TYPE_ERROR_ARB = 0x824C :: GLenum

pattern GL_DEBUG_TYPE_ERROR_KHR = 0x824C :: GLenum

pattern GL_DEBUG_TYPE_MARKER = 0x8268 :: GLenum

pattern GL_DEBUG_TYPE_MARKER_KHR = 0x8268 :: GLenum

pattern GL_DEBUG_TYPE_OTHER = 0x8251 :: GLenum

pattern GL_DEBUG_TYPE_OTHER_ARB = 0x8251 :: GLenum

pattern GL_DEBUG_TYPE_OTHER_KHR = 0x8251 :: GLenum

pattern GL_DEBUG_TYPE_PERFORMANCE = 0x8250 :: GLenum

pattern GL_DEBUG_TYPE_PERFORMANCE_ARB = 0x8250 :: GLenum

pattern GL_DEBUG_TYPE_PERFORMANCE_KHR = 0x8250 :: GLenum

pattern GL_DEBUG_TYPE_POP_GROUP = 0x826A :: GLenum

pattern GL_DEBUG_TYPE_POP_GROUP_KHR = 0x826A :: GLenum

pattern GL_DEBUG_TYPE_PORTABILITY = 0x824F :: GLenum

pattern GL_DEBUG_TYPE_PORTABILITY_ARB = 0x824F :: GLenum

pattern GL_DEBUG_TYPE_PORTABILITY_KHR = 0x824F :: GLenum

pattern GL_DEBUG_TYPE_PUSH_GROUP = 0x8269 :: GLenum

pattern GL_DEBUG_TYPE_PUSH_GROUP_KHR = 0x8269 :: GLenum

pattern GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 0x824E :: GLenum

pattern GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 0x824E :: GLenum

pattern GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 0x824E :: GLenum

pattern GL_DECAL = 0x2101 :: GLenum

pattern GL_DECODE_EXT = 0x8A49 :: GLenum

pattern GL_DECR = 0x1E03 :: GLenum

pattern GL_DECR_WRAP = 0x8508 :: GLenum

pattern GL_DECR_WRAP_EXT = 0x8508 :: GLenum

pattern GL_DECR_WRAP_OES = 0x8508 :: GLenum

pattern GL_DEFORMATIONS_MASK_SGIX = 0x8196 :: GLenum

pattern GL_DELETE_STATUS = 0x8B80 :: GLenum

pattern GL_DEPENDENT_AR_TEXTURE_2D_NV = 0x86E9 :: GLenum

pattern GL_DEPENDENT_GB_TEXTURE_2D_NV = 0x86EA :: GLenum

pattern GL_DEPENDENT_HILO_TEXTURE_2D_NV = 0x8858 :: GLenum

pattern GL_DEPENDENT_RGB_TEXTURE_3D_NV = 0x8859 :: GLenum

pattern GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = 0x885A :: GLenum

pattern GL_DEPTH = 0x1801 :: GLenum

pattern GL_DEPTH24_STENCIL8 = 0x88F0 :: GLenum

pattern GL_DEPTH24_STENCIL8_EXT = 0x88F0 :: GLenum

pattern GL_DEPTH24_STENCIL8_OES = 0x88F0 :: GLenum

pattern GL_DEPTH32F_STENCIL8 = 0x8CAD :: GLenum

pattern GL_DEPTH32F_STENCIL8_NV = 0x8DAC :: GLenum

pattern GL_DEPTH_ATTACHMENT = 0x8D00 :: GLenum

pattern GL_DEPTH_ATTACHMENT_EXT = 0x8D00 :: GLenum

pattern GL_DEPTH_ATTACHMENT_OES = 0x8D00 :: GLenum

pattern GL_DEPTH_BIAS = 0x0D1F :: GLenum

pattern GL_DEPTH_BITS = 0x0D56 :: GLenum

pattern GL_DEPTH_BOUNDS_EXT = 0x8891 :: GLenum

pattern GL_DEPTH_BOUNDS_TEST_EXT = 0x8890 :: GLenum

pattern GL_DEPTH_BUFFER_BIT = 0x00000100 :: GLbitfield

pattern GL_DEPTH_BUFFER_BIT0_QCOM = 0x00000100 :: GLbitfield

pattern GL_DEPTH_BUFFER_BIT1_QCOM = 0x00000200 :: GLbitfield

pattern GL_DEPTH_BUFFER_BIT2_QCOM = 0x00000400 :: GLbitfield

pattern GL_DEPTH_BUFFER_BIT3_QCOM = 0x00000800 :: GLbitfield

pattern GL_DEPTH_BUFFER_BIT4_QCOM = 0x00001000 :: GLbitfield

pattern GL_DEPTH_BUFFER_BIT5_QCOM = 0x00002000 :: GLbitfield

pattern GL_DEPTH_BUFFER_BIT6_QCOM = 0x00004000 :: GLbitfield

pattern GL_DEPTH_BUFFER_BIT7_QCOM = 0x00008000 :: GLbitfield

pattern GL_DEPTH_BUFFER_FLOAT_MODE_NV = 0x8DAF :: GLenum

pattern GL_DEPTH_CLAMP = 0x864F :: GLenum

pattern GL_DEPTH_CLAMP_FAR_AMD = 0x901F :: GLenum

pattern GL_DEPTH_CLAMP_NEAR_AMD = 0x901E :: GLenum

pattern GL_DEPTH_CLAMP_NV = 0x864F :: GLenum

pattern GL_DEPTH_CLEAR_VALUE = 0x0B73 :: GLenum

pattern GL_DEPTH_COMPONENT = 0x1902 :: GLenum

pattern GL_DEPTH_COMPONENT16 = 0x81A5 :: GLenum

pattern GL_DEPTH_COMPONENT16_ARB = 0x81A5 :: GLenum

pattern GL_DEPTH_COMPONENT16_NONLINEAR_NV = 0x8E2C :: GLenum

pattern GL_DEPTH_COMPONENT16_OES = 0x81A5 :: GLenum

pattern GL_DEPTH_COMPONENT16_SGIX = 0x81A5 :: GLenum

pattern GL_DEPTH_COMPONENT24 = 0x81A6 :: GLenum

pattern GL_DEPTH_COMPONENT24_ARB = 0x81A6 :: GLenum

pattern GL_DEPTH_COMPONENT24_OES = 0x81A6 :: GLenum

pattern GL_DEPTH_COMPONENT24_SGIX = 0x81A6 :: GLenum

pattern GL_DEPTH_COMPONENT32 = 0x81A7 :: GLenum

pattern GL_DEPTH_COMPONENT32F = 0x8CAC :: GLenum

pattern GL_DEPTH_COMPONENT32F_NV = 0x8DAB :: GLenum

pattern GL_DEPTH_COMPONENT32_ARB = 0x81A7 :: GLenum

pattern GL_DEPTH_COMPONENT32_OES = 0x81A7 :: GLenum

pattern GL_DEPTH_COMPONENT32_SGIX = 0x81A7 :: GLenum

pattern GL_DEPTH_COMPONENTS = 0x8284 :: GLenum

pattern GL_DEPTH_EXT = 0x1801 :: GLenum

pattern GL_DEPTH_FUNC = 0x0B74 :: GLenum

pattern GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX = 0x8311 :: GLenum

pattern GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX = 0x8312 :: GLenum

pattern GL_DEPTH_PASS_INSTRUMENT_SGIX = 0x8310 :: GLenum

pattern GL_DEPTH_RANGE = 0x0B70 :: GLenum

pattern GL_DEPTH_RENDERABLE = 0x8287 :: GLenum

pattern GL_DEPTH_SAMPLES_NV = 0x932D :: GLenum

pattern GL_DEPTH_SCALE = 0x0D1E :: GLenum

pattern GL_DEPTH_STENCIL = 0x84F9 :: GLenum

pattern GL_DEPTH_STENCIL_ATTACHMENT = 0x821A :: GLenum

pattern GL_DEPTH_STENCIL_EXT = 0x84F9 :: GLenum

pattern GL_DEPTH_STENCIL_MESA = 0x8750 :: GLenum

pattern GL_DEPTH_STENCIL_NV = 0x84F9 :: GLenum

pattern GL_DEPTH_STENCIL_OES = 0x84F9 :: GLenum

pattern GL_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA :: GLenum

pattern GL_DEPTH_STENCIL_TO_BGRA_NV = 0x886F :: GLenum

pattern GL_DEPTH_STENCIL_TO_RGBA_NV = 0x886E :: GLenum

pattern GL_DEPTH_TEST = 0x0B71 :: GLenum

pattern GL_DEPTH_TEXTURE_MODE = 0x884B :: GLenum

pattern GL_DEPTH_TEXTURE_MODE_ARB = 0x884B :: GLenum

pattern GL_DEPTH_WRITEMASK = 0x0B72 :: GLenum

pattern GL_DETAIL_TEXTURE_2D_BINDING_SGIS = 0x8096 :: GLenum

pattern GL_DETAIL_TEXTURE_2D_SGIS = 0x8095 :: GLenum

pattern GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = 0x809C :: GLenum

pattern GL_DETAIL_TEXTURE_LEVEL_SGIS = 0x809A :: GLenum

pattern GL_DETAIL_TEXTURE_MODE_SGIS = 0x809B :: GLenum

pattern GL_DIFFERENCE = 0x929E :: GLenum

pattern GL_DIFFERENCE_KHR = 0x929E :: GLenum

pattern GL_DIFFERENCE_NV = 0x929E :: GLenum

pattern GL_DIFFUSE = 0x1201 :: GLenum

pattern GL_DISCARD_ATI = 0x8763 :: GLenum

pattern GL_DISCARD_NV = 0x8530 :: GLenum

pattern GL_DISCRETE_AMD = 0x9006 :: GLenum

pattern GL_DISJOINT_NV = 0x9283 :: GLenum

pattern GL_DISPATCH_INDIRECT_BUFFER = 0x90EE :: GLenum

pattern GL_DISPATCH_INDIRECT_BUFFER_BINDING = 0x90EF :: GLenum

pattern GL_DISPLAY_LIST = 0x82E7 :: GLenum

pattern GL_DISTANCE_ATTENUATION_EXT = 0x8129 :: GLenum

pattern GL_DISTANCE_ATTENUATION_SGIS = 0x8129 :: GLenum

pattern GL_DITHER = 0x0BD0 :: GLenum

pattern GL_DMP_PROGRAM_BINARY_DMP = 0x9253 :: GLenum

pattern GL_DOMAIN = 0x0A02 :: GLenum

pattern GL_DONT_CARE = 0x1100 :: GLenum

pattern GL_DOT2_ADD_ATI = 0x896C :: GLenum

pattern GL_DOT3_ATI = 0x8966 :: GLenum

pattern GL_DOT3_RGB = 0x86AE :: GLenum

pattern GL_DOT3_RGBA = 0x86AF :: GLenum

pattern GL_DOT3_RGBA_ARB = 0x86AF :: GLenum

pattern GL_DOT3_RGBA_EXT = 0x8741 :: GLenum

pattern GL_DOT3_RGBA_IMG = 0x86AF :: GLenum

pattern GL_DOT3_RGB_ARB = 0x86AE :: GLenum

pattern GL_DOT3_RGB_EXT = 0x8740 :: GLenum

pattern GL_DOT4_ATI = 0x8967 :: GLenum

pattern GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = 0x885D :: GLenum

pattern GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = 0x86F3 :: GLenum

pattern GL_DOT_PRODUCT_DEPTH_REPLACE_NV = 0x86ED :: GLenum

pattern GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = 0x86F1 :: GLenum

pattern GL_DOT_PRODUCT_NV = 0x86EC :: GLenum

pattern GL_DOT_PRODUCT_PASS_THROUGH_NV = 0x885B :: GLenum

pattern GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = 0x86F2 :: GLenum

pattern GL_DOT_PRODUCT_TEXTURE_1D_NV = 0x885C :: GLenum

pattern GL_DOT_PRODUCT_TEXTURE_2D_NV = 0x86EE :: GLenum

pattern GL_DOT_PRODUCT_TEXTURE_3D_NV = 0x86EF :: GLenum

pattern GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = 0x86F0 :: GLenum

pattern GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = 0x864E :: GLenum

pattern GL_DOUBLE = 0x140A :: GLenum

pattern GL_DOUBLEBUFFER = 0x0C32 :: GLenum

pattern GL_DOUBLE_EXT = 0x140A :: GLenum

pattern GL_DOUBLE_MAT2 = 0x8F46 :: GLenum

pattern GL_DOUBLE_MAT2_EXT = 0x8F46 :: GLenum

pattern GL_DOUBLE_MAT2x3 = 0x8F49 :: GLenum

pattern GL_DOUBLE_MAT2x3_EXT = 0x8F49 :: GLenum

pattern GL_DOUBLE_MAT2x4 = 0x8F4A :: GLenum

pattern GL_DOUBLE_MAT2x4_EXT = 0x8F4A :: GLenum

pattern GL_DOUBLE_MAT3 = 0x8F47 :: GLenum

pattern GL_DOUBLE_MAT3_EXT = 0x8F47 :: GLenum

pattern GL_DOUBLE_MAT3x2 = 0x8F4B :: GLenum

pattern GL_DOUBLE_MAT3x2_EXT = 0x8F4B :: GLenum

pattern GL_DOUBLE_MAT3x4 = 0x8F4C :: GLenum

pattern GL_DOUBLE_MAT3x4_EXT = 0x8F4C :: GLenum

pattern GL_DOUBLE_MAT4 = 0x8F48 :: GLenum

pattern GL_DOUBLE_MAT4_EXT = 0x8F48 :: GLenum

pattern GL_DOUBLE_MAT4x2 = 0x8F4D :: GLenum

pattern GL_DOUBLE_MAT4x2_EXT = 0x8F4D :: GLenum

pattern GL_DOUBLE_MAT4x3 = 0x8F4E :: GLenum

pattern GL_DOUBLE_MAT4x3_EXT = 0x8F4E :: GLenum

pattern GL_DOUBLE_VEC2 = 0x8FFC :: GLenum

pattern GL_DOUBLE_VEC2_EXT = 0x8FFC :: GLenum

pattern GL_DOUBLE_VEC3 = 0x8FFD :: GLenum

pattern GL_DOUBLE_VEC3_EXT = 0x8FFD :: GLenum

pattern GL_DOUBLE_VEC4 = 0x8FFE :: GLenum

pattern GL_DOUBLE_VEC4_EXT = 0x8FFE :: GLenum

pattern GL_DOWNSAMPLE_SCALES_IMG = 0x913E :: GLenum

pattern GL_DRAW_ARRAYS_COMMAND_NV = 0x0003 :: GLenum

pattern GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV = 0x0007 :: GLenum

pattern GL_DRAW_ARRAYS_STRIP_COMMAND_NV = 0x0005 :: GLenum

pattern GL_DRAW_BUFFER = 0x0C01 :: GLenum

pattern GL_DRAW_BUFFER0 = 0x8825 :: GLenum

pattern GL_DRAW_BUFFER0_ARB = 0x8825 :: GLenum

pattern GL_DRAW_BUFFER0_ATI = 0x8825 :: GLenum

pattern GL_DRAW_BUFFER0_EXT = 0x8825 :: GLenum

pattern GL_DRAW_BUFFER0_NV = 0x8825 :: GLenum

pattern GL_DRAW_BUFFER1 = 0x8826 :: GLenum

pattern GL_DRAW_BUFFER10 = 0x882F :: GLenum

pattern GL_DRAW_BUFFER10_ARB = 0x882F :: GLenum

pattern GL_DRAW_BUFFER10_ATI = 0x882F :: GLenum

pattern GL_DRAW_BUFFER10_EXT = 0x882F :: GLenum

pattern GL_DRAW_BUFFER10_NV = 0x882F :: GLenum

pattern GL_DRAW_BUFFER11 = 0x8830 :: GLenum

pattern GL_DRAW_BUFFER11_ARB = 0x8830 :: GLenum

pattern GL_DRAW_BUFFER11_ATI = 0x8830 :: GLenum

pattern GL_DRAW_BUFFER11_EXT = 0x8830 :: GLenum

pattern GL_DRAW_BUFFER11_NV = 0x8830 :: GLenum

pattern GL_DRAW_BUFFER12 = 0x8831 :: GLenum

pattern GL_DRAW_BUFFER12_ARB = 0x8831 :: GLenum

pattern GL_DRAW_BUFFER12_ATI = 0x8831 :: GLenum

pattern GL_DRAW_BUFFER12_EXT = 0x8831 :: GLenum

pattern GL_DRAW_BUFFER12_NV = 0x8831 :: GLenum

pattern GL_DRAW_BUFFER13 = 0x8832 :: GLenum

pattern GL_DRAW_BUFFER13_ARB = 0x8832 :: GLenum

pattern GL_DRAW_BUFFER13_ATI = 0x8832 :: GLenum

pattern GL_DRAW_BUFFER13_EXT = 0x8832 :: GLenum

pattern GL_DRAW_BUFFER13_NV = 0x8832 :: GLenum

pattern GL_DRAW_BUFFER14 = 0x8833 :: GLenum

pattern GL_DRAW_BUFFER14_ARB = 0x8833 :: GLenum

pattern GL_DRAW_BUFFER14_ATI = 0x8833 :: GLenum

pattern GL_DRAW_BUFFER14_EXT = 0x8833 :: GLenum

pattern GL_DRAW_BUFFER14_NV = 0x8833 :: GLenum

pattern GL_DRAW_BUFFER15 = 0x8834 :: GLenum

pattern GL_DRAW_BUFFER15_ARB = 0x8834 :: GLenum

pattern GL_DRAW_BUFFER15_ATI = 0x8834 :: GLenum

pattern GL_DRAW_BUFFER15_EXT = 0x8834 :: GLenum

pattern GL_DRAW_BUFFER15_NV = 0x8834 :: GLenum

pattern GL_DRAW_BUFFER1_ARB = 0x8826 :: GLenum

pattern GL_DRAW_BUFFER1_ATI = 0x8826 :: GLenum

pattern GL_DRAW_BUFFER1_EXT = 0x8826 :: GLenum

pattern GL_DRAW_BUFFER1_NV = 0x8826 :: GLenum

pattern GL_DRAW_BUFFER2 = 0x8827 :: GLenum

pattern GL_DRAW_BUFFER2_ARB = 0x8827 :: GLenum

pattern GL_DRAW_BUFFER2_ATI = 0x8827 :: GLenum

pattern GL_DRAW_BUFFER2_EXT = 0x8827 :: GLenum

pattern GL_DRAW_BUFFER2_NV = 0x8827 :: GLenum

pattern GL_DRAW_BUFFER3 = 0x8828 :: GLenum

pattern GL_DRAW_BUFFER3_ARB = 0x8828 :: GLenum

pattern GL_DRAW_BUFFER3_ATI = 0x8828 :: GLenum

pattern GL_DRAW_BUFFER3_EXT = 0x8828 :: GLenum

pattern GL_DRAW_BUFFER3_NV = 0x8828 :: GLenum

pattern GL_DRAW_BUFFER4 = 0x8829 :: GLenum

pattern GL_DRAW_BUFFER4_ARB = 0x8829 :: GLenum

pattern GL_DRAW_BUFFER4_ATI = 0x8829 :: GLenum

pattern GL_DRAW_BUFFER4_EXT = 0x8829 :: GLenum

pattern GL_DRAW_BUFFER4_NV = 0x8829 :: GLenum

pattern GL_DRAW_BUFFER5 = 0x882A :: GLenum

pattern GL_DRAW_BUFFER5_ARB = 0x882A :: GLenum

pattern GL_DRAW_BUFFER5_ATI = 0x882A :: GLenum

pattern GL_DRAW_BUFFER5_EXT = 0x882A :: GLenum

pattern GL_DRAW_BUFFER5_NV = 0x882A :: GLenum

pattern GL_DRAW_BUFFER6 = 0x882B :: GLenum

pattern GL_DRAW_BUFFER6_ARB = 0x882B :: GLenum

pattern GL_DRAW_BUFFER6_ATI = 0x882B :: GLenum

pattern GL_DRAW_BUFFER6_EXT = 0x882B :: GLenum

pattern GL_DRAW_BUFFER6_NV = 0x882B :: GLenum

pattern GL_DRAW_BUFFER7 = 0x882C :: GLenum

pattern GL_DRAW_BUFFER7_ARB = 0x882C :: GLenum

pattern GL_DRAW_BUFFER7_ATI = 0x882C :: GLenum

pattern GL_DRAW_BUFFER7_EXT = 0x882C :: GLenum

pattern GL_DRAW_BUFFER7_NV = 0x882C :: GLenum

pattern GL_DRAW_BUFFER8 = 0x882D :: GLenum

pattern GL_DRAW_BUFFER8_ARB = 0x882D :: GLenum

pattern GL_DRAW_BUFFER8_ATI = 0x882D :: GLenum

pattern GL_DRAW_BUFFER8_EXT = 0x882D :: GLenum

pattern GL_DRAW_BUFFER8_NV = 0x882D :: GLenum

pattern GL_DRAW_BUFFER9 = 0x882E :: GLenum

pattern GL_DRAW_BUFFER9_ARB = 0x882E :: GLenum

pattern GL_DRAW_BUFFER9_ATI = 0x882E :: GLenum

pattern GL_DRAW_BUFFER9_EXT = 0x882E :: GLenum

pattern GL_DRAW_BUFFER9_NV = 0x882E :: GLenum

pattern GL_DRAW_BUFFER_EXT = 0x0C01 :: GLenum

pattern GL_DRAW_ELEMENTS_COMMAND_NV = 0x0002 :: GLenum

pattern GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV = 0x0006 :: GLenum

pattern GL_DRAW_ELEMENTS_STRIP_COMMAND_NV = 0x0004 :: GLenum

pattern GL_DRAW_FRAMEBUFFER = 0x8CA9 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_ANGLE = 0x8CA9 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_APPLE = 0x8CA9 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_BINDING = 0x8CA6 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_BINDING_ANGLE = 0x8CA6 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_BINDING_APPLE = 0x8CA6 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_BINDING_EXT = 0x8CA6 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_BINDING_NV = 0x8CA6 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_EXT = 0x8CA9 :: GLenum

pattern GL_DRAW_FRAMEBUFFER_NV = 0x8CA9 :: GLenum

pattern GL_DRAW_INDIRECT_ADDRESS_NV = 0x8F41 :: GLenum

pattern GL_DRAW_INDIRECT_BUFFER = 0x8F3F :: GLenum

pattern GL_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43 :: GLenum

pattern GL_DRAW_INDIRECT_LENGTH_NV = 0x8F42 :: GLenum

pattern GL_DRAW_INDIRECT_UNIFIED_NV = 0x8F40 :: GLenum

pattern GL_DRAW_PIXELS_APPLE = 0x8A0A :: GLenum

pattern GL_DRAW_PIXEL_TOKEN = 0x0705 :: GLenum

pattern GL_DSDT8_MAG8_INTENSITY8_NV = 0x870B :: GLenum

pattern GL_DSDT8_MAG8_NV = 0x870A :: GLenum

pattern GL_DSDT8_NV = 0x8709 :: GLenum

pattern GL_DSDT_MAG_INTENSITY_NV = 0x86DC :: GLenum

pattern GL_DSDT_MAG_NV = 0x86F6 :: GLenum

pattern GL_DSDT_MAG_VIB_NV = 0x86F7 :: GLenum

pattern GL_DSDT_NV = 0x86F5 :: GLenum

pattern GL_DST_ALPHA = 0x0304 :: GLenum

pattern GL_DST_ATOP_NV = 0x928F :: GLenum

pattern GL_DST_COLOR = 0x0306 :: GLenum

pattern GL_DST_IN_NV = 0x928B :: GLenum

pattern GL_DST_NV = 0x9287 :: GLenum

pattern GL_DST_OUT_NV = 0x928D :: GLenum

pattern GL_DST_OVER_NV = 0x9289 :: GLenum

pattern GL_DS_BIAS_NV = 0x8716 :: GLenum

pattern GL_DS_SCALE_NV = 0x8710 :: GLenum

pattern GL_DT_BIAS_NV = 0x8717 :: GLenum

pattern GL_DT_SCALE_NV = 0x8711 :: GLenum

pattern GL_DU8DV8_ATI = 0x877A :: GLenum

pattern GL_DUAL_ALPHA12_SGIS = 0x8112 :: GLenum

pattern GL_DUAL_ALPHA16_SGIS = 0x8113 :: GLenum

pattern GL_DUAL_ALPHA4_SGIS = 0x8110 :: GLenum

pattern GL_DUAL_ALPHA8_SGIS = 0x8111 :: GLenum

pattern GL_DUAL_INTENSITY12_SGIS = 0x811A :: GLenum

pattern GL_DUAL_INTENSITY16_SGIS = 0x811B :: GLenum

pattern GL_DUAL_INTENSITY4_SGIS = 0x8118 :: GLenum

pattern GL_DUAL_INTENSITY8_SGIS = 0x8119 :: GLenum

pattern GL_DUAL_LUMINANCE12_SGIS = 0x8116 :: GLenum

pattern GL_DUAL_LUMINANCE16_SGIS = 0x8117 :: GLenum

pattern GL_DUAL_LUMINANCE4_SGIS = 0x8114 :: GLenum

pattern GL_DUAL_LUMINANCE8_SGIS = 0x8115 :: GLenum

pattern GL_DUAL_LUMINANCE_ALPHA4_SGIS = 0x811C :: GLenum

pattern GL_DUAL_LUMINANCE_ALPHA8_SGIS = 0x811D :: GLenum

pattern GL_DUAL_TEXTURE_SELECT_SGIS = 0x8124 :: GLenum

pattern GL_DUDV_ATI = 0x8779 :: GLenum

pattern GL_DUP_FIRST_CUBIC_CURVE_TO_NV = 0xF2 :: GLubyte

pattern GL_DUP_LAST_CUBIC_CURVE_TO_NV = 0xF4 :: GLubyte

pattern GL_DYNAMIC_ATI = 0x8761 :: GLenum

pattern GL_DYNAMIC_COPY = 0x88EA :: GLenum

pattern GL_DYNAMIC_COPY_ARB = 0x88EA :: GLenum

pattern GL_DYNAMIC_DRAW = 0x88E8 :: GLenum

pattern GL_DYNAMIC_DRAW_ARB = 0x88E8 :: GLenum

pattern GL_DYNAMIC_READ = 0x88E9 :: GLenum

pattern GL_DYNAMIC_READ_ARB = 0x88E9 :: GLenum

pattern GL_DYNAMIC_STORAGE_BIT = 0x0100 :: GLbitfield

pattern GL_DYNAMIC_STORAGE_BIT_EXT = 0x0100 :: GLbitfield

pattern GL_EDGEFLAG_BIT_PGI = 0x00040000 :: GLbitfield

pattern GL_EDGE_FLAG = 0x0B43 :: GLenum

pattern GL_EDGE_FLAG_ARRAY = 0x8079 :: GLenum

pattern GL_EDGE_FLAG_ARRAY_ADDRESS_NV = 0x8F26 :: GLenum

pattern GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 0x889B :: GLenum

pattern GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = 0x889B :: GLenum

pattern GL_EDGE_FLAG_ARRAY_COUNT_EXT = 0x808D :: GLenum

pattern GL_EDGE_FLAG_ARRAY_EXT = 0x8079 :: GLenum

pattern GL_EDGE_FLAG_ARRAY_LENGTH_NV = 0x8F30 :: GLenum

pattern GL_EDGE_FLAG_ARRAY_LIST_IBM = 103075 :: GLenum

pattern GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM = 103085 :: GLenum

pattern GL_EDGE_FLAG_ARRAY_POINTER = 0x8093 :: GLenum

pattern GL_EDGE_FLAG_ARRAY_POINTER_EXT = 0x8093 :: GLenum

pattern GL_EDGE_FLAG_ARRAY_STRIDE = 0x808C :: GLenum

pattern GL_EDGE_FLAG_ARRAY_STRIDE_EXT = 0x808C :: GLenum

pattern GL_EFFECTIVE_RASTER_SAMPLES_EXT = 0x932C :: GLenum

pattern GL_EIGHTH_BIT_ATI = 0x00000020 :: GLbitfield

pattern GL_ELEMENT_ADDRESS_COMMAND_NV = 0x0008 :: GLenum

pattern GL_ELEMENT_ARRAY_ADDRESS_NV = 0x8F29 :: GLenum

pattern GL_ELEMENT_ARRAY_APPLE = 0x8A0C :: GLenum

pattern GL_ELEMENT_ARRAY_ATI = 0x8768 :: GLenum

pattern GL_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002 :: GLbitfield

pattern GL_ELEMENT_ARRAY_BARRIER_BIT_EXT = 0x00000002 :: GLbitfield

pattern GL_ELEMENT_ARRAY_BUFFER = 0x8893 :: GLenum

pattern GL_ELEMENT_ARRAY_BUFFER_ARB = 0x8893 :: GLenum

pattern GL_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895 :: GLenum

pattern GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = 0x8895 :: GLenum

pattern GL_ELEMENT_ARRAY_LENGTH_NV = 0x8F33 :: GLenum

pattern GL_ELEMENT_ARRAY_POINTER_APPLE = 0x8A0E :: GLenum

pattern GL_ELEMENT_ARRAY_POINTER_ATI = 0x876A :: GLenum

pattern GL_ELEMENT_ARRAY_TYPE_APPLE = 0x8A0D :: GLenum

pattern GL_ELEMENT_ARRAY_TYPE_ATI = 0x8769 :: GLenum

pattern GL_ELEMENT_ARRAY_UNIFIED_NV = 0x8F1F :: GLenum

pattern GL_EMBOSS_CONSTANT_NV = 0x855E :: GLenum

pattern GL_EMBOSS_LIGHT_NV = 0x855D :: GLenum

pattern GL_EMBOSS_MAP_NV = 0x855F :: GLenum

pattern GL_EMISSION = 0x1600 :: GLenum

pattern GL_ENABLE_BIT = 0x00002000 :: GLbitfield

pattern GL_EQUAL = 0x0202 :: GLenum

pattern GL_EQUIV = 0x1509 :: GLenum

pattern GL_ETC1_RGB8_OES = 0x8D64 :: GLenum

pattern GL_ETC1_SRGB8_NV = 0x88EE :: GLenum

pattern GL_EVAL_2D_NV = 0x86C0 :: GLenum

pattern GL_EVAL_BIT = 0x00010000 :: GLbitfield

pattern GL_EVAL_FRACTIONAL_TESSELLATION_NV = 0x86C5 :: GLenum

pattern GL_EVAL_TRIANGULAR_2D_NV = 0x86C1 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB0_NV = 0x86C6 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB10_NV = 0x86D0 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB11_NV = 0x86D1 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB12_NV = 0x86D2 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB13_NV = 0x86D3 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB14_NV = 0x86D4 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB15_NV = 0x86D5 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB1_NV = 0x86C7 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB2_NV = 0x86C8 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB3_NV = 0x86C9 :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB4_NV = 0x86CA :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB5_NV = 0x86CB :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB6_NV = 0x86CC :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB7_NV = 0x86CD :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB8_NV = 0x86CE :: GLenum

pattern GL_EVAL_VERTEX_ATTRIB9_NV = 0x86CF :: GLenum

pattern GL_EXCLUSION = 0x92A0 :: GLenum

pattern GL_EXCLUSION_KHR = 0x92A0 :: GLenum

pattern GL_EXCLUSION_NV = 0x92A0 :: GLenum

pattern GL_EXCLUSIVE_EXT = 0x8F11 :: GLenum

pattern GL_EXP = 0x0800 :: GLenum

pattern GL_EXP2 = 0x0801 :: GLenum

pattern GL_EXPAND_NEGATE_NV = 0x8539 :: GLenum

pattern GL_EXPAND_NORMAL_NV = 0x8538 :: GLenum

pattern GL_EXTENSIONS = 0x1F03 :: GLenum

pattern GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD = 0x9160 :: GLenum

pattern GL_EYE_DISTANCE_TO_LINE_SGIS = 0x81F2 :: GLenum

pattern GL_EYE_DISTANCE_TO_POINT_SGIS = 0x81F0 :: GLenum

pattern GL_EYE_LINEAR = 0x2400 :: GLenum

pattern GL_EYE_LINEAR_NV = 0x2400 :: GLenum

pattern GL_EYE_LINE_SGIS = 0x81F6 :: GLenum

pattern GL_EYE_PLANE = 0x2502 :: GLenum

pattern GL_EYE_PLANE_ABSOLUTE_NV = 0x855C :: GLenum

pattern GL_EYE_POINT_SGIS = 0x81F4 :: GLenum

pattern GL_EYE_RADIAL_NV = 0x855B :: GLenum

pattern GL_E_TIMES_F_NV = 0x8531 :: GLenum

pattern GL_FACTOR_ALPHA_MODULATE_IMG = 0x8C07 :: GLenum

pattern GL_FACTOR_MAX_AMD = 0x901D :: GLenum

pattern GL_FACTOR_MIN_AMD = 0x901C :: GLenum

pattern GL_FAILURE_NV = 0x9030 :: GLenum

pattern GL_FALSE = 0 :: GLboolean

pattern GL_FASTEST = 0x1101 :: GLenum

pattern GL_FEEDBACK = 0x1C01 :: GLenum

pattern GL_FEEDBACK_BUFFER_POINTER = 0x0DF0 :: GLenum

pattern GL_FEEDBACK_BUFFER_SIZE = 0x0DF1 :: GLenum

pattern GL_FEEDBACK_BUFFER_TYPE = 0x0DF2 :: GLenum

pattern GL_FENCE_APPLE = 0x8A0B :: GLenum

pattern GL_FENCE_CONDITION_NV = 0x84F4 :: GLenum

pattern GL_FENCE_STATUS_NV = 0x84F3 :: GLenum

pattern GL_FETCH_PER_SAMPLE_ARM = 0x8F65 :: GLenum

pattern GL_FIELDS_NV = 0x8E27 :: GLenum

pattern GL_FIELD_LOWER_NV = 0x9023 :: GLenum

pattern GL_FIELD_UPPER_NV = 0x9022 :: GLenum

pattern GL_FILE_NAME_NV = 0x9074 :: GLenum

pattern GL_FILL = 0x1B02 :: GLenum

pattern GL_FILL_NV = 0x1B02 :: GLenum

pattern GL_FILL_RECTANGLE_NV = 0x933C :: GLenum

pattern GL_FILTER = 0x829A :: GLenum

pattern GL_FILTER4_SGIS = 0x8146 :: GLenum

pattern GL_FIRST_TO_REST_NV = 0x90AF :: GLenum

pattern GL_FIRST_VERTEX_CONVENTION = 0x8E4D :: GLenum

pattern GL_FIRST_VERTEX_CONVENTION_EXT = 0x8E4D :: GLenum

pattern GL_FIRST_VERTEX_CONVENTION_OES = 0x8E4D :: GLenum

pattern GL_FIXED = 0x140C :: GLenum

pattern GL_FIXED_OES = 0x140C :: GLenum

pattern GL_FIXED_ONLY = 0x891D :: GLenum

pattern GL_FIXED_ONLY_ARB = 0x891D :: GLenum

pattern GL_FLAT = 0x1D00 :: GLenum

pattern GL_FLOAT = 0x1406 :: GLenum

pattern GL_FLOAT16_NV = 0x8FF8 :: GLenum

pattern GL_FLOAT16_VEC2_NV = 0x8FF9 :: GLenum

pattern GL_FLOAT16_VEC3_NV = 0x8FFA :: GLenum

pattern GL_FLOAT16_VEC4_NV = 0x8FFB :: GLenum

pattern GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD :: GLenum

pattern GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV = 0x8DAD :: GLenum

pattern GL_FLOAT_CLEAR_COLOR_VALUE_NV = 0x888D :: GLenum

pattern GL_FLOAT_MAT2 = 0x8B5A :: GLenum

pattern GL_FLOAT_MAT2_ARB = 0x8B5A :: GLenum

pattern GL_FLOAT_MAT2x3 = 0x8B65 :: GLenum

pattern GL_FLOAT_MAT2x3_NV = 0x8B65 :: GLenum

pattern GL_FLOAT_MAT2x4 = 0x8B66 :: GLenum

pattern GL_FLOAT_MAT2x4_NV = 0x8B66 :: GLenum

pattern GL_FLOAT_MAT3 = 0x8B5B :: GLenum

pattern GL_FLOAT_MAT3_ARB = 0x8B5B :: GLenum

pattern GL_FLOAT_MAT3x2 = 0x8B67 :: GLenum

pattern GL_FLOAT_MAT3x2_NV = 0x8B67 :: GLenum

pattern GL_FLOAT_MAT3x4 = 0x8B68 :: GLenum

pattern GL_FLOAT_MAT3x4_NV = 0x8B68 :: GLenum

pattern GL_FLOAT_MAT4 = 0x8B5C :: GLenum

pattern GL_FLOAT_MAT4_ARB = 0x8B5C :: GLenum

pattern GL_FLOAT_MAT4x2 = 0x8B69 :: GLenum

pattern GL_FLOAT_MAT4x2_NV = 0x8B69 :: GLenum

pattern GL_FLOAT_MAT4x3 = 0x8B6A :: GLenum

pattern GL_FLOAT_MAT4x3_NV = 0x8B6A :: GLenum

pattern GL_FLOAT_R16_NV = 0x8884 :: GLenum

pattern GL_FLOAT_R32_NV = 0x8885 :: GLenum

pattern GL_FLOAT_RG16_NV = 0x8886 :: GLenum

pattern GL_FLOAT_RG32_NV = 0x8887 :: GLenum

pattern GL_FLOAT_RGB16_NV = 0x8888 :: GLenum

pattern GL_FLOAT_RGB32_NV = 0x8889 :: GLenum

pattern GL_FLOAT_RGBA16_NV = 0x888A :: GLenum

pattern GL_FLOAT_RGBA32_NV = 0x888B :: GLenum

pattern GL_FLOAT_RGBA_MODE_NV = 0x888E :: GLenum

pattern GL_FLOAT_RGBA_NV = 0x8883 :: GLenum

pattern GL_FLOAT_RGB_NV = 0x8882 :: GLenum

pattern GL_FLOAT_RG_NV = 0x8881 :: GLenum

pattern GL_FLOAT_R_NV = 0x8880 :: GLenum

pattern GL_FLOAT_VEC2 = 0x8B50 :: GLenum

pattern GL_FLOAT_VEC2_ARB = 0x8B50 :: GLenum

pattern GL_FLOAT_VEC3 = 0x8B51 :: GLenum

pattern GL_FLOAT_VEC3_ARB = 0x8B51 :: GLenum

pattern GL_FLOAT_VEC4 = 0x8B52 :: GLenum

pattern GL_FLOAT_VEC4_ARB = 0x8B52 :: GLenum

pattern GL_FOG = 0x0B60 :: GLenum

pattern GL_FOG_BIT = 0x00000080 :: GLbitfield

pattern GL_FOG_COLOR = 0x0B66 :: GLenum

pattern GL_FOG_COORD = 0x8451 :: GLenum

pattern GL_FOG_COORDINATE = 0x8451 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY = 0x8457 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 0x889D :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = 0x889D :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_EXT = 0x8457 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_LIST_IBM = 103076 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM = 103086 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_POINTER = 0x8456 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_POINTER_EXT = 0x8456 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_STRIDE = 0x8455 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_STRIDE_EXT = 0x8455 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_TYPE = 0x8454 :: GLenum

pattern GL_FOG_COORDINATE_ARRAY_TYPE_EXT = 0x8454 :: GLenum

pattern GL_FOG_COORDINATE_EXT = 0x8451 :: GLenum

pattern GL_FOG_COORDINATE_SOURCE = 0x8450 :: GLenum

pattern GL_FOG_COORDINATE_SOURCE_EXT = 0x8450 :: GLenum

pattern GL_FOG_COORD_ARRAY = 0x8457 :: GLenum

pattern GL_FOG_COORD_ARRAY_ADDRESS_NV = 0x8F28 :: GLenum

pattern GL_FOG_COORD_ARRAY_BUFFER_BINDING = 0x889D :: GLenum

pattern GL_FOG_COORD_ARRAY_LENGTH_NV = 0x8F32 :: GLenum

pattern GL_FOG_COORD_ARRAY_POINTER = 0x8456 :: GLenum

pattern GL_FOG_COORD_ARRAY_STRIDE = 0x8455 :: GLenum

pattern GL_FOG_COORD_ARRAY_TYPE = 0x8454 :: GLenum

pattern GL_FOG_COORD_SRC = 0x8450 :: GLenum

pattern GL_FOG_DENSITY = 0x0B62 :: GLenum

pattern GL_FOG_DISTANCE_MODE_NV = 0x855A :: GLenum

pattern GL_FOG_END = 0x0B64 :: GLenum

pattern GL_FOG_FUNC_POINTS_SGIS = 0x812B :: GLenum

pattern GL_FOG_FUNC_SGIS = 0x812A :: GLenum

pattern GL_FOG_HINT = 0x0C54 :: GLenum

pattern GL_FOG_INDEX = 0x0B61 :: GLenum

pattern GL_FOG_MODE = 0x0B65 :: GLenum

pattern GL_FOG_OFFSET_SGIX = 0x8198 :: GLenum

pattern GL_FOG_OFFSET_VALUE_SGIX = 0x8199 :: GLenum

pattern GL_FOG_SPECULAR_TEXTURE_WIN = 0x80EC :: GLenum

pattern GL_FOG_START = 0x0B63 :: GLenum

pattern GL_FONT_ASCENDER_BIT_NV = 0x00200000 :: GLbitfield

pattern GL_FONT_DESCENDER_BIT_NV = 0x00400000 :: GLbitfield

pattern GL_FONT_GLYPHS_AVAILABLE_NV = 0x9368 :: GLenum

pattern GL_FONT_HAS_KERNING_BIT_NV = 0x10000000 :: GLbitfield

pattern GL_FONT_HEIGHT_BIT_NV = 0x00800000 :: GLbitfield

pattern GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = 0x02000000 :: GLbitfield

pattern GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV = 0x01000000 :: GLbitfield

pattern GL_FONT_NUM_GLYPH_INDICES_BIT_NV = 0x20000000 :: GLbitfield

pattern GL_FONT_TARGET_UNAVAILABLE_NV = 0x9369 :: GLenum

pattern GL_FONT_UNAVAILABLE_NV = 0x936A :: GLenum

pattern GL_FONT_UNDERLINE_POSITION_BIT_NV = 0x04000000 :: GLbitfield

pattern GL_FONT_UNDERLINE_THICKNESS_BIT_NV = 0x08000000 :: GLbitfield

pattern GL_FONT_UNINTELLIGIBLE_NV = 0x936B :: GLenum

pattern GL_FONT_UNITS_PER_EM_BIT_NV = 0x00100000 :: GLbitfield

pattern GL_FONT_X_MAX_BOUNDS_BIT_NV = 0x00040000 :: GLbitfield

pattern GL_FONT_X_MIN_BOUNDS_BIT_NV = 0x00010000 :: GLbitfield

pattern GL_FONT_Y_MAX_BOUNDS_BIT_NV = 0x00080000 :: GLbitfield

pattern GL_FONT_Y_MIN_BOUNDS_BIT_NV = 0x00020000 :: GLbitfield

pattern GL_FORCE_BLUE_TO_ONE_NV = 0x8860 :: GLenum

pattern GL_FORMAT_SUBSAMPLE_244_244_OML = 0x8983 :: GLenum

pattern GL_FORMAT_SUBSAMPLE_24_24_OML = 0x8982 :: GLenum

pattern GL_FRACTIONAL_EVEN = 0x8E7C :: GLenum

pattern GL_FRACTIONAL_EVEN_EXT = 0x8E7C :: GLenum

pattern GL_FRACTIONAL_EVEN_OES = 0x8E7C :: GLenum

pattern GL_FRACTIONAL_ODD = 0x8E7B :: GLenum

pattern GL_FRACTIONAL_ODD_EXT = 0x8E7B :: GLenum

pattern GL_FRACTIONAL_ODD_OES = 0x8E7B :: GLenum

pattern GL_FRAGMENTS_INSTRUMENT_COUNTERS_SGIX = 0x8314 :: GLenum

pattern GL_FRAGMENTS_INSTRUMENT_MAX_SGIX = 0x8315 :: GLenum

pattern GL_FRAGMENTS_INSTRUMENT_SGIX = 0x8313 :: GLenum

pattern GL_FRAGMENT_ALPHA_MODULATE_IMG = 0x8C08 :: GLenum

pattern GL_FRAGMENT_COLOR_EXT = 0x834C :: GLenum

pattern GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX = 0x8402 :: GLenum

pattern GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX = 0x8403 :: GLenum

pattern GL_FRAGMENT_COLOR_MATERIAL_SGIX = 0x8401 :: GLenum

pattern GL_FRAGMENT_COVERAGE_COLOR_NV = 0x92DE :: GLenum

pattern GL_FRAGMENT_COVERAGE_TO_COLOR_NV = 0x92DD :: GLenum

pattern GL_FRAGMENT_DEPTH = 0x8452 :: GLenum

pattern GL_FRAGMENT_DEPTH_EXT = 0x8452 :: GLenum

pattern GL_FRAGMENT_INPUT_NV = 0x936D :: GLenum

pattern GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D :: GLenum

pattern GL_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES = 0x8E5D :: GLenum

pattern GL_FRAGMENT_LIGHT0_SGIX = 0x840C :: GLenum

pattern GL_FRAGMENT_LIGHT1_SGIX = 0x840D :: GLenum

pattern GL_FRAGMENT_LIGHT2_SGIX = 0x840E :: GLenum

pattern GL_FRAGMENT_LIGHT3_SGIX = 0x840F :: GLenum

pattern GL_FRAGMENT_LIGHT4_SGIX = 0x8410 :: GLenum

pattern GL_FRAGMENT_LIGHT5_SGIX = 0x8411 :: GLenum

pattern GL_FRAGMENT_LIGHT6_SGIX = 0x8412 :: GLenum

pattern GL_FRAGMENT_LIGHT7_SGIX = 0x8413 :: GLenum

pattern GL_FRAGMENT_LIGHTING_SGIX = 0x8400 :: GLenum

pattern GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = 0x840A :: GLenum

pattern GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = 0x8408 :: GLenum

pattern GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = 0x840B :: GLenum

pattern GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = 0x8409 :: GLenum

pattern GL_FRAGMENT_MATERIAL_EXT = 0x8349 :: GLenum

pattern GL_FRAGMENT_NORMAL_EXT = 0x834A :: GLenum

pattern GL_FRAGMENT_PROGRAM_ARB = 0x8804 :: GLenum

pattern GL_FRAGMENT_PROGRAM_BINDING_NV = 0x8873 :: GLenum

pattern GL_FRAGMENT_PROGRAM_CALLBACK_DATA_MESA = 0x8BB3 :: GLenum

pattern GL_FRAGMENT_PROGRAM_CALLBACK_FUNC_MESA = 0x8BB2 :: GLenum

pattern GL_FRAGMENT_PROGRAM_CALLBACK_MESA = 0x8BB1 :: GLenum

pattern GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV = 0x8E5D :: GLenum

pattern GL_FRAGMENT_PROGRAM_NV = 0x8870 :: GLenum

pattern GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA4 :: GLenum

pattern GL_FRAGMENT_PROGRAM_POSITION_MESA = 0x8BB0 :: GLenum

pattern GL_FRAGMENT_SHADER = 0x8B30 :: GLenum

pattern GL_FRAGMENT_SHADER_ARB = 0x8B30 :: GLenum

pattern GL_FRAGMENT_SHADER_ATI = 0x8920 :: GLenum

pattern GL_FRAGMENT_SHADER_BIT = 0x00000002 :: GLbitfield

pattern GL_FRAGMENT_SHADER_BIT_EXT = 0x00000002 :: GLbitfield

pattern GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B :: GLenum

pattern GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = 0x8B8B :: GLenum

pattern GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES = 0x8B8B :: GLenum

pattern GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT = 0x8A52 :: GLenum

pattern GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM = 0x8F66 :: GLenum

pattern GL_FRAGMENT_SHADER_INVOCATIONS_ARB = 0x82F4 :: GLenum

pattern GL_FRAGMENT_SUBROUTINE = 0x92EC :: GLenum

pattern GL_FRAGMENT_SUBROUTINE_UNIFORM = 0x92F2 :: GLenum

pattern GL_FRAGMENT_TEXTURE = 0x829F :: GLenum

pattern GL_FRAMEBUFFER = 0x8D40 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_ANGLE = 0x93A3 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT = 0x8210 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT = 0x8211 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 0x8DA7 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = 0x8DA7 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT = 0x8DA7 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_LAYERED_OES = 0x8DA7 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = 0x8CD1 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES = 0x8CD1 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = 0x8CD0 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES = 0x8CD0 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = 0x8CD4 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES = 0x8CD4 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR = 0x9632 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = 0x8CD3 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES = 0x8CD3 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT = 0x8CD4 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = 0x8CD2 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES = 0x8CD2 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR = 0x9630 :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT = 0x8D6C :: GLenum

pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SCALE_IMG = 0x913F :: GLenum

pattern GL_FRAMEBUFFER_BARRIER_BIT = 0x00000400 :: GLbitfield

pattern GL_FRAMEBUFFER_BARRIER_BIT_EXT = 0x00000400 :: GLbitfield

pattern GL_FRAMEBUFFER_BINDING = 0x8CA6 :: GLenum

pattern GL_FRAMEBUFFER_BINDING_ANGLE = 0x8CA6 :: GLenum

pattern GL_FRAMEBUFFER_BINDING_EXT = 0x8CA6 :: GLenum

pattern GL_FRAMEBUFFER_BINDING_OES = 0x8CA6 :: GLenum

pattern GL_FRAMEBUFFER_BLEND = 0x828B :: GLenum

pattern GL_FRAMEBUFFER_COMPLETE = 0x8CD5 :: GLenum

pattern GL_FRAMEBUFFER_COMPLETE_EXT = 0x8CD5 :: GLenum

pattern GL_FRAMEBUFFER_COMPLETE_OES = 0x8CD5 :: GLenum

pattern GL_FRAMEBUFFER_DEFAULT = 0x8218 :: GLenum

pattern GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 0x9314 :: GLenum

pattern GL_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311 :: GLenum

pattern GL_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312 :: GLenum

pattern GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT = 0x9312 :: GLenum

pattern GL_FRAMEBUFFER_DEFAULT_LAYERS_OES = 0x9312 :: GLenum

pattern GL_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313 :: GLenum

pattern GL_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310 :: GLenum

pattern GL_FRAMEBUFFER_EXT = 0x8D40 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = 0x8CD6 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES = 0x8CD6 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 0x8CD9 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = 0x8CD9 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES = 0x8CD9 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = 0x8CDB :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_OES = 0x8CDB :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = 0x8CDA :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES = 0x8CDA :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_INSUFFICIENT_SHADER_COMBINED_LOCAL_STORAGE_EXT = 0x9652 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = 0x8DA9 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT = 0x8DA9 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 0x8DA8 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB = 0x8DA8 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT = 0x8DA8 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES = 0x8DA8 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = 0x8CD7 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES = 0x8CD7 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_AND_DOWNSAMPLE_IMG = 0x913C :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE = 0x8D56 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE = 0x8D56 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT = 0x8D56 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG = 0x9134 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV = 0x8D56 :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = 0x8CDC :: GLenum

pattern GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_OES = 0x8CDC :: GLenum

pattern GL_FRAMEBUFFER_OES = 0x8D40 :: GLenum

pattern GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB = 0x9342 :: GLenum

pattern GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV = 0x9342 :: GLenum

pattern GL_FRAMEBUFFER_RENDERABLE = 0x8289 :: GLenum

pattern GL_FRAMEBUFFER_RENDERABLE_LAYERED = 0x828A :: GLenum

pattern GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB = 0x9343 :: GLenum

pattern GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV = 0x9343 :: GLenum

pattern GL_FRAMEBUFFER_SRGB = 0x8DB9 :: GLenum

pattern GL_FRAMEBUFFER_SRGB_CAPABLE_EXT = 0x8DBA :: GLenum

pattern GL_FRAMEBUFFER_SRGB_EXT = 0x8DB9 :: GLenum

pattern GL_FRAMEBUFFER_UNDEFINED = 0x8219 :: GLenum

pattern GL_FRAMEBUFFER_UNDEFINED_OES = 0x8219 :: GLenum

pattern GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD :: GLenum

pattern GL_FRAMEBUFFER_UNSUPPORTED_EXT = 0x8CDD :: GLenum

pattern GL_FRAMEBUFFER_UNSUPPORTED_OES = 0x8CDD :: GLenum

pattern GL_FRAMEZOOM_FACTOR_SGIX = 0x818C :: GLenum

pattern GL_FRAMEZOOM_SGIX = 0x818B :: GLenum

pattern GL_FRAME_NV = 0x8E26 :: GLenum

pattern GL_FRONT = 0x0404 :: GLenum

pattern GL_FRONT_AND_BACK = 0x0408 :: GLenum

pattern GL_FRONT_FACE = 0x0B46 :: GLenum

pattern GL_FRONT_FACE_COMMAND_NV = 0x0012 :: GLenum

pattern GL_FRONT_LEFT = 0x0400 :: GLenum

pattern GL_FRONT_RIGHT = 0x0401 :: GLenum

pattern GL_FULL_RANGE_EXT = 0x87E1 :: GLenum

pattern GL_FULL_STIPPLE_HINT_PGI = 0x1A219 :: GLenum

pattern GL_FULL_SUPPORT = 0x82B7 :: GLenum

pattern GL_FUNC_ADD = 0x8006 :: GLenum

pattern GL_FUNC_ADD_EXT = 0x8006 :: GLenum

pattern GL_FUNC_ADD_OES = 0x8006 :: GLenum

pattern GL_FUNC_REVERSE_SUBTRACT = 0x800B :: GLenum

pattern GL_FUNC_REVERSE_SUBTRACT_EXT = 0x800B :: GLenum

pattern GL_FUNC_REVERSE_SUBTRACT_OES = 0x800B :: GLenum

pattern GL_FUNC_SUBTRACT = 0x800A :: GLenum

pattern GL_FUNC_SUBTRACT_EXT = 0x800A :: GLenum

pattern GL_FUNC_SUBTRACT_OES = 0x800A :: GLenum

pattern GL_GCCSO_SHADER_BINARY_FJ = 0x9260 :: GLenum

pattern GL_GENERATE_MIPMAP = 0x8191 :: GLenum

pattern GL_GENERATE_MIPMAP_HINT = 0x8192 :: GLenum

pattern GL_GENERATE_MIPMAP_HINT_SGIS = 0x8192 :: GLenum

pattern GL_GENERATE_MIPMAP_SGIS = 0x8191 :: GLenum

pattern GL_GENERIC_ATTRIB_NV = 0x8C7D :: GLenum

pattern GL_GEOMETRY_DEFORMATION_BIT_SGIX = 0x00000002 :: GLbitfield

pattern GL_GEOMETRY_DEFORMATION_SGIX = 0x8194 :: GLenum

pattern GL_GEOMETRY_INPUT_TYPE = 0x8917 :: GLenum

pattern GL_GEOMETRY_INPUT_TYPE_ARB = 0x8DDB :: GLenum

pattern GL_GEOMETRY_INPUT_TYPE_EXT = 0x8DDB :: GLenum

pattern GL_GEOMETRY_LINKED_INPUT_TYPE_EXT = 0x8917 :: GLenum

pattern GL_GEOMETRY_LINKED_INPUT_TYPE_OES = 0x8917 :: GLenum

pattern GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT = 0x8918 :: GLenum

pattern GL_GEOMETRY_LINKED_OUTPUT_TYPE_OES = 0x8918 :: GLenum

pattern GL_GEOMETRY_LINKED_VERTICES_OUT_EXT = 0x8916 :: GLenum

pattern GL_GEOMETRY_LINKED_VERTICES_OUT_OES = 0x8916 :: GLenum

pattern GL_GEOMETRY_OUTPUT_TYPE = 0x8918 :: GLenum

pattern GL_GEOMETRY_OUTPUT_TYPE_ARB = 0x8DDC :: GLenum

pattern GL_GEOMETRY_OUTPUT_TYPE_EXT = 0x8DDC :: GLenum

pattern GL_GEOMETRY_PROGRAM_NV = 0x8C26 :: GLenum

pattern GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA3 :: GLenum

pattern GL_GEOMETRY_SHADER = 0x8DD9 :: GLenum

pattern GL_GEOMETRY_SHADER_ARB = 0x8DD9 :: GLenum

pattern GL_GEOMETRY_SHADER_BIT = 0x00000004 :: GLbitfield

pattern GL_GEOMETRY_SHADER_BIT_EXT = 0x00000004 :: GLbitfield

pattern GL_GEOMETRY_SHADER_BIT_OES = 0x00000004 :: GLbitfield

pattern GL_GEOMETRY_SHADER_EXT = 0x8DD9 :: GLenum

pattern GL_GEOMETRY_SHADER_INVOCATIONS = 0x887F :: GLenum

pattern GL_GEOMETRY_SHADER_INVOCATIONS_EXT = 0x887F :: GLenum

pattern GL_GEOMETRY_SHADER_INVOCATIONS_OES = 0x887F :: GLenum

pattern GL_GEOMETRY_SHADER_OES = 0x8DD9 :: GLenum

pattern GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB = 0x82F3 :: GLenum

pattern GL_GEOMETRY_SUBROUTINE = 0x92EB :: GLenum

pattern GL_GEOMETRY_SUBROUTINE_UNIFORM = 0x92F1 :: GLenum

pattern GL_GEOMETRY_TEXTURE = 0x829E :: GLenum

pattern GL_GEOMETRY_VERTICES_OUT = 0x8916 :: GLenum

pattern GL_GEOMETRY_VERTICES_OUT_ARB = 0x8DDA :: GLenum

pattern GL_GEOMETRY_VERTICES_OUT_EXT = 0x8DDA :: GLenum

pattern GL_GEQUAL = 0x0206 :: GLenum

pattern GL_GET_TEXTURE_IMAGE_FORMAT = 0x8291 :: GLenum

pattern GL_GET_TEXTURE_IMAGE_TYPE = 0x8292 :: GLenum

pattern GL_GLOBAL_ALPHA_FACTOR_SUN = 0x81DA :: GLenum

pattern GL_GLOBAL_ALPHA_SUN = 0x81D9 :: GLenum

pattern GL_GLYPH_HAS_KERNING_BIT_NV = 0x100 :: GLbitfield

pattern GL_GLYPH_HEIGHT_BIT_NV = 0x02 :: GLbitfield

pattern GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = 0x10 :: GLbitfield

pattern GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = 0x04 :: GLbitfield

pattern GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = 0x08 :: GLbitfield

pattern GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = 0x80 :: GLbitfield

pattern GL_GLYPH_VERTICAL_BEARING_X_BIT_NV = 0x20 :: GLbitfield

pattern GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV = 0x40 :: GLbitfield

pattern GL_GLYPH_WIDTH_BIT_NV = 0x01 :: GLbitfield

pattern GL_GPU_ADDRESS_NV = 0x8F34 :: GLenum

pattern GL_GPU_DISJOINT_EXT = 0x8FBB :: GLenum

pattern GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX = 0x9049 :: GLenum

pattern GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX = 0x9047 :: GLenum

pattern GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX = 0x904B :: GLenum

pattern GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX = 0x904A :: GLenum

pattern GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX = 0x9048 :: GLenum

pattern GL_GPU_OPTIMIZED_QCOM = 0x8FB2 :: GLenum

pattern GL_GREATER = 0x0204 :: GLenum

pattern GL_GREEN = 0x1904 :: GLenum

pattern GL_GREEN_BIAS = 0x0D19 :: GLenum

pattern GL_GREEN_BITS = 0x0D53 :: GLenum

pattern GL_GREEN_BIT_ATI = 0x00000002 :: GLbitfield

pattern GL_GREEN_INTEGER = 0x8D95 :: GLenum

pattern GL_GREEN_INTEGER_EXT = 0x8D95 :: GLenum

pattern GL_GREEN_MAX_CLAMP_INGR = 0x8565 :: GLenum

pattern GL_GREEN_MIN_CLAMP_INGR = 0x8561 :: GLenum

pattern GL_GREEN_NV = 0x1904 :: GLenum

pattern GL_GREEN_SCALE = 0x0D18 :: GLenum

pattern GL_GS_PROGRAM_BINARY_MTK = 0x9641 :: GLenum

pattern GL_GS_SHADER_BINARY_MTK = 0x9640 :: GLenum

pattern GL_GUILTY_CONTEXT_RESET = 0x8253 :: GLenum

pattern GL_GUILTY_CONTEXT_RESET_ARB = 0x8253 :: GLenum

pattern GL_GUILTY_CONTEXT_RESET_EXT = 0x8253 :: GLenum

pattern GL_GUILTY_CONTEXT_RESET_KHR = 0x8253 :: GLenum

pattern GL_HALF_APPLE = 0x140B :: GLenum

pattern GL_HALF_BIAS_NEGATE_NV = 0x853B :: GLenum

pattern GL_HALF_BIAS_NORMAL_NV = 0x853A :: GLenum

pattern GL_HALF_BIT_ATI = 0x00000008 :: GLbitfield

pattern GL_HALF_FLOAT = 0x140B :: GLenum

pattern GL_HALF_FLOAT_ARB = 0x140B :: GLenum

pattern GL_HALF_FLOAT_NV = 0x140B :: GLenum

pattern GL_HALF_FLOAT_OES = 0x8D61 :: GLenum

pattern GL_HARDLIGHT = 0x929B :: GLenum

pattern GL_HARDLIGHT_KHR = 0x929B :: GLenum

pattern GL_HARDLIGHT_NV = 0x929B :: GLenum

pattern GL_HARDMIX_NV = 0x92A9 :: GLenum

pattern GL_HIGH_FLOAT = 0x8DF2 :: GLenum

pattern GL_HIGH_INT = 0x8DF5 :: GLenum

pattern GL_HILO16_NV = 0x86F8 :: GLenum

pattern GL_HILO8_NV = 0x885E :: GLenum

pattern GL_HILO_NV = 0x86F4 :: GLenum

pattern GL_HINT_BIT = 0x00008000 :: GLbitfield

pattern GL_HISTOGRAM = 0x8024 :: GLenum

pattern GL_HISTOGRAM_ALPHA_SIZE = 0x802B :: GLenum

pattern GL_HISTOGRAM_ALPHA_SIZE_EXT = 0x802B :: GLenum

pattern GL_HISTOGRAM_BLUE_SIZE = 0x802A :: GLenum

pattern GL_HISTOGRAM_BLUE_SIZE_EXT = 0x802A :: GLenum

pattern GL_HISTOGRAM_EXT = 0x8024 :: GLenum

pattern GL_HISTOGRAM_FORMAT = 0x8027 :: GLenum

pattern GL_HISTOGRAM_FORMAT_EXT = 0x8027 :: GLenum

pattern GL_HISTOGRAM_GREEN_SIZE = 0x8029 :: GLenum

pattern GL_HISTOGRAM_GREEN_SIZE_EXT = 0x8029 :: GLenum

pattern GL_HISTOGRAM_LUMINANCE_SIZE = 0x802C :: GLenum

pattern GL_HISTOGRAM_LUMINANCE_SIZE_EXT = 0x802C :: GLenum

pattern GL_HISTOGRAM_RED_SIZE = 0x8028 :: GLenum

pattern GL_HISTOGRAM_RED_SIZE_EXT = 0x8028 :: GLenum

pattern GL_HISTOGRAM_SINK = 0x802D :: GLenum

pattern GL_HISTOGRAM_SINK_EXT = 0x802D :: GLenum

pattern GL_HISTOGRAM_WIDTH = 0x8026 :: GLenum

pattern GL_HISTOGRAM_WIDTH_EXT = 0x8026 :: GLenum

pattern GL_HI_BIAS_NV = 0x8714 :: GLenum

pattern GL_HI_SCALE_NV = 0x870E :: GLenum

pattern GL_HORIZONTAL_LINE_TO_NV = 0x06 :: GLubyte

pattern GL_HSL_COLOR = 0x92AF :: GLenum

pattern GL_HSL_COLOR_KHR = 0x92AF :: GLenum

pattern GL_HSL_COLOR_NV = 0x92AF :: GLenum

pattern GL_HSL_HUE = 0x92AD :: GLenum

pattern GL_HSL_HUE_KHR = 0x92AD :: GLenum

pattern GL_HSL_HUE_NV = 0x92AD :: GLenum

pattern GL_HSL_LUMINOSITY = 0x92B0 :: GLenum

pattern GL_HSL_LUMINOSITY_KHR = 0x92B0 :: GLenum

pattern GL_HSL_LUMINOSITY_NV = 0x92B0 :: GLenum

pattern GL_HSL_SATURATION = 0x92AE :: GLenum

pattern GL_HSL_SATURATION_KHR = 0x92AE :: GLenum

pattern GL_HSL_SATURATION_NV = 0x92AE :: GLenum

pattern GL_IDENTITY_NV = 0x862A :: GLenum

pattern GL_IGNORE_BORDER_HP = 0x8150 :: GLenum

pattern GL_IMAGE_1D = 0x904C :: GLenum

pattern GL_IMAGE_1D_ARRAY = 0x9052 :: GLenum

pattern GL_IMAGE_1D_ARRAY_EXT = 0x9052 :: GLenum

pattern GL_IMAGE_1D_EXT = 0x904C :: GLenum

pattern GL_IMAGE_2D = 0x904D :: GLenum

pattern GL_IMAGE_2D_ARRAY = 0x9053 :: GLenum

pattern GL_IMAGE_2D_ARRAY_EXT = 0x9053 :: GLenum

pattern GL_IMAGE_2D_EXT = 0x904D :: GLenum

pattern GL_IMAGE_2D_MULTISAMPLE = 0x9055 :: GLenum

pattern GL_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056 :: GLenum

pattern GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x9056 :: GLenum

pattern GL_IMAGE_2D_MULTISAMPLE_EXT = 0x9055 :: GLenum

pattern GL_IMAGE_2D_RECT = 0x904F :: GLenum

pattern GL_IMAGE_2D_RECT_EXT = 0x904F :: GLenum

pattern GL_IMAGE_3D = 0x904E :: GLenum

pattern GL_IMAGE_3D_EXT = 0x904E :: GLenum

pattern GL_IMAGE_BINDING_ACCESS = 0x8F3E :: GLenum

pattern GL_IMAGE_BINDING_ACCESS_EXT = 0x8F3E :: GLenum

pattern GL_IMAGE_BINDING_FORMAT = 0x906E :: GLenum

pattern GL_IMAGE_BINDING_FORMAT_EXT = 0x906E :: GLenum

pattern GL_IMAGE_BINDING_LAYER = 0x8F3D :: GLenum

pattern GL_IMAGE_BINDING_LAYERED = 0x8F3C :: GLenum

pattern GL_IMAGE_BINDING_LAYERED_EXT = 0x8F3C :: GLenum

pattern GL_IMAGE_BINDING_LAYER_EXT = 0x8F3D :: GLenum

pattern GL_IMAGE_BINDING_LEVEL = 0x8F3B :: GLenum

pattern GL_IMAGE_BINDING_LEVEL_EXT = 0x8F3B :: GLenum

pattern GL_IMAGE_BINDING_NAME = 0x8F3A :: GLenum

pattern GL_IMAGE_BINDING_NAME_EXT = 0x8F3A :: GLenum

pattern GL_IMAGE_BUFFER = 0x9051 :: GLenum

pattern GL_IMAGE_BUFFER_EXT = 0x9051 :: GLenum

pattern GL_IMAGE_BUFFER_OES = 0x9051 :: GLenum

pattern GL_IMAGE_CLASS_10_10_10_2 = 0x82C3 :: GLenum

pattern GL_IMAGE_CLASS_11_11_10 = 0x82C2 :: GLenum

pattern GL_IMAGE_CLASS_1_X_16 = 0x82BE :: GLenum

pattern GL_IMAGE_CLASS_1_X_32 = 0x82BB :: GLenum

pattern GL_IMAGE_CLASS_1_X_8 = 0x82C1 :: GLenum

pattern GL_IMAGE_CLASS_2_X_16 = 0x82BD :: GLenum

pattern GL_IMAGE_CLASS_2_X_32 = 0x82BA :: GLenum

pattern GL_IMAGE_CLASS_2_X_8 = 0x82C0 :: GLenum

pattern GL_IMAGE_CLASS_4_X_16 = 0x82BC :: GLenum

pattern GL_IMAGE_CLASS_4_X_32 = 0x82B9 :: GLenum

pattern GL_IMAGE_CLASS_4_X_8 = 0x82BF :: GLenum

pattern GL_IMAGE_COMPATIBILITY_CLASS = 0x82A8 :: GLenum

pattern GL_IMAGE_CUBE = 0x9050 :: GLenum

pattern GL_IMAGE_CUBE_EXT = 0x9050 :: GLenum

pattern GL_IMAGE_CUBE_MAP_ARRAY = 0x9054 :: GLenum

pattern GL_IMAGE_CUBE_MAP_ARRAY_EXT = 0x9054 :: GLenum

pattern GL_IMAGE_CUBE_MAP_ARRAY_OES = 0x9054 :: GLenum

pattern GL_IMAGE_CUBIC_WEIGHT_HP = 0x815E :: GLenum

pattern GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 0x90C9 :: GLenum

pattern GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 0x90C8 :: GLenum

pattern GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7 :: GLenum

pattern GL_IMAGE_MAG_FILTER_HP = 0x815C :: GLenum

pattern GL_IMAGE_MIN_FILTER_HP = 0x815D :: GLenum

pattern GL_IMAGE_PIXEL_FORMAT = 0x82A9 :: GLenum

pattern GL_IMAGE_PIXEL_TYPE = 0x82AA :: GLenum

pattern GL_IMAGE_ROTATE_ANGLE_HP = 0x8159 :: GLenum

pattern GL_IMAGE_ROTATE_ORIGIN_X_HP = 0x815A :: GLenum

pattern GL_IMAGE_ROTATE_ORIGIN_Y_HP = 0x815B :: GLenum

pattern GL_IMAGE_SCALE_X_HP = 0x8155 :: GLenum

pattern GL_IMAGE_SCALE_Y_HP = 0x8156 :: GLenum

pattern GL_IMAGE_TEXEL_SIZE = 0x82A7 :: GLenum

pattern GL_IMAGE_TRANSFORM_2D_HP = 0x8161 :: GLenum

pattern GL_IMAGE_TRANSLATE_X_HP = 0x8157 :: GLenum

pattern GL_IMAGE_TRANSLATE_Y_HP = 0x8158 :: GLenum

pattern GL_IMPLEMENTATION_COLOR_READ_FORMAT = 0x8B9B :: GLenum

pattern GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES = 0x8B9B :: GLenum

pattern GL_IMPLEMENTATION_COLOR_READ_TYPE = 0x8B9A :: GLenum

pattern GL_IMPLEMENTATION_COLOR_READ_TYPE_OES = 0x8B9A :: GLenum

pattern GL_INCLUSIVE_EXT = 0x8F10 :: GLenum

pattern GL_INCR = 0x1E02 :: GLenum

pattern GL_INCR_WRAP = 0x8507 :: GLenum

pattern GL_INCR_WRAP_EXT = 0x8507 :: GLenum

pattern GL_INCR_WRAP_OES = 0x8507 :: GLenum

pattern GL_INDEX = 0x8222 :: GLenum

pattern GL_INDEX_ARRAY = 0x8077 :: GLenum

pattern GL_INDEX_ARRAY_ADDRESS_NV = 0x8F24 :: GLenum

pattern GL_INDEX_ARRAY_BUFFER_BINDING = 0x8899 :: GLenum

pattern GL_INDEX_ARRAY_BUFFER_BINDING_ARB = 0x8899 :: GLenum

pattern GL_INDEX_ARRAY_COUNT_EXT = 0x8087 :: GLenum

pattern GL_INDEX_ARRAY_EXT = 0x8077 :: GLenum

pattern GL_INDEX_ARRAY_LENGTH_NV = 0x8F2E :: GLenum

pattern GL_INDEX_ARRAY_LIST_IBM = 103073 :: GLenum

pattern GL_INDEX_ARRAY_LIST_STRIDE_IBM = 103083 :: GLenum

pattern GL_INDEX_ARRAY_POINTER = 0x8091 :: GLenum

pattern GL_INDEX_ARRAY_POINTER_EXT = 0x8091 :: GLenum

pattern GL_INDEX_ARRAY_STRIDE = 0x8086 :: GLenum

pattern GL_INDEX_ARRAY_STRIDE_EXT = 0x8086 :: GLenum

pattern GL_INDEX_ARRAY_TYPE = 0x8085 :: GLenum

pattern GL_INDEX_ARRAY_TYPE_EXT = 0x8085 :: GLenum

pattern GL_INDEX_BITS = 0x0D51 :: GLenum

pattern GL_INDEX_BIT_PGI = 0x00080000 :: GLbitfield

pattern GL_INDEX_CLEAR_VALUE = 0x0C20 :: GLenum

pattern GL_INDEX_LOGIC_OP = 0x0BF1 :: GLenum

pattern GL_INDEX_MATERIAL_EXT = 0x81B8 :: GLenum

pattern GL_INDEX_MATERIAL_FACE_EXT = 0x81BA :: GLenum

pattern GL_INDEX_MATERIAL_PARAMETER_EXT = 0x81B9 :: GLenum

pattern GL_INDEX_MODE = 0x0C30 :: GLenum

pattern GL_INDEX_OFFSET = 0x0D13 :: GLenum

pattern GL_INDEX_SHIFT = 0x0D12 :: GLenum

pattern GL_INDEX_TEST_EXT = 0x81B5 :: GLenum

pattern GL_INDEX_TEST_FUNC_EXT = 0x81B6 :: GLenum

pattern GL_INDEX_TEST_REF_EXT = 0x81B7 :: GLenum

pattern GL_INDEX_WRITEMASK = 0x0C21 :: GLenum

pattern GL_INFO_LOG_LENGTH = 0x8B84 :: GLenum

pattern GL_INNOCENT_CONTEXT_RESET = 0x8254 :: GLenum

pattern GL_INNOCENT_CONTEXT_RESET_ARB = 0x8254 :: GLenum

pattern GL_INNOCENT_CONTEXT_RESET_EXT = 0x8254 :: GLenum

pattern GL_INNOCENT_CONTEXT_RESET_KHR = 0x8254 :: GLenum

pattern GL_INSTRUMENT_BUFFER_POINTER_SGIX = 0x8180 :: GLenum

pattern GL_INSTRUMENT_MEASUREMENTS_SGIX = 0x8181 :: GLenum

pattern GL_INT = 0x1404 :: GLenum

pattern GL_INT16_NV = 0x8FE4 :: GLenum

pattern GL_INT16_VEC2_NV = 0x8FE5 :: GLenum

pattern GL_INT16_VEC3_NV = 0x8FE6 :: GLenum

pattern GL_INT16_VEC4_NV = 0x8FE7 :: GLenum

pattern GL_INT64_ARB = 0x140E :: GLenum

pattern GL_INT64_NV = 0x140E :: GLenum

pattern GL_INT64_VEC2_ARB = 0x8FE9 :: GLenum

pattern GL_INT64_VEC2_NV = 0x8FE9 :: GLenum

pattern GL_INT64_VEC3_ARB = 0x8FEA :: GLenum

pattern GL_INT64_VEC3_NV = 0x8FEA :: GLenum

pattern GL_INT64_VEC4_ARB = 0x8FEB :: GLenum

pattern GL_INT64_VEC4_NV = 0x8FEB :: GLenum

pattern GL_INT8_NV = 0x8FE0 :: GLenum

pattern GL_INT8_VEC2_NV = 0x8FE1 :: GLenum

pattern GL_INT8_VEC3_NV = 0x8FE2 :: GLenum

pattern GL_INT8_VEC4_NV = 0x8FE3 :: GLenum

pattern GL_INTENSITY = 0x8049 :: GLenum

pattern GL_INTENSITY12 = 0x804C :: GLenum

pattern GL_INTENSITY12_EXT = 0x804C :: GLenum

pattern GL_INTENSITY16 = 0x804D :: GLenum

pattern GL_INTENSITY16F_ARB = 0x881D :: GLenum

pattern GL_INTENSITY16I_EXT = 0x8D8B :: GLenum

pattern GL_INTENSITY16UI_EXT = 0x8D79 :: GLenum

pattern GL_INTENSITY16_EXT = 0x804D :: GLenum

pattern GL_INTENSITY16_SNORM = 0x901B :: GLenum

pattern GL_INTENSITY32F_ARB = 0x8817 :: GLenum

pattern GL_INTENSITY32I_EXT = 0x8D85 :: GLenum

pattern GL_INTENSITY32UI_EXT = 0x8D73 :: GLenum

pattern GL_INTENSITY4 = 0x804A :: GLenum

pattern GL_INTENSITY4_EXT = 0x804A :: GLenum

pattern GL_INTENSITY8 = 0x804B :: GLenum

pattern GL_INTENSITY8I_EXT = 0x8D91 :: GLenum

pattern GL_INTENSITY8UI_EXT = 0x8D7F :: GLenum

pattern GL_INTENSITY8_EXT = 0x804B :: GLenum

pattern GL_INTENSITY8_SNORM = 0x9017 :: GLenum

pattern GL_INTENSITY_EXT = 0x8049 :: GLenum

pattern GL_INTENSITY_FLOAT16_APPLE = 0x881D :: GLenum

pattern GL_INTENSITY_FLOAT16_ATI = 0x881D :: GLenum

pattern GL_INTENSITY_FLOAT32_APPLE = 0x8817 :: GLenum

pattern GL_INTENSITY_FLOAT32_ATI = 0x8817 :: GLenum

pattern GL_INTENSITY_SNORM = 0x9013 :: GLenum

pattern GL_INTERLACE_OML = 0x8980 :: GLenum

pattern GL_INTERLACE_READ_INGR = 0x8568 :: GLenum

pattern GL_INTERLACE_READ_OML = 0x8981 :: GLenum

pattern GL_INTERLACE_SGIX = 0x8094 :: GLenum

pattern GL_INTERLEAVED_ATTRIBS = 0x8C8C :: GLenum

pattern GL_INTERLEAVED_ATTRIBS_EXT = 0x8C8C :: GLenum

pattern GL_INTERLEAVED_ATTRIBS_NV = 0x8C8C :: GLenum

pattern GL_INTERNALFORMAT_ALPHA_SIZE = 0x8274 :: GLenum

pattern GL_INTERNALFORMAT_ALPHA_TYPE = 0x827B :: GLenum

pattern GL_INTERNALFORMAT_BLUE_SIZE = 0x8273 :: GLenum

pattern GL_INTERNALFORMAT_BLUE_TYPE = 0x827A :: GLenum

pattern GL_INTERNALFORMAT_DEPTH_SIZE = 0x8275 :: GLenum

pattern GL_INTERNALFORMAT_DEPTH_TYPE = 0x827C :: GLenum

pattern GL_INTERNALFORMAT_GREEN_SIZE = 0x8272 :: GLenum

pattern GL_INTERNALFORMAT_GREEN_TYPE = 0x8279 :: GLenum

pattern GL_INTERNALFORMAT_PREFERRED = 0x8270 :: GLenum

pattern GL_INTERNALFORMAT_RED_SIZE = 0x8271 :: GLenum

pattern GL_INTERNALFORMAT_RED_TYPE = 0x8278 :: GLenum

pattern GL_INTERNALFORMAT_SHARED_SIZE = 0x8277 :: GLenum

pattern GL_INTERNALFORMAT_STENCIL_SIZE = 0x8276 :: GLenum

pattern GL_INTERNALFORMAT_STENCIL_TYPE = 0x827D :: GLenum

pattern GL_INTERNALFORMAT_SUPPORTED = 0x826F :: GLenum

pattern GL_INTERPOLATE = 0x8575 :: GLenum

pattern GL_INTERPOLATE_ARB = 0x8575 :: GLenum

pattern GL_INTERPOLATE_EXT = 0x8575 :: GLenum

pattern GL_INT_10_10_10_2_OES = 0x8DF7 :: GLenum

pattern GL_INT_2_10_10_10_REV = 0x8D9F :: GLenum

pattern GL_INT_IMAGE_1D = 0x9057 :: GLenum

pattern GL_INT_IMAGE_1D_ARRAY = 0x905D :: GLenum

pattern GL_INT_IMAGE_1D_ARRAY_EXT = 0x905D :: GLenum

pattern GL_INT_IMAGE_1D_EXT = 0x9057 :: GLenum

pattern GL_INT_IMAGE_2D = 0x9058 :: GLenum

pattern GL_INT_IMAGE_2D_ARRAY = 0x905E :: GLenum

pattern GL_INT_IMAGE_2D_ARRAY_EXT = 0x905E :: GLenum

pattern GL_INT_IMAGE_2D_EXT = 0x9058 :: GLenum

pattern GL_INT_IMAGE_2D_MULTISAMPLE = 0x9060 :: GLenum

pattern GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061 :: GLenum

pattern GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x9061 :: GLenum

pattern GL_INT_IMAGE_2D_MULTISAMPLE_EXT = 0x9060 :: GLenum

pattern GL_INT_IMAGE_2D_RECT = 0x905A :: GLenum

pattern GL_INT_IMAGE_2D_RECT_EXT = 0x905A :: GLenum

pattern GL_INT_IMAGE_3D = 0x9059 :: GLenum

pattern GL_INT_IMAGE_3D_EXT = 0x9059 :: GLenum

pattern GL_INT_IMAGE_BUFFER = 0x905C :: GLenum

pattern GL_INT_IMAGE_BUFFER_EXT = 0x905C :: GLenum

pattern GL_INT_IMAGE_BUFFER_OES = 0x905C :: GLenum

pattern GL_INT_IMAGE_CUBE = 0x905B :: GLenum

pattern GL_INT_IMAGE_CUBE_EXT = 0x905B :: GLenum

pattern GL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F :: GLenum

pattern GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT = 0x905F :: GLenum

pattern GL_INT_IMAGE_CUBE_MAP_ARRAY_OES = 0x905F :: GLenum

pattern GL_INT_SAMPLER_1D = 0x8DC9 :: GLenum

pattern GL_INT_SAMPLER_1D_ARRAY = 0x8DCE :: GLenum

pattern GL_INT_SAMPLER_1D_ARRAY_EXT = 0x8DCE :: GLenum

pattern GL_INT_SAMPLER_1D_EXT = 0x8DC9 :: GLenum

pattern GL_INT_SAMPLER_2D = 0x8DCA :: GLenum

pattern GL_INT_SAMPLER_2D_ARRAY = 0x8DCF :: GLenum

pattern GL_INT_SAMPLER_2D_ARRAY_EXT = 0x8DCF :: GLenum

pattern GL_INT_SAMPLER_2D_EXT = 0x8DCA :: GLenum

pattern GL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109 :: GLenum

pattern GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C :: GLenum

pattern GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910C :: GLenum

pattern GL_INT_SAMPLER_2D_RECT = 0x8DCD :: GLenum

pattern GL_INT_SAMPLER_2D_RECT_EXT = 0x8DCD :: GLenum

pattern GL_INT_SAMPLER_3D = 0x8DCB :: GLenum

pattern GL_INT_SAMPLER_3D_EXT = 0x8DCB :: GLenum

pattern GL_INT_SAMPLER_BUFFER = 0x8DD0 :: GLenum

pattern GL_INT_SAMPLER_BUFFER_AMD = 0x9002 :: GLenum

pattern GL_INT_SAMPLER_BUFFER_EXT = 0x8DD0 :: GLenum

pattern GL_INT_SAMPLER_BUFFER_OES = 0x8DD0 :: GLenum

pattern GL_INT_SAMPLER_CUBE = 0x8DCC :: GLenum

pattern GL_INT_SAMPLER_CUBE_EXT = 0x8DCC :: GLenum

pattern GL_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E :: GLenum

pattern GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900E :: GLenum

pattern GL_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900E :: GLenum

pattern GL_INT_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900E :: GLenum

pattern GL_INT_SAMPLER_RENDERBUFFER_NV = 0x8E57 :: GLenum

pattern GL_INT_VEC2 = 0x8B53 :: GLenum

pattern GL_INT_VEC2_ARB = 0x8B53 :: GLenum

pattern GL_INT_VEC3 = 0x8B54 :: GLenum

pattern GL_INT_VEC3_ARB = 0x8B54 :: GLenum

pattern GL_INT_VEC4 = 0x8B55 :: GLenum

pattern GL_INT_VEC4_ARB = 0x8B55 :: GLenum

pattern GL_INVALID_ENUM = 0x0500 :: GLenum

pattern GL_INVALID_FRAMEBUFFER_OPERATION = 0x0506 :: GLenum

pattern GL_INVALID_FRAMEBUFFER_OPERATION_EXT = 0x0506 :: GLenum

pattern GL_INVALID_FRAMEBUFFER_OPERATION_OES = 0x0506 :: GLenum

pattern GL_INVALID_INDEX = 0xFFFFFFFF :: GLuint

pattern GL_INVALID_OPERATION = 0x0502 :: GLenum

pattern GL_INVALID_VALUE = 0x0501 :: GLenum

pattern GL_INVARIANT_DATATYPE_EXT = 0x87EB :: GLenum

pattern GL_INVARIANT_EXT = 0x87C2 :: GLenum

pattern GL_INVARIANT_VALUE_EXT = 0x87EA :: GLenum

pattern GL_INVERSE_NV = 0x862B :: GLenum

pattern GL_INVERSE_TRANSPOSE_NV = 0x862D :: GLenum

pattern GL_INVERT = 0x150A :: GLenum

pattern GL_INVERTED_SCREEN_W_REND = 0x8491 :: GLenum

pattern GL_INVERT_OVG_NV = 0x92B4 :: GLenum

pattern GL_INVERT_RGB_NV = 0x92A3 :: GLenum

pattern GL_IR_INSTRUMENT1_SGIX = 0x817F :: GLenum

pattern GL_ISOLINES = 0x8E7A :: GLenum

pattern GL_ISOLINES_EXT = 0x8E7A :: GLenum

pattern GL_ISOLINES_OES = 0x8E7A :: GLenum

pattern GL_IS_PER_PATCH = 0x92E7 :: GLenum

pattern GL_IS_PER_PATCH_EXT = 0x92E7 :: GLenum

pattern GL_IS_PER_PATCH_OES = 0x92E7 :: GLenum

pattern GL_IS_ROW_MAJOR = 0x9300 :: GLenum

pattern GL_ITALIC_BIT_NV = 0x02 :: GLbitfield

pattern GL_IUI_N3F_V2F_EXT = 0x81AF :: GLenum

pattern GL_IUI_N3F_V3F_EXT = 0x81B0 :: GLenum

pattern GL_IUI_V2F_EXT = 0x81AD :: GLenum

pattern GL_IUI_V3F_EXT = 0x81AE :: GLenum

pattern GL_KEEP = 0x1E00 :: GLenum

pattern GL_LARGE_CCW_ARC_TO_NV = 0x16 :: GLubyte

pattern GL_LARGE_CW_ARC_TO_NV = 0x18 :: GLubyte

pattern GL_LAST_VERTEX_CONVENTION = 0x8E4E :: GLenum

pattern GL_LAST_VERTEX_CONVENTION_EXT = 0x8E4E :: GLenum

pattern GL_LAST_VERTEX_CONVENTION_OES = 0x8E4E :: GLenum

pattern GL_LAST_VIDEO_CAPTURE_STATUS_NV = 0x9027 :: GLenum

pattern GL_LAYER_NV = 0x8DAA :: GLenum

pattern GL_LAYER_PROVOKING_VERTEX = 0x825E :: GLenum

pattern GL_LAYER_PROVOKING_VERTEX_EXT = 0x825E :: GLenum

pattern GL_LAYER_PROVOKING_VERTEX_OES = 0x825E :: GLenum

pattern GL_LAYOUT_DEFAULT_INTEL = 0 :: GLenum

pattern GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2 :: GLenum

pattern GL_LAYOUT_LINEAR_INTEL = 1 :: GLenum

pattern GL_LEFT = 0x0406 :: GLenum

pattern GL_LEQUAL = 0x0203 :: GLenum

pattern GL_LERP_ATI = 0x8969 :: GLenum

pattern GL_LESS = 0x0201 :: GLenum

pattern GL_LIGHT0 = 0x4000 :: GLenum

pattern GL_LIGHT1 = 0x4001 :: GLenum

pattern GL_LIGHT2 = 0x4002 :: GLenum

pattern GL_LIGHT3 = 0x4003 :: GLenum

pattern GL_LIGHT4 = 0x4004 :: GLenum

pattern GL_LIGHT5 = 0x4005 :: GLenum

pattern GL_LIGHT6 = 0x4006 :: GLenum

pattern GL_LIGHT7 = 0x4007 :: GLenum

pattern GL_LIGHTEN = 0x9298 :: GLenum

pattern GL_LIGHTEN_KHR = 0x9298 :: GLenum

pattern GL_LIGHTEN_NV = 0x9298 :: GLenum

pattern GL_LIGHTING = 0x0B50 :: GLenum

pattern GL_LIGHTING_BIT = 0x00000040 :: GLbitfield

pattern GL_LIGHT_ENV_MODE_SGIX = 0x8407 :: GLenum

pattern GL_LIGHT_MODEL_AMBIENT = 0x0B53 :: GLenum

pattern GL_LIGHT_MODEL_COLOR_CONTROL = 0x81F8 :: GLenum

pattern GL_LIGHT_MODEL_COLOR_CONTROL_EXT = 0x81F8 :: GLenum

pattern GL_LIGHT_MODEL_LOCAL_VIEWER = 0x0B51 :: GLenum

pattern GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = 0x85B0 :: GLenum

pattern GL_LIGHT_MODEL_TWO_SIDE = 0x0B52 :: GLenum

pattern GL_LINE = 0x1B01 :: GLenum

pattern GL_LINEAR = 0x2601 :: GLenum

pattern GL_LINEARBURN_NV = 0x92A5 :: GLenum

pattern GL_LINEARDODGE_NV = 0x92A4 :: GLenum

pattern GL_LINEARLIGHT_NV = 0x92A7 :: GLenum

pattern GL_LINEAR_ATTENUATION = 0x1208 :: GLenum

pattern GL_LINEAR_CLIPMAP_LINEAR_SGIX = 0x8170 :: GLenum

pattern GL_LINEAR_CLIPMAP_NEAREST_SGIX = 0x844F :: GLenum

pattern GL_LINEAR_DETAIL_ALPHA_SGIS = 0x8098 :: GLenum

pattern GL_LINEAR_DETAIL_COLOR_SGIS = 0x8099 :: GLenum

pattern GL_LINEAR_DETAIL_SGIS = 0x8097 :: GLenum

pattern GL_LINEAR_MIPMAP_LINEAR = 0x2703 :: GLenum

pattern GL_LINEAR_MIPMAP_NEAREST = 0x2701 :: GLenum

pattern GL_LINEAR_SHARPEN_ALPHA_SGIS = 0x80AE :: GLenum

pattern GL_LINEAR_SHARPEN_COLOR_SGIS = 0x80AF :: GLenum

pattern GL_LINEAR_SHARPEN_SGIS = 0x80AD :: GLenum

pattern GL_LINES = 0x0001 :: GLenum

pattern GL_LINES_ADJACENCY = 0x000A :: GLenum

pattern GL_LINES_ADJACENCY_ARB = 0x000A :: GLenum

pattern GL_LINES_ADJACENCY_EXT = 0x000A :: GLenum

pattern GL_LINES_ADJACENCY_OES = 0x000A :: GLenum

pattern GL_LINE_BIT = 0x00000004 :: GLbitfield

pattern GL_LINE_LOOP = 0x0002 :: GLenum

pattern GL_LINE_NV = 0x1B01 :: GLenum

pattern GL_LINE_QUALITY_HINT_SGIX = 0x835B :: GLenum

pattern GL_LINE_RESET_TOKEN = 0x0707 :: GLenum

pattern GL_LINE_SMOOTH = 0x0B20 :: GLenum

pattern GL_LINE_SMOOTH_HINT = 0x0C52 :: GLenum

pattern GL_LINE_STIPPLE = 0x0B24 :: GLenum

pattern GL_LINE_STIPPLE_PATTERN = 0x0B25 :: GLenum

pattern GL_LINE_STIPPLE_REPEAT = 0x0B26 :: GLenum

pattern GL_LINE_STRIP = 0x0003 :: GLenum

pattern GL_LINE_STRIP_ADJACENCY = 0x000B :: GLenum

pattern GL_LINE_STRIP_ADJACENCY_ARB = 0x000B :: GLenum

pattern GL_LINE_STRIP_ADJACENCY_EXT = 0x000B :: GLenum

pattern GL_LINE_STRIP_ADJACENCY_OES = 0x000B :: GLenum

pattern GL_LINE_TOKEN = 0x0702 :: GLenum

pattern GL_LINE_TO_NV = 0x04 :: GLubyte

pattern GL_LINE_WIDTH = 0x0B21 :: GLenum

pattern GL_LINE_WIDTH_COMMAND_NV = 0x000D :: GLenum

pattern GL_LINE_WIDTH_GRANULARITY = 0x0B23 :: GLenum

pattern GL_LINE_WIDTH_RANGE = 0x0B22 :: GLenum

pattern GL_LINK_STATUS = 0x8B82 :: GLenum

pattern GL_LIST_BASE = 0x0B32 :: GLenum

pattern GL_LIST_BIT = 0x00020000 :: GLbitfield

pattern GL_LIST_INDEX = 0x0B33 :: GLenum

pattern GL_LIST_MODE = 0x0B30 :: GLenum

pattern GL_LIST_PRIORITY_SGIX = 0x8182 :: GLenum

pattern GL_LOAD = 0x0101 :: GLenum

pattern GL_LOCAL_CONSTANT_DATATYPE_EXT = 0x87ED :: GLenum

pattern GL_LOCAL_CONSTANT_EXT = 0x87C3 :: GLenum

pattern GL_LOCAL_CONSTANT_VALUE_EXT = 0x87EC :: GLenum

pattern GL_LOCAL_EXT = 0x87C4 :: GLenum

pattern GL_LOCATION = 0x930E :: GLenum

pattern GL_LOCATION_COMPONENT = 0x934A :: GLenum

pattern GL_LOCATION_INDEX = 0x930F :: GLenum

pattern GL_LOCATION_INDEX_EXT = 0x930F :: GLenum

pattern GL_LOGIC_OP = 0x0BF1 :: GLenum

pattern GL_LOGIC_OP_MODE = 0x0BF0 :: GLenum

pattern GL_LOSE_CONTEXT_ON_RESET = 0x8252 :: GLenum

pattern GL_LOSE_CONTEXT_ON_RESET_ARB = 0x8252 :: GLenum

pattern GL_LOSE_CONTEXT_ON_RESET_EXT = 0x8252 :: GLenum

pattern GL_LOSE_CONTEXT_ON_RESET_KHR = 0x8252 :: GLenum

pattern GL_LOWER_LEFT = 0x8CA1 :: GLenum

pattern GL_LOW_FLOAT = 0x8DF0 :: GLenum

pattern GL_LOW_INT = 0x8DF3 :: GLenum

pattern GL_LO_BIAS_NV = 0x8715 :: GLenum

pattern GL_LO_SCALE_NV = 0x870F :: GLenum

pattern GL_LUMINANCE = 0x1909 :: GLenum

pattern GL_LUMINANCE12 = 0x8041 :: GLenum

pattern GL_LUMINANCE12_ALPHA12 = 0x8047 :: GLenum

pattern GL_LUMINANCE12_ALPHA12_EXT = 0x8047 :: GLenum

pattern GL_LUMINANCE12_ALPHA4 = 0x8046 :: GLenum

pattern GL_LUMINANCE12_ALPHA4_EXT = 0x8046 :: GLenum

pattern GL_LUMINANCE12_EXT = 0x8041 :: GLenum

pattern GL_LUMINANCE16 = 0x8042 :: GLenum

pattern GL_LUMINANCE16F_ARB = 0x881E :: GLenum

pattern GL_LUMINANCE16F_EXT = 0x881E :: GLenum

pattern GL_LUMINANCE16I_EXT = 0x8D8C :: GLenum

pattern GL_LUMINANCE16UI_EXT = 0x8D7A :: GLenum

pattern GL_LUMINANCE16_ALPHA16 = 0x8048 :: GLenum

pattern GL_LUMINANCE16_ALPHA16_EXT = 0x8048 :: GLenum

pattern GL_LUMINANCE16_ALPHA16_SNORM = 0x901A :: GLenum

pattern GL_LUMINANCE16_EXT = 0x8042 :: GLenum

pattern GL_LUMINANCE16_SNORM = 0x9019 :: GLenum

pattern GL_LUMINANCE32F_ARB = 0x8818 :: GLenum

pattern GL_LUMINANCE32F_EXT = 0x8818 :: GLenum

pattern GL_LUMINANCE32I_EXT = 0x8D86 :: GLenum

pattern GL_LUMINANCE32UI_EXT = 0x8D74 :: GLenum

pattern GL_LUMINANCE4 = 0x803F :: GLenum

pattern GL_LUMINANCE4_ALPHA4 = 0x8043 :: GLenum

pattern GL_LUMINANCE4_ALPHA4_EXT = 0x8043 :: GLenum

pattern GL_LUMINANCE4_ALPHA4_OES = 0x8043 :: GLenum

pattern GL_LUMINANCE4_EXT = 0x803F :: GLenum

pattern GL_LUMINANCE6_ALPHA2 = 0x8044 :: GLenum

pattern GL_LUMINANCE6_ALPHA2_EXT = 0x8044 :: GLenum

pattern GL_LUMINANCE8 = 0x8040 :: GLenum

pattern GL_LUMINANCE8I_EXT = 0x8D92 :: GLenum

pattern GL_LUMINANCE8UI_EXT = 0x8D80 :: GLenum

pattern GL_LUMINANCE8_ALPHA8 = 0x8045 :: GLenum

pattern GL_LUMINANCE8_ALPHA8_EXT = 0x8045 :: GLenum

pattern GL_LUMINANCE8_ALPHA8_OES = 0x8045 :: GLenum

pattern GL_LUMINANCE8_ALPHA8_SNORM = 0x9016 :: GLenum

pattern GL_LUMINANCE8_EXT = 0x8040 :: GLenum

pattern GL_LUMINANCE8_OES = 0x8040 :: GLenum

pattern GL_LUMINANCE8_SNORM = 0x9015 :: GLenum

pattern GL_LUMINANCE_ALPHA = 0x190A :: GLenum

pattern GL_LUMINANCE_ALPHA16F_ARB = 0x881F :: GLenum

pattern GL_LUMINANCE_ALPHA16F_EXT = 0x881F :: GLenum

pattern GL_LUMINANCE_ALPHA16I_EXT = 0x8D8D :: GLenum

pattern GL_LUMINANCE_ALPHA16UI_EXT = 0x8D7B :: GLenum

pattern GL_LUMINANCE_ALPHA32F_ARB = 0x8819 :: GLenum

pattern GL_LUMINANCE_ALPHA32F_EXT = 0x8819 :: GLenum

pattern GL_LUMINANCE_ALPHA32I_EXT = 0x8D87 :: GLenum

pattern GL_LUMINANCE_ALPHA32UI_EXT = 0x8D75 :: GLenum

pattern GL_LUMINANCE_ALPHA8I_EXT = 0x8D93 :: GLenum

pattern GL_LUMINANCE_ALPHA8UI_EXT = 0x8D81 :: GLenum

pattern GL_LUMINANCE_ALPHA_FLOAT16_APPLE = 0x881F :: GLenum

pattern GL_LUMINANCE_ALPHA_FLOAT16_ATI = 0x881F :: GLenum

pattern GL_LUMINANCE_ALPHA_FLOAT32_APPLE = 0x8819 :: GLenum

pattern GL_LUMINANCE_ALPHA_FLOAT32_ATI = 0x8819 :: GLenum

pattern GL_LUMINANCE_ALPHA_INTEGER_EXT = 0x8D9D :: GLenum

pattern GL_LUMINANCE_ALPHA_SNORM = 0x9012 :: GLenum

pattern GL_LUMINANCE_FLOAT16_APPLE = 0x881E :: GLenum

pattern GL_LUMINANCE_FLOAT16_ATI = 0x881E :: GLenum

pattern GL_LUMINANCE_FLOAT32_APPLE = 0x8818 :: GLenum

pattern GL_LUMINANCE_FLOAT32_ATI = 0x8818 :: GLenum

pattern GL_LUMINANCE_INTEGER_EXT = 0x8D9C :: GLenum

pattern GL_LUMINANCE_SNORM = 0x9011 :: GLenum

pattern GL_MAD_ATI = 0x8968 :: GLenum

pattern GL_MAGNITUDE_BIAS_NV = 0x8718 :: GLenum

pattern GL_MAGNITUDE_SCALE_NV = 0x8712 :: GLenum

pattern GL_MAJOR_VERSION = 0x821B :: GLenum

pattern GL_MALI_PROGRAM_BINARY_ARM = 0x8F61 :: GLenum

pattern GL_MALI_SHADER_BINARY_ARM = 0x8F60 :: GLenum

pattern GL_MANUAL_GENERATE_MIPMAP = 0x8294 :: GLenum

pattern GL_MAP1_BINORMAL_EXT = 0x8446 :: GLenum

pattern GL_MAP1_COLOR_4 = 0x0D90 :: GLenum

pattern GL_MAP1_GRID_DOMAIN = 0x0DD0 :: GLenum

pattern GL_MAP1_GRID_SEGMENTS = 0x0DD1 :: GLenum

pattern GL_MAP1_INDEX = 0x0D91 :: GLenum

pattern GL_MAP1_NORMAL = 0x0D92 :: GLenum

pattern GL_MAP1_TANGENT_EXT = 0x8444 :: GLenum

pattern GL_MAP1_TEXTURE_COORD_1 = 0x0D93 :: GLenum

pattern GL_MAP1_TEXTURE_COORD_2 = 0x0D94 :: GLenum

pattern GL_MAP1_TEXTURE_COORD_3 = 0x0D95 :: GLenum

pattern GL_MAP1_TEXTURE_COORD_4 = 0x0D96 :: GLenum

pattern GL_MAP1_VERTEX_3 = 0x0D97 :: GLenum

pattern GL_MAP1_VERTEX_4 = 0x0D98 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB0_4_NV = 0x8660 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB10_4_NV = 0x866A :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB11_4_NV = 0x866B :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB12_4_NV = 0x866C :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB13_4_NV = 0x866D :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB14_4_NV = 0x866E :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB15_4_NV = 0x866F :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB1_4_NV = 0x8661 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB2_4_NV = 0x8662 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB3_4_NV = 0x8663 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB4_4_NV = 0x8664 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB5_4_NV = 0x8665 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB6_4_NV = 0x8666 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB7_4_NV = 0x8667 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB8_4_NV = 0x8668 :: GLenum

pattern GL_MAP1_VERTEX_ATTRIB9_4_NV = 0x8669 :: GLenum

pattern GL_MAP2_BINORMAL_EXT = 0x8447 :: GLenum

pattern GL_MAP2_COLOR_4 = 0x0DB0 :: GLenum

pattern GL_MAP2_GRID_DOMAIN = 0x0DD2 :: GLenum

pattern GL_MAP2_GRID_SEGMENTS = 0x0DD3 :: GLenum

pattern GL_MAP2_INDEX = 0x0DB1 :: GLenum

pattern GL_MAP2_NORMAL = 0x0DB2 :: GLenum

pattern GL_MAP2_TANGENT_EXT = 0x8445 :: GLenum

pattern GL_MAP2_TEXTURE_COORD_1 = 0x0DB3 :: GLenum

pattern GL_MAP2_TEXTURE_COORD_2 = 0x0DB4 :: GLenum

pattern GL_MAP2_TEXTURE_COORD_3 = 0x0DB5 :: GLenum

pattern GL_MAP2_TEXTURE_COORD_4 = 0x0DB6 :: GLenum

pattern GL_MAP2_VERTEX_3 = 0x0DB7 :: GLenum

pattern GL_MAP2_VERTEX_4 = 0x0DB8 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB0_4_NV = 0x8670 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB10_4_NV = 0x867A :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB11_4_NV = 0x867B :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB12_4_NV = 0x867C :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB13_4_NV = 0x867D :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB14_4_NV = 0x867E :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB15_4_NV = 0x867F :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB1_4_NV = 0x8671 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB2_4_NV = 0x8672 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB3_4_NV = 0x8673 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB4_4_NV = 0x8674 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB5_4_NV = 0x8675 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB6_4_NV = 0x8676 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB7_4_NV = 0x8677 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB8_4_NV = 0x8678 :: GLenum

pattern GL_MAP2_VERTEX_ATTRIB9_4_NV = 0x8679 :: GLenum

pattern GL_MAP_ATTRIB_U_ORDER_NV = 0x86C3 :: GLenum

pattern GL_MAP_ATTRIB_V_ORDER_NV = 0x86C4 :: GLenum

pattern GL_MAP_COHERENT_BIT = 0x0080 :: GLbitfield

pattern GL_MAP_COHERENT_BIT_EXT = 0x0080 :: GLbitfield

pattern GL_MAP_COLOR = 0x0D10 :: GLenum

pattern GL_MAP_FLUSH_EXPLICIT_BIT = 0x0010 :: GLbitfield

pattern GL_MAP_FLUSH_EXPLICIT_BIT_EXT = 0x0010 :: GLbitfield

pattern GL_MAP_INVALIDATE_BUFFER_BIT = 0x0008 :: GLbitfield

pattern GL_MAP_INVALIDATE_BUFFER_BIT_EXT = 0x0008 :: GLbitfield

pattern GL_MAP_INVALIDATE_RANGE_BIT = 0x0004 :: GLbitfield

pattern GL_MAP_INVALIDATE_RANGE_BIT_EXT = 0x0004 :: GLbitfield

pattern GL_MAP_PERSISTENT_BIT = 0x0040 :: GLbitfield

pattern GL_MAP_PERSISTENT_BIT_EXT = 0x0040 :: GLbitfield

pattern GL_MAP_READ_BIT = 0x0001 :: GLbitfield

pattern GL_MAP_READ_BIT_EXT = 0x0001 :: GLbitfield

pattern GL_MAP_STENCIL = 0x0D11 :: GLenum

pattern GL_MAP_TESSELLATION_NV = 0x86C2 :: GLenum

pattern GL_MAP_UNSYNCHRONIZED_BIT = 0x0020 :: GLbitfield

pattern GL_MAP_UNSYNCHRONIZED_BIT_EXT = 0x0020 :: GLbitfield

pattern GL_MAP_WRITE_BIT = 0x0002 :: GLbitfield

pattern GL_MAP_WRITE_BIT_EXT = 0x0002 :: GLbitfield

pattern GL_MATERIAL_SIDE_HINT_PGI = 0x1A22C :: GLenum

pattern GL_MATRIX0_ARB = 0x88C0 :: GLenum

pattern GL_MATRIX0_NV = 0x8630 :: GLenum

pattern GL_MATRIX10_ARB = 0x88CA :: GLenum

pattern GL_MATRIX11_ARB = 0x88CB :: GLenum

pattern GL_MATRIX12_ARB = 0x88CC :: GLenum

pattern GL_MATRIX13_ARB = 0x88CD :: GLenum

pattern GL_MATRIX14_ARB = 0x88CE :: GLenum

pattern GL_MATRIX15_ARB = 0x88CF :: GLenum

pattern GL_MATRIX16_ARB = 0x88D0 :: GLenum

pattern GL_MATRIX17_ARB = 0x88D1 :: GLenum

pattern GL_MATRIX18_ARB = 0x88D2 :: GLenum

pattern GL_MATRIX19_ARB = 0x88D3 :: GLenum

pattern GL_MATRIX1_ARB = 0x88C1 :: GLenum

pattern GL_MATRIX1_NV = 0x8631 :: GLenum

pattern GL_MATRIX20_ARB = 0x88D4 :: GLenum

pattern GL_MATRIX21_ARB = 0x88D5 :: GLenum

pattern GL_MATRIX22_ARB = 0x88D6 :: GLenum

pattern GL_MATRIX23_ARB = 0x88D7 :: GLenum

pattern GL_MATRIX24_ARB = 0x88D8 :: GLenum

pattern GL_MATRIX25_ARB = 0x88D9 :: GLenum

pattern GL_MATRIX26_ARB = 0x88DA :: GLenum

pattern GL_MATRIX27_ARB = 0x88DB :: GLenum

pattern GL_MATRIX28_ARB = 0x88DC :: GLenum

pattern GL_MATRIX29_ARB = 0x88DD :: GLenum

pattern GL_MATRIX2_ARB = 0x88C2 :: GLenum

pattern GL_MATRIX2_NV = 0x8632 :: GLenum

pattern GL_MATRIX30_ARB = 0x88DE :: GLenum

pattern GL_MATRIX31_ARB = 0x88DF :: GLenum

pattern GL_MATRIX3_ARB = 0x88C3 :: GLenum

pattern GL_MATRIX3_NV = 0x8633 :: GLenum

pattern GL_MATRIX4_ARB = 0x88C4 :: GLenum

pattern GL_MATRIX4_NV = 0x8634 :: GLenum

pattern GL_MATRIX5_ARB = 0x88C5 :: GLenum

pattern GL_MATRIX5_NV = 0x8635 :: GLenum

pattern GL_MATRIX6_ARB = 0x88C6 :: GLenum

pattern GL_MATRIX6_NV = 0x8636 :: GLenum

pattern GL_MATRIX7_ARB = 0x88C7 :: GLenum

pattern GL_MATRIX7_NV = 0x8637 :: GLenum

pattern GL_MATRIX8_ARB = 0x88C8 :: GLenum

pattern GL_MATRIX9_ARB = 0x88C9 :: GLenum

pattern GL_MATRIX_EXT = 0x87C0 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_ARB = 0x8844 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES = 0x8B9E :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_OES = 0x8844 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_POINTER_ARB = 0x8849 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_POINTER_OES = 0x8849 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_SIZE_ARB = 0x8846 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_SIZE_OES = 0x8846 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 0x8848 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_STRIDE_OES = 0x8848 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_TYPE_ARB = 0x8847 :: GLenum

pattern GL_MATRIX_INDEX_ARRAY_TYPE_OES = 0x8847 :: GLenum

pattern GL_MATRIX_MODE = 0x0BA0 :: GLenum

pattern GL_MATRIX_PALETTE_ARB = 0x8840 :: GLenum

pattern GL_MATRIX_PALETTE_OES = 0x8840 :: GLenum

pattern GL_MATRIX_STRIDE = 0x92FF :: GLenum

pattern GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI = 0x00200000 :: GLbitfield

pattern GL_MAT_AMBIENT_BIT_PGI = 0x00100000 :: GLbitfield

pattern GL_MAT_COLOR_INDEXES_BIT_PGI = 0x01000000 :: GLbitfield

pattern GL_MAT_DIFFUSE_BIT_PGI = 0x00400000 :: GLbitfield

pattern GL_MAT_EMISSION_BIT_PGI = 0x00800000 :: GLbitfield

pattern GL_MAT_SHININESS_BIT_PGI = 0x02000000 :: GLbitfield

pattern GL_MAT_SPECULAR_BIT_PGI = 0x04000000 :: GLbitfield

pattern GL_MAX = 0x8008 :: GLenum

pattern GL_MAX_3D_TEXTURE_SIZE = 0x8073 :: GLenum

pattern GL_MAX_3D_TEXTURE_SIZE_EXT = 0x8073 :: GLenum

pattern GL_MAX_3D_TEXTURE_SIZE_OES = 0x8073 :: GLenum

pattern GL_MAX_4D_TEXTURE_SIZE_SGIS = 0x8138 :: GLenum

pattern GL_MAX_ACTIVE_LIGHTS_SGIX = 0x8405 :: GLenum

pattern GL_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF :: GLenum

pattern GL_MAX_ARRAY_TEXTURE_LAYERS_EXT = 0x88FF :: GLenum

pattern GL_MAX_ASYNC_DRAW_PIXELS_SGIX = 0x8360 :: GLenum

pattern GL_MAX_ASYNC_HISTOGRAM_SGIX = 0x832D :: GLenum

pattern GL_MAX_ASYNC_READ_PIXELS_SGIX = 0x8361 :: GLenum

pattern GL_MAX_ASYNC_TEX_IMAGE_SGIX = 0x835F :: GLenum

pattern GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 0x92DC :: GLenum

pattern GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 0x92D8 :: GLenum

pattern GL_MAX_ATTRIB_STACK_DEPTH = 0x0D35 :: GLenum

pattern GL_MAX_BINDABLE_UNIFORM_SIZE_EXT = 0x8DED :: GLenum

pattern GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = 0x0D3B :: GLenum

pattern GL_MAX_CLIPMAP_DEPTH_SGIX = 0x8177 :: GLenum

pattern GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX = 0x8178 :: GLenum

pattern GL_MAX_CLIP_DISTANCES = 0x0D32 :: GLenum

pattern GL_MAX_CLIP_DISTANCES_APPLE = 0x0D32 :: GLenum

pattern GL_MAX_CLIP_DISTANCES_EXT = 0x0D32 :: GLenum

pattern GL_MAX_CLIP_PLANES = 0x0D32 :: GLenum

pattern GL_MAX_CLIP_PLANES_IMG = 0x0D32 :: GLenum

pattern GL_MAX_COLOR_ATTACHMENTS = 0x8CDF :: GLenum

pattern GL_MAX_COLOR_ATTACHMENTS_EXT = 0x8CDF :: GLenum

pattern GL_MAX_COLOR_ATTACHMENTS_NV = 0x8CDF :: GLenum

pattern GL_MAX_COLOR_MATRIX_STACK_DEPTH = 0x80B3 :: GLenum

pattern GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = 0x80B3 :: GLenum

pattern GL_MAX_COLOR_TEXTURE_SAMPLES = 0x910E :: GLenum

pattern GL_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7 :: GLenum

pattern GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 0x92D1 :: GLenum

pattern GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 0x82FA :: GLenum

pattern GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT = 0x82FA :: GLenum

pattern GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 0x8266 :: GLenum

pattern GL_MAX_COMBINED_DIMENSIONS = 0x8282 :: GLenum

pattern GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 0x8A33 :: GLenum

pattern GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 0x8A32 :: GLenum

pattern GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT = 0x8A32 :: GLenum

pattern GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES = 0x8A32 :: GLenum

pattern GL_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF :: GLenum

pattern GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39 :: GLenum

pattern GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT = 0x8F39 :: GLenum

pattern GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 0x8F39 :: GLenum

pattern GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 0x90DC :: GLenum

pattern GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E :: GLenum

pattern GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = 0x8E1E :: GLenum

pattern GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES = 0x8E1E :: GLenum

pattern GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F :: GLenum

pattern GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = 0x8E1F :: GLenum

pattern GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = 0x8E1F :: GLenum

pattern GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D :: GLenum

pattern GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = 0x8B4D :: GLenum

pattern GL_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E :: GLenum

pattern GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 0x8A31 :: GLenum

pattern GL_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265 :: GLenum

pattern GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 0x8264 :: GLenum

pattern GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB = 0x90EB :: GLenum

pattern GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB = 0x91BF :: GLenum

pattern GL_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD :: GLenum

pattern GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 0x90DB :: GLenum

pattern GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 0x8262 :: GLenum

pattern GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 0x91BC :: GLenum

pattern GL_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB :: GLenum

pattern GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 0x8263 :: GLenum

pattern GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB = 0x9344 :: GLenum

pattern GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB = 0x9345 :: GLenum

pattern GL_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE :: GLenum

pattern GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 0x90EB :: GLenum

pattern GL_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF :: GLenum

pattern GL_MAX_CONVOLUTION_HEIGHT = 0x801B :: GLenum

pattern GL_MAX_CONVOLUTION_HEIGHT_EXT = 0x801B :: GLenum

pattern GL_MAX_CONVOLUTION_WIDTH = 0x801A :: GLenum

pattern GL_MAX_CONVOLUTION_WIDTH_EXT = 0x801A :: GLenum

pattern GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C :: GLenum

pattern GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = 0x851C :: GLenum

pattern GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT = 0x851C :: GLenum

pattern GL_MAX_CUBE_MAP_TEXTURE_SIZE_OES = 0x851C :: GLenum

pattern GL_MAX_CULL_DISTANCES = 0x82F9 :: GLenum

pattern GL_MAX_CULL_DISTANCES_EXT = 0x82F9 :: GLenum

pattern GL_MAX_DEBUG_GROUP_STACK_DEPTH = 0x826C :: GLenum

pattern GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 0x826C :: GLenum

pattern GL_MAX_DEBUG_LOGGED_MESSAGES = 0x9144 :: GLenum

pattern GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 0x9144 :: GLenum

pattern GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 0x9144 :: GLenum

pattern GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = 0x9144 :: GLenum

pattern GL_MAX_DEBUG_MESSAGE_LENGTH = 0x9143 :: GLenum

pattern GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 0x9143 :: GLenum

pattern GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 0x9143 :: GLenum

pattern GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = 0x9143 :: GLenum

pattern GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV = 0x90D1 :: GLenum

pattern GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV = 0x90D0 :: GLenum

pattern GL_MAX_DEFORMATION_ORDER_SGIX = 0x8197 :: GLenum

pattern GL_MAX_DEPTH = 0x8280 :: GLenum

pattern GL_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F :: GLenum

pattern GL_MAX_DRAW_BUFFERS = 0x8824 :: GLenum

pattern GL_MAX_DRAW_BUFFERS_ARB = 0x8824 :: GLenum

pattern GL_MAX_DRAW_BUFFERS_ATI = 0x8824 :: GLenum

pattern GL_MAX_DRAW_BUFFERS_EXT = 0x8824 :: GLenum

pattern GL_MAX_DRAW_BUFFERS_NV = 0x8824 :: GLenum

pattern GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 0x88FC :: GLenum

pattern GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT = 0x88FC :: GLenum

pattern GL_MAX_ELEMENTS_INDICES = 0x80E9 :: GLenum

pattern GL_MAX_ELEMENTS_INDICES_EXT = 0x80E9 :: GLenum

pattern GL_MAX_ELEMENTS_VERTICES = 0x80E8 :: GLenum

pattern GL_MAX_ELEMENTS_VERTICES_EXT = 0x80E8 :: GLenum

pattern GL_MAX_ELEMENT_INDEX = 0x8D6B :: GLenum

pattern GL_MAX_EVAL_ORDER = 0x0D30 :: GLenum

pattern GL_MAX_EXT = 0x8008 :: GLenum

pattern GL_MAX_FOG_FUNC_POINTS_SGIS = 0x812C :: GLenum

pattern GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6 :: GLenum

pattern GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 0x92D0 :: GLenum

pattern GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT = 0x8DE3 :: GLenum

pattern GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE :: GLenum

pattern GL_MAX_FRAGMENT_INPUT_COMPONENTS = 0x9125 :: GLenum

pattern GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C :: GLenum

pattern GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV = 0x8E5C :: GLenum

pattern GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES = 0x8E5C :: GLenum

pattern GL_MAX_FRAGMENT_LIGHTS_SGIX = 0x8404 :: GLenum

pattern GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = 0x8868 :: GLenum

pattern GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 0x90DA :: GLenum

pattern GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D :: GLenum

pattern GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 0x8B49 :: GLenum

pattern GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = 0x8B49 :: GLenum

pattern GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD :: GLenum

pattern GL_MAX_FRAMEBUFFER_HEIGHT = 0x9316 :: GLenum

pattern GL_MAX_FRAMEBUFFER_LAYERS = 0x9317 :: GLenum

pattern GL_MAX_FRAMEBUFFER_LAYERS_EXT = 0x9317 :: GLenum

pattern GL_MAX_FRAMEBUFFER_LAYERS_OES = 0x9317 :: GLenum

pattern GL_MAX_FRAMEBUFFER_SAMPLES = 0x9318 :: GLenum

pattern GL_MAX_FRAMEBUFFER_WIDTH = 0x9315 :: GLenum

pattern GL_MAX_FRAMEZOOM_FACTOR_SGIX = 0x818D :: GLenum

pattern GL_MAX_GENERAL_COMBINERS_NV = 0x854D :: GLenum

pattern GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5 :: GLenum

pattern GL_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT = 0x92D5 :: GLenum

pattern GL_MAX_GEOMETRY_ATOMIC_COUNTERS_OES = 0x92D5 :: GLenum

pattern GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 0x92CF :: GLenum

pattern GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CF :: GLenum

pattern GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES = 0x92CF :: GLenum

pattern GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT = 0x8DE4 :: GLenum

pattern GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD :: GLenum

pattern GL_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT = 0x90CD :: GLenum

pattern GL_MAX_GEOMETRY_IMAGE_UNIFORMS_OES = 0x90CD :: GLenum

pattern GL_MAX_GEOMETRY_INPUT_COMPONENTS = 0x9123 :: GLenum

pattern GL_MAX_GEOMETRY_INPUT_COMPONENTS_EXT = 0x9123 :: GLenum

pattern GL_MAX_GEOMETRY_INPUT_COMPONENTS_OES = 0x9123 :: GLenum

pattern GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 0x9124 :: GLenum

pattern GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT = 0x9124 :: GLenum

pattern GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES = 0x9124 :: GLenum

pattern GL_MAX_GEOMETRY_OUTPUT_VERTICES = 0x8DE0 :: GLenum

pattern GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB = 0x8DE0 :: GLenum

pattern GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT = 0x8DE0 :: GLenum

pattern GL_MAX_GEOMETRY_OUTPUT_VERTICES_OES = 0x8DE0 :: GLenum

pattern GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV = 0x8E5A :: GLenum

pattern GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A :: GLenum

pattern GL_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT = 0x8E5A :: GLenum

pattern GL_MAX_GEOMETRY_SHADER_INVOCATIONS_OES = 0x8E5A :: GLenum

pattern GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 0x90D7 :: GLenum

pattern GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT = 0x90D7 :: GLenum

pattern GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES = 0x90D7 :: GLenum

pattern GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 0x8C29 :: GLenum

pattern GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB = 0x8C29 :: GLenum

pattern GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT = 0x8C29 :: GLenum

pattern GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES = 0x8C29 :: GLenum

pattern GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 0x8DE1 :: GLenum

pattern GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB = 0x8DE1 :: GLenum

pattern GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT = 0x8DE1 :: GLenum

pattern GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES = 0x8DE1 :: GLenum

pattern GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C :: GLenum

pattern GL_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT = 0x8A2C :: GLenum

pattern GL_MAX_GEOMETRY_UNIFORM_BLOCKS_OES = 0x8A2C :: GLenum

pattern GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 0x8DDF :: GLenum

pattern GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB = 0x8DDF :: GLenum

pattern GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT = 0x8DDF :: GLenum

pattern GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES = 0x8DDF :: GLenum

pattern GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = 0x8DDD :: GLenum

pattern GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT = 0x8DDD :: GLenum

pattern GL_MAX_HEIGHT = 0x827F :: GLenum

pattern GL_MAX_IMAGE_SAMPLES = 0x906D :: GLenum

pattern GL_MAX_IMAGE_SAMPLES_EXT = 0x906D :: GLenum

pattern GL_MAX_IMAGE_UNITS = 0x8F38 :: GLenum

pattern GL_MAX_IMAGE_UNITS_EXT = 0x8F38 :: GLenum

pattern GL_MAX_INTEGER_SAMPLES = 0x9110 :: GLenum

pattern GL_MAX_LABEL_LENGTH = 0x82E8 :: GLenum

pattern GL_MAX_LABEL_LENGTH_KHR = 0x82E8 :: GLenum

pattern GL_MAX_LAYERS = 0x8281 :: GLenum

pattern GL_MAX_LIGHTS = 0x0D31 :: GLenum

pattern GL_MAX_LIST_NESTING = 0x0B31 :: GLenum

pattern GL_MAX_MAP_TESSELLATION_NV = 0x86D6 :: GLenum

pattern GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 0x8841 :: GLenum

pattern GL_MAX_MODELVIEW_STACK_DEPTH = 0x0D36 :: GLenum

pattern GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E11 :: GLenum

pattern GL_MAX_MULTIVIEW_BUFFERS_EXT = 0x90F2 :: GLenum

pattern GL_MAX_NAME_LENGTH = 0x92F6 :: GLenum

pattern GL_MAX_NAME_STACK_DEPTH = 0x0D37 :: GLenum

pattern GL_MAX_NUM_ACTIVE_VARIABLES = 0x92F7 :: GLenum

pattern GL_MAX_NUM_COMPATIBLE_SUBROUTINES = 0x92F8 :: GLenum

pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87CA :: GLenum

pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = 0x87CD :: GLenum

pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = 0x87CE :: GLenum

pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87CC :: GLenum

pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = 0x87CB :: GLenum

pattern GL_MAX_PALETTE_MATRICES_ARB = 0x8842 :: GLenum

pattern GL_MAX_PALETTE_MATRICES_OES = 0x8842 :: GLenum

pattern GL_MAX_PATCH_VERTICES = 0x8E7D :: GLenum

pattern GL_MAX_PATCH_VERTICES_EXT = 0x8E7D :: GLenum

pattern GL_MAX_PATCH_VERTICES_OES = 0x8E7D :: GLenum

pattern GL_MAX_PIXEL_MAP_TABLE = 0x0D34 :: GLenum

pattern GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = 0x8337 :: GLenum

pattern GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = 0x87F1 :: GLenum

pattern GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B1 :: GLenum

pattern GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x880B :: GLenum

pattern GL_MAX_PROGRAM_ATTRIBS_ARB = 0x88AD :: GLenum

pattern GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8908 :: GLenum

pattern GL_MAX_PROGRAM_CALL_DEPTH_NV = 0x88F5 :: GLenum

pattern GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = 0x88B5 :: GLenum

pattern GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = 0x88F4 :: GLenum

pattern GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV = 0x8DA5 :: GLenum

pattern GL_MAX_PROGRAM_GENERIC_RESULTS_NV = 0x8DA6 :: GLenum

pattern GL_MAX_PROGRAM_IF_DEPTH_NV = 0x88F6 :: GLenum

pattern GL_MAX_PROGRAM_INSTRUCTIONS_ARB = 0x88A1 :: GLenum

pattern GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = 0x88B4 :: GLenum

pattern GL_MAX_PROGRAM_LOOP_COUNT_NV = 0x88F8 :: GLenum

pattern GL_MAX_PROGRAM_LOOP_DEPTH_NV = 0x88F7 :: GLenum

pattern GL_MAX_PROGRAM_MATRICES_ARB = 0x862F :: GLenum

pattern GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = 0x862E :: GLenum

pattern GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B3 :: GLenum

pattern GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x880E :: GLenum

pattern GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AF :: GLenum

pattern GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A3 :: GLenum

pattern GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AB :: GLenum

pattern GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A7 :: GLenum

pattern GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x8810 :: GLenum

pattern GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x880F :: GLenum

pattern GL_MAX_PROGRAM_OUTPUT_VERTICES_NV = 0x8C27 :: GLenum

pattern GL_MAX_PROGRAM_PARAMETERS_ARB = 0x88A9 :: GLenum

pattern GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV = 0x8DA0 :: GLenum

pattern GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV = 0x8DA1 :: GLenum

pattern GL_MAX_PROGRAM_PATCH_ATTRIBS_NV = 0x86D8 :: GLenum

pattern GL_MAX_PROGRAM_RESULT_COMPONENTS_NV = 0x8909 :: GLenum

pattern GL_MAX_PROGRAM_SUBROUTINE_NUM_NV = 0x8F45 :: GLenum

pattern GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV = 0x8F44 :: GLenum

pattern GL_MAX_PROGRAM_TEMPORARIES_ARB = 0x88A5 :: GLenum

pattern GL_MAX_PROGRAM_TEXEL_OFFSET = 0x8905 :: GLenum

pattern GL_MAX_PROGRAM_TEXEL_OFFSET_EXT = 0x8905 :: GLenum

pattern GL_MAX_PROGRAM_TEXEL_OFFSET_NV = 0x8905 :: GLenum

pattern GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB = 0x8F9F :: GLenum

pattern GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5F :: GLenum

pattern GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5F :: GLenum

pattern GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV = 0x8E5F :: GLenum

pattern GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = 0x880D :: GLenum

pattern GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x880C :: GLenum

pattern GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV = 0x8C28 :: GLenum

pattern GL_MAX_PROJECTION_STACK_DEPTH = 0x0D38 :: GLenum

pattern GL_MAX_RASTER_SAMPLES_EXT = 0x9329 :: GLenum

pattern GL_MAX_RATIONAL_EVAL_ORDER_NV = 0x86D7 :: GLenum

pattern GL_MAX_RECTANGLE_TEXTURE_SIZE = 0x84F8 :: GLenum

pattern GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = 0x84F8 :: GLenum

pattern GL_MAX_RECTANGLE_TEXTURE_SIZE_NV = 0x84F8 :: GLenum

pattern GL_MAX_RENDERBUFFER_SIZE = 0x84E8 :: GLenum

pattern GL_MAX_RENDERBUFFER_SIZE_EXT = 0x84E8 :: GLenum

pattern GL_MAX_RENDERBUFFER_SIZE_OES = 0x84E8 :: GLenum

pattern GL_MAX_SAMPLES = 0x8D57 :: GLenum

pattern GL_MAX_SAMPLES_ANGLE = 0x8D57 :: GLenum

pattern GL_MAX_SAMPLES_APPLE = 0x8D57 :: GLenum

pattern GL_MAX_SAMPLES_EXT = 0x8D57 :: GLenum

pattern GL_MAX_SAMPLES_IMG = 0x9135 :: GLenum

pattern GL_MAX_SAMPLES_NV = 0x8D57 :: GLenum

pattern GL_MAX_SAMPLE_MASK_WORDS = 0x8E59 :: GLenum

pattern GL_MAX_SAMPLE_MASK_WORDS_NV = 0x8E59 :: GLenum

pattern GL_MAX_SERVER_WAIT_TIMEOUT = 0x9111 :: GLenum

pattern GL_MAX_SERVER_WAIT_TIMEOUT_APPLE = 0x9111 :: GLenum

pattern GL_MAX_SHADER_BUFFER_ADDRESS_NV = 0x8F35 :: GLenum

pattern GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_FAST_SIZE_EXT = 0x9650 :: GLenum

pattern GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_SIZE_EXT = 0x9651 :: GLenum

pattern GL_MAX_SHADER_COMPILER_THREADS_ARB = 0x91B0 :: GLenum

pattern GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT = 0x8F63 :: GLenum

pattern GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT = 0x8F67 :: GLenum

pattern GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE :: GLenum

pattern GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 0x90DD :: GLenum

pattern GL_MAX_SHININESS_NV = 0x8504 :: GLenum

pattern GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD = 0x9199 :: GLenum

pattern GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = 0x9199 :: GLenum

pattern GL_MAX_SPARSE_3D_TEXTURE_SIZE_EXT = 0x9199 :: GLenum

pattern GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 0x919A :: GLenum

pattern GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB = 0x919A :: GLenum

pattern GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_EXT = 0x919A :: GLenum

pattern GL_MAX_SPARSE_TEXTURE_SIZE_AMD = 0x9198 :: GLenum

pattern GL_MAX_SPARSE_TEXTURE_SIZE_ARB = 0x9198 :: GLenum

pattern GL_MAX_SPARSE_TEXTURE_SIZE_EXT = 0x9198 :: GLenum

pattern GL_MAX_SPOT_EXPONENT_NV = 0x8505 :: GLenum

pattern GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV = 0x9349 :: GLenum

pattern GL_MAX_SUBROUTINES = 0x8DE7 :: GLenum

pattern GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 0x8DE8 :: GLenum

pattern GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 0x92D3 :: GLenum

pattern GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT = 0x92D3 :: GLenum

pattern GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES = 0x92D3 :: GLenum

pattern GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 0x92CD :: GLenum

pattern GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CD :: GLenum

pattern GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES = 0x92CD :: GLenum

pattern GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 0x90CB :: GLenum

pattern GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT = 0x90CB :: GLenum

pattern GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES = 0x90CB :: GLenum

pattern GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C :: GLenum

pattern GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT = 0x886C :: GLenum

pattern GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES = 0x886C :: GLenum

pattern GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83 :: GLenum

pattern GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT = 0x8E83 :: GLenum

pattern GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES = 0x8E83 :: GLenum

pattern GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 0x90D8 :: GLenum

pattern GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT = 0x90D8 :: GLenum

pattern GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES = 0x90D8 :: GLenum

pattern GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81 :: GLenum

pattern GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT = 0x8E81 :: GLenum

pattern GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES = 0x8E81 :: GLenum

pattern GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85 :: GLenum

pattern GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT = 0x8E85 :: GLenum

pattern GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES = 0x8E85 :: GLenum

pattern GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89 :: GLenum

pattern GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT = 0x8E89 :: GLenum

pattern GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES = 0x8E89 :: GLenum

pattern GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F :: GLenum

pattern GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = 0x8E7F :: GLenum

pattern GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES = 0x8E7F :: GLenum

pattern GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 0x92D4 :: GLenum

pattern GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT = 0x92D4 :: GLenum

pattern GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES = 0x92D4 :: GLenum

pattern GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 0x92CE :: GLenum

pattern GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CE :: GLenum

pattern GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES = 0x92CE :: GLenum

pattern GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 0x90CC :: GLenum

pattern GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT = 0x90CC :: GLenum

pattern GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES = 0x90CC :: GLenum

pattern GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D :: GLenum

pattern GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT = 0x886D :: GLenum

pattern GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES = 0x886D :: GLenum

pattern GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86 :: GLenum

pattern GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT = 0x8E86 :: GLenum

pattern GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES = 0x8E86 :: GLenum

pattern GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 0x90D9 :: GLenum

pattern GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT = 0x90D9 :: GLenum

pattern GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES = 0x90D9 :: GLenum

pattern GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82 :: GLenum

pattern GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT = 0x8E82 :: GLenum

pattern GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES = 0x8E82 :: GLenum

pattern GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A :: GLenum

pattern GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT = 0x8E8A :: GLenum

pattern GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES = 0x8E8A :: GLenum

pattern GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80 :: GLenum

pattern GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = 0x8E80 :: GLenum

pattern GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = 0x8E80 :: GLenum

pattern GL_MAX_TESS_GEN_LEVEL = 0x8E7E :: GLenum

pattern GL_MAX_TESS_GEN_LEVEL_EXT = 0x8E7E :: GLenum

pattern GL_MAX_TESS_GEN_LEVEL_OES = 0x8E7E :: GLenum

pattern GL_MAX_TESS_PATCH_COMPONENTS = 0x8E84 :: GLenum

pattern GL_MAX_TESS_PATCH_COMPONENTS_EXT = 0x8E84 :: GLenum

pattern GL_MAX_TESS_PATCH_COMPONENTS_OES = 0x8E84 :: GLenum

pattern GL_MAX_TEXTURE_BUFFER_SIZE = 0x8C2B :: GLenum

pattern GL_MAX_TEXTURE_BUFFER_SIZE_ARB = 0x8C2B :: GLenum

pattern GL_MAX_TEXTURE_BUFFER_SIZE_EXT = 0x8C2B :: GLenum

pattern GL_MAX_TEXTURE_BUFFER_SIZE_OES = 0x8C2B :: GLenum

pattern GL_MAX_TEXTURE_COORDS = 0x8871 :: GLenum

pattern GL_MAX_TEXTURE_COORDS_ARB = 0x8871 :: GLenum

pattern GL_MAX_TEXTURE_COORDS_NV = 0x8871 :: GLenum

pattern GL_MAX_TEXTURE_IMAGE_UNITS = 0x8872 :: GLenum

pattern GL_MAX_TEXTURE_IMAGE_UNITS_ARB = 0x8872 :: GLenum

pattern GL_MAX_TEXTURE_IMAGE_UNITS_NV = 0x8872 :: GLenum

pattern GL_MAX_TEXTURE_LOD_BIAS = 0x84FD :: GLenum

pattern GL_MAX_TEXTURE_LOD_BIAS_EXT = 0x84FD :: GLenum

pattern GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF :: GLenum

pattern GL_MAX_TEXTURE_SIZE = 0x0D33 :: GLenum

pattern GL_MAX_TEXTURE_STACK_DEPTH = 0x0D39 :: GLenum

pattern GL_MAX_TEXTURE_UNITS = 0x84E2 :: GLenum

pattern GL_MAX_TEXTURE_UNITS_ARB = 0x84E2 :: GLenum

pattern GL_MAX_TRACK_MATRICES_NV = 0x862F :: GLenum

pattern GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = 0x862E :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 0x8E70 :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = 0x8C8A :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 0x8C8A :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 0x8C8B :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = 0x8C8B :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = 0x8C8B :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 0x8C80 :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = 0x8C80 :: GLenum

pattern GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = 0x8C80 :: GLenum

pattern GL_MAX_UNIFORM_BLOCK_SIZE = 0x8A30 :: GLenum

pattern GL_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F :: GLenum

pattern GL_MAX_UNIFORM_LOCATIONS = 0x826E :: GLenum

pattern GL_MAX_VARYING_COMPONENTS = 0x8B4B :: GLenum

pattern GL_MAX_VARYING_COMPONENTS_EXT = 0x8B4B :: GLenum

pattern GL_MAX_VARYING_FLOATS = 0x8B4B :: GLenum

pattern GL_MAX_VARYING_FLOATS_ARB = 0x8B4B :: GLenum

pattern GL_MAX_VARYING_VECTORS = 0x8DFC :: GLenum

pattern GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = 0x8520 :: GLenum

pattern GL_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2 :: GLenum

pattern GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 0x92CC :: GLenum

pattern GL_MAX_VERTEX_ATTRIBS = 0x8869 :: GLenum

pattern GL_MAX_VERTEX_ATTRIBS_ARB = 0x8869 :: GLenum

pattern GL_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA :: GLenum

pattern GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D9 :: GLenum

pattern GL_MAX_VERTEX_ATTRIB_STRIDE = 0x82E5 :: GLenum

pattern GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT = 0x8DE2 :: GLenum

pattern GL_MAX_VERTEX_HINT_PGI = 0x1A22D :: GLenum

pattern GL_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA :: GLenum

pattern GL_MAX_VERTEX_OUTPUT_COMPONENTS = 0x9122 :: GLenum

pattern GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87C5 :: GLenum

pattern GL_MAX_VERTEX_SHADER_INVARIANTS_EXT = 0x87C7 :: GLenum

pattern GL_MAX_VERTEX_SHADER_LOCALS_EXT = 0x87C9 :: GLenum

pattern GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87C8 :: GLenum

pattern GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 0x90D6 :: GLenum

pattern GL_MAX_VERTEX_SHADER_VARIANTS_EXT = 0x87C6 :: GLenum

pattern GL_MAX_VERTEX_STREAMS = 0x8E71 :: GLenum

pattern GL_MAX_VERTEX_STREAMS_ATI = 0x876B :: GLenum

pattern GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C :: GLenum

pattern GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = 0x8B4C :: GLenum

pattern GL_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B :: GLenum

pattern GL_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A :: GLenum

pattern GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = 0x8B4A :: GLenum

pattern GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB :: GLenum

pattern GL_MAX_VERTEX_UNITS_ARB = 0x86A4 :: GLenum

pattern GL_MAX_VERTEX_UNITS_OES = 0x86A4 :: GLenum

pattern GL_MAX_VERTEX_VARYING_COMPONENTS_ARB = 0x8DDE :: GLenum

pattern GL_MAX_VERTEX_VARYING_COMPONENTS_EXT = 0x8DDE :: GLenum

pattern GL_MAX_VIEWPORTS = 0x825B :: GLenum

pattern GL_MAX_VIEWPORTS_NV = 0x825B :: GLenum

pattern GL_MAX_VIEWPORT_DIMS = 0x0D3A :: GLenum

pattern GL_MAX_VIEWS_OVR = 0x9631 :: GLenum

pattern GL_MAX_WIDTH = 0x827E :: GLenum

pattern GL_MAX_WINDOW_RECTANGLES_EXT = 0x8F14 :: GLenum

pattern GL_MEDIUM_FLOAT = 0x8DF1 :: GLenum

pattern GL_MEDIUM_INT = 0x8DF4 :: GLenum

pattern GL_MIN = 0x8007 :: GLenum

pattern GL_MINMAX = 0x802E :: GLenum

pattern GL_MINMAX_EXT = 0x802E :: GLenum

pattern GL_MINMAX_FORMAT = 0x802F :: GLenum

pattern GL_MINMAX_FORMAT_EXT = 0x802F :: GLenum

pattern GL_MINMAX_SINK = 0x8030 :: GLenum

pattern GL_MINMAX_SINK_EXT = 0x8030 :: GLenum

pattern GL_MINOR_VERSION = 0x821C :: GLenum

pattern GL_MINUS_CLAMPED_NV = 0x92B3 :: GLenum

pattern GL_MINUS_NV = 0x929F :: GLenum

pattern GL_MIN_EXT = 0x8007 :: GLenum

pattern GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B :: GLenum

pattern GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV = 0x8E5B :: GLenum

pattern GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES = 0x8E5B :: GLenum

pattern GL_MIN_LOD_WARNING_AMD = 0x919C :: GLenum

pattern GL_MIN_MAP_BUFFER_ALIGNMENT = 0x90BC :: GLenum

pattern GL_MIN_PROGRAM_TEXEL_OFFSET = 0x8904 :: GLenum

pattern GL_MIN_PROGRAM_TEXEL_OFFSET_EXT = 0x8904 :: GLenum

pattern GL_MIN_PROGRAM_TEXEL_OFFSET_NV = 0x8904 :: GLenum

pattern GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5E :: GLenum

pattern GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5E :: GLenum

pattern GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV = 0x8E5E :: GLenum

pattern GL_MIN_SAMPLE_SHADING_VALUE = 0x8C37 :: GLenum

pattern GL_MIN_SAMPLE_SHADING_VALUE_ARB = 0x8C37 :: GLenum

pattern GL_MIN_SAMPLE_SHADING_VALUE_OES = 0x8C37 :: GLenum

pattern GL_MIN_SPARSE_LEVEL_AMD = 0x919B :: GLenum

pattern GL_MIPMAP = 0x8293 :: GLenum

pattern GL_MIRRORED_REPEAT = 0x8370 :: GLenum

pattern GL_MIRRORED_REPEAT_ARB = 0x8370 :: GLenum

pattern GL_MIRRORED_REPEAT_IBM = 0x8370 :: GLenum

pattern GL_MIRRORED_REPEAT_OES = 0x8370 :: GLenum

pattern GL_MIRROR_CLAMP_ATI = 0x8742 :: GLenum

pattern GL_MIRROR_CLAMP_EXT = 0x8742 :: GLenum

pattern GL_MIRROR_CLAMP_TO_BORDER_EXT = 0x8912 :: GLenum

pattern GL_MIRROR_CLAMP_TO_EDGE = 0x8743 :: GLenum

pattern GL_MIRROR_CLAMP_TO_EDGE_ATI = 0x8743 :: GLenum

pattern GL_MIRROR_CLAMP_TO_EDGE_EXT = 0x8743 :: GLenum

pattern GL_MITER_REVERT_NV = 0x90A7 :: GLenum

pattern GL_MITER_TRUNCATE_NV = 0x90A8 :: GLenum

pattern GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV = 0x932F :: GLenum

pattern GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV = 0x9330 :: GLenum

pattern GL_MODELVIEW = 0x1700 :: GLenum

pattern GL_MODELVIEW0_ARB = 0x1700 :: GLenum

pattern GL_MODELVIEW0_EXT = 0x1700 :: GLenum

pattern GL_MODELVIEW0_MATRIX_EXT = 0x0BA6 :: GLenum

pattern GL_MODELVIEW0_STACK_DEPTH_EXT = 0x0BA3 :: GLenum

pattern GL_MODELVIEW10_ARB = 0x872A :: GLenum

pattern GL_MODELVIEW11_ARB = 0x872B :: GLenum

pattern GL_MODELVIEW12_ARB = 0x872C :: GLenum

pattern GL_MODELVIEW13_ARB = 0x872D :: GLenum

pattern GL_MODELVIEW14_ARB = 0x872E :: GLenum

pattern GL_MODELVIEW15_ARB = 0x872F :: GLenum

pattern GL_MODELVIEW16_ARB = 0x8730 :: GLenum

pattern GL_MODELVIEW17_ARB = 0x8731 :: GLenum

pattern GL_MODELVIEW18_ARB = 0x8732 :: GLenum

pattern GL_MODELVIEW19_ARB = 0x8733 :: GLenum

pattern GL_MODELVIEW1_ARB = 0x850A :: GLenum

pattern GL_MODELVIEW1_EXT = 0x850A :: GLenum

pattern GL_MODELVIEW1_MATRIX_EXT = 0x8506 :: GLenum

pattern GL_MODELVIEW1_STACK_DEPTH_EXT = 0x8502 :: GLenum

pattern GL_MODELVIEW20_ARB = 0x8734 :: GLenum

pattern GL_MODELVIEW21_ARB = 0x8735 :: GLenum

pattern GL_MODELVIEW22_ARB = 0x8736 :: GLenum

pattern GL_MODELVIEW23_ARB = 0x8737 :: GLenum

pattern GL_MODELVIEW24_ARB = 0x8738 :: GLenum

pattern GL_MODELVIEW25_ARB = 0x8739 :: GLenum

pattern GL_MODELVIEW26_ARB = 0x873A :: GLenum

pattern GL_MODELVIEW27_ARB = 0x873B :: GLenum

pattern GL_MODELVIEW28_ARB = 0x873C :: GLenum

pattern GL_MODELVIEW29_ARB = 0x873D :: GLenum

pattern GL_MODELVIEW2_ARB = 0x8722 :: GLenum

pattern GL_MODELVIEW30_ARB = 0x873E :: GLenum

pattern GL_MODELVIEW31_ARB = 0x873F :: GLenum

pattern GL_MODELVIEW3_ARB = 0x8723 :: GLenum

pattern GL_MODELVIEW4_ARB = 0x8724 :: GLenum

pattern GL_MODELVIEW5_ARB = 0x8725 :: GLenum

pattern GL_MODELVIEW6_ARB = 0x8726 :: GLenum

pattern GL_MODELVIEW7_ARB = 0x8727 :: GLenum

pattern GL_MODELVIEW8_ARB = 0x8728 :: GLenum

pattern GL_MODELVIEW9_ARB = 0x8729 :: GLenum

pattern GL_MODELVIEW_MATRIX = 0x0BA6 :: GLenum

pattern GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES = 0x898D :: GLenum

pattern GL_MODELVIEW_PROJECTION_NV = 0x8629 :: GLenum

pattern GL_MODELVIEW_STACK_DEPTH = 0x0BA3 :: GLenum

pattern GL_MODULATE = 0x2100 :: GLenum

pattern GL_MODULATE_ADD_ATI = 0x8744 :: GLenum

pattern GL_MODULATE_COLOR_IMG = 0x8C04 :: GLenum

pattern GL_MODULATE_SIGNED_ADD_ATI = 0x8745 :: GLenum

pattern GL_MODULATE_SUBTRACT_ATI = 0x8746 :: GLenum

pattern GL_MOVE_TO_CONTINUES_NV = 0x90B6 :: GLenum

pattern GL_MOVE_TO_NV = 0x02 :: GLubyte

pattern GL_MOVE_TO_RESETS_NV = 0x90B5 :: GLenum

pattern GL_MOV_ATI = 0x8961 :: GLenum

pattern GL_MULT = 0x0103 :: GLenum

pattern GL_MULTIPLY = 0x9294 :: GLenum

pattern GL_MULTIPLY_KHR = 0x9294 :: GLenum

pattern GL_MULTIPLY_NV = 0x9294 :: GLenum

pattern GL_MULTISAMPLE = 0x809D :: GLenum

pattern GL_MULTISAMPLES_NV = 0x9371 :: GLenum

pattern GL_MULTISAMPLE_3DFX = 0x86B2 :: GLenum

pattern GL_MULTISAMPLE_ARB = 0x809D :: GLenum

pattern GL_MULTISAMPLE_BIT = 0x20000000 :: GLbitfield

pattern GL_MULTISAMPLE_BIT_3DFX = 0x20000000 :: GLbitfield

pattern GL_MULTISAMPLE_BIT_ARB = 0x20000000 :: GLbitfield

pattern GL_MULTISAMPLE_BIT_EXT = 0x20000000 :: GLbitfield

pattern GL_MULTISAMPLE_BUFFER_BIT0_QCOM = 0x01000000 :: GLbitfield

pattern GL_MULTISAMPLE_BUFFER_BIT1_QCOM = 0x02000000 :: GLbitfield

pattern GL_MULTISAMPLE_BUFFER_BIT2_QCOM = 0x04000000 :: GLbitfield

pattern GL_MULTISAMPLE_BUFFER_BIT3_QCOM = 0x08000000 :: GLbitfield

pattern GL_MULTISAMPLE_BUFFER_BIT4_QCOM = 0x10000000 :: GLbitfield

pattern GL_MULTISAMPLE_BUFFER_BIT5_QCOM = 0x20000000 :: GLbitfield

pattern GL_MULTISAMPLE_BUFFER_BIT6_QCOM = 0x40000000 :: GLbitfield

pattern GL_MULTISAMPLE_BUFFER_BIT7_QCOM = 0x80000000 :: GLbitfield

pattern GL_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E12 :: GLenum

pattern GL_MULTISAMPLE_EXT = 0x809D :: GLenum

pattern GL_MULTISAMPLE_FILTER_HINT_NV = 0x8534 :: GLenum

pattern GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY = 0x9382 :: GLenum

pattern GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB = 0x9382 :: GLenum

pattern GL_MULTISAMPLE_LINE_WIDTH_RANGE = 0x9381 :: GLenum

pattern GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB = 0x9381 :: GLenum

pattern GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT = 0x932B :: GLenum

pattern GL_MULTISAMPLE_SGIS = 0x809D :: GLenum

pattern GL_MULTIVIEW_EXT = 0x90F1 :: GLenum

pattern GL_MUL_ATI = 0x8964 :: GLenum

pattern GL_MVP_MATRIX_EXT = 0x87E3 :: GLenum

pattern GL_N3F_V3F = 0x2A25 :: GLenum

pattern GL_NAMED_STRING_LENGTH_ARB = 0x8DE9 :: GLenum

pattern GL_NAMED_STRING_TYPE_ARB = 0x8DEA :: GLenum

pattern GL_NAME_LENGTH = 0x92F9 :: GLenum

pattern GL_NAME_STACK_DEPTH = 0x0D70 :: GLenum

pattern GL_NAND = 0x150E :: GLenum

pattern GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI = 0x1A203 :: GLenum

pattern GL_NATIVE_GRAPHICS_END_HINT_PGI = 0x1A204 :: GLenum

pattern GL_NATIVE_GRAPHICS_HANDLE_PGI = 0x1A202 :: GLenum

pattern GL_NEAREST = 0x2600 :: GLenum

pattern GL_NEAREST_CLIPMAP_LINEAR_SGIX = 0x844E :: GLenum

pattern GL_NEAREST_CLIPMAP_NEAREST_SGIX = 0x844D :: GLenum

pattern GL_NEAREST_MIPMAP_LINEAR = 0x2702 :: GLenum

pattern GL_NEAREST_MIPMAP_NEAREST = 0x2700 :: GLenum

pattern GL_NEGATE_BIT_ATI = 0x00000004 :: GLbitfield

pattern GL_NEGATIVE_ONE_EXT = 0x87DF :: GLenum

pattern GL_NEGATIVE_ONE_TO_ONE = 0x935E :: GLenum

pattern GL_NEGATIVE_W_EXT = 0x87DC :: GLenum

pattern GL_NEGATIVE_X_EXT = 0x87D9 :: GLenum

pattern GL_NEGATIVE_Y_EXT = 0x87DA :: GLenum

pattern GL_NEGATIVE_Z_EXT = 0x87DB :: GLenum

pattern GL_NEVER = 0x0200 :: GLenum

pattern GL_NEXT_BUFFER_NV = -2 :: GLenum

pattern GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV = 0x9025 :: GLenum

pattern GL_NICEST = 0x1102 :: GLenum

pattern GL_NONE = 0 :: GLenum

pattern GL_NONE_OES = 0 :: GLenum

pattern GL_NOOP = 0x1505 :: GLenum

pattern GL_NOP_COMMAND_NV = 0x0001 :: GLenum

pattern GL_NOR = 0x1508 :: GLenum

pattern GL_NORMALIZE = 0x0BA1 :: GLenum

pattern GL_NORMALIZED_RANGE_EXT = 0x87E0 :: GLenum

pattern GL_NORMAL_ARRAY = 0x8075 :: GLenum

pattern GL_NORMAL_ARRAY_ADDRESS_NV = 0x8F22 :: GLenum

pattern GL_NORMAL_ARRAY_BUFFER_BINDING = 0x8897 :: GLenum

pattern GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = 0x8897 :: GLenum

pattern GL_NORMAL_ARRAY_COUNT_EXT = 0x8080 :: GLenum

pattern GL_NORMAL_ARRAY_EXT = 0x8075 :: GLenum

pattern GL_NORMAL_ARRAY_LENGTH_NV = 0x8F2C :: GLenum

pattern GL_NORMAL_ARRAY_LIST_IBM = 103071 :: GLenum

pattern GL_NORMAL_ARRAY_LIST_STRIDE_IBM = 103081 :: GLenum

pattern GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F6 :: GLenum

pattern GL_NORMAL_ARRAY_POINTER = 0x808F :: GLenum

pattern GL_NORMAL_ARRAY_POINTER_EXT = 0x808F :: GLenum

pattern GL_NORMAL_ARRAY_STRIDE = 0x807F :: GLenum

pattern GL_NORMAL_ARRAY_STRIDE_EXT = 0x807F :: GLenum

pattern GL_NORMAL_ARRAY_TYPE = 0x807E :: GLenum

pattern GL_NORMAL_ARRAY_TYPE_EXT = 0x807E :: GLenum

pattern GL_NORMAL_BIT_PGI = 0x08000000 :: GLbitfield

pattern GL_NORMAL_MAP = 0x8511 :: GLenum

pattern GL_NORMAL_MAP_ARB = 0x8511 :: GLenum

pattern GL_NORMAL_MAP_EXT = 0x8511 :: GLenum

pattern GL_NORMAL_MAP_NV = 0x8511 :: GLenum

pattern GL_NORMAL_MAP_OES = 0x8511 :: GLenum

pattern GL_NOTEQUAL = 0x0205 :: GLenum

pattern GL_NO_ERROR = 0 :: GLenum

pattern GL_NO_RESET_NOTIFICATION = 0x8261 :: GLenum

pattern GL_NO_RESET_NOTIFICATION_ARB = 0x8261 :: GLenum

pattern GL_NO_RESET_NOTIFICATION_EXT = 0x8261 :: GLenum

pattern GL_NO_RESET_NOTIFICATION_KHR = 0x8261 :: GLenum

pattern GL_NUM_ACTIVE_VARIABLES = 0x9304 :: GLenum

pattern GL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A :: GLenum

pattern GL_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2 :: GLenum

pattern GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A2 :: GLenum

pattern GL_NUM_DOWNSAMPLE_SCALES_IMG = 0x913D :: GLenum

pattern GL_NUM_EXTENSIONS = 0x821D :: GLenum

pattern GL_NUM_FILL_STREAMS_NV = 0x8E29 :: GLenum

pattern GL_NUM_FRAGMENT_CONSTANTS_ATI = 0x896F :: GLenum

pattern GL_NUM_FRAGMENT_REGISTERS_ATI = 0x896E :: GLenum

pattern GL_NUM_GENERAL_COMBINERS_NV = 0x854E :: GLenum

pattern GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI = 0x8973 :: GLenum

pattern GL_NUM_INSTRUCTIONS_PER_PASS_ATI = 0x8971 :: GLenum

pattern GL_NUM_INSTRUCTIONS_TOTAL_ATI = 0x8972 :: GLenum

pattern GL_NUM_LOOPBACK_COMPONENTS_ATI = 0x8974 :: GLenum

pattern GL_NUM_PASSES_ATI = 0x8970 :: GLenum

pattern GL_NUM_PROGRAM_BINARY_FORMATS = 0x87FE :: GLenum

pattern GL_NUM_PROGRAM_BINARY_FORMATS_OES = 0x87FE :: GLenum

pattern GL_NUM_SAMPLE_COUNTS = 0x9380 :: GLenum

pattern GL_NUM_SHADER_BINARY_FORMATS = 0x8DF9 :: GLenum

pattern GL_NUM_SHADING_LANGUAGE_VERSIONS = 0x82E9 :: GLenum

pattern GL_NUM_SPARSE_LEVELS_ARB = 0x91AA :: GLenum

pattern GL_NUM_SPARSE_LEVELS_EXT = 0x91AA :: GLenum

pattern GL_NUM_VIDEO_CAPTURE_STREAMS_NV = 0x9024 :: GLenum

pattern GL_NUM_VIRTUAL_PAGE_SIZES_ARB = 0x91A8 :: GLenum

pattern GL_NUM_VIRTUAL_PAGE_SIZES_EXT = 0x91A8 :: GLenum

pattern GL_NUM_WINDOW_RECTANGLES_EXT = 0x8F15 :: GLenum

pattern GL_OBJECT_ACTIVE_ATTRIBUTES_ARB = 0x8B89 :: GLenum

pattern GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = 0x8B8A :: GLenum

pattern GL_OBJECT_ACTIVE_UNIFORMS_ARB = 0x8B86 :: GLenum

pattern GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 0x8B87 :: GLenum

pattern GL_OBJECT_ATTACHED_OBJECTS_ARB = 0x8B85 :: GLenum

pattern GL_OBJECT_BUFFER_SIZE_ATI = 0x8764 :: GLenum

pattern GL_OBJECT_BUFFER_USAGE_ATI = 0x8765 :: GLenum

pattern GL_OBJECT_COMPILE_STATUS_ARB = 0x8B81 :: GLenum

pattern GL_OBJECT_DELETE_STATUS_ARB = 0x8B80 :: GLenum

pattern GL_OBJECT_DISTANCE_TO_LINE_SGIS = 0x81F3 :: GLenum

pattern GL_OBJECT_DISTANCE_TO_POINT_SGIS = 0x81F1 :: GLenum

pattern GL_OBJECT_INFO_LOG_LENGTH_ARB = 0x8B84 :: GLenum

pattern GL_OBJECT_LINEAR = 0x2401 :: GLenum

pattern GL_OBJECT_LINEAR_NV = 0x2401 :: GLenum

pattern GL_OBJECT_LINE_SGIS = 0x81F7 :: GLenum

pattern GL_OBJECT_LINK_STATUS_ARB = 0x8B82 :: GLenum

pattern GL_OBJECT_PLANE = 0x2501 :: GLenum

pattern GL_OBJECT_POINT_SGIS = 0x81F5 :: GLenum

pattern GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 0x8B88 :: GLenum

pattern GL_OBJECT_SUBTYPE_ARB = 0x8B4F :: GLenum

pattern GL_OBJECT_TYPE = 0x9112 :: GLenum

pattern GL_OBJECT_TYPE_APPLE = 0x9112 :: GLenum

pattern GL_OBJECT_TYPE_ARB = 0x8B4E :: GLenum

pattern GL_OBJECT_VALIDATE_STATUS_ARB = 0x8B83 :: GLenum

pattern GL_OCCLUSION_QUERY_EVENT_MASK_AMD = 0x874F :: GLenum

pattern GL_OCCLUSION_TEST_HP = 0x8165 :: GLenum

pattern GL_OCCLUSION_TEST_RESULT_HP = 0x8166 :: GLenum

pattern GL_OFFSET = 0x92FC :: GLenum

pattern GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = 0x8856 :: GLenum

pattern GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8857 :: GLenum

pattern GL_OFFSET_HILO_TEXTURE_2D_NV = 0x8854 :: GLenum

pattern GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = 0x8855 :: GLenum

pattern GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = 0x8850 :: GLenum

pattern GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = 0x8851 :: GLenum

pattern GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8852 :: GLenum

pattern GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = 0x8853 :: GLenum

pattern GL_OFFSET_TEXTURE_2D_BIAS_NV = 0x86E3 :: GLenum

pattern GL_OFFSET_TEXTURE_2D_MATRIX_NV = 0x86E1 :: GLenum

pattern GL_OFFSET_TEXTURE_2D_NV = 0x86E8 :: GLenum

pattern GL_OFFSET_TEXTURE_2D_SCALE_NV = 0x86E2 :: GLenum

pattern GL_OFFSET_TEXTURE_BIAS_NV = 0x86E3 :: GLenum

pattern GL_OFFSET_TEXTURE_MATRIX_NV = 0x86E1 :: GLenum

pattern GL_OFFSET_TEXTURE_RECTANGLE_NV = 0x864C :: GLenum

pattern GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = 0x864D :: GLenum

pattern GL_OFFSET_TEXTURE_SCALE_NV = 0x86E2 :: GLenum

pattern GL_ONE = 1 :: GLenum

pattern GL_ONE_EXT = 0x87DE :: GLenum

pattern GL_ONE_MINUS_CONSTANT_ALPHA = 0x8004 :: GLenum

pattern GL_ONE_MINUS_CONSTANT_ALPHA_EXT = 0x8004 :: GLenum

pattern GL_ONE_MINUS_CONSTANT_COLOR = 0x8002 :: GLenum

pattern GL_ONE_MINUS_CONSTANT_COLOR_EXT = 0x8002 :: GLenum

pattern GL_ONE_MINUS_DST_ALPHA = 0x0305 :: GLenum

pattern GL_ONE_MINUS_DST_COLOR = 0x0307 :: GLenum

pattern GL_ONE_MINUS_SRC1_ALPHA = 0x88FB :: GLenum

pattern GL_ONE_MINUS_SRC1_ALPHA_EXT = 0x88FB :: GLenum

pattern GL_ONE_MINUS_SRC1_COLOR = 0x88FA :: GLenum

pattern GL_ONE_MINUS_SRC1_COLOR_EXT = 0x88FA :: GLenum

pattern GL_ONE_MINUS_SRC_ALPHA = 0x0303 :: GLenum

pattern GL_ONE_MINUS_SRC_COLOR = 0x0301 :: GLenum

pattern GL_OPERAND0_ALPHA = 0x8598 :: GLenum

pattern GL_OPERAND0_ALPHA_ARB = 0x8598 :: GLenum

pattern GL_OPERAND0_ALPHA_EXT = 0x8598 :: GLenum

pattern GL_OPERAND0_RGB = 0x8590 :: GLenum

pattern GL_OPERAND0_RGB_ARB = 0x8590 :: GLenum

pattern GL_OPERAND0_RGB_EXT = 0x8590 :: GLenum

pattern GL_OPERAND1_ALPHA = 0x8599 :: GLenum

pattern GL_OPERAND1_ALPHA_ARB = 0x8599 :: GLenum

pattern GL_OPERAND1_ALPHA_EXT = 0x8599 :: GLenum

pattern GL_OPERAND1_RGB = 0x8591 :: GLenum

pattern GL_OPERAND1_RGB_ARB = 0x8591 :: GLenum

pattern GL_OPERAND1_RGB_EXT = 0x8591 :: GLenum

pattern GL_OPERAND2_ALPHA = 0x859A :: GLenum

pattern GL_OPERAND2_ALPHA_ARB = 0x859A :: GLenum

pattern GL_OPERAND2_ALPHA_EXT = 0x859A :: GLenum

pattern GL_OPERAND2_RGB = 0x8592 :: GLenum

pattern GL_OPERAND2_RGB_ARB = 0x8592 :: GLenum

pattern GL_OPERAND2_RGB_EXT = 0x8592 :: GLenum

pattern GL_OPERAND3_ALPHA_NV = 0x859B :: GLenum

pattern GL_OPERAND3_RGB_NV = 0x8593 :: GLenum

pattern GL_OP_ADD_EXT = 0x8787 :: GLenum

pattern GL_OP_CLAMP_EXT = 0x878E :: GLenum

pattern GL_OP_CROSS_PRODUCT_EXT = 0x8797 :: GLenum

pattern GL_OP_DOT3_EXT = 0x8784 :: GLenum

pattern GL_OP_DOT4_EXT = 0x8785 :: GLenum

pattern GL_OP_EXP_BASE_2_EXT = 0x8791 :: GLenum

pattern GL_OP_FLOOR_EXT = 0x878F :: GLenum

pattern GL_OP_FRAC_EXT = 0x8789 :: GLenum

pattern GL_OP_INDEX_EXT = 0x8782 :: GLenum

pattern GL_OP_LOG_BASE_2_EXT = 0x8792 :: GLenum

pattern GL_OP_MADD_EXT = 0x8788 :: GLenum

pattern GL_OP_MAX_EXT = 0x878A :: GLenum

pattern GL_OP_MIN_EXT = 0x878B :: GLenum

pattern GL_OP_MOV_EXT = 0x8799 :: GLenum

pattern GL_OP_MULTIPLY_MATRIX_EXT = 0x8798 :: GLenum

pattern GL_OP_MUL_EXT = 0x8786 :: GLenum

pattern GL_OP_NEGATE_EXT = 0x8783 :: GLenum

pattern GL_OP_POWER_EXT = 0x8793 :: GLenum

pattern GL_OP_RECIP_EXT = 0x8794 :: GLenum

pattern GL_OP_RECIP_SQRT_EXT = 0x8795 :: GLenum

pattern GL_OP_ROUND_EXT = 0x8790 :: GLenum

pattern GL_OP_SET_GE_EXT = 0x878C :: GLenum

pattern GL_OP_SET_LT_EXT = 0x878D :: GLenum

pattern GL_OP_SUB_EXT = 0x8796 :: GLenum

pattern GL_OR = 0x1507 :: GLenum

pattern GL_ORDER = 0x0A01 :: GLenum

pattern GL_OR_INVERTED = 0x150D :: GLenum

pattern GL_OR_REVERSE = 0x150B :: GLenum

pattern GL_OUTPUT_COLOR0_EXT = 0x879B :: GLenum

pattern GL_OUTPUT_COLOR1_EXT = 0x879C :: GLenum

pattern GL_OUTPUT_FOG_EXT = 0x87BD :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD0_EXT = 0x879D :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD10_EXT = 0x87A7 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD11_EXT = 0x87A8 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD12_EXT = 0x87A9 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD13_EXT = 0x87AA :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD14_EXT = 0x87AB :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD15_EXT = 0x87AC :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD16_EXT = 0x87AD :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD17_EXT = 0x87AE :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD18_EXT = 0x87AF :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD19_EXT = 0x87B0 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD1_EXT = 0x879E :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD20_EXT = 0x87B1 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD21_EXT = 0x87B2 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD22_EXT = 0x87B3 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD23_EXT = 0x87B4 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD24_EXT = 0x87B5 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD25_EXT = 0x87B6 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD26_EXT = 0x87B7 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD27_EXT = 0x87B8 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD28_EXT = 0x87B9 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD29_EXT = 0x87BA :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD2_EXT = 0x879F :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD30_EXT = 0x87BB :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD31_EXT = 0x87BC :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD3_EXT = 0x87A0 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD4_EXT = 0x87A1 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD5_EXT = 0x87A2 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD6_EXT = 0x87A3 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD7_EXT = 0x87A4 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD8_EXT = 0x87A5 :: GLenum

pattern GL_OUTPUT_TEXTURE_COORD9_EXT = 0x87A6 :: GLenum

pattern GL_OUTPUT_VERTEX_EXT = 0x879A :: GLenum

pattern GL_OUT_OF_MEMORY = 0x0505 :: GLenum

pattern GL_OVERLAY = 0x9296 :: GLenum

pattern GL_OVERLAY_KHR = 0x9296 :: GLenum

pattern GL_OVERLAY_NV = 0x9296 :: GLenum

pattern GL_PACK_ALIGNMENT = 0x0D05 :: GLenum

pattern GL_PACK_CMYK_HINT_EXT = 0x800E :: GLenum

pattern GL_PACK_COMPRESSED_BLOCK_DEPTH = 0x912D :: GLenum

pattern GL_PACK_COMPRESSED_BLOCK_HEIGHT = 0x912C :: GLenum

pattern GL_PACK_COMPRESSED_BLOCK_SIZE = 0x912E :: GLenum

pattern GL_PACK_COMPRESSED_BLOCK_WIDTH = 0x912B :: GLenum

pattern GL_PACK_COMPRESSED_SIZE_SGIX = 0x831C :: GLenum

pattern GL_PACK_IMAGE_DEPTH_SGIS = 0x8131 :: GLenum

pattern GL_PACK_IMAGE_HEIGHT = 0x806C :: GLenum

pattern GL_PACK_IMAGE_HEIGHT_EXT = 0x806C :: GLenum

pattern GL_PACK_INVERT_MESA = 0x8758 :: GLenum

pattern GL_PACK_LSB_FIRST = 0x0D01 :: GLenum

pattern GL_PACK_MAX_COMPRESSED_SIZE_SGIX = 0x831B :: GLenum

pattern GL_PACK_RESAMPLE_OML = 0x8984 :: GLenum

pattern GL_PACK_RESAMPLE_SGIX = 0x842E :: GLenum

pattern GL_PACK_REVERSE_ROW_ORDER_ANGLE = 0x93A4 :: GLenum

pattern GL_PACK_ROW_BYTES_APPLE = 0x8A15 :: GLenum

pattern GL_PACK_ROW_LENGTH = 0x0D02 :: GLenum

pattern GL_PACK_SKIP_IMAGES = 0x806B :: GLenum

pattern GL_PACK_SKIP_IMAGES_EXT = 0x806B :: GLenum

pattern GL_PACK_SKIP_PIXELS = 0x0D04 :: GLenum

pattern GL_PACK_SKIP_ROWS = 0x0D03 :: GLenum

pattern GL_PACK_SKIP_VOLUMES_SGIS = 0x8130 :: GLenum

pattern GL_PACK_SUBSAMPLE_RATE_SGIX = 0x85A0 :: GLenum

pattern GL_PACK_SWAP_BYTES = 0x0D00 :: GLenum

pattern GL_PALETTE4_R5_G6_B5_OES = 0x8B92 :: GLenum

pattern GL_PALETTE4_RGB5_A1_OES = 0x8B94 :: GLenum

pattern GL_PALETTE4_RGB8_OES = 0x8B90 :: GLenum

pattern GL_PALETTE4_RGBA4_OES = 0x8B93 :: GLenum

pattern GL_PALETTE4_RGBA8_OES = 0x8B91 :: GLenum

pattern GL_PALETTE8_R5_G6_B5_OES = 0x8B97 :: GLenum

pattern GL_PALETTE8_RGB5_A1_OES = 0x8B99 :: GLenum

pattern GL_PALETTE8_RGB8_OES = 0x8B95 :: GLenum

pattern GL_PALETTE8_RGBA4_OES = 0x8B98 :: GLenum

pattern GL_PALETTE8_RGBA8_OES = 0x8B96 :: GLenum

pattern GL_PARALLEL_ARRAYS_INTEL = 0x83F4 :: GLenum

pattern GL_PARAMETER_BUFFER_ARB = 0x80EE :: GLenum

pattern GL_PARAMETER_BUFFER_BINDING_ARB = 0x80EF :: GLenum

pattern GL_PARTIAL_SUCCESS_NV = 0x902E :: GLenum

pattern GL_PASS_THROUGH_NV = 0x86E6 :: GLenum

pattern GL_PASS_THROUGH_TOKEN = 0x0700 :: GLenum

pattern GL_PATCHES = 0x000E :: GLenum

pattern GL_PATCHES_EXT = 0x000E :: GLenum

pattern GL_PATCHES_OES = 0x000E :: GLenum

pattern GL_PATCH_DEFAULT_INNER_LEVEL = 0x8E73 :: GLenum

pattern GL_PATCH_DEFAULT_INNER_LEVEL_EXT = 0x8E73 :: GLenum

pattern GL_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74 :: GLenum

pattern GL_PATCH_DEFAULT_OUTER_LEVEL_EXT = 0x8E74 :: GLenum

pattern GL_PATCH_VERTICES = 0x8E72 :: GLenum

pattern GL_PATCH_VERTICES_EXT = 0x8E72 :: GLenum

pattern GL_PATCH_VERTICES_OES = 0x8E72 :: GLenum

pattern GL_PATH_CLIENT_LENGTH_NV = 0x907F :: GLenum

pattern GL_PATH_COMMAND_COUNT_NV = 0x909D :: GLenum

pattern GL_PATH_COMPUTED_LENGTH_NV = 0x90A0 :: GLenum

pattern GL_PATH_COORD_COUNT_NV = 0x909E :: GLenum

pattern GL_PATH_COVER_DEPTH_FUNC_NV = 0x90BF :: GLenum

pattern GL_PATH_DASH_ARRAY_COUNT_NV = 0x909F :: GLenum

pattern GL_PATH_DASH_CAPS_NV = 0x907B :: GLenum

pattern GL_PATH_DASH_OFFSET_NV = 0x907E :: GLenum

pattern GL_PATH_DASH_OFFSET_RESET_NV = 0x90B4 :: GLenum

pattern GL_PATH_END_CAPS_NV = 0x9076 :: GLenum

pattern GL_PATH_ERROR_POSITION_NV = 0x90AB :: GLenum

pattern GL_PATH_FILL_BOUNDING_BOX_NV = 0x90A1 :: GLenum

pattern GL_PATH_FILL_COVER_MODE_NV = 0x9082 :: GLenum

pattern GL_PATH_FILL_MASK_NV = 0x9081 :: GLenum

pattern GL_PATH_FILL_MODE_NV = 0x9080 :: GLenum

pattern GL_PATH_FOG_GEN_MODE_NV = 0x90AC :: GLenum

pattern GL_PATH_FORMAT_PS_NV = 0x9071 :: GLenum

pattern GL_PATH_FORMAT_SVG_NV = 0x9070 :: GLenum

pattern GL_PATH_GEN_COEFF_NV = 0x90B1 :: GLenum

pattern GL_PATH_GEN_COLOR_FORMAT_NV = 0x90B2 :: GLenum

pattern GL_PATH_GEN_COMPONENTS_NV = 0x90B3 :: GLenum

pattern GL_PATH_GEN_MODE_NV = 0x90B0 :: GLenum

pattern GL_PATH_INITIAL_DASH_CAP_NV = 0x907C :: GLenum

pattern GL_PATH_INITIAL_END_CAP_NV = 0x9077 :: GLenum

pattern GL_PATH_JOIN_STYLE_NV = 0x9079 :: GLenum

pattern GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = 0x0D36 :: GLenum

pattern GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV = 0x0D38 :: GLenum

pattern GL_PATH_MITER_LIMIT_NV = 0x907A :: GLenum

pattern GL_PATH_MODELVIEW_MATRIX_NV = 0x0BA6 :: GLenum

pattern GL_PATH_MODELVIEW_NV = 0x1700 :: GLenum

pattern GL_PATH_MODELVIEW_STACK_DEPTH_NV = 0x0BA3 :: GLenum

pattern GL_PATH_OBJECT_BOUNDING_BOX_NV = 0x908A :: GLenum

pattern GL_PATH_PROJECTION_MATRIX_NV = 0x0BA7 :: GLenum

pattern GL_PATH_PROJECTION_NV = 0x1701 :: GLenum

pattern GL_PATH_PROJECTION_STACK_DEPTH_NV = 0x0BA4 :: GLenum

pattern GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = 0x90BD :: GLenum

pattern GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = 0x90BE :: GLenum

pattern GL_PATH_STENCIL_FUNC_NV = 0x90B7 :: GLenum

pattern GL_PATH_STENCIL_REF_NV = 0x90B8 :: GLenum

pattern GL_PATH_STENCIL_VALUE_MASK_NV = 0x90B9 :: GLenum

pattern GL_PATH_STROKE_BOUNDING_BOX_NV = 0x90A2 :: GLenum

pattern GL_PATH_STROKE_COVER_MODE_NV = 0x9083 :: GLenum

pattern GL_PATH_STROKE_MASK_NV = 0x9084 :: GLenum

pattern GL_PATH_STROKE_WIDTH_NV = 0x9075 :: GLenum

pattern GL_PATH_TERMINAL_DASH_CAP_NV = 0x907D :: GLenum

pattern GL_PATH_TERMINAL_END_CAP_NV = 0x9078 :: GLenum

pattern GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = 0x84E3 :: GLenum

pattern GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = 0x84E4 :: GLenum

pattern GL_PERCENTAGE_AMD = 0x8BC3 :: GLenum

pattern GL_PERFMON_GLOBAL_MODE_QCOM = 0x8FA0 :: GLenum

pattern GL_PERFMON_RESULT_AMD = 0x8BC6 :: GLenum

pattern GL_PERFMON_RESULT_AVAILABLE_AMD = 0x8BC4 :: GLenum

pattern GL_PERFMON_RESULT_SIZE_AMD = 0x8BC5 :: GLenum

pattern GL_PERFORMANCE_MONITOR_AMD = 0x9152 :: GLenum

pattern GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 0x94FC :: GLenum

pattern GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 0x94FB :: GLenum

pattern GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 0x94FA :: GLenum

pattern GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 0x94F8 :: GLenum

pattern GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 0x94F9 :: GLenum

pattern GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 0x94FF :: GLenum

pattern GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 0x94F1 :: GLenum

pattern GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 0x94F2 :: GLenum

pattern GL_PERFQUERY_COUNTER_EVENT_INTEL = 0x94F0 :: GLenum

pattern GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 0x94FE :: GLenum

pattern GL_PERFQUERY_COUNTER_RAW_INTEL = 0x94F4 :: GLenum

pattern GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 0x94F3 :: GLenum

pattern GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 0x94F5 :: GLenum

pattern GL_PERFQUERY_DONOT_FLUSH_INTEL = 0x83F9 :: GLenum

pattern GL_PERFQUERY_FLUSH_INTEL = 0x83FA :: GLenum

pattern GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = 0x00000001 :: GLbitfield

pattern GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 0x9500 :: GLenum

pattern GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 0x94FD :: GLenum

pattern GL_PERFQUERY_SINGLE_CONTEXT_INTEL = 0x00000000 :: GLbitfield

pattern GL_PERFQUERY_WAIT_INTEL = 0x83FB :: GLenum

pattern GL_PERSPECTIVE_CORRECTION_HINT = 0x0C50 :: GLenum

pattern GL_PERTURB_EXT = 0x85AE :: GLenum

pattern GL_PER_STAGE_CONSTANTS_NV = 0x8535 :: GLenum

pattern GL_PHONG_HINT_WIN = 0x80EB :: GLenum

pattern GL_PHONG_WIN = 0x80EA :: GLenum

pattern GL_PINLIGHT_NV = 0x92A8 :: GLenum

pattern GL_PIXEL_BUFFER_BARRIER_BIT = 0x00000080 :: GLbitfield

pattern GL_PIXEL_BUFFER_BARRIER_BIT_EXT = 0x00000080 :: GLbitfield

pattern GL_PIXEL_COUNTER_BITS_NV = 0x8864 :: GLenum

pattern GL_PIXEL_COUNT_AVAILABLE_NV = 0x8867 :: GLenum

pattern GL_PIXEL_COUNT_NV = 0x8866 :: GLenum

pattern GL_PIXEL_CUBIC_WEIGHT_EXT = 0x8333 :: GLenum

pattern GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = 0x8355 :: GLenum

pattern GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = 0x8354 :: GLenum

pattern GL_PIXEL_GROUP_COLOR_SGIS = 0x8356 :: GLenum

pattern GL_PIXEL_MAG_FILTER_EXT = 0x8331 :: GLenum

pattern GL_PIXEL_MAP_A_TO_A = 0x0C79 :: GLenum

pattern GL_PIXEL_MAP_A_TO_A_SIZE = 0x0CB9 :: GLenum

pattern GL_PIXEL_MAP_B_TO_B = 0x0C78 :: GLenum

pattern GL_PIXEL_MAP_B_TO_B_SIZE = 0x0CB8 :: GLenum

pattern GL_PIXEL_MAP_G_TO_G = 0x0C77 :: GLenum

pattern GL_PIXEL_MAP_G_TO_G_SIZE = 0x0CB7 :: GLenum

pattern GL_PIXEL_MAP_I_TO_A = 0x0C75 :: GLenum

pattern GL_PIXEL_MAP_I_TO_A_SIZE = 0x0CB5 :: GLenum

pattern GL_PIXEL_MAP_I_TO_B = 0x0C74 :: GLenum

pattern GL_PIXEL_MAP_I_TO_B_SIZE = 0x0CB4 :: GLenum

pattern GL_PIXEL_MAP_I_TO_G = 0x0C73 :: GLenum

pattern GL_PIXEL_MAP_I_TO_G_SIZE = 0x0CB3 :: GLenum

pattern GL_PIXEL_MAP_I_TO_I = 0x0C70 :: GLenum

pattern GL_PIXEL_MAP_I_TO_I_SIZE = 0x0CB0 :: GLenum

pattern GL_PIXEL_MAP_I_TO_R = 0x0C72 :: GLenum

pattern GL_PIXEL_MAP_I_TO_R_SIZE = 0x0CB2 :: GLenum

pattern GL_PIXEL_MAP_R_TO_R = 0x0C76 :: GLenum

pattern GL_PIXEL_MAP_R_TO_R_SIZE = 0x0CB6 :: GLenum

pattern GL_PIXEL_MAP_S_TO_S = 0x0C71 :: GLenum

pattern GL_PIXEL_MAP_S_TO_S_SIZE = 0x0CB1 :: GLenum

pattern GL_PIXEL_MIN_FILTER_EXT = 0x8332 :: GLenum

pattern GL_PIXEL_MODE_BIT = 0x00000020 :: GLbitfield

pattern GL_PIXEL_PACK_BUFFER = 0x88EB :: GLenum

pattern GL_PIXEL_PACK_BUFFER_ARB = 0x88EB :: GLenum

pattern GL_PIXEL_PACK_BUFFER_BINDING = 0x88ED :: GLenum

pattern GL_PIXEL_PACK_BUFFER_BINDING_ARB = 0x88ED :: GLenum

pattern GL_PIXEL_PACK_BUFFER_BINDING_EXT = 0x88ED :: GLenum

pattern GL_PIXEL_PACK_BUFFER_EXT = 0x88EB :: GLenum

pattern GL_PIXEL_SUBSAMPLE_2424_SGIX = 0x85A3 :: GLenum

pattern GL_PIXEL_SUBSAMPLE_4242_SGIX = 0x85A4 :: GLenum

pattern GL_PIXEL_SUBSAMPLE_4444_SGIX = 0x85A2 :: GLenum

pattern GL_PIXEL_TEXTURE_SGIS = 0x8353 :: GLenum

pattern GL_PIXEL_TEX_GEN_ALPHA_LS_SGIX = 0x8189 :: GLenum

pattern GL_PIXEL_TEX_GEN_ALPHA_MS_SGIX = 0x818A :: GLenum

pattern GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX = 0x8188 :: GLenum

pattern GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX = 0x8187 :: GLenum

pattern GL_PIXEL_TEX_GEN_MODE_SGIX = 0x832B :: GLenum

pattern GL_PIXEL_TEX_GEN_Q_CEILING_SGIX = 0x8184 :: GLenum

pattern GL_PIXEL_TEX_GEN_Q_FLOOR_SGIX = 0x8186 :: GLenum

pattern GL_PIXEL_TEX_GEN_Q_ROUND_SGIX = 0x8185 :: GLenum

pattern GL_PIXEL_TEX_GEN_SGIX = 0x8139 :: GLenum

pattern GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX = 0x813E :: GLenum

pattern GL_PIXEL_TILE_CACHE_INCREMENT_SGIX = 0x813F :: GLenum

pattern GL_PIXEL_TILE_CACHE_SIZE_SGIX = 0x8145 :: GLenum

pattern GL_PIXEL_TILE_GRID_DEPTH_SGIX = 0x8144 :: GLenum

pattern GL_PIXEL_TILE_GRID_HEIGHT_SGIX = 0x8143 :: GLenum

pattern GL_PIXEL_TILE_GRID_WIDTH_SGIX = 0x8142 :: GLenum

pattern GL_PIXEL_TILE_HEIGHT_SGIX = 0x8141 :: GLenum

pattern GL_PIXEL_TILE_WIDTH_SGIX = 0x8140 :: GLenum

pattern GL_PIXEL_TRANSFORM_2D_EXT = 0x8330 :: GLenum

pattern GL_PIXEL_TRANSFORM_2D_MATRIX_EXT = 0x8338 :: GLenum

pattern GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = 0x8336 :: GLenum

pattern GL_PIXEL_UNPACK_BUFFER = 0x88EC :: GLenum

pattern GL_PIXEL_UNPACK_BUFFER_ARB = 0x88EC :: GLenum

pattern GL_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF :: GLenum

pattern GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = 0x88EF :: GLenum

pattern GL_PIXEL_UNPACK_BUFFER_BINDING_EXT = 0x88EF :: GLenum

pattern GL_PIXEL_UNPACK_BUFFER_EXT = 0x88EC :: GLenum

pattern GL_PLUS_CLAMPED_ALPHA_NV = 0x92B2 :: GLenum

pattern GL_PLUS_CLAMPED_NV = 0x92B1 :: GLenum

pattern GL_PLUS_DARKER_NV = 0x9292 :: GLenum

pattern GL_PLUS_NV = 0x9291 :: GLenum

pattern GL_PN_TRIANGLES_ATI = 0x87F0 :: GLenum

pattern GL_PN_TRIANGLES_NORMAL_MODE_ATI = 0x87F3 :: GLenum

pattern GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = 0x87F7 :: GLenum

pattern GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = 0x87F8 :: GLenum

pattern GL_PN_TRIANGLES_POINT_MODE_ATI = 0x87F2 :: GLenum

pattern GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = 0x87F6 :: GLenum

pattern GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = 0x87F5 :: GLenum

pattern GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = 0x87F4 :: GLenum

pattern GL_POINT = 0x1B00 :: GLenum

pattern GL_POINTS = 0x0000 :: GLenum

pattern GL_POINT_BIT = 0x00000002 :: GLbitfield

pattern GL_POINT_DISTANCE_ATTENUATION = 0x8129 :: GLenum

pattern GL_POINT_DISTANCE_ATTENUATION_ARB = 0x8129 :: GLenum

pattern GL_POINT_FADE_THRESHOLD_SIZE = 0x8128 :: GLenum

pattern GL_POINT_FADE_THRESHOLD_SIZE_ARB = 0x8128 :: GLenum

pattern GL_POINT_FADE_THRESHOLD_SIZE_EXT = 0x8128 :: GLenum

pattern GL_POINT_FADE_THRESHOLD_SIZE_SGIS = 0x8128 :: GLenum

pattern GL_POINT_NV = 0x1B00 :: GLenum

pattern GL_POINT_SIZE = 0x0B11 :: GLenum

pattern GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES = 0x8B9F :: GLenum

pattern GL_POINT_SIZE_ARRAY_OES = 0x8B9C :: GLenum

pattern GL_POINT_SIZE_ARRAY_POINTER_OES = 0x898C :: GLenum

pattern GL_POINT_SIZE_ARRAY_STRIDE_OES = 0x898B :: GLenum

pattern GL_POINT_SIZE_ARRAY_TYPE_OES = 0x898A :: GLenum

pattern GL_POINT_SIZE_GRANULARITY = 0x0B13 :: GLenum

pattern GL_POINT_SIZE_MAX = 0x8127 :: GLenum

pattern GL_POINT_SIZE_MAX_ARB = 0x8127 :: GLenum

pattern GL_POINT_SIZE_MAX_EXT = 0x8127 :: GLenum

pattern GL_POINT_SIZE_MAX_SGIS = 0x8127 :: GLenum

pattern GL_POINT_SIZE_MIN = 0x8126 :: GLenum

pattern GL_POINT_SIZE_MIN_ARB = 0x8126 :: GLenum

pattern GL_POINT_SIZE_MIN_EXT = 0x8126 :: GLenum

pattern GL_POINT_SIZE_MIN_SGIS = 0x8126 :: GLenum

pattern GL_POINT_SIZE_RANGE = 0x0B12 :: GLenum

pattern GL_POINT_SMOOTH = 0x0B10 :: GLenum

pattern GL_POINT_SMOOTH_HINT = 0x0C51 :: GLenum

pattern GL_POINT_SPRITE = 0x8861 :: GLenum

pattern GL_POINT_SPRITE_ARB = 0x8861 :: GLenum

pattern GL_POINT_SPRITE_COORD_ORIGIN = 0x8CA0 :: GLenum

pattern GL_POINT_SPRITE_NV = 0x8861 :: GLenum

pattern GL_POINT_SPRITE_OES = 0x8861 :: GLenum

pattern GL_POINT_SPRITE_R_MODE_NV = 0x8863 :: GLenum

pattern GL_POINT_TOKEN = 0x0701 :: GLenum

pattern GL_POLYGON = 0x0009 :: GLenum

pattern GL_POLYGON_BIT = 0x00000008 :: GLbitfield

pattern GL_POLYGON_MODE = 0x0B40 :: GLenum

pattern GL_POLYGON_MODE_NV = 0x0B40 :: GLenum

pattern GL_POLYGON_OFFSET_BIAS_EXT = 0x8039 :: GLenum

pattern GL_POLYGON_OFFSET_CLAMP_EXT = 0x8E1B :: GLenum

pattern GL_POLYGON_OFFSET_COMMAND_NV = 0x000E :: GLenum

pattern GL_POLYGON_OFFSET_EXT = 0x8037 :: GLenum

pattern GL_POLYGON_OFFSET_FACTOR = 0x8038 :: GLenum

pattern GL_POLYGON_OFFSET_FACTOR_EXT = 0x8038 :: GLenum

pattern GL_POLYGON_OFFSET_FILL = 0x8037 :: GLenum

pattern GL_POLYGON_OFFSET_LINE = 0x2A02 :: GLenum

pattern GL_POLYGON_OFFSET_LINE_NV = 0x2A02 :: GLenum

pattern GL_POLYGON_OFFSET_POINT = 0x2A01 :: GLenum

pattern GL_POLYGON_OFFSET_POINT_NV = 0x2A01 :: GLenum

pattern GL_POLYGON_OFFSET_UNITS = 0x2A00 :: GLenum

pattern GL_POLYGON_SMOOTH = 0x0B41 :: GLenum

pattern GL_POLYGON_SMOOTH_HINT = 0x0C53 :: GLenum

pattern GL_POLYGON_STIPPLE = 0x0B42 :: GLenum

pattern GL_POLYGON_STIPPLE_BIT = 0x00000010 :: GLbitfield

pattern GL_POLYGON_TOKEN = 0x0703 :: GLenum

pattern GL_POSITION = 0x1203 :: GLenum

pattern GL_POST_COLOR_MATRIX_ALPHA_BIAS = 0x80BB :: GLenum

pattern GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = 0x80BB :: GLenum

pattern GL_POST_COLOR_MATRIX_ALPHA_SCALE = 0x80B7 :: GLenum

pattern GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = 0x80B7 :: GLenum

pattern GL_POST_COLOR_MATRIX_BLUE_BIAS = 0x80BA :: GLenum

pattern GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = 0x80BA :: GLenum

pattern GL_POST_COLOR_MATRIX_BLUE_SCALE = 0x80B6 :: GLenum

pattern GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = 0x80B6 :: GLenum

pattern GL_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D2 :: GLenum

pattern GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = 0x80D2 :: GLenum

pattern GL_POST_COLOR_MATRIX_GREEN_BIAS = 0x80B9 :: GLenum

pattern GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = 0x80B9 :: GLenum

pattern GL_POST_COLOR_MATRIX_GREEN_SCALE = 0x80B5 :: GLenum

pattern GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = 0x80B5 :: GLenum

pattern GL_POST_COLOR_MATRIX_RED_BIAS = 0x80B8 :: GLenum

pattern GL_POST_COLOR_MATRIX_RED_BIAS_SGI = 0x80B8 :: GLenum

pattern GL_POST_COLOR_MATRIX_RED_SCALE = 0x80B4 :: GLenum

pattern GL_POST_COLOR_MATRIX_RED_SCALE_SGI = 0x80B4 :: GLenum

pattern GL_POST_CONVOLUTION_ALPHA_BIAS = 0x8023 :: GLenum

pattern GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = 0x8023 :: GLenum

pattern GL_POST_CONVOLUTION_ALPHA_SCALE = 0x801F :: GLenum

pattern GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = 0x801F :: GLenum

pattern GL_POST_CONVOLUTION_BLUE_BIAS = 0x8022 :: GLenum

pattern GL_POST_CONVOLUTION_BLUE_BIAS_EXT = 0x8022 :: GLenum

pattern GL_POST_CONVOLUTION_BLUE_SCALE = 0x801E :: GLenum

pattern GL_POST_CONVOLUTION_BLUE_SCALE_EXT = 0x801E :: GLenum

pattern GL_POST_CONVOLUTION_COLOR_TABLE = 0x80D1 :: GLenum

pattern GL_POST_CONVOLUTION_COLOR_TABLE_SGI = 0x80D1 :: GLenum

pattern GL_POST_CONVOLUTION_GREEN_BIAS = 0x8021 :: GLenum

pattern GL_POST_CONVOLUTION_GREEN_BIAS_EXT = 0x8021 :: GLenum

pattern GL_POST_CONVOLUTION_GREEN_SCALE = 0x801D :: GLenum

pattern GL_POST_CONVOLUTION_GREEN_SCALE_EXT = 0x801D :: GLenum

pattern GL_POST_CONVOLUTION_RED_BIAS = 0x8020 :: GLenum

pattern GL_POST_CONVOLUTION_RED_BIAS_EXT = 0x8020 :: GLenum

pattern GL_POST_CONVOLUTION_RED_SCALE = 0x801C :: GLenum

pattern GL_POST_CONVOLUTION_RED_SCALE_EXT = 0x801C :: GLenum

pattern GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = 0x8162 :: GLenum

pattern GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX = 0x817B :: GLenum

pattern GL_POST_TEXTURE_FILTER_BIAS_SGIX = 0x8179 :: GLenum

pattern GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX = 0x817C :: GLenum

pattern GL_POST_TEXTURE_FILTER_SCALE_SGIX = 0x817A :: GLenum

pattern GL_PREFER_DOUBLEBUFFER_HINT_PGI = 0x1A1F8 :: GLenum

pattern GL_PRESENT_DURATION_NV = 0x8E2B :: GLenum

pattern GL_PRESENT_TIME_NV = 0x8E2A :: GLenum

pattern GL_PRESERVE_ATI = 0x8762 :: GLenum

pattern GL_PREVIOUS = 0x8578 :: GLenum

pattern GL_PREVIOUS_ARB = 0x8578 :: GLenum

pattern GL_PREVIOUS_EXT = 0x8578 :: GLenum

pattern GL_PREVIOUS_TEXTURE_INPUT_NV = 0x86E4 :: GLenum

pattern GL_PRIMARY_COLOR = 0x8577 :: GLenum

pattern GL_PRIMARY_COLOR_ARB = 0x8577 :: GLenum

pattern GL_PRIMARY_COLOR_EXT = 0x8577 :: GLenum

pattern GL_PRIMARY_COLOR_NV = 0x852C :: GLenum

pattern GL_PRIMITIVES_GENERATED = 0x8C87 :: GLenum

pattern GL_PRIMITIVES_GENERATED_EXT = 0x8C87 :: GLenum

pattern GL_PRIMITIVES_GENERATED_NV = 0x8C87 :: GLenum

pattern GL_PRIMITIVES_GENERATED_OES = 0x8C87 :: GLenum

pattern GL_PRIMITIVES_SUBMITTED_ARB = 0x82EF :: GLenum

pattern GL_PRIMITIVE_BOUNDING_BOX = 0x92BE :: GLenum

pattern GL_PRIMITIVE_BOUNDING_BOX_ARB = 0x92BE :: GLenum

pattern GL_PRIMITIVE_BOUNDING_BOX_EXT = 0x92BE :: GLenum

pattern GL_PRIMITIVE_BOUNDING_BOX_OES = 0x92BE :: GLenum

pattern GL_PRIMITIVE_ID_NV = 0x8C7C :: GLenum

pattern GL_PRIMITIVE_RESTART = 0x8F9D :: GLenum

pattern GL_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69 :: GLenum

pattern GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 0x8221 :: GLenum

pattern GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED_OES = 0x8221 :: GLenum

pattern GL_PRIMITIVE_RESTART_INDEX = 0x8F9E :: GLenum

pattern GL_PRIMITIVE_RESTART_INDEX_NV = 0x8559 :: GLenum

pattern GL_PRIMITIVE_RESTART_NV = 0x8558 :: GLenum

pattern GL_PROGRAM = 0x82E2 :: GLenum

pattern GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB = 0x9341 :: GLenum

pattern GL_PROGRAMMABLE_SAMPLE_LOCATION_NV = 0x9341 :: GLenum

pattern GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB = 0x9340 :: GLenum

pattern GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV = 0x9340 :: GLenum

pattern GL_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B0 :: GLenum

pattern GL_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x8805 :: GLenum

pattern GL_PROGRAM_ATTRIBS_ARB = 0x88AC :: GLenum

pattern GL_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8906 :: GLenum

pattern GL_PROGRAM_BINARY_ANGLE = 0x93A6 :: GLenum

pattern GL_PROGRAM_BINARY_FORMATS = 0x87FF :: GLenum

pattern GL_PROGRAM_BINARY_FORMATS_OES = 0x87FF :: GLenum

pattern GL_PROGRAM_BINARY_LENGTH = 0x8741 :: GLenum

pattern GL_PROGRAM_BINARY_LENGTH_OES = 0x8741 :: GLenum

pattern GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 0x8257 :: GLenum

pattern GL_PROGRAM_BINDING_ARB = 0x8677 :: GLenum

pattern GL_PROGRAM_ERROR_POSITION_ARB = 0x864B :: GLenum

pattern GL_PROGRAM_ERROR_POSITION_NV = 0x864B :: GLenum

pattern GL_PROGRAM_ERROR_STRING_ARB = 0x8874 :: GLenum

pattern GL_PROGRAM_ERROR_STRING_NV = 0x8874 :: GLenum

pattern GL_PROGRAM_FORMAT_ARB = 0x8876 :: GLenum

pattern GL_PROGRAM_FORMAT_ASCII_ARB = 0x8875 :: GLenum

pattern GL_PROGRAM_INPUT = 0x92E3 :: GLenum

pattern GL_PROGRAM_INSTRUCTIONS_ARB = 0x88A0 :: GLenum

pattern GL_PROGRAM_KHR = 0x82E2 :: GLenum

pattern GL_PROGRAM_LENGTH_ARB = 0x8627 :: GLenum

pattern GL_PROGRAM_LENGTH_NV = 0x8627 :: GLenum

pattern GL_PROGRAM_MATRIX_EXT = 0x8E2D :: GLenum

pattern GL_PROGRAM_MATRIX_STACK_DEPTH_EXT = 0x8E2F :: GLenum

pattern GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B2 :: GLenum

pattern GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x8808 :: GLenum

pattern GL_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AE :: GLenum

pattern GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A2 :: GLenum

pattern GL_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AA :: GLenum

pattern GL_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A6 :: GLenum

pattern GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x880A :: GLenum

pattern GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x8809 :: GLenum

pattern GL_PROGRAM_OBJECT_ARB = 0x8B40 :: GLenum

pattern GL_PROGRAM_OBJECT_EXT = 0x8B40 :: GLenum

pattern GL_PROGRAM_OUTPUT = 0x92E4 :: GLenum

pattern GL_PROGRAM_PARAMETERS_ARB = 0x88A8 :: GLenum

pattern GL_PROGRAM_PARAMETER_NV = 0x8644 :: GLenum

pattern GL_PROGRAM_PIPELINE = 0x82E4 :: GLenum

pattern GL_PROGRAM_PIPELINE_BINDING = 0x825A :: GLenum

pattern GL_PROGRAM_PIPELINE_BINDING_EXT = 0x825A :: GLenum

pattern GL_PROGRAM_PIPELINE_KHR = 0x82E4 :: GLenum

pattern GL_PROGRAM_PIPELINE_OBJECT_EXT = 0x8A4F :: GLenum

pattern GL_PROGRAM_POINT_SIZE = 0x8642 :: GLenum

pattern GL_PROGRAM_POINT_SIZE_ARB = 0x8642 :: GLenum

pattern GL_PROGRAM_POINT_SIZE_EXT = 0x8642 :: GLenum

pattern GL_PROGRAM_RESIDENT_NV = 0x8647 :: GLenum

pattern GL_PROGRAM_RESULT_COMPONENTS_NV = 0x8907 :: GLenum

pattern GL_PROGRAM_SEPARABLE = 0x8258 :: GLenum

pattern GL_PROGRAM_SEPARABLE_EXT = 0x8258 :: GLenum

pattern GL_PROGRAM_STRING_ARB = 0x8628 :: GLenum

pattern GL_PROGRAM_STRING_NV = 0x8628 :: GLenum

pattern GL_PROGRAM_TARGET_NV = 0x8646 :: GLenum

pattern GL_PROGRAM_TEMPORARIES_ARB = 0x88A4 :: GLenum

pattern GL_PROGRAM_TEX_INDIRECTIONS_ARB = 0x8807 :: GLenum

pattern GL_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x8806 :: GLenum

pattern GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = 0x88B6 :: GLenum

pattern GL_PROJECTION = 0x1701 :: GLenum

pattern GL_PROJECTION_MATRIX = 0x0BA7 :: GLenum

pattern GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES = 0x898E :: GLenum

pattern GL_PROJECTION_STACK_DEPTH = 0x0BA4 :: GLenum

pattern GL_PROVOKING_VERTEX = 0x8E4F :: GLenum

pattern GL_PROVOKING_VERTEX_EXT = 0x8E4F :: GLenum

pattern GL_PROXY_COLOR_TABLE = 0x80D3 :: GLenum

pattern GL_PROXY_COLOR_TABLE_SGI = 0x80D3 :: GLenum

pattern GL_PROXY_HISTOGRAM = 0x8025 :: GLenum

pattern GL_PROXY_HISTOGRAM_EXT = 0x8025 :: GLenum

pattern GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5 :: GLenum

pattern GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = 0x80D5 :: GLenum

pattern GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = 0x80D4 :: GLenum

pattern GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = 0x80D4 :: GLenum

pattern GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = 0x8163 :: GLenum

pattern GL_PROXY_TEXTURE_1D = 0x8063 :: GLenum

pattern GL_PROXY_TEXTURE_1D_ARRAY = 0x8C19 :: GLenum

pattern GL_PROXY_TEXTURE_1D_ARRAY_EXT = 0x8C19 :: GLenum

pattern GL_PROXY_TEXTURE_1D_EXT = 0x8063 :: GLenum

pattern GL_PROXY_TEXTURE_1D_STACK_MESAX = 0x875B :: GLenum

pattern GL_PROXY_TEXTURE_2D = 0x8064 :: GLenum

pattern GL_PROXY_TEXTURE_2D_ARRAY = 0x8C1B :: GLenum

pattern GL_PROXY_TEXTURE_2D_ARRAY_EXT = 0x8C1B :: GLenum

pattern GL_PROXY_TEXTURE_2D_EXT = 0x8064 :: GLenum

pattern GL_PROXY_TEXTURE_2D_MULTISAMPLE = 0x9101 :: GLenum

pattern GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9103 :: GLenum

pattern GL_PROXY_TEXTURE_2D_STACK_MESAX = 0x875C :: GLenum

pattern GL_PROXY_TEXTURE_3D = 0x8070 :: GLenum

pattern GL_PROXY_TEXTURE_3D_EXT = 0x8070 :: GLenum

pattern GL_PROXY_TEXTURE_4D_SGIS = 0x8135 :: GLenum

pattern GL_PROXY_TEXTURE_COLOR_TABLE_SGI = 0x80BD :: GLenum

pattern GL_PROXY_TEXTURE_CUBE_MAP = 0x851B :: GLenum

pattern GL_PROXY_TEXTURE_CUBE_MAP_ARB = 0x851B :: GLenum

pattern GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 0x900B :: GLenum

pattern GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x900B :: GLenum

pattern GL_PROXY_TEXTURE_CUBE_MAP_EXT = 0x851B :: GLenum

pattern GL_PROXY_TEXTURE_RECTANGLE = 0x84F7 :: GLenum

pattern GL_PROXY_TEXTURE_RECTANGLE_ARB = 0x84F7 :: GLenum

pattern GL_PROXY_TEXTURE_RECTANGLE_NV = 0x84F7 :: GLenum

pattern GL_PURGEABLE_APPLE = 0x8A1D :: GLenum

pattern GL_PURGED_CONTEXT_RESET_NV = 0x92BB :: GLenum

pattern GL_Q = 0x2003 :: GLenum

pattern GL_QUADRATIC_ATTENUATION = 0x1209 :: GLenum

pattern GL_QUADRATIC_CURVE_TO_NV = 0x0A :: GLubyte

pattern GL_QUADS = 0x0007 :: GLenum

pattern GL_QUADS_EXT = 0x0007 :: GLenum

pattern GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 0x8E4C :: GLenum

pattern GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT = 0x8E4C :: GLenum

pattern GL_QUADS_OES = 0x0007 :: GLenum

pattern GL_QUAD_ALPHA4_SGIS = 0x811E :: GLenum

pattern GL_QUAD_ALPHA8_SGIS = 0x811F :: GLenum

pattern GL_QUAD_INTENSITY4_SGIS = 0x8122 :: GLenum

pattern GL_QUAD_INTENSITY8_SGIS = 0x8123 :: GLenum

pattern GL_QUAD_LUMINANCE4_SGIS = 0x8120 :: GLenum

pattern GL_QUAD_LUMINANCE8_SGIS = 0x8121 :: GLenum

pattern GL_QUAD_MESH_SUN = 0x8614 :: GLenum

pattern GL_QUAD_STRIP = 0x0008 :: GLenum

pattern GL_QUAD_TEXTURE_SELECT_SGIS = 0x8125 :: GLenum

pattern GL_QUARTER_BIT_ATI = 0x00000010 :: GLbitfield

pattern GL_QUERY = 0x82E3 :: GLenum

pattern GL_QUERY_ALL_EVENT_BITS_AMD = 0xFFFFFFFF :: GLuint

pattern GL_QUERY_BUFFER = 0x9192 :: GLenum

pattern GL_QUERY_BUFFER_AMD = 0x9192 :: GLenum

pattern GL_QUERY_BUFFER_BARRIER_BIT = 0x00008000 :: GLbitfield

pattern GL_QUERY_BUFFER_BINDING = 0x9193 :: GLenum

pattern GL_QUERY_BUFFER_BINDING_AMD = 0x9193 :: GLenum

pattern GL_QUERY_BY_REGION_NO_WAIT = 0x8E16 :: GLenum

pattern GL_QUERY_BY_REGION_NO_WAIT_INVERTED = 0x8E1A :: GLenum

pattern GL_QUERY_BY_REGION_NO_WAIT_NV = 0x8E16 :: GLenum

pattern GL_QUERY_BY_REGION_WAIT = 0x8E15 :: GLenum

pattern GL_QUERY_BY_REGION_WAIT_INVERTED = 0x8E19 :: GLenum

pattern GL_QUERY_BY_REGION_WAIT_NV = 0x8E15 :: GLenum

pattern GL_QUERY_COUNTER_BITS = 0x8864 :: GLenum

pattern GL_QUERY_COUNTER_BITS_ARB = 0x8864 :: GLenum

pattern GL_QUERY_COUNTER_BITS_EXT = 0x8864 :: GLenum

pattern GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD = 0x00000008 :: GLuint

pattern GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD = 0x00000002 :: GLuint

pattern GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD = 0x00000001 :: GLuint

pattern GL_QUERY_KHR = 0x82E3 :: GLenum

pattern GL_QUERY_NO_WAIT = 0x8E14 :: GLenum

pattern GL_QUERY_NO_WAIT_INVERTED = 0x8E18 :: GLenum

pattern GL_QUERY_NO_WAIT_NV = 0x8E14 :: GLenum

pattern GL_QUERY_OBJECT_AMD = 0x9153 :: GLenum

pattern GL_QUERY_OBJECT_EXT = 0x9153 :: GLenum

pattern GL_QUERY_RESULT = 0x8866 :: GLenum

pattern GL_QUERY_RESULT_ARB = 0x8866 :: GLenum

pattern GL_QUERY_RESULT_AVAILABLE = 0x8867 :: GLenum

pattern GL_QUERY_RESULT_AVAILABLE_ARB = 0x8867 :: GLenum

pattern GL_QUERY_RESULT_AVAILABLE_EXT = 0x8867 :: GLenum

pattern GL_QUERY_RESULT_EXT = 0x8866 :: GLenum

pattern GL_QUERY_RESULT_NO_WAIT = 0x9194 :: GLenum

pattern GL_QUERY_RESULT_NO_WAIT_AMD = 0x9194 :: GLenum

pattern GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD = 0x00000004 :: GLuint

pattern GL_QUERY_TARGET = 0x82EA :: GLenum

pattern GL_QUERY_WAIT = 0x8E13 :: GLenum

pattern GL_QUERY_WAIT_INVERTED = 0x8E17 :: GLenum

pattern GL_QUERY_WAIT_NV = 0x8E13 :: GLenum

pattern GL_R = 0x2002 :: GLenum

pattern GL_R11F_G11F_B10F = 0x8C3A :: GLenum

pattern GL_R11F_G11F_B10F_APPLE = 0x8C3A :: GLenum

pattern GL_R11F_G11F_B10F_EXT = 0x8C3A :: GLenum

pattern GL_R16 = 0x822A :: GLenum

pattern GL_R16F = 0x822D :: GLenum

pattern GL_R16F_EXT = 0x822D :: GLenum

pattern GL_R16I = 0x8233 :: GLenum

pattern GL_R16UI = 0x8234 :: GLenum

pattern GL_R16_EXT = 0x822A :: GLenum

pattern GL_R16_SNORM = 0x8F98 :: GLenum

pattern GL_R16_SNORM_EXT = 0x8F98 :: GLenum

pattern GL_R1UI_C3F_V3F_SUN = 0x85C6 :: GLenum

pattern GL_R1UI_C4F_N3F_V3F_SUN = 0x85C8 :: GLenum

pattern GL_R1UI_C4UB_V3F_SUN = 0x85C5 :: GLenum

pattern GL_R1UI_N3F_V3F_SUN = 0x85C7 :: GLenum

pattern GL_R1UI_T2F_C4F_N3F_V3F_SUN = 0x85CB :: GLenum

pattern GL_R1UI_T2F_N3F_V3F_SUN = 0x85CA :: GLenum

pattern GL_R1UI_T2F_V3F_SUN = 0x85C9 :: GLenum

pattern GL_R1UI_V3F_SUN = 0x85C4 :: GLenum

pattern GL_R32F = 0x822E :: GLenum

pattern GL_R32F_EXT = 0x822E :: GLenum

pattern GL_R32I = 0x8235 :: GLenum

pattern GL_R32UI = 0x8236 :: GLenum

pattern GL_R3_G3_B2 = 0x2A10 :: GLenum

pattern GL_R8 = 0x8229 :: GLenum

pattern GL_R8I = 0x8231 :: GLenum

pattern GL_R8UI = 0x8232 :: GLenum

pattern GL_R8_EXT = 0x8229 :: GLenum

pattern GL_R8_SNORM = 0x8F94 :: GLenum

pattern GL_RASTERIZER_DISCARD = 0x8C89 :: GLenum

pattern GL_RASTERIZER_DISCARD_EXT = 0x8C89 :: GLenum

pattern GL_RASTERIZER_DISCARD_NV = 0x8C89 :: GLenum

pattern GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT = 0x932A :: GLenum

pattern GL_RASTER_MULTISAMPLE_EXT = 0x9327 :: GLenum

pattern GL_RASTER_POSITION_UNCLIPPED_IBM = 0x19262 :: GLenum

pattern GL_RASTER_SAMPLES_EXT = 0x9328 :: GLenum

pattern GL_READ_BUFFER = 0x0C02 :: GLenum

pattern GL_READ_BUFFER_EXT = 0x0C02 :: GLenum

pattern GL_READ_BUFFER_NV = 0x0C02 :: GLenum

pattern GL_READ_FRAMEBUFFER = 0x8CA8 :: GLenum

pattern GL_READ_FRAMEBUFFER_ANGLE = 0x8CA8 :: GLenum

pattern GL_READ_FRAMEBUFFER_APPLE = 0x8CA8 :: GLenum

pattern GL_READ_FRAMEBUFFER_BINDING = 0x8CAA :: GLenum

pattern GL_READ_FRAMEBUFFER_BINDING_ANGLE = 0x8CAA :: GLenum

pattern GL_READ_FRAMEBUFFER_BINDING_APPLE = 0x8CAA :: GLenum

pattern GL_READ_FRAMEBUFFER_BINDING_EXT = 0x8CAA :: GLenum

pattern GL_READ_FRAMEBUFFER_BINDING_NV = 0x8CAA :: GLenum

pattern GL_READ_FRAMEBUFFER_EXT = 0x8CA8 :: GLenum

pattern GL_READ_FRAMEBUFFER_NV = 0x8CA8 :: GLenum

pattern GL_READ_ONLY = 0x88B8 :: GLenum

pattern GL_READ_ONLY_ARB = 0x88B8 :: GLenum

pattern GL_READ_PIXELS = 0x828C :: GLenum

pattern GL_READ_PIXELS_FORMAT = 0x828D :: GLenum

pattern GL_READ_PIXELS_TYPE = 0x828E :: GLenum

pattern GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = 0x887B :: GLenum

pattern GL_READ_PIXEL_DATA_RANGE_NV = 0x8879 :: GLenum

pattern GL_READ_PIXEL_DATA_RANGE_POINTER_NV = 0x887D :: GLenum

pattern GL_READ_WRITE = 0x88BA :: GLenum

pattern GL_READ_WRITE_ARB = 0x88BA :: GLenum

pattern GL_RECIP_ADD_SIGNED_ALPHA_IMG = 0x8C05 :: GLenum

pattern GL_RECLAIM_MEMORY_HINT_PGI = 0x1A1FE :: GLenum

pattern GL_RECT_NV = 0xF6 :: GLubyte

pattern GL_RED = 0x1903 :: GLenum

pattern GL_REDUCE = 0x8016 :: GLenum

pattern GL_REDUCE_EXT = 0x8016 :: GLenum

pattern GL_RED_BIAS = 0x0D15 :: GLenum

pattern GL_RED_BITS = 0x0D52 :: GLenum

pattern GL_RED_BIT_ATI = 0x00000001 :: GLbitfield

pattern GL_RED_EXT = 0x1903 :: GLenum

pattern GL_RED_INTEGER = 0x8D94 :: GLenum

pattern GL_RED_INTEGER_EXT = 0x8D94 :: GLenum

pattern GL_RED_MAX_CLAMP_INGR = 0x8564 :: GLenum

pattern GL_RED_MIN_CLAMP_INGR = 0x8560 :: GLenum

pattern GL_RED_NV = 0x1903 :: GLenum

pattern GL_RED_SCALE = 0x0D14 :: GLenum

pattern GL_RED_SNORM = 0x8F90 :: GLenum

pattern GL_REFERENCED_BY_COMPUTE_SHADER = 0x930B :: GLenum

pattern GL_REFERENCED_BY_FRAGMENT_SHADER = 0x930A :: GLenum

pattern GL_REFERENCED_BY_GEOMETRY_SHADER = 0x9309 :: GLenum

pattern GL_REFERENCED_BY_GEOMETRY_SHADER_EXT = 0x9309 :: GLenum

pattern GL_REFERENCED_BY_GEOMETRY_SHADER_OES = 0x9309 :: GLenum

pattern GL_REFERENCED_BY_TESS_CONTROL_SHADER = 0x9307 :: GLenum

pattern GL_REFERENCED_BY_TESS_CONTROL_SHADER_EXT = 0x9307 :: GLenum

pattern GL_REFERENCED_BY_TESS_CONTROL_SHADER_OES = 0x9307 :: GLenum

pattern GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x9308 :: GLenum

pattern GL_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT = 0x9308 :: GLenum

pattern GL_REFERENCED_BY_TESS_EVALUATION_SHADER_OES = 0x9308 :: GLenum

pattern GL_REFERENCED_BY_VERTEX_SHADER = 0x9306 :: GLenum

pattern GL_REFERENCE_PLANE_EQUATION_SGIX = 0x817E :: GLenum

pattern GL_REFERENCE_PLANE_SGIX = 0x817D :: GLenum

pattern GL_REFLECTION_MAP = 0x8512 :: GLenum

pattern GL_REFLECTION_MAP_ARB = 0x8512 :: GLenum

pattern GL_REFLECTION_MAP_EXT = 0x8512 :: GLenum

pattern GL_REFLECTION_MAP_NV = 0x8512 :: GLenum

pattern GL_REFLECTION_MAP_OES = 0x8512 :: GLenum

pattern GL_REGISTER_COMBINERS_NV = 0x8522 :: GLenum

pattern GL_REG_0_ATI = 0x8921 :: GLenum

pattern GL_REG_10_ATI = 0x892B :: GLenum

pattern GL_REG_11_ATI = 0x892C :: GLenum

pattern GL_REG_12_ATI = 0x892D :: GLenum

pattern GL_REG_13_ATI = 0x892E :: GLenum

pattern GL_REG_14_ATI = 0x892F :: GLenum

pattern GL_REG_15_ATI = 0x8930 :: GLenum

pattern GL_REG_16_ATI = 0x8931 :: GLenum

pattern GL_REG_17_ATI = 0x8932 :: GLenum

pattern GL_REG_18_ATI = 0x8933 :: GLenum

pattern GL_REG_19_ATI = 0x8934 :: GLenum

pattern GL_REG_1_ATI = 0x8922 :: GLenum

pattern GL_REG_20_ATI = 0x8935 :: GLenum

pattern GL_REG_21_ATI = 0x8936 :: GLenum

pattern GL_REG_22_ATI = 0x8937 :: GLenum

pattern GL_REG_23_ATI = 0x8938 :: GLenum

pattern GL_REG_24_ATI = 0x8939 :: GLenum

pattern GL_REG_25_ATI = 0x893A :: GLenum

pattern GL_REG_26_ATI = 0x893B :: GLenum

pattern GL_REG_27_ATI = 0x893C :: GLenum

pattern GL_REG_28_ATI = 0x893D :: GLenum

pattern GL_REG_29_ATI = 0x893E :: GLenum

pattern GL_REG_2_ATI = 0x8923 :: GLenum

pattern GL_REG_30_ATI = 0x893F :: GLenum

pattern GL_REG_31_ATI = 0x8940 :: GLenum

pattern GL_REG_3_ATI = 0x8924 :: GLenum

pattern GL_REG_4_ATI = 0x8925 :: GLenum

pattern GL_REG_5_ATI = 0x8926 :: GLenum

pattern GL_REG_6_ATI = 0x8927 :: GLenum

pattern GL_REG_7_ATI = 0x8928 :: GLenum

pattern GL_REG_8_ATI = 0x8929 :: GLenum

pattern GL_REG_9_ATI = 0x892A :: GLenum

pattern GL_RELATIVE_ARC_TO_NV = 0xFF :: GLubyte

pattern GL_RELATIVE_CONIC_CURVE_TO_NV = 0x1B :: GLubyte

pattern GL_RELATIVE_CUBIC_CURVE_TO_NV = 0x0D :: GLubyte

pattern GL_RELATIVE_HORIZONTAL_LINE_TO_NV = 0x07 :: GLubyte

pattern GL_RELATIVE_LARGE_CCW_ARC_TO_NV = 0x17 :: GLubyte

pattern GL_RELATIVE_LARGE_CW_ARC_TO_NV = 0x19 :: GLubyte

pattern GL_RELATIVE_LINE_TO_NV = 0x05 :: GLubyte

pattern GL_RELATIVE_MOVE_TO_NV = 0x03 :: GLubyte

pattern GL_RELATIVE_QUADRATIC_CURVE_TO_NV = 0x0B :: GLubyte

pattern GL_RELATIVE_RECT_NV = 0xF7 :: GLubyte

pattern GL_RELATIVE_ROUNDED_RECT2_NV = 0xEB :: GLubyte

pattern GL_RELATIVE_ROUNDED_RECT4_NV = 0xED :: GLubyte

pattern GL_RELATIVE_ROUNDED_RECT8_NV = 0xEF :: GLubyte

pattern GL_RELATIVE_ROUNDED_RECT_NV = 0xE9 :: GLubyte

pattern GL_RELATIVE_SMALL_CCW_ARC_TO_NV = 0x13 :: GLubyte

pattern GL_RELATIVE_SMALL_CW_ARC_TO_NV = 0x15 :: GLubyte

pattern GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = 0x11 :: GLubyte

pattern GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0F :: GLubyte

pattern GL_RELATIVE_VERTICAL_LINE_TO_NV = 0x09 :: GLubyte

pattern GL_RELEASED_APPLE = 0x8A19 :: GLenum

pattern GL_RENDER = 0x1C00 :: GLenum

pattern GL_RENDERBUFFER = 0x8D41 :: GLenum

pattern GL_RENDERBUFFER_ALPHA_SIZE = 0x8D53 :: GLenum

pattern GL_RENDERBUFFER_ALPHA_SIZE_EXT = 0x8D53 :: GLenum

pattern GL_RENDERBUFFER_ALPHA_SIZE_OES = 0x8D53 :: GLenum

pattern GL_RENDERBUFFER_BINDING = 0x8CA7 :: GLenum

pattern GL_RENDERBUFFER_BINDING_ANGLE = 0x8CA7 :: GLenum

pattern GL_RENDERBUFFER_BINDING_EXT = 0x8CA7 :: GLenum

pattern GL_RENDERBUFFER_BINDING_OES = 0x8CA7 :: GLenum

pattern GL_RENDERBUFFER_BLUE_SIZE = 0x8D52 :: GLenum

pattern GL_RENDERBUFFER_BLUE_SIZE_EXT = 0x8D52 :: GLenum

pattern GL_RENDERBUFFER_BLUE_SIZE_OES = 0x8D52 :: GLenum

pattern GL_RENDERBUFFER_COLOR_SAMPLES_NV = 0x8E10 :: GLenum

pattern GL_RENDERBUFFER_COVERAGE_SAMPLES_NV = 0x8CAB :: GLenum

pattern GL_RENDERBUFFER_DEPTH_SIZE = 0x8D54 :: GLenum

pattern GL_RENDERBUFFER_DEPTH_SIZE_EXT = 0x8D54 :: GLenum

pattern GL_RENDERBUFFER_DEPTH_SIZE_OES = 0x8D54 :: GLenum

pattern GL_RENDERBUFFER_EXT = 0x8D41 :: GLenum

pattern GL_RENDERBUFFER_FREE_MEMORY_ATI = 0x87FD :: GLenum

pattern GL_RENDERBUFFER_GREEN_SIZE = 0x8D51 :: GLenum

pattern GL_RENDERBUFFER_GREEN_SIZE_EXT = 0x8D51 :: GLenum

pattern GL_RENDERBUFFER_GREEN_SIZE_OES = 0x8D51 :: GLenum

pattern GL_RENDERBUFFER_HEIGHT = 0x8D43 :: GLenum

pattern GL_RENDERBUFFER_HEIGHT_EXT = 0x8D43 :: GLenum

pattern GL_RENDERBUFFER_HEIGHT_OES = 0x8D43 :: GLenum

pattern GL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44 :: GLenum

pattern GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = 0x8D44 :: GLenum

pattern GL_RENDERBUFFER_INTERNAL_FORMAT_OES = 0x8D44 :: GLenum

pattern GL_RENDERBUFFER_OES = 0x8D41 :: GLenum

pattern GL_RENDERBUFFER_RED_SIZE = 0x8D50 :: GLenum

pattern GL_RENDERBUFFER_RED_SIZE_EXT = 0x8D50 :: GLenum

pattern GL_RENDERBUFFER_RED_SIZE_OES = 0x8D50 :: GLenum

pattern GL_RENDERBUFFER_SAMPLES = 0x8CAB :: GLenum

pattern GL_RENDERBUFFER_SAMPLES_ANGLE = 0x8CAB :: GLenum

pattern GL_RENDERBUFFER_SAMPLES_APPLE = 0x8CAB :: GLenum

pattern GL_RENDERBUFFER_SAMPLES_EXT = 0x8CAB :: GLenum

pattern GL_RENDERBUFFER_SAMPLES_IMG = 0x9133 :: GLenum

pattern GL_RENDERBUFFER_SAMPLES_NV = 0x8CAB :: GLenum

pattern GL_RENDERBUFFER_STENCIL_SIZE = 0x8D55 :: GLenum

pattern GL_RENDERBUFFER_STENCIL_SIZE_EXT = 0x8D55 :: GLenum

pattern GL_RENDERBUFFER_STENCIL_SIZE_OES = 0x8D55 :: GLenum

pattern GL_RENDERBUFFER_WIDTH = 0x8D42 :: GLenum

pattern GL_RENDERBUFFER_WIDTH_EXT = 0x8D42 :: GLenum

pattern GL_RENDERBUFFER_WIDTH_OES = 0x8D42 :: GLenum

pattern GL_RENDERER = 0x1F01 :: GLenum

pattern GL_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM = 0x8FB3 :: GLenum

pattern GL_RENDER_MODE = 0x0C40 :: GLenum

pattern GL_REPEAT = 0x2901 :: GLenum

pattern GL_REPLACE = 0x1E01 :: GLenum

pattern GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN = 0x85C3 :: GLenum

pattern GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = 0x85C2 :: GLenum

pattern GL_REPLACEMENT_CODE_ARRAY_SUN = 0x85C0 :: GLenum

pattern GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN = 0x85C1 :: GLenum

pattern GL_REPLACEMENT_CODE_SUN = 0x81D8 :: GLenum

pattern GL_REPLACE_EXT = 0x8062 :: GLenum

pattern GL_REPLACE_MIDDLE_SUN = 0x0002 :: GLenum

pattern GL_REPLACE_OLDEST_SUN = 0x0003 :: GLenum

pattern GL_REPLACE_VALUE_AMD = 0x874B :: GLenum

pattern GL_REPLICATE_BORDER = 0x8153 :: GLenum

pattern GL_REPLICATE_BORDER_HP = 0x8153 :: GLenum

pattern GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES = 0x8D68 :: GLenum

pattern GL_RESAMPLE_AVERAGE_OML = 0x8988 :: GLenum

pattern GL_RESAMPLE_DECIMATE_OML = 0x8989 :: GLenum

pattern GL_RESAMPLE_DECIMATE_SGIX = 0x8430 :: GLenum

pattern GL_RESAMPLE_REPLICATE_OML = 0x8986 :: GLenum

pattern GL_RESAMPLE_REPLICATE_SGIX = 0x8433 :: GLenum

pattern GL_RESAMPLE_ZERO_FILL_OML = 0x8987 :: GLenum

pattern GL_RESAMPLE_ZERO_FILL_SGIX = 0x8434 :: GLenum

pattern GL_RESCALE_NORMAL = 0x803A :: GLenum

pattern GL_RESCALE_NORMAL_EXT = 0x803A :: GLenum

pattern GL_RESET_NOTIFICATION_STRATEGY = 0x8256 :: GLenum

pattern GL_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256 :: GLenum

pattern GL_RESET_NOTIFICATION_STRATEGY_EXT = 0x8256 :: GLenum

pattern GL_RESET_NOTIFICATION_STRATEGY_KHR = 0x8256 :: GLenum

pattern GL_RESTART_PATH_NV = 0xF0 :: GLubyte

pattern GL_RESTART_SUN = 0x0001 :: GLenum

pattern GL_RETAINED_APPLE = 0x8A1B :: GLenum

pattern GL_RETURN = 0x0102 :: GLenum

pattern GL_RG = 0x8227 :: GLenum

pattern GL_RG16 = 0x822C :: GLenum

pattern GL_RG16F = 0x822F :: GLenum

pattern GL_RG16F_EXT = 0x822F :: GLenum

pattern GL_RG16I = 0x8239 :: GLenum

pattern GL_RG16UI = 0x823A :: GLenum

pattern GL_RG16_EXT = 0x822C :: GLenum

pattern GL_RG16_SNORM = 0x8F99 :: GLenum

pattern GL_RG16_SNORM_EXT = 0x8F99 :: GLenum

pattern GL_RG32F = 0x8230 :: GLenum

pattern GL_RG32F_EXT = 0x8230 :: GLenum

pattern GL_RG32I = 0x823B :: GLenum

pattern GL_RG32UI = 0x823C :: GLenum

pattern GL_RG8 = 0x822B :: GLenum

pattern GL_RG8I = 0x8237 :: GLenum

pattern GL_RG8UI = 0x8238 :: GLenum

pattern GL_RG8_EXT = 0x822B :: GLenum

pattern GL_RG8_SNORM = 0x8F95 :: GLenum

pattern GL_RGB = 0x1907 :: GLenum

pattern GL_RGB10 = 0x8052 :: GLenum

pattern GL_RGB10_A2 = 0x8059 :: GLenum

pattern GL_RGB10_A2UI = 0x906F :: GLenum

pattern GL_RGB10_A2_EXT = 0x8059 :: GLenum

pattern GL_RGB10_EXT = 0x8052 :: GLenum

pattern GL_RGB12 = 0x8053 :: GLenum

pattern GL_RGB12_EXT = 0x8053 :: GLenum

pattern GL_RGB16 = 0x8054 :: GLenum

pattern GL_RGB16F = 0x881B :: GLenum

pattern GL_RGB16F_ARB = 0x881B :: GLenum

pattern GL_RGB16F_EXT = 0x881B :: GLenum

pattern GL_RGB16I = 0x8D89 :: GLenum

pattern GL_RGB16I_EXT = 0x8D89 :: GLenum

pattern GL_RGB16UI = 0x8D77 :: GLenum

pattern GL_RGB16UI_EXT = 0x8D77 :: GLenum

pattern GL_RGB16_EXT = 0x8054 :: GLenum

pattern GL_RGB16_SNORM = 0x8F9A :: GLenum

pattern GL_RGB16_SNORM_EXT = 0x8F9A :: GLenum

pattern GL_RGB2_EXT = 0x804E :: GLenum

pattern GL_RGB32F = 0x8815 :: GLenum

pattern GL_RGB32F_ARB = 0x8815 :: GLenum

pattern GL_RGB32F_EXT = 0x8815 :: GLenum

pattern GL_RGB32I = 0x8D83 :: GLenum

pattern GL_RGB32I_EXT = 0x8D83 :: GLenum

pattern GL_RGB32UI = 0x8D71 :: GLenum

pattern GL_RGB32UI_EXT = 0x8D71 :: GLenum

pattern GL_RGB4 = 0x804F :: GLenum

pattern GL_RGB4_EXT = 0x804F :: GLenum

pattern GL_RGB4_S3TC = 0x83A1 :: GLenum

pattern GL_RGB5 = 0x8050 :: GLenum

pattern GL_RGB565 = 0x8D62 :: GLenum

pattern GL_RGB565_OES = 0x8D62 :: GLenum

pattern GL_RGB5_A1 = 0x8057 :: GLenum

pattern GL_RGB5_A1_EXT = 0x8057 :: GLenum

pattern GL_RGB5_A1_OES = 0x8057 :: GLenum

pattern GL_RGB5_EXT = 0x8050 :: GLenum

pattern GL_RGB8 = 0x8051 :: GLenum

pattern GL_RGB8I = 0x8D8F :: GLenum

pattern GL_RGB8I_EXT = 0x8D8F :: GLenum

pattern GL_RGB8UI = 0x8D7D :: GLenum

pattern GL_RGB8UI_EXT = 0x8D7D :: GLenum

pattern GL_RGB8_EXT = 0x8051 :: GLenum

pattern GL_RGB8_OES = 0x8051 :: GLenum

pattern GL_RGB8_SNORM = 0x8F96 :: GLenum

pattern GL_RGB9_E5 = 0x8C3D :: GLenum

pattern GL_RGB9_E5_APPLE = 0x8C3D :: GLenum

pattern GL_RGB9_E5_EXT = 0x8C3D :: GLenum

pattern GL_RGBA = 0x1908 :: GLenum

pattern GL_RGBA12 = 0x805A :: GLenum

pattern GL_RGBA12_EXT = 0x805A :: GLenum

pattern GL_RGBA16 = 0x805B :: GLenum

pattern GL_RGBA16F = 0x881A :: GLenum

pattern GL_RGBA16F_ARB = 0x881A :: GLenum

pattern GL_RGBA16F_EXT = 0x881A :: GLenum

pattern GL_RGBA16I = 0x8D88 :: GLenum

pattern GL_RGBA16I_EXT = 0x8D88 :: GLenum

pattern GL_RGBA16UI = 0x8D76 :: GLenum

pattern GL_RGBA16UI_EXT = 0x8D76 :: GLenum

pattern GL_RGBA16_EXT = 0x805B :: GLenum

pattern GL_RGBA16_SNORM = 0x8F9B :: GLenum

pattern GL_RGBA16_SNORM_EXT = 0x8F9B :: GLenum

pattern GL_RGBA2 = 0x8055 :: GLenum

pattern GL_RGBA2_EXT = 0x8055 :: GLenum

pattern GL_RGBA32F = 0x8814 :: GLenum

pattern GL_RGBA32F_ARB = 0x8814 :: GLenum

pattern GL_RGBA32F_EXT = 0x8814 :: GLenum

pattern GL_RGBA32I = 0x8D82 :: GLenum

pattern GL_RGBA32I_EXT = 0x8D82 :: GLenum

pattern GL_RGBA32UI = 0x8D70 :: GLenum

pattern GL_RGBA32UI_EXT = 0x8D70 :: GLenum

pattern GL_RGBA4 = 0x8056 :: GLenum

pattern GL_RGBA4_DXT5_S3TC = 0x83A5 :: GLenum

pattern GL_RGBA4_EXT = 0x8056 :: GLenum

pattern GL_RGBA4_OES = 0x8056 :: GLenum

pattern GL_RGBA4_S3TC = 0x83A3 :: GLenum

pattern GL_RGBA8 = 0x8058 :: GLenum

pattern GL_RGBA8I = 0x8D8E :: GLenum

pattern GL_RGBA8I_EXT = 0x8D8E :: GLenum

pattern GL_RGBA8UI = 0x8D7C :: GLenum

pattern GL_RGBA8UI_EXT = 0x8D7C :: GLenum

pattern GL_RGBA8_EXT = 0x8058 :: GLenum

pattern GL_RGBA8_OES = 0x8058 :: GLenum

pattern GL_RGBA8_SNORM = 0x8F97 :: GLenum

pattern GL_RGBA_DXT5_S3TC = 0x83A4 :: GLenum

pattern GL_RGBA_FLOAT16_APPLE = 0x881A :: GLenum

pattern GL_RGBA_FLOAT16_ATI = 0x881A :: GLenum

pattern GL_RGBA_FLOAT32_APPLE = 0x8814 :: GLenum

pattern GL_RGBA_FLOAT32_ATI = 0x8814 :: GLenum

pattern GL_RGBA_FLOAT_MODE_ARB = 0x8820 :: GLenum

pattern GL_RGBA_FLOAT_MODE_ATI = 0x8820 :: GLenum

pattern GL_RGBA_INTEGER = 0x8D99 :: GLenum

pattern GL_RGBA_INTEGER_EXT = 0x8D99 :: GLenum

pattern GL_RGBA_INTEGER_MODE_EXT = 0x8D9E :: GLenum

pattern GL_RGBA_MODE = 0x0C31 :: GLenum

pattern GL_RGBA_S3TC = 0x83A2 :: GLenum

pattern GL_RGBA_SIGNED_COMPONENTS_EXT = 0x8C3C :: GLenum

pattern GL_RGBA_SNORM = 0x8F93 :: GLenum

pattern GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = 0x86D9 :: GLenum

pattern GL_RGB_422_APPLE = 0x8A1F :: GLenum

pattern GL_RGB_FLOAT16_APPLE = 0x881B :: GLenum

pattern GL_RGB_FLOAT16_ATI = 0x881B :: GLenum

pattern GL_RGB_FLOAT32_APPLE = 0x8815 :: GLenum

pattern GL_RGB_FLOAT32_ATI = 0x8815 :: GLenum

pattern GL_RGB_INTEGER = 0x8D98 :: GLenum

pattern GL_RGB_INTEGER_EXT = 0x8D98 :: GLenum

pattern GL_RGB_RAW_422_APPLE = 0x8A51 :: GLenum

pattern GL_RGB_S3TC = 0x83A0 :: GLenum

pattern GL_RGB_SCALE = 0x8573 :: GLenum

pattern GL_RGB_SCALE_ARB = 0x8573 :: GLenum

pattern GL_RGB_SCALE_EXT = 0x8573 :: GLenum

pattern GL_RGB_SNORM = 0x8F92 :: GLenum

pattern GL_RG_EXT = 0x8227 :: GLenum

pattern GL_RG_INTEGER = 0x8228 :: GLenum

pattern GL_RG_SNORM = 0x8F91 :: GLenum

pattern GL_RIGHT = 0x0407 :: GLenum

pattern GL_ROUNDED_RECT2_NV = 0xEA :: GLubyte

pattern GL_ROUNDED_RECT4_NV = 0xEC :: GLubyte

pattern GL_ROUNDED_RECT8_NV = 0xEE :: GLubyte

pattern GL_ROUNDED_RECT_NV = 0xE8 :: GLubyte

pattern GL_ROUND_NV = 0x90A4 :: GLenum

pattern GL_S = 0x2000 :: GLenum

pattern GL_SAMPLER = 0x82E6 :: GLenum

pattern GL_SAMPLER_1D = 0x8B5D :: GLenum

pattern GL_SAMPLER_1D_ARB = 0x8B5D :: GLenum

pattern GL_SAMPLER_1D_ARRAY = 0x8DC0 :: GLenum

pattern GL_SAMPLER_1D_ARRAY_EXT = 0x8DC0 :: GLenum

pattern GL_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3 :: GLenum

pattern GL_SAMPLER_1D_ARRAY_SHADOW_EXT = 0x8DC3 :: GLenum

pattern GL_SAMPLER_1D_SHADOW = 0x8B61 :: GLenum

pattern GL_SAMPLER_1D_SHADOW_ARB = 0x8B61 :: GLenum

pattern GL_SAMPLER_2D = 0x8B5E :: GLenum

pattern GL_SAMPLER_2D_ARB = 0x8B5E :: GLenum

pattern GL_SAMPLER_2D_ARRAY = 0x8DC1 :: GLenum

pattern GL_SAMPLER_2D_ARRAY_EXT = 0x8DC1 :: GLenum

pattern GL_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4 :: GLenum

pattern GL_SAMPLER_2D_ARRAY_SHADOW_EXT = 0x8DC4 :: GLenum

pattern GL_SAMPLER_2D_ARRAY_SHADOW_NV = 0x8DC4 :: GLenum

pattern GL_SAMPLER_2D_MULTISAMPLE = 0x9108 :: GLenum

pattern GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B :: GLenum

pattern GL_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910B :: GLenum

pattern GL_SAMPLER_2D_RECT = 0x8B63 :: GLenum

pattern GL_SAMPLER_2D_RECT_ARB = 0x8B63 :: GLenum

pattern GL_SAMPLER_2D_RECT_SHADOW = 0x8B64 :: GLenum

pattern GL_SAMPLER_2D_RECT_SHADOW_ARB = 0x8B64 :: GLenum

pattern GL_SAMPLER_2D_SHADOW = 0x8B62 :: GLenum

pattern GL_SAMPLER_2D_SHADOW_ARB = 0x8B62 :: GLenum

pattern GL_SAMPLER_2D_SHADOW_EXT = 0x8B62 :: GLenum

pattern GL_SAMPLER_3D = 0x8B5F :: GLenum

pattern GL_SAMPLER_3D_ARB = 0x8B5F :: GLenum

pattern GL_SAMPLER_3D_OES = 0x8B5F :: GLenum

pattern GL_SAMPLER_BINDING = 0x8919 :: GLenum

pattern GL_SAMPLER_BUFFER = 0x8DC2 :: GLenum

pattern GL_SAMPLER_BUFFER_AMD = 0x9001 :: GLenum

pattern GL_SAMPLER_BUFFER_EXT = 0x8DC2 :: GLenum

pattern GL_SAMPLER_BUFFER_OES = 0x8DC2 :: GLenum

pattern GL_SAMPLER_CUBE = 0x8B60 :: GLenum

pattern GL_SAMPLER_CUBE_ARB = 0x8B60 :: GLenum

pattern GL_SAMPLER_CUBE_MAP_ARRAY = 0x900C :: GLenum

pattern GL_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900C :: GLenum

pattern GL_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900C :: GLenum

pattern GL_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900C :: GLenum

pattern GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D :: GLenum

pattern GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB = 0x900D :: GLenum

pattern GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT = 0x900D :: GLenum

pattern GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_OES = 0x900D :: GLenum

pattern GL_SAMPLER_CUBE_SHADOW = 0x8DC5 :: GLenum

pattern GL_SAMPLER_CUBE_SHADOW_EXT = 0x8DC5 :: GLenum

pattern GL_SAMPLER_CUBE_SHADOW_NV = 0x8DC5 :: GLenum

pattern GL_SAMPLER_EXTERNAL_2D_Y2Y_EXT = 0x8BE7 :: GLenum

pattern GL_SAMPLER_EXTERNAL_OES = 0x8D66 :: GLenum

pattern GL_SAMPLER_KHR = 0x82E6 :: GLenum

pattern GL_SAMPLER_OBJECT_AMD = 0x9155 :: GLenum

pattern GL_SAMPLER_RENDERBUFFER_NV = 0x8E56 :: GLenum

pattern GL_SAMPLES = 0x80A9 :: GLenum

pattern GL_SAMPLES_3DFX = 0x86B4 :: GLenum

pattern GL_SAMPLES_ARB = 0x80A9 :: GLenum

pattern GL_SAMPLES_EXT = 0x80A9 :: GLenum

pattern GL_SAMPLES_PASSED = 0x8914 :: GLenum

pattern GL_SAMPLES_PASSED_ARB = 0x8914 :: GLenum

pattern GL_SAMPLES_SGIS = 0x80A9 :: GLenum

pattern GL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E :: GLenum

pattern GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = 0x809E :: GLenum

pattern GL_SAMPLE_ALPHA_TO_MASK_EXT = 0x809E :: GLenum

pattern GL_SAMPLE_ALPHA_TO_MASK_SGIS = 0x809E :: GLenum

pattern GL_SAMPLE_ALPHA_TO_ONE = 0x809F :: GLenum

pattern GL_SAMPLE_ALPHA_TO_ONE_ARB = 0x809F :: GLenum

pattern GL_SAMPLE_ALPHA_TO_ONE_EXT = 0x809F :: GLenum

pattern GL_SAMPLE_ALPHA_TO_ONE_SGIS = 0x809F :: GLenum

pattern GL_SAMPLE_BUFFERS = 0x80A8 :: GLenum

pattern GL_SAMPLE_BUFFERS_3DFX = 0x86B3 :: GLenum

pattern GL_SAMPLE_BUFFERS_ARB = 0x80A8 :: GLenum

pattern GL_SAMPLE_BUFFERS_EXT = 0x80A8 :: GLenum

pattern GL_SAMPLE_BUFFERS_SGIS = 0x80A8 :: GLenum

pattern GL_SAMPLE_COVERAGE = 0x80A0 :: GLenum

pattern GL_SAMPLE_COVERAGE_ARB = 0x80A0 :: GLenum

pattern GL_SAMPLE_COVERAGE_INVERT = 0x80AB :: GLenum

pattern GL_SAMPLE_COVERAGE_INVERT_ARB = 0x80AB :: GLenum

pattern GL_SAMPLE_COVERAGE_VALUE = 0x80AA :: GLenum

pattern GL_SAMPLE_COVERAGE_VALUE_ARB = 0x80AA :: GLenum

pattern GL_SAMPLE_LOCATION_ARB = 0x8E50 :: GLenum

pattern GL_SAMPLE_LOCATION_NV = 0x8E50 :: GLenum

pattern GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB = 0x933F :: GLenum

pattern GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV = 0x933F :: GLenum

pattern GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB = 0x933E :: GLenum

pattern GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV = 0x933E :: GLenum

pattern GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB = 0x933D :: GLenum

pattern GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV = 0x933D :: GLenum

pattern GL_SAMPLE_MASK = 0x8E51 :: GLenum

pattern GL_SAMPLE_MASK_EXT = 0x80A0 :: GLenum

pattern GL_SAMPLE_MASK_INVERT_EXT = 0x80AB :: GLenum

pattern GL_SAMPLE_MASK_INVERT_SGIS = 0x80AB :: GLenum

pattern GL_SAMPLE_MASK_NV = 0x8E51 :: GLenum

pattern GL_SAMPLE_MASK_SGIS = 0x80A0 :: GLenum

pattern GL_SAMPLE_MASK_VALUE = 0x8E52 :: GLenum

pattern GL_SAMPLE_MASK_VALUE_EXT = 0x80AA :: GLenum

pattern GL_SAMPLE_MASK_VALUE_NV = 0x8E52 :: GLenum

pattern GL_SAMPLE_MASK_VALUE_SGIS = 0x80AA :: GLenum

pattern GL_SAMPLE_PATTERN_EXT = 0x80AC :: GLenum

pattern GL_SAMPLE_PATTERN_SGIS = 0x80AC :: GLenum

pattern GL_SAMPLE_POSITION = 0x8E50 :: GLenum

pattern GL_SAMPLE_POSITION_NV = 0x8E50 :: GLenum

pattern GL_SAMPLE_SHADING = 0x8C36 :: GLenum

pattern GL_SAMPLE_SHADING_ARB = 0x8C36 :: GLenum

pattern GL_SAMPLE_SHADING_OES = 0x8C36 :: GLenum

pattern GL_SATURATE_BIT_ATI = 0x00000040 :: GLbitfield

pattern GL_SCALAR_EXT = 0x87BE :: GLenum

pattern GL_SCALEBIAS_HINT_SGIX = 0x8322 :: GLenum

pattern GL_SCALED_RESOLVE_FASTEST_EXT = 0x90BA :: GLenum

pattern GL_SCALED_RESOLVE_NICEST_EXT = 0x90BB :: GLenum

pattern GL_SCALE_BY_FOUR_NV = 0x853F :: GLenum

pattern GL_SCALE_BY_ONE_HALF_NV = 0x8540 :: GLenum

pattern GL_SCALE_BY_TWO_NV = 0x853E :: GLenum

pattern GL_SCISSOR_BIT = 0x00080000 :: GLbitfield

pattern GL_SCISSOR_BOX = 0x0C10 :: GLenum

pattern GL_SCISSOR_COMMAND_NV = 0x0011 :: GLenum

pattern GL_SCISSOR_TEST = 0x0C11 :: GLenum

pattern GL_SCREEN = 0x9295 :: GLenum

pattern GL_SCREEN_COORDINATES_REND = 0x8490 :: GLenum

pattern GL_SCREEN_KHR = 0x9295 :: GLenum

pattern GL_SCREEN_NV = 0x9295 :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY = 0x845E :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV = 0x8F27 :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 0x889C :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x889C :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_EXT = 0x845E :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_LENGTH_NV = 0x8F31 :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_LIST_IBM = 103077 :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM = 103087 :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_POINTER = 0x845D :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_POINTER_EXT = 0x845D :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_SIZE = 0x845A :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_SIZE_EXT = 0x845A :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_STRIDE = 0x845C :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = 0x845C :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_TYPE = 0x845B :: GLenum

pattern GL_SECONDARY_COLOR_ARRAY_TYPE_EXT = 0x845B :: GLenum

pattern GL_SECONDARY_COLOR_NV = 0x852D :: GLenum

pattern GL_SECONDARY_INTERPOLATOR_ATI = 0x896D :: GLenum

pattern GL_SELECT = 0x1C02 :: GLenum

pattern GL_SELECTION_BUFFER_POINTER = 0x0DF3 :: GLenum

pattern GL_SELECTION_BUFFER_SIZE = 0x0DF4 :: GLenum

pattern GL_SEPARABLE_2D = 0x8012 :: GLenum

pattern GL_SEPARABLE_2D_EXT = 0x8012 :: GLenum

pattern GL_SEPARATE_ATTRIBS = 0x8C8D :: GLenum

pattern GL_SEPARATE_ATTRIBS_EXT = 0x8C8D :: GLenum

pattern GL_SEPARATE_ATTRIBS_NV = 0x8C8D :: GLenum

pattern GL_SEPARATE_SPECULAR_COLOR = 0x81FA :: GLenum

pattern GL_SEPARATE_SPECULAR_COLOR_EXT = 0x81FA :: GLenum

pattern GL_SET = 0x150F :: GLenum

pattern GL_SET_AMD = 0x874A :: GLenum

pattern GL_SGX_BINARY_IMG = 0x8C0A :: GLenum

pattern GL_SGX_PROGRAM_BINARY_IMG = 0x9130 :: GLenum

pattern GL_SHADER = 0x82E1 :: GLenum

pattern GL_SHADER_BINARY_DMP = 0x9250 :: GLenum

pattern GL_SHADER_BINARY_FORMATS = 0x8DF8 :: GLenum

pattern GL_SHADER_BINARY_VIV = 0x8FC4 :: GLenum

pattern GL_SHADER_COMPILER = 0x8DFA :: GLenum

pattern GL_SHADER_CONSISTENT_NV = 0x86DD :: GLenum

pattern GL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV = 0x00000010 :: GLbitfield

pattern GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 0x00000020 :: GLbitfield

pattern GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT = 0x00000020 :: GLbitfield

pattern GL_SHADER_IMAGE_ATOMIC = 0x82A6 :: GLenum

pattern GL_SHADER_IMAGE_LOAD = 0x82A4 :: GLenum

pattern GL_SHADER_IMAGE_STORE = 0x82A5 :: GLenum

pattern GL_SHADER_INCLUDE_ARB = 0x8DAE :: GLenum

pattern GL_SHADER_KHR = 0x82E1 :: GLenum

pattern GL_SHADER_OBJECT_ARB = 0x8B48 :: GLenum

pattern GL_SHADER_OBJECT_EXT = 0x8B48 :: GLenum

pattern GL_SHADER_OPERATION_NV = 0x86DF :: GLenum

pattern GL_SHADER_PIXEL_LOCAL_STORAGE_EXT = 0x8F64 :: GLenum

pattern GL_SHADER_SOURCE_LENGTH = 0x8B88 :: GLenum

pattern GL_SHADER_STORAGE_BARRIER_BIT = 0x00002000 :: GLbitfield

pattern GL_SHADER_STORAGE_BLOCK = 0x92E6 :: GLenum

pattern GL_SHADER_STORAGE_BUFFER = 0x90D2 :: GLenum

pattern GL_SHADER_STORAGE_BUFFER_BINDING = 0x90D3 :: GLenum

pattern GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 0x90DF :: GLenum

pattern GL_SHADER_STORAGE_BUFFER_SIZE = 0x90D5 :: GLenum

pattern GL_SHADER_STORAGE_BUFFER_START = 0x90D4 :: GLenum

pattern GL_SHADER_TYPE = 0x8B4F :: GLenum

pattern GL_SHADE_MODEL = 0x0B54 :: GLenum

pattern GL_SHADING_LANGUAGE_VERSION = 0x8B8C :: GLenum

pattern GL_SHADING_LANGUAGE_VERSION_ARB = 0x8B8C :: GLenum

pattern GL_SHADOW_AMBIENT_SGIX = 0x80BF :: GLenum

pattern GL_SHADOW_ATTENUATION_EXT = 0x834E :: GLenum

pattern GL_SHARED_EDGE_NV = 0xC0 :: GLubyte

pattern GL_SHARED_TEXTURE_PALETTE_EXT = 0x81FB :: GLenum

pattern GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = 0x80B0 :: GLenum

pattern GL_SHININESS = 0x1601 :: GLenum

pattern GL_SHORT = 0x1402 :: GLenum

pattern GL_SIGNALED = 0x9119 :: GLenum

pattern GL_SIGNALED_APPLE = 0x9119 :: GLenum

pattern GL_SIGNED_ALPHA8_NV = 0x8706 :: GLenum

pattern GL_SIGNED_ALPHA_NV = 0x8705 :: GLenum

pattern GL_SIGNED_HILO16_NV = 0x86FA :: GLenum

pattern GL_SIGNED_HILO8_NV = 0x885F :: GLenum

pattern GL_SIGNED_HILO_NV = 0x86F9 :: GLenum

pattern GL_SIGNED_IDENTITY_NV = 0x853C :: GLenum

pattern GL_SIGNED_INTENSITY8_NV = 0x8708 :: GLenum

pattern GL_SIGNED_INTENSITY_NV = 0x8707 :: GLenum

pattern GL_SIGNED_LUMINANCE8_ALPHA8_NV = 0x8704 :: GLenum

pattern GL_SIGNED_LUMINANCE8_NV = 0x8702 :: GLenum

pattern GL_SIGNED_LUMINANCE_ALPHA_NV = 0x8703 :: GLenum

pattern GL_SIGNED_LUMINANCE_NV = 0x8701 :: GLenum

pattern GL_SIGNED_NEGATE_NV = 0x853D :: GLenum

pattern GL_SIGNED_NORMALIZED = 0x8F9C :: GLenum

pattern GL_SIGNED_RGB8_NV = 0x86FF :: GLenum

pattern GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = 0x870D :: GLenum

pattern GL_SIGNED_RGBA8_NV = 0x86FC :: GLenum

pattern GL_SIGNED_RGBA_NV = 0x86FB :: GLenum

pattern GL_SIGNED_RGB_NV = 0x86FE :: GLenum

pattern GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = 0x870C :: GLenum

pattern GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 0x82AC :: GLenum

pattern GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 0x82AE :: GLenum

pattern GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 0x82AD :: GLenum

pattern GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 0x82AF :: GLenum

pattern GL_SINGLE_COLOR = 0x81F9 :: GLenum

pattern GL_SINGLE_COLOR_EXT = 0x81F9 :: GLenum

pattern GL_SKIP_COMPONENTS1_NV = -6 :: GLenum

pattern GL_SKIP_COMPONENTS2_NV = -5 :: GLenum

pattern GL_SKIP_COMPONENTS3_NV = -4 :: GLenum

pattern GL_SKIP_COMPONENTS4_NV = -3 :: GLenum

pattern GL_SKIP_DECODE_EXT = 0x8A4A :: GLenum

pattern GL_SKIP_MISSING_GLYPH_NV = 0x90A9 :: GLenum

pattern GL_SLICE_ACCUM_SUN = 0x85CC :: GLenum

pattern GL_SLIM10U_SGIX = 0x831E :: GLenum

pattern GL_SLIM12S_SGIX = 0x831F :: GLenum

pattern GL_SLIM8U_SGIX = 0x831D :: GLenum

pattern GL_SLUMINANCE = 0x8C46 :: GLenum

pattern GL_SLUMINANCE8 = 0x8C47 :: GLenum

pattern GL_SLUMINANCE8_ALPHA8 = 0x8C45 :: GLenum

pattern GL_SLUMINANCE8_ALPHA8_EXT = 0x8C45 :: GLenum

pattern GL_SLUMINANCE8_ALPHA8_NV = 0x8C45 :: GLenum

pattern GL_SLUMINANCE8_EXT = 0x8C47 :: GLenum

pattern GL_SLUMINANCE8_NV = 0x8C47 :: GLenum

pattern GL_SLUMINANCE_ALPHA = 0x8C44 :: GLenum

pattern GL_SLUMINANCE_ALPHA_EXT = 0x8C44 :: GLenum

pattern GL_SLUMINANCE_ALPHA_NV = 0x8C44 :: GLenum

pattern GL_SLUMINANCE_EXT = 0x8C46 :: GLenum

pattern GL_SLUMINANCE_NV = 0x8C46 :: GLenum

pattern GL_SMALL_CCW_ARC_TO_NV = 0x12 :: GLubyte

pattern GL_SMALL_CW_ARC_TO_NV = 0x14 :: GLubyte

pattern GL_SMAPHS30_PROGRAM_BINARY_DMP = 0x9251 :: GLenum

pattern GL_SMAPHS_PROGRAM_BINARY_DMP = 0x9252 :: GLenum

pattern GL_SMOOTH = 0x1D01 :: GLenum

pattern GL_SMOOTH_CUBIC_CURVE_TO_NV = 0x10 :: GLubyte

pattern GL_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23 :: GLenum

pattern GL_SMOOTH_LINE_WIDTH_RANGE = 0x0B22 :: GLenum

pattern GL_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13 :: GLenum

pattern GL_SMOOTH_POINT_SIZE_RANGE = 0x0B12 :: GLenum

pattern GL_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0E :: GLubyte

pattern GL_SM_COUNT_NV = 0x933B :: GLenum

pattern GL_SOFTLIGHT = 0x929C :: GLenum

pattern GL_SOFTLIGHT_KHR = 0x929C :: GLenum

pattern GL_SOFTLIGHT_NV = 0x929C :: GLenum

pattern GL_SOURCE0_ALPHA = 0x8588 :: GLenum

pattern GL_SOURCE0_ALPHA_ARB = 0x8588 :: GLenum

pattern GL_SOURCE0_ALPHA_EXT = 0x8588 :: GLenum

pattern GL_SOURCE0_RGB = 0x8580 :: GLenum

pattern GL_SOURCE0_RGB_ARB = 0x8580 :: GLenum

pattern GL_SOURCE0_RGB_EXT = 0x8580 :: GLenum

pattern GL_SOURCE1_ALPHA = 0x8589 :: GLenum

pattern GL_SOURCE1_ALPHA_ARB = 0x8589 :: GLenum

pattern GL_SOURCE1_ALPHA_EXT = 0x8589 :: GLenum

pattern GL_SOURCE1_RGB = 0x8581 :: GLenum

pattern GL_SOURCE1_RGB_ARB = 0x8581 :: GLenum

pattern GL_SOURCE1_RGB_EXT = 0x8581 :: GLenum

pattern GL_SOURCE2_ALPHA = 0x858A :: GLenum

pattern GL_SOURCE2_ALPHA_ARB = 0x858A :: GLenum

pattern GL_SOURCE2_ALPHA_EXT = 0x858A :: GLenum

pattern GL_SOURCE2_RGB = 0x8582 :: GLenum

pattern GL_SOURCE2_RGB_ARB = 0x8582 :: GLenum

pattern GL_SOURCE2_RGB_EXT = 0x8582 :: GLenum

pattern GL_SOURCE3_ALPHA_NV = 0x858B :: GLenum

pattern GL_SOURCE3_RGB_NV = 0x8583 :: GLenum

pattern GL_SPARE0_NV = 0x852E :: GLenum

pattern GL_SPARE0_PLUS_SECONDARY_COLOR_NV = 0x8532 :: GLenum

pattern GL_SPARE1_NV = 0x852F :: GLenum

pattern GL_SPARSE_BUFFER_PAGE_SIZE_ARB = 0x82F8 :: GLenum

pattern GL_SPARSE_STORAGE_BIT_ARB = 0x0400 :: GLbitfield

pattern GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = 0x91A9 :: GLenum

pattern GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_EXT = 0x91A9 :: GLenum

pattern GL_SPECULAR = 0x1202 :: GLenum

pattern GL_SPHERE_MAP = 0x2402 :: GLenum

pattern GL_SPOT_CUTOFF = 0x1206 :: GLenum

pattern GL_SPOT_DIRECTION = 0x1204 :: GLenum

pattern GL_SPOT_EXPONENT = 0x1205 :: GLenum

pattern GL_SPRITE_AXIAL_SGIX = 0x814C :: GLenum

pattern GL_SPRITE_AXIS_SGIX = 0x814A :: GLenum

pattern GL_SPRITE_EYE_ALIGNED_SGIX = 0x814E :: GLenum

pattern GL_SPRITE_MODE_SGIX = 0x8149 :: GLenum

pattern GL_SPRITE_OBJECT_ALIGNED_SGIX = 0x814D :: GLenum

pattern GL_SPRITE_SGIX = 0x8148 :: GLenum

pattern GL_SPRITE_TRANSLATION_SGIX = 0x814B :: GLenum

pattern GL_SQUARE_NV = 0x90A3 :: GLenum

pattern GL_SR8_EXT = 0x8FBD :: GLenum

pattern GL_SRC0_ALPHA = 0x8588 :: GLenum

pattern GL_SRC0_RGB = 0x8580 :: GLenum

pattern GL_SRC1_ALPHA = 0x8589 :: GLenum

pattern GL_SRC1_ALPHA_EXT = 0x8589 :: GLenum

pattern GL_SRC1_COLOR = 0x88F9 :: GLenum

pattern GL_SRC1_COLOR_EXT = 0x88F9 :: GLenum

pattern GL_SRC1_RGB = 0x8581 :: GLenum

pattern GL_SRC2_ALPHA = 0x858A :: GLenum

pattern GL_SRC2_RGB = 0x8582 :: GLenum

pattern GL_SRC_ALPHA = 0x0302 :: GLenum

pattern GL_SRC_ALPHA_SATURATE = 0x0308 :: GLenum

pattern GL_SRC_ALPHA_SATURATE_EXT = 0x0308 :: GLenum

pattern GL_SRC_ATOP_NV = 0x928E :: GLenum

pattern GL_SRC_COLOR = 0x0300 :: GLenum

pattern GL_SRC_IN_NV = 0x928A :: GLenum

pattern GL_SRC_NV = 0x9286 :: GLenum

pattern GL_SRC_OUT_NV = 0x928C :: GLenum

pattern GL_SRC_OVER_NV = 0x9288 :: GLenum

pattern GL_SRG8_EXT = 0x8FBE :: GLenum

pattern GL_SRGB = 0x8C40 :: GLenum

pattern GL_SRGB8 = 0x8C41 :: GLenum

pattern GL_SRGB8_ALPHA8 = 0x8C43 :: GLenum

pattern GL_SRGB8_ALPHA8_EXT = 0x8C43 :: GLenum

pattern GL_SRGB8_EXT = 0x8C41 :: GLenum

pattern GL_SRGB8_NV = 0x8C41 :: GLenum

pattern GL_SRGB_ALPHA = 0x8C42 :: GLenum

pattern GL_SRGB_ALPHA_EXT = 0x8C42 :: GLenum

pattern GL_SRGB_DECODE_ARB = 0x8299 :: GLenum

pattern GL_SRGB_EXT = 0x8C40 :: GLenum

pattern GL_SRGB_READ = 0x8297 :: GLenum

pattern GL_SRGB_WRITE = 0x8298 :: GLenum

pattern GL_STACK_OVERFLOW = 0x0503 :: GLenum

pattern GL_STACK_OVERFLOW_KHR = 0x0503 :: GLenum

pattern GL_STACK_UNDERFLOW = 0x0504 :: GLenum

pattern GL_STACK_UNDERFLOW_KHR = 0x0504 :: GLenum

pattern GL_STANDARD_FONT_FORMAT_NV = 0x936C :: GLenum

pattern GL_STANDARD_FONT_NAME_NV = 0x9072 :: GLenum

pattern GL_STATE_RESTORE = 0x8BDC :: GLenum

pattern GL_STATIC_ATI = 0x8760 :: GLenum

pattern GL_STATIC_COPY = 0x88E6 :: GLenum

pattern GL_STATIC_COPY_ARB = 0x88E6 :: GLenum

pattern GL_STATIC_DRAW = 0x88E4 :: GLenum

pattern GL_STATIC_DRAW_ARB = 0x88E4 :: GLenum

pattern GL_STATIC_READ = 0x88E5 :: GLenum

pattern GL_STATIC_READ_ARB = 0x88E5 :: GLenum

pattern GL_STATIC_VERTEX_ARRAY_IBM = 103061 :: GLenum

pattern GL_STENCIL = 0x1802 :: GLenum

pattern GL_STENCIL_ATTACHMENT = 0x8D20 :: GLenum

pattern GL_STENCIL_ATTACHMENT_EXT = 0x8D20 :: GLenum

pattern GL_STENCIL_ATTACHMENT_OES = 0x8D20 :: GLenum

pattern GL_STENCIL_BACK_FAIL = 0x8801 :: GLenum

pattern GL_STENCIL_BACK_FAIL_ATI = 0x8801 :: GLenum

pattern GL_STENCIL_BACK_FUNC = 0x8800 :: GLenum

pattern GL_STENCIL_BACK_FUNC_ATI = 0x8800 :: GLenum

pattern GL_STENCIL_BACK_OP_VALUE_AMD = 0x874D :: GLenum

pattern GL_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802 :: GLenum

pattern GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = 0x8802 :: GLenum

pattern GL_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803 :: GLenum

pattern GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = 0x8803 :: GLenum

pattern GL_STENCIL_BACK_REF = 0x8CA3 :: GLenum

pattern GL_STENCIL_BACK_VALUE_MASK = 0x8CA4 :: GLenum

pattern GL_STENCIL_BACK_WRITEMASK = 0x8CA5 :: GLenum

pattern GL_STENCIL_BITS = 0x0D57 :: GLenum

pattern GL_STENCIL_BUFFER_BIT = 0x00000400 :: GLbitfield

pattern GL_STENCIL_BUFFER_BIT0_QCOM = 0x00010000 :: GLbitfield

pattern GL_STENCIL_BUFFER_BIT1_QCOM = 0x00020000 :: GLbitfield

pattern GL_STENCIL_BUFFER_BIT2_QCOM = 0x00040000 :: GLbitfield

pattern GL_STENCIL_BUFFER_BIT3_QCOM = 0x00080000 :: GLbitfield

pattern GL_STENCIL_BUFFER_BIT4_QCOM = 0x00100000 :: GLbitfield

pattern GL_STENCIL_BUFFER_BIT5_QCOM = 0x00200000 :: GLbitfield

pattern GL_STENCIL_BUFFER_BIT6_QCOM = 0x00400000 :: GLbitfield

pattern GL_STENCIL_BUFFER_BIT7_QCOM = 0x00800000 :: GLbitfield

pattern GL_STENCIL_CLEAR_TAG_VALUE_EXT = 0x88F3 :: GLenum

pattern GL_STENCIL_CLEAR_VALUE = 0x0B91 :: GLenum

pattern GL_STENCIL_COMPONENTS = 0x8285 :: GLenum

pattern GL_STENCIL_EXT = 0x1802 :: GLenum

pattern GL_STENCIL_FAIL = 0x0B94 :: GLenum

pattern GL_STENCIL_FUNC = 0x0B92 :: GLenum

pattern GL_STENCIL_INDEX = 0x1901 :: GLenum

pattern GL_STENCIL_INDEX1 = 0x8D46 :: GLenum

pattern GL_STENCIL_INDEX16 = 0x8D49 :: GLenum

pattern GL_STENCIL_INDEX16_EXT = 0x8D49 :: GLenum

pattern GL_STENCIL_INDEX1_EXT = 0x8D46 :: GLenum

pattern GL_STENCIL_INDEX1_OES = 0x8D46 :: GLenum

pattern GL_STENCIL_INDEX4 = 0x8D47 :: GLenum

pattern GL_STENCIL_INDEX4_EXT = 0x8D47 :: GLenum

pattern GL_STENCIL_INDEX4_OES = 0x8D47 :: GLenum

pattern GL_STENCIL_INDEX8 = 0x8D48 :: GLenum

pattern GL_STENCIL_INDEX8_EXT = 0x8D48 :: GLenum

pattern GL_STENCIL_INDEX8_OES = 0x8D48 :: GLenum

pattern GL_STENCIL_INDEX_OES = 0x1901 :: GLenum

pattern GL_STENCIL_OP_VALUE_AMD = 0x874C :: GLenum

pattern GL_STENCIL_PASS_DEPTH_FAIL = 0x0B95 :: GLenum

pattern GL_STENCIL_PASS_DEPTH_PASS = 0x0B96 :: GLenum

pattern GL_STENCIL_REF = 0x0B97 :: GLenum

pattern GL_STENCIL_REF_COMMAND_NV = 0x000C :: GLenum

pattern GL_STENCIL_RENDERABLE = 0x8288 :: GLenum

pattern GL_STENCIL_SAMPLES_NV = 0x932E :: GLenum

pattern GL_STENCIL_TAG_BITS_EXT = 0x88F2 :: GLenum

pattern GL_STENCIL_TEST = 0x0B90 :: GLenum

pattern GL_STENCIL_TEST_TWO_SIDE_EXT = 0x8910 :: GLenum

pattern GL_STENCIL_VALUE_MASK = 0x0B93 :: GLenum

pattern GL_STENCIL_WRITEMASK = 0x0B98 :: GLenum

pattern GL_STEREO = 0x0C33 :: GLenum

pattern GL_STORAGE_CACHED_APPLE = 0x85BE :: GLenum

pattern GL_STORAGE_CLIENT_APPLE = 0x85B4 :: GLenum

pattern GL_STORAGE_PRIVATE_APPLE = 0x85BD :: GLenum

pattern GL_STORAGE_SHARED_APPLE = 0x85BF :: GLenum

pattern GL_STREAM_COPY = 0x88E2 :: GLenum

pattern GL_STREAM_COPY_ARB = 0x88E2 :: GLenum

pattern GL_STREAM_DRAW = 0x88E0 :: GLenum

pattern GL_STREAM_DRAW_ARB = 0x88E0 :: GLenum

pattern GL_STREAM_RASTERIZATION_AMD = 0x91A0 :: GLenum

pattern GL_STREAM_READ = 0x88E1 :: GLenum

pattern GL_STREAM_READ_ARB = 0x88E1 :: GLenum

pattern GL_STRICT_DEPTHFUNC_HINT_PGI = 0x1A216 :: GLenum

pattern GL_STRICT_LIGHTING_HINT_PGI = 0x1A217 :: GLenum

pattern GL_STRICT_SCISSOR_HINT_PGI = 0x1A218 :: GLenum

pattern GL_SUBPIXEL_BITS = 0x0D50 :: GLenum

pattern GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV = 0x9347 :: GLenum

pattern GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV = 0x9348 :: GLenum

pattern GL_SUBSAMPLE_DISTANCE_AMD = 0x883F :: GLenum

pattern GL_SUBTRACT = 0x84E7 :: GLenum

pattern GL_SUBTRACT_ARB = 0x84E7 :: GLenum

pattern GL_SUB_ATI = 0x8965 :: GLenum

pattern GL_SUCCESS_NV = 0x902F :: GLenum

pattern GL_SUPERSAMPLE_SCALE_X_NV = 0x9372 :: GLenum

pattern GL_SUPERSAMPLE_SCALE_Y_NV = 0x9373 :: GLenum

pattern GL_SURFACE_MAPPED_NV = 0x8700 :: GLenum

pattern GL_SURFACE_REGISTERED_NV = 0x86FD :: GLenum

pattern GL_SURFACE_STATE_NV = 0x86EB :: GLenum

pattern GL_SWIZZLE_STQ_ATI = 0x8977 :: GLenum

pattern GL_SWIZZLE_STQ_DQ_ATI = 0x8979 :: GLenum

pattern GL_SWIZZLE_STRQ_ATI = 0x897A :: GLenum

pattern GL_SWIZZLE_STRQ_DQ_ATI = 0x897B :: GLenum

pattern GL_SWIZZLE_STR_ATI = 0x8976 :: GLenum

pattern GL_SWIZZLE_STR_DR_ATI = 0x8978 :: GLenum

pattern GL_SYNC_CL_EVENT_ARB = 0x8240 :: GLenum

pattern GL_SYNC_CL_EVENT_COMPLETE_ARB = 0x8241 :: GLenum

pattern GL_SYNC_CONDITION = 0x9113 :: GLenum

pattern GL_SYNC_CONDITION_APPLE = 0x9113 :: GLenum

pattern GL_SYNC_FENCE = 0x9116 :: GLenum

pattern GL_SYNC_FENCE_APPLE = 0x9116 :: GLenum

pattern GL_SYNC_FLAGS = 0x9115 :: GLenum

pattern GL_SYNC_FLAGS_APPLE = 0x9115 :: GLenum

pattern GL_SYNC_FLUSH_COMMANDS_BIT = 0x00000001 :: GLbitfield

pattern GL_SYNC_FLUSH_COMMANDS_BIT_APPLE = 0x00000001 :: GLbitfield

pattern GL_SYNC_GPU_COMMANDS_COMPLETE = 0x9117 :: GLenum

pattern GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE = 0x9117 :: GLenum

pattern GL_SYNC_OBJECT_APPLE = 0x8A53 :: GLenum

pattern GL_SYNC_STATUS = 0x9114 :: GLenum

pattern GL_SYNC_STATUS_APPLE = 0x9114 :: GLenum

pattern GL_SYNC_X11_FENCE_EXT = 0x90E1 :: GLenum

pattern GL_SYSTEM_FONT_NAME_NV = 0x9073 :: GLenum

pattern GL_T = 0x2001 :: GLenum

pattern GL_T2F_C3F_V3F = 0x2A2A :: GLenum

pattern GL_T2F_C4F_N3F_V3F = 0x2A2C :: GLenum

pattern GL_T2F_C4UB_V3F = 0x2A29 :: GLenum

pattern GL_T2F_IUI_N3F_V2F_EXT = 0x81B3 :: GLenum

pattern GL_T2F_IUI_N3F_V3F_EXT = 0x81B4 :: GLenum

pattern GL_T2F_IUI_V2F_EXT = 0x81B1 :: GLenum

pattern GL_T2F_IUI_V3F_EXT = 0x81B2 :: GLenum

pattern GL_T2F_N3F_V3F = 0x2A2B :: GLenum

pattern GL_T2F_V3F = 0x2A27 :: GLenum

pattern GL_T4F_C4F_N3F_V4F = 0x2A2D :: GLenum

pattern GL_T4F_V4F = 0x2A28 :: GLenum

pattern GL_TABLE_TOO_LARGE = 0x8031 :: GLenum

pattern GL_TABLE_TOO_LARGE_EXT = 0x8031 :: GLenum

pattern GL_TANGENT_ARRAY_EXT = 0x8439 :: GLenum

pattern GL_TANGENT_ARRAY_POINTER_EXT = 0x8442 :: GLenum

pattern GL_TANGENT_ARRAY_STRIDE_EXT = 0x843F :: GLenum

pattern GL_TANGENT_ARRAY_TYPE_EXT = 0x843E :: GLenum

pattern GL_TERMINATE_SEQUENCE_COMMAND_NV = 0x0000 :: GLenum

pattern GL_TESSELLATION_FACTOR_AMD = 0x9005 :: GLenum

pattern GL_TESSELLATION_MODE_AMD = 0x9004 :: GLenum

pattern GL_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75 :: GLenum

pattern GL_TESS_CONTROL_OUTPUT_VERTICES_EXT = 0x8E75 :: GLenum

pattern GL_TESS_CONTROL_OUTPUT_VERTICES_OES = 0x8E75 :: GLenum

pattern GL_TESS_CONTROL_PROGRAM_NV = 0x891E :: GLenum

pattern GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV = 0x8C74 :: GLenum

pattern GL_TESS_CONTROL_SHADER = 0x8E88 :: GLenum

pattern GL_TESS_CONTROL_SHADER_BIT = 0x00000008 :: GLbitfield

pattern GL_TESS_CONTROL_SHADER_BIT_EXT = 0x00000008 :: GLbitfield

pattern GL_TESS_CONTROL_SHADER_BIT_OES = 0x00000008 :: GLbitfield

pattern GL_TESS_CONTROL_SHADER_EXT = 0x8E88 :: GLenum

pattern GL_TESS_CONTROL_SHADER_OES = 0x8E88 :: GLenum

pattern GL_TESS_CONTROL_SHADER_PATCHES_ARB = 0x82F1 :: GLenum

pattern GL_TESS_CONTROL_SUBROUTINE = 0x92E9 :: GLenum

pattern GL_TESS_CONTROL_SUBROUTINE_UNIFORM = 0x92EF :: GLenum

pattern GL_TESS_CONTROL_TEXTURE = 0x829C :: GLenum

pattern GL_TESS_EVALUATION_PROGRAM_NV = 0x891F :: GLenum

pattern GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV = 0x8C75 :: GLenum

pattern GL_TESS_EVALUATION_SHADER = 0x8E87 :: GLenum

pattern GL_TESS_EVALUATION_SHADER_BIT = 0x00000010 :: GLbitfield

pattern GL_TESS_EVALUATION_SHADER_BIT_EXT = 0x00000010 :: GLbitfield

pattern GL_TESS_EVALUATION_SHADER_BIT_OES = 0x00000010 :: GLbitfield

pattern GL_TESS_EVALUATION_SHADER_EXT = 0x8E87 :: GLenum

pattern GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB = 0x82F2 :: GLenum

pattern GL_TESS_EVALUATION_SHADER_OES = 0x8E87 :: GLenum

pattern GL_TESS_EVALUATION_SUBROUTINE = 0x92EA :: GLenum

pattern GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 0x92F0 :: GLenum

pattern GL_TESS_EVALUATION_TEXTURE = 0x829D :: GLenum

pattern GL_TESS_GEN_MODE = 0x8E76 :: GLenum

pattern GL_TESS_GEN_MODE_EXT = 0x8E76 :: GLenum

pattern GL_TESS_GEN_MODE_OES = 0x8E76 :: GLenum

pattern GL_TESS_GEN_POINT_MODE = 0x8E79 :: GLenum

pattern GL_TESS_GEN_POINT_MODE_EXT = 0x8E79 :: GLenum

pattern GL_TESS_GEN_POINT_MODE_OES = 0x8E79 :: GLenum

pattern GL_TESS_GEN_SPACING = 0x8E77 :: GLenum

pattern GL_TESS_GEN_SPACING_EXT = 0x8E77 :: GLenum

pattern GL_TESS_GEN_SPACING_OES = 0x8E77 :: GLenum

pattern GL_TESS_GEN_VERTEX_ORDER = 0x8E78 :: GLenum

pattern GL_TESS_GEN_VERTEX_ORDER_EXT = 0x8E78 :: GLenum

pattern GL_TESS_GEN_VERTEX_ORDER_OES = 0x8E78 :: GLenum

pattern GL_TEXCOORD1_BIT_PGI = 0x10000000 :: GLbitfield

pattern GL_TEXCOORD2_BIT_PGI = 0x20000000 :: GLbitfield

pattern GL_TEXCOORD3_BIT_PGI = 0x40000000 :: GLbitfield

pattern GL_TEXCOORD4_BIT_PGI = 0x80000000 :: GLbitfield

pattern GL_TEXTURE = 0x1702 :: GLenum

pattern GL_TEXTURE0 = 0x84C0 :: GLenum

pattern GL_TEXTURE0_ARB = 0x84C0 :: GLenum

pattern GL_TEXTURE1 = 0x84C1 :: GLenum

pattern GL_TEXTURE10 = 0x84CA :: GLenum

pattern GL_TEXTURE10_ARB = 0x84CA :: GLenum

pattern GL_TEXTURE11 = 0x84CB :: GLenum

pattern GL_TEXTURE11_ARB = 0x84CB :: GLenum

pattern GL_TEXTURE12 = 0x84CC :: GLenum

pattern GL_TEXTURE12_ARB = 0x84CC :: GLenum

pattern GL_TEXTURE13 = 0x84CD :: GLenum

pattern GL_TEXTURE13_ARB = 0x84CD :: GLenum

pattern GL_TEXTURE14 = 0x84CE :: GLenum

pattern GL_TEXTURE14_ARB = 0x84CE :: GLenum

pattern GL_TEXTURE15 = 0x84CF :: GLenum

pattern GL_TEXTURE15_ARB = 0x84CF :: GLenum

pattern GL_TEXTURE16 = 0x84D0 :: GLenum

pattern GL_TEXTURE16_ARB = 0x84D0 :: GLenum

pattern GL_TEXTURE17 = 0x84D1 :: GLenum

pattern GL_TEXTURE17_ARB = 0x84D1 :: GLenum

pattern GL_TEXTURE18 = 0x84D2 :: GLenum

pattern GL_TEXTURE18_ARB = 0x84D2 :: GLenum

pattern GL_TEXTURE19 = 0x84D3 :: GLenum

pattern GL_TEXTURE19_ARB = 0x84D3 :: GLenum

pattern GL_TEXTURE1_ARB = 0x84C1 :: GLenum

pattern GL_TEXTURE2 = 0x84C2 :: GLenum

pattern GL_TEXTURE20 = 0x84D4 :: GLenum

pattern GL_TEXTURE20_ARB = 0x84D4 :: GLenum

pattern GL_TEXTURE21 = 0x84D5 :: GLenum

pattern GL_TEXTURE21_ARB = 0x84D5 :: GLenum

pattern GL_TEXTURE22 = 0x84D6 :: GLenum

pattern GL_TEXTURE22_ARB = 0x84D6 :: GLenum

pattern GL_TEXTURE23 = 0x84D7 :: GLenum

pattern GL_TEXTURE23_ARB = 0x84D7 :: GLenum

pattern GL_TEXTURE24 = 0x84D8 :: GLenum

pattern GL_TEXTURE24_ARB = 0x84D8 :: GLenum

pattern GL_TEXTURE25 = 0x84D9 :: GLenum

pattern GL_TEXTURE25_ARB = 0x84D9 :: GLenum

pattern GL_TEXTURE26 = 0x84DA :: GLenum

pattern GL_TEXTURE26_ARB = 0x84DA :: GLenum

pattern GL_TEXTURE27 = 0x84DB :: GLenum

pattern GL_TEXTURE27_ARB = 0x84DB :: GLenum

pattern GL_TEXTURE28 = 0x84DC :: GLenum

pattern GL_TEXTURE28_ARB = 0x84DC :: GLenum

pattern GL_TEXTURE29 = 0x84DD :: GLenum

pattern GL_TEXTURE29_ARB = 0x84DD :: GLenum

pattern GL_TEXTURE2_ARB = 0x84C2 :: GLenum

pattern GL_TEXTURE3 = 0x84C3 :: GLenum

pattern GL_TEXTURE30 = 0x84DE :: GLenum

pattern GL_TEXTURE30_ARB = 0x84DE :: GLenum

pattern GL_TEXTURE31 = 0x84DF :: GLenum

pattern GL_TEXTURE31_ARB = 0x84DF :: GLenum

pattern GL_TEXTURE3_ARB = 0x84C3 :: GLenum

pattern GL_TEXTURE4 = 0x84C4 :: GLenum

pattern GL_TEXTURE4_ARB = 0x84C4 :: GLenum

pattern GL_TEXTURE5 = 0x84C5 :: GLenum

pattern GL_TEXTURE5_ARB = 0x84C5 :: GLenum

pattern GL_TEXTURE6 = 0x84C6 :: GLenum

pattern GL_TEXTURE6_ARB = 0x84C6 :: GLenum

pattern GL_TEXTURE7 = 0x84C7 :: GLenum

pattern GL_TEXTURE7_ARB = 0x84C7 :: GLenum

pattern GL_TEXTURE8 = 0x84C8 :: GLenum

pattern GL_TEXTURE8_ARB = 0x84C8 :: GLenum

pattern GL_TEXTURE9 = 0x84C9 :: GLenum

pattern GL_TEXTURE9_ARB = 0x84C9 :: GLenum

pattern GL_TEXTURE_1D = 0x0DE0 :: GLenum

pattern GL_TEXTURE_1D_ARRAY = 0x8C18 :: GLenum

pattern GL_TEXTURE_1D_ARRAY_EXT = 0x8C18 :: GLenum

pattern GL_TEXTURE_1D_BINDING_EXT = 0x8068 :: GLenum

pattern GL_TEXTURE_1D_STACK_BINDING_MESAX = 0x875D :: GLenum

pattern GL_TEXTURE_1D_STACK_MESAX = 0x8759 :: GLenum

pattern GL_TEXTURE_2D = 0x0DE1 :: GLenum

pattern GL_TEXTURE_2D_ARRAY = 0x8C1A :: GLenum

pattern GL_TEXTURE_2D_ARRAY_EXT = 0x8C1A :: GLenum

pattern GL_TEXTURE_2D_BINDING_EXT = 0x8069 :: GLenum

pattern GL_TEXTURE_2D_MULTISAMPLE = 0x9100 :: GLenum

pattern GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102 :: GLenum

pattern GL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES = 0x9102 :: GLenum

pattern GL_TEXTURE_2D_STACK_BINDING_MESAX = 0x875E :: GLenum

pattern GL_TEXTURE_2D_STACK_MESAX = 0x875A :: GLenum

pattern GL_TEXTURE_3D = 0x806F :: GLenum

pattern GL_TEXTURE_3D_BINDING_EXT = 0x806A :: GLenum

pattern GL_TEXTURE_3D_BINDING_OES = 0x806A :: GLenum

pattern GL_TEXTURE_3D_EXT = 0x806F :: GLenum

pattern GL_TEXTURE_3D_OES = 0x806F :: GLenum

pattern GL_TEXTURE_4DSIZE_SGIS = 0x8136 :: GLenum

pattern GL_TEXTURE_4D_BINDING_SGIS = 0x814F :: GLenum

pattern GL_TEXTURE_4D_SGIS = 0x8134 :: GLenum

pattern GL_TEXTURE_ALPHA_MODULATE_IMG = 0x8C06 :: GLenum

pattern GL_TEXTURE_ALPHA_SIZE = 0x805F :: GLenum

pattern GL_TEXTURE_ALPHA_SIZE_EXT = 0x805F :: GLenum

pattern GL_TEXTURE_ALPHA_TYPE = 0x8C13 :: GLenum

pattern GL_TEXTURE_ALPHA_TYPE_ARB = 0x8C13 :: GLenum

pattern GL_TEXTURE_APPLICATION_MODE_EXT = 0x834F :: GLenum

pattern GL_TEXTURE_BASE_LEVEL = 0x813C :: GLenum

pattern GL_TEXTURE_BASE_LEVEL_SGIS = 0x813C :: GLenum

pattern GL_TEXTURE_BINDING_1D = 0x8068 :: GLenum

pattern GL_TEXTURE_BINDING_1D_ARRAY = 0x8C1C :: GLenum

pattern GL_TEXTURE_BINDING_1D_ARRAY_EXT = 0x8C1C :: GLenum

pattern GL_TEXTURE_BINDING_2D = 0x8069 :: GLenum

pattern GL_TEXTURE_BINDING_2D_ARRAY = 0x8C1D :: GLenum

pattern GL_TEXTURE_BINDING_2D_ARRAY_EXT = 0x8C1D :: GLenum

pattern GL_TEXTURE_BINDING_2D_MULTISAMPLE = 0x9104 :: GLenum

pattern GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 0x9105 :: GLenum

pattern GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES = 0x9105 :: GLenum

pattern GL_TEXTURE_BINDING_3D = 0x806A :: GLenum

pattern GL_TEXTURE_BINDING_3D_OES = 0x806A :: GLenum

pattern GL_TEXTURE_BINDING_BUFFER = 0x8C2C :: GLenum

pattern GL_TEXTURE_BINDING_BUFFER_ARB = 0x8C2C :: GLenum

pattern GL_TEXTURE_BINDING_BUFFER_EXT = 0x8C2C :: GLenum

pattern GL_TEXTURE_BINDING_BUFFER_OES = 0x8C2C :: GLenum

pattern GL_TEXTURE_BINDING_CUBE_MAP = 0x8514 :: GLenum

pattern GL_TEXTURE_BINDING_CUBE_MAP_ARB = 0x8514 :: GLenum

pattern GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 0x900A :: GLenum

pattern GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB = 0x900A :: GLenum

pattern GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT = 0x900A :: GLenum

pattern GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_OES = 0x900A :: GLenum

pattern GL_TEXTURE_BINDING_CUBE_MAP_EXT = 0x8514 :: GLenum

pattern GL_TEXTURE_BINDING_CUBE_MAP_OES = 0x8514 :: GLenum

pattern GL_TEXTURE_BINDING_EXTERNAL_OES = 0x8D67 :: GLenum

pattern GL_TEXTURE_BINDING_RECTANGLE = 0x84F6 :: GLenum

pattern GL_TEXTURE_BINDING_RECTANGLE_ARB = 0x84F6 :: GLenum

pattern GL_TEXTURE_BINDING_RECTANGLE_NV = 0x84F6 :: GLenum

pattern GL_TEXTURE_BINDING_RENDERBUFFER_NV = 0x8E53 :: GLenum

pattern GL_TEXTURE_BIT = 0x00040000 :: GLbitfield

pattern GL_TEXTURE_BLUE_SIZE = 0x805E :: GLenum

pattern GL_TEXTURE_BLUE_SIZE_EXT = 0x805E :: GLenum

pattern GL_TEXTURE_BLUE_TYPE = 0x8C12 :: GLenum

pattern GL_TEXTURE_BLUE_TYPE_ARB = 0x8C12 :: GLenum

pattern GL_TEXTURE_BORDER = 0x1005 :: GLenum

pattern GL_TEXTURE_BORDER_COLOR = 0x1004 :: GLenum

pattern GL_TEXTURE_BORDER_COLOR_EXT = 0x1004 :: GLenum

pattern GL_TEXTURE_BORDER_COLOR_NV = 0x1004 :: GLenum

pattern GL_TEXTURE_BORDER_COLOR_OES = 0x1004 :: GLenum

pattern GL_TEXTURE_BORDER_VALUES_NV = 0x871A :: GLenum

pattern GL_TEXTURE_BUFFER = 0x8C2A :: GLenum

pattern GL_TEXTURE_BUFFER_ARB = 0x8C2A :: GLenum

pattern GL_TEXTURE_BUFFER_BINDING = 0x8C2A :: GLenum

pattern GL_TEXTURE_BUFFER_BINDING_EXT = 0x8C2A :: GLenum

pattern GL_TEXTURE_BUFFER_BINDING_OES = 0x8C2A :: GLenum

pattern GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 0x8C2D :: GLenum

pattern GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB = 0x8C2D :: GLenum

pattern GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT = 0x8C2D :: GLenum

pattern GL_TEXTURE_BUFFER_DATA_STORE_BINDING_OES = 0x8C2D :: GLenum

pattern GL_TEXTURE_BUFFER_EXT = 0x8C2A :: GLenum

pattern GL_TEXTURE_BUFFER_FORMAT_ARB = 0x8C2E :: GLenum

pattern GL_TEXTURE_BUFFER_FORMAT_EXT = 0x8C2E :: GLenum

pattern GL_TEXTURE_BUFFER_OES = 0x8C2A :: GLenum

pattern GL_TEXTURE_BUFFER_OFFSET = 0x919D :: GLenum

pattern GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 0x919F :: GLenum

pattern GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT = 0x919F :: GLenum

pattern GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_OES = 0x919F :: GLenum

pattern GL_TEXTURE_BUFFER_OFFSET_EXT = 0x919D :: GLenum

pattern GL_TEXTURE_BUFFER_OFFSET_OES = 0x919D :: GLenum

pattern GL_TEXTURE_BUFFER_SIZE = 0x919E :: GLenum

pattern GL_TEXTURE_BUFFER_SIZE_EXT = 0x919E :: GLenum

pattern GL_TEXTURE_BUFFER_SIZE_OES = 0x919E :: GLenum

pattern GL_TEXTURE_CLIPMAP_CENTER_SGIX = 0x8171 :: GLenum

pattern GL_TEXTURE_CLIPMAP_DEPTH_SGIX = 0x8176 :: GLenum

pattern GL_TEXTURE_CLIPMAP_FRAME_SGIX = 0x8172 :: GLenum

pattern GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = 0x8175 :: GLenum

pattern GL_TEXTURE_CLIPMAP_OFFSET_SGIX = 0x8173 :: GLenum

pattern GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = 0x8174 :: GLenum

pattern GL_TEXTURE_COLOR_SAMPLES_NV = 0x9046 :: GLenum

pattern GL_TEXTURE_COLOR_TABLE_SGI = 0x80BC :: GLenum

pattern GL_TEXTURE_COLOR_WRITEMASK_SGIS = 0x81EF :: GLenum

pattern GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = 0x80BF :: GLenum

pattern GL_TEXTURE_COMPARE_FUNC = 0x884D :: GLenum

pattern GL_TEXTURE_COMPARE_FUNC_ARB = 0x884D :: GLenum

pattern GL_TEXTURE_COMPARE_FUNC_EXT = 0x884D :: GLenum

pattern GL_TEXTURE_COMPARE_MODE = 0x884C :: GLenum

pattern GL_TEXTURE_COMPARE_MODE_ARB = 0x884C :: GLenum

pattern GL_TEXTURE_COMPARE_MODE_EXT = 0x884C :: GLenum

pattern GL_TEXTURE_COMPARE_OPERATOR_SGIX = 0x819B :: GLenum

pattern GL_TEXTURE_COMPARE_SGIX = 0x819A :: GLenum

pattern GL_TEXTURE_COMPONENTS = 0x1003 :: GLenum

pattern GL_TEXTURE_COMPRESSED = 0x86A1 :: GLenum

pattern GL_TEXTURE_COMPRESSED_ARB = 0x86A1 :: GLenum

pattern GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 0x82B2 :: GLenum

pattern GL_TEXTURE_COMPRESSED_BLOCK_SIZE = 0x82B3 :: GLenum

pattern GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = 0x82B1 :: GLenum

pattern GL_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0 :: GLenum

pattern GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = 0x86A0 :: GLenum

pattern GL_TEXTURE_COMPRESSION_HINT = 0x84EF :: GLenum

pattern GL_TEXTURE_COMPRESSION_HINT_ARB = 0x84EF :: GLenum

pattern GL_TEXTURE_CONSTANT_DATA_SUNX = 0x81D6 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY = 0x8078 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_ADDRESS_NV = 0x8F25 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 0x889A :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = 0x889A :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_COUNT_EXT = 0x808B :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_EXT = 0x8078 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_LENGTH_NV = 0x8F2F :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_LIST_IBM = 103074 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM = 103084 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F8 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_POINTER = 0x8092 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_POINTER_EXT = 0x8092 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_SIZE = 0x8088 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_SIZE_EXT = 0x8088 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_STRIDE = 0x808A :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = 0x808A :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_TYPE = 0x8089 :: GLenum

pattern GL_TEXTURE_COORD_ARRAY_TYPE_EXT = 0x8089 :: GLenum

pattern GL_TEXTURE_COORD_NV = 0x8C79 :: GLenum

pattern GL_TEXTURE_COVERAGE_SAMPLES_NV = 0x9045 :: GLenum

pattern GL_TEXTURE_CROP_RECT_OES = 0x8B9D :: GLenum

pattern GL_TEXTURE_CUBE_MAP = 0x8513 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_ARB = 0x8513 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_ARRAY = 0x9009 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x9009 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_ARRAY_EXT = 0x9009 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_ARRAY_OES = 0x9009 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_EXT = 0x8513 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = 0x8516 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT = 0x8516 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES = 0x8516 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = 0x8518 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT = 0x8518 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES = 0x8518 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = 0x851A :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT = 0x851A :: GLenum

pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES = 0x851A :: GLenum

pattern GL_TEXTURE_CUBE_MAP_OES = 0x8513 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = 0x8515 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT = 0x8515 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES = 0x8515 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = 0x8517 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT = 0x8517 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES = 0x8517 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = 0x8519 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT = 0x8519 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES = 0x8519 :: GLenum

pattern GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F :: GLenum

pattern GL_TEXTURE_DEFORMATION_BIT_SGIX = 0x00000001 :: GLbitfield

pattern GL_TEXTURE_DEFORMATION_SGIX = 0x8195 :: GLenum

pattern GL_TEXTURE_DEPTH = 0x8071 :: GLenum

pattern GL_TEXTURE_DEPTH_EXT = 0x8071 :: GLenum

pattern GL_TEXTURE_DEPTH_QCOM = 0x8BD4 :: GLenum

pattern GL_TEXTURE_DEPTH_SIZE = 0x884A :: GLenum

pattern GL_TEXTURE_DEPTH_SIZE_ARB = 0x884A :: GLenum

pattern GL_TEXTURE_DEPTH_TYPE = 0x8C16 :: GLenum

pattern GL_TEXTURE_DEPTH_TYPE_ARB = 0x8C16 :: GLenum

pattern GL_TEXTURE_DS_SIZE_NV = 0x871D :: GLenum

pattern GL_TEXTURE_DT_SIZE_NV = 0x871E :: GLenum

pattern GL_TEXTURE_ENV = 0x2300 :: GLenum

pattern GL_TEXTURE_ENV_BIAS_SGIX = 0x80BE :: GLenum

pattern GL_TEXTURE_ENV_COLOR = 0x2201 :: GLenum

pattern GL_TEXTURE_ENV_MODE = 0x2200 :: GLenum

pattern GL_TEXTURE_EXTERNAL_OES = 0x8D65 :: GLenum

pattern GL_TEXTURE_FETCH_BARRIER_BIT = 0x00000008 :: GLbitfield

pattern GL_TEXTURE_FETCH_BARRIER_BIT_EXT = 0x00000008 :: GLbitfield

pattern GL_TEXTURE_FILTER4_SIZE_SGIS = 0x8147 :: GLenum

pattern GL_TEXTURE_FILTER_CONTROL = 0x8500 :: GLenum

pattern GL_TEXTURE_FILTER_CONTROL_EXT = 0x8500 :: GLenum

pattern GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 0x9107 :: GLenum

pattern GL_TEXTURE_FLOAT_COMPONENTS_NV = 0x888C :: GLenum

pattern GL_TEXTURE_FORMAT_QCOM = 0x8BD6 :: GLenum

pattern GL_TEXTURE_FREE_MEMORY_ATI = 0x87FC :: GLenum

pattern GL_TEXTURE_GATHER = 0x82A2 :: GLenum

pattern GL_TEXTURE_GATHER_SHADOW = 0x82A3 :: GLenum

pattern GL_TEXTURE_GEN_MODE = 0x2500 :: GLenum

pattern GL_TEXTURE_GEN_MODE_OES = 0x2500 :: GLenum

pattern GL_TEXTURE_GEN_Q = 0x0C63 :: GLenum

pattern GL_TEXTURE_GEN_R = 0x0C62 :: GLenum

pattern GL_TEXTURE_GEN_S = 0x0C60 :: GLenum

pattern GL_TEXTURE_GEN_STR_OES = 0x8D60 :: GLenum

pattern GL_TEXTURE_GEN_T = 0x0C61 :: GLenum

pattern GL_TEXTURE_GEQUAL_R_SGIX = 0x819D :: GLenum

pattern GL_TEXTURE_GREEN_SIZE = 0x805D :: GLenum

pattern GL_TEXTURE_GREEN_SIZE_EXT = 0x805D :: GLenum

pattern GL_TEXTURE_GREEN_TYPE = 0x8C11 :: GLenum

pattern GL_TEXTURE_GREEN_TYPE_ARB = 0x8C11 :: GLenum

pattern GL_TEXTURE_HEIGHT = 0x1001 :: GLenum

pattern GL_TEXTURE_HEIGHT_QCOM = 0x8BD3 :: GLenum

pattern GL_TEXTURE_HI_SIZE_NV = 0x871B :: GLenum

pattern GL_TEXTURE_IMAGE_FORMAT = 0x828F :: GLenum

pattern GL_TEXTURE_IMAGE_TYPE = 0x8290 :: GLenum

pattern GL_TEXTURE_IMAGE_VALID_QCOM = 0x8BD8 :: GLenum

pattern GL_TEXTURE_IMMUTABLE_FORMAT = 0x912F :: GLenum

pattern GL_TEXTURE_IMMUTABLE_FORMAT_EXT = 0x912F :: GLenum

pattern GL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF :: GLenum

pattern GL_TEXTURE_INDEX_SIZE_EXT = 0x80ED :: GLenum

pattern GL_TEXTURE_INTENSITY_SIZE = 0x8061 :: GLenum

pattern GL_TEXTURE_INTENSITY_SIZE_EXT = 0x8061 :: GLenum

pattern GL_TEXTURE_INTENSITY_TYPE = 0x8C15 :: GLenum

pattern GL_TEXTURE_INTENSITY_TYPE_ARB = 0x8C15 :: GLenum

pattern GL_TEXTURE_INTERNAL_FORMAT = 0x1003 :: GLenum

pattern GL_TEXTURE_INTERNAL_FORMAT_QCOM = 0x8BD5 :: GLenum

pattern GL_TEXTURE_LEQUAL_R_SGIX = 0x819C :: GLenum

pattern GL_TEXTURE_LIGHTING_MODE_HP = 0x8167 :: GLenum

pattern GL_TEXTURE_LIGHT_EXT = 0x8350 :: GLenum

pattern GL_TEXTURE_LOD_BIAS = 0x8501 :: GLenum

pattern GL_TEXTURE_LOD_BIAS_EXT = 0x8501 :: GLenum

pattern GL_TEXTURE_LOD_BIAS_R_SGIX = 0x8190 :: GLenum

pattern GL_TEXTURE_LOD_BIAS_S_SGIX = 0x818E :: GLenum

pattern GL_TEXTURE_LOD_BIAS_T_SGIX = 0x818F :: GLenum

pattern GL_TEXTURE_LO_SIZE_NV = 0x871C :: GLenum

pattern GL_TEXTURE_LUMINANCE_SIZE = 0x8060 :: GLenum

pattern GL_TEXTURE_LUMINANCE_SIZE_EXT = 0x8060 :: GLenum

pattern GL_TEXTURE_LUMINANCE_TYPE = 0x8C14 :: GLenum

pattern GL_TEXTURE_LUMINANCE_TYPE_ARB = 0x8C14 :: GLenum

pattern GL_TEXTURE_MAG_FILTER = 0x2800 :: GLenum

pattern GL_TEXTURE_MAG_SIZE_NV = 0x871F :: GLenum

pattern GL_TEXTURE_MATERIAL_FACE_EXT = 0x8351 :: GLenum

pattern GL_TEXTURE_MATERIAL_PARAMETER_EXT = 0x8352 :: GLenum

pattern GL_TEXTURE_MATRIX = 0x0BA8 :: GLenum

pattern GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES = 0x898F :: GLenum

pattern GL_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE :: GLenum

pattern GL_TEXTURE_MAX_CLAMP_R_SGIX = 0x836B :: GLenum

pattern GL_TEXTURE_MAX_CLAMP_S_SGIX = 0x8369 :: GLenum

pattern GL_TEXTURE_MAX_CLAMP_T_SGIX = 0x836A :: GLenum

pattern GL_TEXTURE_MAX_LEVEL = 0x813D :: GLenum

pattern GL_TEXTURE_MAX_LEVEL_APPLE = 0x813D :: GLenum

pattern GL_TEXTURE_MAX_LEVEL_SGIS = 0x813D :: GLenum

pattern GL_TEXTURE_MAX_LOD = 0x813B :: GLenum

pattern GL_TEXTURE_MAX_LOD_SGIS = 0x813B :: GLenum

pattern GL_TEXTURE_MEMORY_LAYOUT_INTEL = 0x83FF :: GLenum

pattern GL_TEXTURE_MIN_FILTER = 0x2801 :: GLenum

pattern GL_TEXTURE_MIN_LOD = 0x813A :: GLenum

pattern GL_TEXTURE_MIN_LOD_SGIS = 0x813A :: GLenum

pattern GL_TEXTURE_MULTI_BUFFER_HINT_SGIX = 0x812E :: GLenum

pattern GL_TEXTURE_NORMAL_EXT = 0x85AF :: GLenum

pattern GL_TEXTURE_NUM_LEVELS_QCOM = 0x8BD9 :: GLenum

pattern GL_TEXTURE_OBJECT_VALID_QCOM = 0x8BDB :: GLenum

pattern GL_TEXTURE_POST_SPECULAR_HP = 0x8168 :: GLenum

pattern GL_TEXTURE_PRE_SPECULAR_HP = 0x8169 :: GLenum

pattern GL_TEXTURE_PRIORITY = 0x8066 :: GLenum

pattern GL_TEXTURE_PRIORITY_EXT = 0x8066 :: GLenum

pattern GL_TEXTURE_PROTECTED_EXT = 0x8BFA :: GLenum

pattern GL_TEXTURE_RANGE_LENGTH_APPLE = 0x85B7 :: GLenum

pattern GL_TEXTURE_RANGE_POINTER_APPLE = 0x85B8 :: GLenum

pattern GL_TEXTURE_RECTANGLE = 0x84F5 :: GLenum

pattern GL_TEXTURE_RECTANGLE_ARB = 0x84F5 :: GLenum

pattern GL_TEXTURE_RECTANGLE_NV = 0x84F5 :: GLenum

pattern GL_TEXTURE_REDUCTION_MODE_ARB = 0x9366 :: GLenum

pattern GL_TEXTURE_RED_SIZE = 0x805C :: GLenum

pattern GL_TEXTURE_RED_SIZE_EXT = 0x805C :: GLenum

pattern GL_TEXTURE_RED_TYPE = 0x8C10 :: GLenum

pattern GL_TEXTURE_RED_TYPE_ARB = 0x8C10 :: GLenum

pattern GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV = 0x8E54 :: GLenum

pattern GL_TEXTURE_RENDERBUFFER_NV = 0x8E55 :: GLenum

pattern GL_TEXTURE_RESIDENT = 0x8067 :: GLenum

pattern GL_TEXTURE_RESIDENT_EXT = 0x8067 :: GLenum

pattern GL_TEXTURE_SAMPLES = 0x9106 :: GLenum

pattern GL_TEXTURE_SAMPLES_IMG = 0x9136 :: GLenum

pattern GL_TEXTURE_SHADER_NV = 0x86DE :: GLenum

pattern GL_TEXTURE_SHADOW = 0x82A1 :: GLenum

pattern GL_TEXTURE_SHARED_SIZE = 0x8C3F :: GLenum

pattern GL_TEXTURE_SHARED_SIZE_EXT = 0x8C3F :: GLenum

pattern GL_TEXTURE_SPARSE_ARB = 0x91A6 :: GLenum

pattern GL_TEXTURE_SPARSE_EXT = 0x91A6 :: GLenum

pattern GL_TEXTURE_SRGB_DECODE_EXT = 0x8A48 :: GLenum

pattern GL_TEXTURE_STACK_DEPTH = 0x0BA5 :: GLenum

pattern GL_TEXTURE_STENCIL_SIZE = 0x88F1 :: GLenum

pattern GL_TEXTURE_STENCIL_SIZE_EXT = 0x88F1 :: GLenum

pattern GL_TEXTURE_STORAGE_HINT_APPLE = 0x85BC :: GLenum

pattern GL_TEXTURE_STORAGE_SPARSE_BIT_AMD = 0x00000001 :: GLbitfield

pattern GL_TEXTURE_SWIZZLE_A = 0x8E45 :: GLenum

pattern GL_TEXTURE_SWIZZLE_A_EXT = 0x8E45 :: GLenum

pattern GL_TEXTURE_SWIZZLE_B = 0x8E44 :: GLenum

pattern GL_TEXTURE_SWIZZLE_B_EXT = 0x8E44 :: GLenum

pattern GL_TEXTURE_SWIZZLE_G = 0x8E43 :: GLenum

pattern GL_TEXTURE_SWIZZLE_G_EXT = 0x8E43 :: GLenum

pattern GL_TEXTURE_SWIZZLE_R = 0x8E42 :: GLenum

pattern GL_TEXTURE_SWIZZLE_RGBA = 0x8E46 :: GLenum

pattern GL_TEXTURE_SWIZZLE_RGBA_EXT = 0x8E46 :: GLenum

pattern GL_TEXTURE_SWIZZLE_R_EXT = 0x8E42 :: GLenum

pattern GL_TEXTURE_TARGET = 0x1006 :: GLenum

pattern GL_TEXTURE_TARGET_QCOM = 0x8BDA :: GLenum

pattern GL_TEXTURE_TOO_LARGE_EXT = 0x8065 :: GLenum

pattern GL_TEXTURE_TYPE_QCOM = 0x8BD7 :: GLenum

pattern GL_TEXTURE_UNSIGNED_REMAP_MODE_NV = 0x888F :: GLenum

pattern GL_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100 :: GLbitfield

pattern GL_TEXTURE_UPDATE_BARRIER_BIT_EXT = 0x00000100 :: GLbitfield

pattern GL_TEXTURE_USAGE_ANGLE = 0x93A2 :: GLenum

pattern GL_TEXTURE_VIEW = 0x82B5 :: GLenum

pattern GL_TEXTURE_VIEW_MIN_LAYER = 0x82DD :: GLenum

pattern GL_TEXTURE_VIEW_MIN_LAYER_EXT = 0x82DD :: GLenum

pattern GL_TEXTURE_VIEW_MIN_LAYER_OES = 0x82DD :: GLenum

pattern GL_TEXTURE_VIEW_MIN_LEVEL = 0x82DB :: GLenum

pattern GL_TEXTURE_VIEW_MIN_LEVEL_EXT = 0x82DB :: GLenum

pattern GL_TEXTURE_VIEW_MIN_LEVEL_OES = 0x82DB :: GLenum

pattern GL_TEXTURE_VIEW_NUM_LAYERS = 0x82DE :: GLenum

pattern GL_TEXTURE_VIEW_NUM_LAYERS_EXT = 0x82DE :: GLenum

pattern GL_TEXTURE_VIEW_NUM_LAYERS_OES = 0x82DE :: GLenum

pattern GL_TEXTURE_VIEW_NUM_LEVELS = 0x82DC :: GLenum

pattern GL_TEXTURE_VIEW_NUM_LEVELS_EXT = 0x82DC :: GLenum

pattern GL_TEXTURE_VIEW_NUM_LEVELS_OES = 0x82DC :: GLenum

pattern GL_TEXTURE_WIDTH = 0x1000 :: GLenum

pattern GL_TEXTURE_WIDTH_QCOM = 0x8BD2 :: GLenum

pattern GL_TEXTURE_WRAP_Q_SGIS = 0x8137 :: GLenum

pattern GL_TEXTURE_WRAP_R = 0x8072 :: GLenum

pattern GL_TEXTURE_WRAP_R_EXT = 0x8072 :: GLenum

pattern GL_TEXTURE_WRAP_R_OES = 0x8072 :: GLenum

pattern GL_TEXTURE_WRAP_S = 0x2802 :: GLenum

pattern GL_TEXTURE_WRAP_T = 0x2803 :: GLenum

pattern GL_TEXT_FRAGMENT_SHADER_ATI = 0x8200 :: GLenum

pattern GL_TIMEOUT_EXPIRED = 0x911B :: GLenum

pattern GL_TIMEOUT_EXPIRED_APPLE = 0x911B :: GLenum

pattern GL_TIMEOUT_IGNORED = 0xFFFFFFFFFFFFFFFF :: GLuint64

pattern GL_TIMEOUT_IGNORED_APPLE = 0xFFFFFFFFFFFFFFFF :: GLuint64

pattern GL_TIMESTAMP = 0x8E28 :: GLenum

pattern GL_TIMESTAMP_EXT = 0x8E28 :: GLenum

pattern GL_TIME_ELAPSED = 0x88BF :: GLenum

pattern GL_TIME_ELAPSED_EXT = 0x88BF :: GLenum

pattern GL_TOP_LEVEL_ARRAY_SIZE = 0x930C :: GLenum

pattern GL_TOP_LEVEL_ARRAY_STRIDE = 0x930D :: GLenum

pattern GL_TRACE_ALL_BITS_MESA = 0xFFFF :: GLbitfield

pattern GL_TRACE_ARRAYS_BIT_MESA = 0x0004 :: GLbitfield

pattern GL_TRACE_ERRORS_BIT_MESA = 0x0020 :: GLbitfield

pattern GL_TRACE_MASK_MESA = 0x8755 :: GLenum

pattern GL_TRACE_NAME_MESA = 0x8756 :: GLenum

pattern GL_TRACE_OPERATIONS_BIT_MESA = 0x0001 :: GLbitfield

pattern GL_TRACE_PIXELS_BIT_MESA = 0x0010 :: GLbitfield

pattern GL_TRACE_PRIMITIVES_BIT_MESA = 0x0002 :: GLbitfield

pattern GL_TRACE_TEXTURES_BIT_MESA = 0x0008 :: GLbitfield

pattern GL_TRACK_MATRIX_NV = 0x8648 :: GLenum

pattern GL_TRACK_MATRIX_TRANSFORM_NV = 0x8649 :: GLenum

pattern GL_TRANSFORM_BIT = 0x00001000 :: GLbitfield

pattern GL_TRANSFORM_FEEDBACK = 0x8E22 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_ACTIVE = 0x8E24 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = 0x8C7E :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 0x00000800 :: GLbitfield

pattern GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT = 0x00000800 :: GLbitfield

pattern GL_TRANSFORM_FEEDBACK_BINDING = 0x8E25 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BINDING_NV = 0x8E25 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 0x8E24 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV = 0x8E24 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 0x8C8F :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = 0x8C8F :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 0x8C8F :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_EXT = 0x8C8E :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 0x934B :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = 0x8C7F :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 0x8C7F :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_NV = 0x8C8E :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 0x8E23 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV = 0x8E23 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 0x8C85 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = 0x8C85 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = 0x8C85 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_START = 0x8C84 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT = 0x8C84 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = 0x8C84 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 0x934C :: GLenum

pattern GL_TRANSFORM_FEEDBACK_NV = 0x8E22 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB = 0x82EC :: GLenum

pattern GL_TRANSFORM_FEEDBACK_PAUSED = 0x8E23 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = 0x8C88 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 0x8C88 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_RECORD_NV = 0x8C86 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB = 0x82ED :: GLenum

pattern GL_TRANSFORM_FEEDBACK_VARYING = 0x92F4 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_VARYINGS_EXT = 0x8C83 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_VARYINGS_NV = 0x8C83 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 0x8C76 :: GLenum

pattern GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = 0x8C76 :: GLenum

pattern GL_TRANSFORM_HINT_APPLE = 0x85B1 :: GLenum

pattern GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE = 0x93A0 :: GLenum

pattern GL_TRANSLATE_2D_NV = 0x9090 :: GLenum

pattern GL_TRANSLATE_3D_NV = 0x9091 :: GLenum

pattern GL_TRANSLATE_X_NV = 0x908E :: GLenum

pattern GL_TRANSLATE_Y_NV = 0x908F :: GLenum

pattern GL_TRANSPOSE_AFFINE_2D_NV = 0x9096 :: GLenum

pattern GL_TRANSPOSE_AFFINE_3D_NV = 0x9098 :: GLenum

pattern GL_TRANSPOSE_COLOR_MATRIX = 0x84E6 :: GLenum

pattern GL_TRANSPOSE_COLOR_MATRIX_ARB = 0x84E6 :: GLenum

pattern GL_TRANSPOSE_CURRENT_MATRIX_ARB = 0x88B7 :: GLenum

pattern GL_TRANSPOSE_MODELVIEW_MATRIX = 0x84E3 :: GLenum

pattern GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = 0x84E3 :: GLenum

pattern GL_TRANSPOSE_NV = 0x862C :: GLenum

pattern GL_TRANSPOSE_PROGRAM_MATRIX_EXT = 0x8E2E :: GLenum

pattern GL_TRANSPOSE_PROJECTION_MATRIX = 0x84E4 :: GLenum

pattern GL_TRANSPOSE_PROJECTION_MATRIX_ARB = 0x84E4 :: GLenum

pattern GL_TRANSPOSE_TEXTURE_MATRIX = 0x84E5 :: GLenum

pattern GL_TRANSPOSE_TEXTURE_MATRIX_ARB = 0x84E5 :: GLenum

pattern GL_TRIANGLES = 0x0004 :: GLenum

pattern GL_TRIANGLES_ADJACENCY = 0x000C :: GLenum

pattern GL_TRIANGLES_ADJACENCY_ARB = 0x000C :: GLenum

pattern GL_TRIANGLES_ADJACENCY_EXT = 0x000C :: GLenum

pattern GL_TRIANGLES_ADJACENCY_OES = 0x000C :: GLenum

pattern GL_TRIANGLE_FAN = 0x0006 :: GLenum

pattern GL_TRIANGLE_LIST_SUN = 0x81D7 :: GLenum

pattern GL_TRIANGLE_MESH_SUN = 0x8615 :: GLenum

pattern GL_TRIANGLE_STRIP = 0x0005 :: GLenum

pattern GL_TRIANGLE_STRIP_ADJACENCY = 0x000D :: GLenum

pattern GL_TRIANGLE_STRIP_ADJACENCY_ARB = 0x000D :: GLenum

pattern GL_TRIANGLE_STRIP_ADJACENCY_EXT = 0x000D :: GLenum

pattern GL_TRIANGLE_STRIP_ADJACENCY_OES = 0x000D :: GLenum

pattern GL_TRIANGULAR_NV = 0x90A5 :: GLenum

pattern GL_TRUE = 1 :: GLboolean

pattern GL_TYPE = 0x92FA :: GLenum

pattern GL_UNCORRELATED_NV = 0x9282 :: GLenum

pattern GL_UNDEFINED_APPLE = 0x8A1C :: GLenum

pattern GL_UNDEFINED_VERTEX = 0x8260 :: GLenum

pattern GL_UNDEFINED_VERTEX_EXT = 0x8260 :: GLenum

pattern GL_UNDEFINED_VERTEX_OES = 0x8260 :: GLenum

pattern GL_UNIFORM = 0x92E1 :: GLenum

pattern GL_UNIFORM_ADDRESS_COMMAND_NV = 0x000A :: GLenum

pattern GL_UNIFORM_ARRAY_STRIDE = 0x8A3C :: GLenum

pattern GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA :: GLenum

pattern GL_UNIFORM_BARRIER_BIT = 0x00000004 :: GLbitfield

pattern GL_UNIFORM_BARRIER_BIT_EXT = 0x00000004 :: GLbitfield

pattern GL_UNIFORM_BLOCK = 0x92E2 :: GLenum

pattern GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42 :: GLenum

pattern GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43 :: GLenum

pattern GL_UNIFORM_BLOCK_BINDING = 0x8A3F :: GLenum

pattern GL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40 :: GLenum

pattern GL_UNIFORM_BLOCK_INDEX = 0x8A3A :: GLenum

pattern GL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41 :: GLenum

pattern GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC :: GLenum

pattern GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46 :: GLenum

pattern GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45 :: GLenum

pattern GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0 :: GLenum

pattern GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1 :: GLenum

pattern GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44 :: GLenum

pattern GL_UNIFORM_BUFFER = 0x8A11 :: GLenum

pattern GL_UNIFORM_BUFFER_ADDRESS_NV = 0x936F :: GLenum

pattern GL_UNIFORM_BUFFER_BINDING = 0x8A28 :: GLenum

pattern GL_UNIFORM_BUFFER_BINDING_EXT = 0x8DEF :: GLenum

pattern GL_UNIFORM_BUFFER_EXT = 0x8DEE :: GLenum

pattern GL_UNIFORM_BUFFER_LENGTH_NV = 0x9370 :: GLenum

pattern GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 0x8A34 :: GLenum

pattern GL_UNIFORM_BUFFER_SIZE = 0x8A2A :: GLenum

pattern GL_UNIFORM_BUFFER_START = 0x8A29 :: GLenum

pattern GL_UNIFORM_BUFFER_UNIFIED_NV = 0x936E :: GLenum

pattern GL_UNIFORM_IS_ROW_MAJOR = 0x8A3E :: GLenum

pattern GL_UNIFORM_MATRIX_STRIDE = 0x8A3D :: GLenum

pattern GL_UNIFORM_NAME_LENGTH = 0x8A39 :: GLenum

pattern GL_UNIFORM_OFFSET = 0x8A3B :: GLenum

pattern GL_UNIFORM_SIZE = 0x8A38 :: GLenum

pattern GL_UNIFORM_TYPE = 0x8A37 :: GLenum

pattern GL_UNKNOWN_CONTEXT_RESET = 0x8255 :: GLenum

pattern GL_UNKNOWN_CONTEXT_RESET_ARB = 0x8255 :: GLenum

pattern GL_UNKNOWN_CONTEXT_RESET_EXT = 0x8255 :: GLenum

pattern GL_UNKNOWN_CONTEXT_RESET_KHR = 0x8255 :: GLenum

pattern GL_UNPACK_ALIGNMENT = 0x0CF5 :: GLenum

pattern GL_UNPACK_CLIENT_STORAGE_APPLE = 0x85B2 :: GLenum

pattern GL_UNPACK_CMYK_HINT_EXT = 0x800F :: GLenum

pattern GL_UNPACK_COLORSPACE_CONVERSION_WEBGL = 0x9243 :: GLenum

pattern GL_UNPACK_COMPRESSED_BLOCK_DEPTH = 0x9129 :: GLenum

pattern GL_UNPACK_COMPRESSED_BLOCK_HEIGHT = 0x9128 :: GLenum

pattern GL_UNPACK_COMPRESSED_BLOCK_SIZE = 0x912A :: GLenum

pattern GL_UNPACK_COMPRESSED_BLOCK_WIDTH = 0x9127 :: GLenum

pattern GL_UNPACK_COMPRESSED_SIZE_SGIX = 0x831A :: GLenum

pattern GL_UNPACK_CONSTANT_DATA_SUNX = 0x81D5 :: GLenum

pattern GL_UNPACK_FLIP_Y_WEBGL = 0x9240 :: GLenum

pattern GL_UNPACK_IMAGE_DEPTH_SGIS = 0x8133 :: GLenum

pattern GL_UNPACK_IMAGE_HEIGHT = 0x806E :: GLenum

pattern GL_UNPACK_IMAGE_HEIGHT_EXT = 0x806E :: GLenum

pattern GL_UNPACK_LSB_FIRST = 0x0CF1 :: GLenum

pattern GL_UNPACK_PREMULTIPLY_ALPHA_WEBGL = 0x9241 :: GLenum

pattern GL_UNPACK_RESAMPLE_OML = 0x8985 :: GLenum

pattern GL_UNPACK_RESAMPLE_SGIX = 0x842F :: GLenum

pattern GL_UNPACK_ROW_BYTES_APPLE = 0x8A16 :: GLenum

pattern GL_UNPACK_ROW_LENGTH = 0x0CF2 :: GLenum

pattern GL_UNPACK_ROW_LENGTH_EXT = 0x0CF2 :: GLenum

pattern GL_UNPACK_SKIP_IMAGES = 0x806D :: GLenum

pattern GL_UNPACK_SKIP_IMAGES_EXT = 0x806D :: GLenum

pattern GL_UNPACK_SKIP_PIXELS = 0x0CF4 :: GLenum

pattern GL_UNPACK_SKIP_PIXELS_EXT = 0x0CF4 :: GLenum

pattern GL_UNPACK_SKIP_ROWS = 0x0CF3 :: GLenum

pattern GL_UNPACK_SKIP_ROWS_EXT = 0x0CF3 :: GLenum

pattern GL_UNPACK_SKIP_VOLUMES_SGIS = 0x8132 :: GLenum

pattern GL_UNPACK_SUBSAMPLE_RATE_SGIX = 0x85A1 :: GLenum

pattern GL_UNPACK_SWAP_BYTES = 0x0CF0 :: GLenum

pattern GL_UNSIGNALED = 0x9118 :: GLenum

pattern GL_UNSIGNALED_APPLE = 0x9118 :: GLenum

pattern GL_UNSIGNED_BYTE = 0x1401 :: GLenum

pattern GL_UNSIGNED_BYTE_2_3_3_REV = 0x8362 :: GLenum

pattern GL_UNSIGNED_BYTE_2_3_3_REV_EXT = 0x8362 :: GLenum

pattern GL_UNSIGNED_BYTE_3_3_2 = 0x8032 :: GLenum

pattern GL_UNSIGNED_BYTE_3_3_2_EXT = 0x8032 :: GLenum

pattern GL_UNSIGNED_IDENTITY_NV = 0x8536 :: GLenum

pattern GL_UNSIGNED_INT = 0x1405 :: GLenum

pattern GL_UNSIGNED_INT16_NV = 0x8FF0 :: GLenum

pattern GL_UNSIGNED_INT16_VEC2_NV = 0x8FF1 :: GLenum

pattern GL_UNSIGNED_INT16_VEC3_NV = 0x8FF2 :: GLenum

pattern GL_UNSIGNED_INT16_VEC4_NV = 0x8FF3 :: GLenum

pattern GL_UNSIGNED_INT64_AMD = 0x8BC2 :: GLenum

pattern GL_UNSIGNED_INT64_ARB = 0x140F :: GLenum

pattern GL_UNSIGNED_INT64_NV = 0x140F :: GLenum

pattern GL_UNSIGNED_INT64_VEC2_ARB = 0x8FF5 :: GLenum

pattern GL_UNSIGNED_INT64_VEC2_NV = 0x8FF5 :: GLenum

pattern GL_UNSIGNED_INT64_VEC3_ARB = 0x8FF6 :: GLenum

pattern GL_UNSIGNED_INT64_VEC3_NV = 0x8FF6 :: GLenum

pattern GL_UNSIGNED_INT64_VEC4_ARB = 0x8FF7 :: GLenum

pattern GL_UNSIGNED_INT64_VEC4_NV = 0x8FF7 :: GLenum

pattern GL_UNSIGNED_INT8_NV = 0x8FEC :: GLenum

pattern GL_UNSIGNED_INT8_VEC2_NV = 0x8FED :: GLenum

pattern GL_UNSIGNED_INT8_VEC3_NV = 0x8FEE :: GLenum

pattern GL_UNSIGNED_INT8_VEC4_NV = 0x8FEF :: GLenum

pattern GL_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B :: GLenum

pattern GL_UNSIGNED_INT_10F_11F_11F_REV_APPLE = 0x8C3B :: GLenum

pattern GL_UNSIGNED_INT_10F_11F_11F_REV_EXT = 0x8C3B :: GLenum

pattern GL_UNSIGNED_INT_10_10_10_2 = 0x8036 :: GLenum

pattern GL_UNSIGNED_INT_10_10_10_2_EXT = 0x8036 :: GLenum

pattern GL_UNSIGNED_INT_10_10_10_2_OES = 0x8DF6 :: GLenum

pattern GL_UNSIGNED_INT_24_8 = 0x84FA :: GLenum

pattern GL_UNSIGNED_INT_24_8_EXT = 0x84FA :: GLenum

pattern GL_UNSIGNED_INT_24_8_MESA = 0x8751 :: GLenum

pattern GL_UNSIGNED_INT_24_8_NV = 0x84FA :: GLenum

pattern GL_UNSIGNED_INT_24_8_OES = 0x84FA :: GLenum

pattern GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368 :: GLenum

pattern GL_UNSIGNED_INT_2_10_10_10_REV_EXT = 0x8368 :: GLenum

pattern GL_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E :: GLenum

pattern GL_UNSIGNED_INT_5_9_9_9_REV_APPLE = 0x8C3E :: GLenum

pattern GL_UNSIGNED_INT_5_9_9_9_REV_EXT = 0x8C3E :: GLenum

pattern GL_UNSIGNED_INT_8_24_REV_MESA = 0x8752 :: GLenum

pattern GL_UNSIGNED_INT_8_8_8_8 = 0x8035 :: GLenum

pattern GL_UNSIGNED_INT_8_8_8_8_EXT = 0x8035 :: GLenum

pattern GL_UNSIGNED_INT_8_8_8_8_REV = 0x8367 :: GLenum

pattern GL_UNSIGNED_INT_8_8_8_8_REV_EXT = 0x8367 :: GLenum

pattern GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = 0x86DB :: GLenum

pattern GL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_1D = 0x9062 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT = 0x9068 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_1D_EXT = 0x9062 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D = 0x9063 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT = 0x9069 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_EXT = 0x9063 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x906C :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT = 0x906B :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT = 0x9065 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_3D = 0x9064 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_3D_EXT = 0x9064 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_BUFFER_EXT = 0x9067 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_BUFFER_OES = 0x9067 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_CUBE = 0x9066 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_CUBE_EXT = 0x9066 :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT = 0x906A :: GLenum

pattern GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_OES = 0x906A :: GLenum

pattern GL_UNSIGNED_INT_S8_S8_8_8_NV = 0x86DA :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_1D = 0x8DD1 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT = 0x8DD6 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_1D_EXT = 0x8DD1 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D = 0x8DD2 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT = 0x8DD7 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D_EXT = 0x8DD2 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910D :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT = 0x8DD5 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_3D = 0x8DD3 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_3D_EXT = 0x8DD3 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD = 0x9003 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT = 0x8DD8 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_BUFFER_OES = 0x8DD8 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_CUBE_EXT = 0x8DD4 :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900F :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900F :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900F :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900F :: GLenum

pattern GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV = 0x8E58 :: GLenum

pattern GL_UNSIGNED_INT_VEC2 = 0x8DC6 :: GLenum

pattern GL_UNSIGNED_INT_VEC2_EXT = 0x8DC6 :: GLenum

pattern GL_UNSIGNED_INT_VEC3 = 0x8DC7 :: GLenum

pattern GL_UNSIGNED_INT_VEC3_EXT = 0x8DC7 :: GLenum

pattern GL_UNSIGNED_INT_VEC4 = 0x8DC8 :: GLenum

pattern GL_UNSIGNED_INT_VEC4_EXT = 0x8DC8 :: GLenum

pattern GL_UNSIGNED_INVERT_NV = 0x8537 :: GLenum

pattern GL_UNSIGNED_NORMALIZED = 0x8C17 :: GLenum

pattern GL_UNSIGNED_NORMALIZED_ARB = 0x8C17 :: GLenum

pattern GL_UNSIGNED_NORMALIZED_EXT = 0x8C17 :: GLenum

pattern GL_UNSIGNED_SHORT = 0x1403 :: GLenum

pattern GL_UNSIGNED_SHORT_15_1_MESA = 0x8753 :: GLenum

pattern GL_UNSIGNED_SHORT_1_15_REV_MESA = 0x8754 :: GLenum

pattern GL_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366 :: GLenum

pattern GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT = 0x8366 :: GLenum

pattern GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033 :: GLenum

pattern GL_UNSIGNED_SHORT_4_4_4_4_EXT = 0x8033 :: GLenum

pattern GL_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365 :: GLenum

pattern GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT = 0x8365 :: GLenum

pattern GL_UNSIGNED_SHORT_4_4_4_4_REV_IMG = 0x8365 :: GLenum

pattern GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034 :: GLenum

pattern GL_UNSIGNED_SHORT_5_5_5_1_EXT = 0x8034 :: GLenum

pattern GL_UNSIGNED_SHORT_5_6_5 = 0x8363 :: GLenum

pattern GL_UNSIGNED_SHORT_5_6_5_EXT = 0x8363 :: GLenum

pattern GL_UNSIGNED_SHORT_5_6_5_REV = 0x8364 :: GLenum

pattern GL_UNSIGNED_SHORT_5_6_5_REV_EXT = 0x8364 :: GLenum

pattern GL_UNSIGNED_SHORT_8_8_APPLE = 0x85BA :: GLenum

pattern GL_UNSIGNED_SHORT_8_8_MESA = 0x85BA :: GLenum

pattern GL_UNSIGNED_SHORT_8_8_REV_APPLE = 0x85BB :: GLenum

pattern GL_UNSIGNED_SHORT_8_8_REV_MESA = 0x85BB :: GLenum

pattern GL_UPPER_LEFT = 0x8CA2 :: GLenum

pattern GL_USE_MISSING_GLYPH_NV = 0x90AA :: GLenum

pattern GL_UTF16_NV = 0x909B :: GLenum

pattern GL_UTF8_NV = 0x909A :: GLenum

pattern GL_V2F = 0x2A20 :: GLenum

pattern GL_V3F = 0x2A21 :: GLenum

pattern GL_VALIDATE_STATUS = 0x8B83 :: GLenum

pattern GL_VARIABLE_A_NV = 0x8523 :: GLenum

pattern GL_VARIABLE_B_NV = 0x8524 :: GLenum

pattern GL_VARIABLE_C_NV = 0x8525 :: GLenum

pattern GL_VARIABLE_D_NV = 0x8526 :: GLenum

pattern GL_VARIABLE_E_NV = 0x8527 :: GLenum

pattern GL_VARIABLE_F_NV = 0x8528 :: GLenum

pattern GL_VARIABLE_G_NV = 0x8529 :: GLenum

pattern GL_VARIANT_ARRAY_EXT = 0x87E8 :: GLenum

pattern GL_VARIANT_ARRAY_POINTER_EXT = 0x87E9 :: GLenum

pattern GL_VARIANT_ARRAY_STRIDE_EXT = 0x87E6 :: GLenum

pattern GL_VARIANT_ARRAY_TYPE_EXT = 0x87E7 :: GLenum

pattern GL_VARIANT_DATATYPE_EXT = 0x87E5 :: GLenum

pattern GL_VARIANT_EXT = 0x87C1 :: GLenum

pattern GL_VARIANT_VALUE_EXT = 0x87E4 :: GLenum

pattern GL_VBO_FREE_MEMORY_ATI = 0x87FB :: GLenum

pattern GL_VECTOR_EXT = 0x87BF :: GLenum

pattern GL_VENDOR = 0x1F00 :: GLenum

pattern GL_VERSION = 0x1F02 :: GLenum

pattern GL_VERSION_ES_CL_1_0 = 1 :: GLenum

pattern GL_VERSION_ES_CL_1_1 = 1 :: GLenum

pattern GL_VERSION_ES_CM_1_1 = 1 :: GLenum

pattern GL_VERTEX23_BIT_PGI = 0x00000004 :: GLbitfield

pattern GL_VERTEX4_BIT_PGI = 0x00000008 :: GLbitfield

pattern GL_VERTEX_ARRAY = 0x8074 :: GLenum

pattern GL_VERTEX_ARRAY_ADDRESS_NV = 0x8F21 :: GLenum

pattern GL_VERTEX_ARRAY_BINDING = 0x85B5 :: GLenum

pattern GL_VERTEX_ARRAY_BINDING_APPLE = 0x85B5 :: GLenum

pattern GL_VERTEX_ARRAY_BINDING_OES = 0x85B5 :: GLenum

pattern GL_VERTEX_ARRAY_BUFFER_BINDING = 0x8896 :: GLenum

pattern GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = 0x8896 :: GLenum

pattern GL_VERTEX_ARRAY_COUNT_EXT = 0x807D :: GLenum

pattern GL_VERTEX_ARRAY_EXT = 0x8074 :: GLenum

pattern GL_VERTEX_ARRAY_KHR = 0x8074 :: GLenum

pattern GL_VERTEX_ARRAY_LENGTH_NV = 0x8F2B :: GLenum

pattern GL_VERTEX_ARRAY_LIST_IBM = 103070 :: GLenum

pattern GL_VERTEX_ARRAY_LIST_STRIDE_IBM = 103080 :: GLenum

pattern GL_VERTEX_ARRAY_OBJECT_AMD = 0x9154 :: GLenum

pattern GL_VERTEX_ARRAY_OBJECT_EXT = 0x9154 :: GLenum

pattern GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F5 :: GLenum

pattern GL_VERTEX_ARRAY_POINTER = 0x808E :: GLenum

pattern GL_VERTEX_ARRAY_POINTER_EXT = 0x808E :: GLenum

pattern GL_VERTEX_ARRAY_RANGE_APPLE = 0x851D :: GLenum

pattern GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = 0x851E :: GLenum

pattern GL_VERTEX_ARRAY_RANGE_LENGTH_NV = 0x851E :: GLenum

pattern GL_VERTEX_ARRAY_RANGE_NV = 0x851D :: GLenum

pattern GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = 0x8521 :: GLenum

pattern GL_VERTEX_ARRAY_RANGE_POINTER_NV = 0x8521 :: GLenum

pattern GL_VERTEX_ARRAY_RANGE_VALID_NV = 0x851F :: GLenum

pattern GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = 0x8533 :: GLenum

pattern GL_VERTEX_ARRAY_SIZE = 0x807A :: GLenum

pattern GL_VERTEX_ARRAY_SIZE_EXT = 0x807A :: GLenum

pattern GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = 0x851F :: GLenum

pattern GL_VERTEX_ARRAY_STRIDE = 0x807C :: GLenum

pattern GL_VERTEX_ARRAY_STRIDE_EXT = 0x807C :: GLenum

pattern GL_VERTEX_ARRAY_TYPE = 0x807B :: GLenum

pattern GL_VERTEX_ARRAY_TYPE_EXT = 0x807B :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY0_NV = 0x8650 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY10_NV = 0x865A :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY11_NV = 0x865B :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY12_NV = 0x865C :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY13_NV = 0x865D :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY14_NV = 0x865E :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY15_NV = 0x865F :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY1_NV = 0x8651 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY2_NV = 0x8652 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY3_NV = 0x8653 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY4_NV = 0x8654 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY5_NV = 0x8655 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY6_NV = 0x8656 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY7_NV = 0x8657 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY8_NV = 0x8658 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY9_NV = 0x8659 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV = 0x8F20 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 0x00000001 :: GLbitfield

pattern GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT = 0x00000001 :: GLbitfield

pattern GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = 0x889F :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE = 0x88FE :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB = 0x88FE :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT = 0x88FE :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV = 0x88FE :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = 0x8622 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT = 0x88FD :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV = 0x88FD :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV = 0x8F2A :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_LONG = 0x874E :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = 0x886A :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = 0x8645 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = 0x8623 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = 0x8624 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = 0x8625 :: GLenum

pattern GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV = 0x8F1E :: GLenum

pattern GL_VERTEX_ATTRIB_BINDING = 0x82D4 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP1_APPLE = 0x8A00 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE = 0x8A03 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE = 0x8A05 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE = 0x8A04 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE = 0x8A02 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP2_APPLE = 0x8A01 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE = 0x8A07 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE = 0x8A09 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE = 0x8A08 :: GLenum

pattern GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE = 0x8A06 :: GLenum

pattern GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5 :: GLenum

pattern GL_VERTEX_BINDING_BUFFER = 0x8F4F :: GLenum

pattern GL_VERTEX_BINDING_DIVISOR = 0x82D6 :: GLenum

pattern GL_VERTEX_BINDING_OFFSET = 0x82D7 :: GLenum

pattern GL_VERTEX_BINDING_STRIDE = 0x82D8 :: GLenum

pattern GL_VERTEX_BLEND_ARB = 0x86A7 :: GLenum

pattern GL_VERTEX_CONSISTENT_HINT_PGI = 0x1A22B :: GLenum

pattern GL_VERTEX_DATA_HINT_PGI = 0x1A22A :: GLenum

pattern GL_VERTEX_ELEMENT_SWIZZLE_AMD = 0x91A4 :: GLenum

pattern GL_VERTEX_ID_NV = 0x8C7B :: GLenum

pattern GL_VERTEX_ID_SWIZZLE_AMD = 0x91A5 :: GLenum

pattern GL_VERTEX_PRECLIP_HINT_SGIX = 0x83EF :: GLenum

pattern GL_VERTEX_PRECLIP_SGIX = 0x83EE :: GLenum

pattern GL_VERTEX_PROGRAM_ARB = 0x8620 :: GLenum

pattern GL_VERTEX_PROGRAM_BINDING_NV = 0x864A :: GLenum

pattern GL_VERTEX_PROGRAM_CALLBACK_DATA_MESA = 0x8BB7 :: GLenum

pattern GL_VERTEX_PROGRAM_CALLBACK_FUNC_MESA = 0x8BB6 :: GLenum

pattern GL_VERTEX_PROGRAM_CALLBACK_MESA = 0x8BB5 :: GLenum

pattern GL_VERTEX_PROGRAM_NV = 0x8620 :: GLenum

pattern GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA2 :: GLenum

pattern GL_VERTEX_PROGRAM_POINT_SIZE = 0x8642 :: GLenum

pattern GL_VERTEX_PROGRAM_POINT_SIZE_ARB = 0x8642 :: GLenum

pattern GL_VERTEX_PROGRAM_POINT_SIZE_NV = 0x8642 :: GLenum

pattern GL_VERTEX_PROGRAM_POSITION_MESA = 0x8BB4 :: GLenum

pattern GL_VERTEX_PROGRAM_TWO_SIDE = 0x8643 :: GLenum

pattern GL_VERTEX_PROGRAM_TWO_SIDE_ARB = 0x8643 :: GLenum

pattern GL_VERTEX_PROGRAM_TWO_SIDE_NV = 0x8643 :: GLenum

pattern GL_VERTEX_SHADER = 0x8B31 :: GLenum

pattern GL_VERTEX_SHADER_ARB = 0x8B31 :: GLenum

pattern GL_VERTEX_SHADER_BINDING_EXT = 0x8781 :: GLenum

pattern GL_VERTEX_SHADER_BIT = 0x00000001 :: GLbitfield

pattern GL_VERTEX_SHADER_BIT_EXT = 0x00000001 :: GLbitfield

pattern GL_VERTEX_SHADER_EXT = 0x8780 :: GLenum

pattern GL_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87CF :: GLenum

pattern GL_VERTEX_SHADER_INVARIANTS_EXT = 0x87D1 :: GLenum

pattern GL_VERTEX_SHADER_INVOCATIONS_ARB = 0x82F0 :: GLenum

pattern GL_VERTEX_SHADER_LOCALS_EXT = 0x87D3 :: GLenum

pattern GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87D2 :: GLenum

pattern GL_VERTEX_SHADER_OPTIMIZED_EXT = 0x87D4 :: GLenum

pattern GL_VERTEX_SHADER_VARIANTS_EXT = 0x87D0 :: GLenum

pattern GL_VERTEX_SOURCE_ATI = 0x8774 :: GLenum

pattern GL_VERTEX_STATE_PROGRAM_NV = 0x8621 :: GLenum

pattern GL_VERTEX_STREAM0_ATI = 0x876C :: GLenum

pattern GL_VERTEX_STREAM1_ATI = 0x876D :: GLenum

pattern GL_VERTEX_STREAM2_ATI = 0x876E :: GLenum

pattern GL_VERTEX_STREAM3_ATI = 0x876F :: GLenum

pattern GL_VERTEX_STREAM4_ATI = 0x8770 :: GLenum

pattern GL_VERTEX_STREAM5_ATI = 0x8771 :: GLenum

pattern GL_VERTEX_STREAM6_ATI = 0x8772 :: GLenum

pattern GL_VERTEX_STREAM7_ATI = 0x8773 :: GLenum

pattern GL_VERTEX_SUBROUTINE = 0x92E8 :: GLenum

pattern GL_VERTEX_SUBROUTINE_UNIFORM = 0x92EE :: GLenum

pattern GL_VERTEX_TEXTURE = 0x829B :: GLenum

pattern GL_VERTEX_WEIGHTING_EXT = 0x8509 :: GLenum

pattern GL_VERTEX_WEIGHT_ARRAY_EXT = 0x850C :: GLenum

pattern GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = 0x8510 :: GLenum

pattern GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = 0x850D :: GLenum

pattern GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = 0x850F :: GLenum

pattern GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = 0x850E :: GLenum

pattern GL_VERTICAL_LINE_TO_NV = 0x08 :: GLubyte

pattern GL_VERTICES_SUBMITTED_ARB = 0x82EE :: GLenum

pattern GL_VIBRANCE_BIAS_NV = 0x8719 :: GLenum

pattern GL_VIBRANCE_SCALE_NV = 0x8713 :: GLenum

pattern GL_VIDEO_BUFFER_BINDING_NV = 0x9021 :: GLenum

pattern GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV = 0x902D :: GLenum

pattern GL_VIDEO_BUFFER_NV = 0x9020 :: GLenum

pattern GL_VIDEO_BUFFER_PITCH_NV = 0x9028 :: GLenum

pattern GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV = 0x903B :: GLenum

pattern GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV = 0x903A :: GLenum

pattern GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV = 0x9039 :: GLenum

pattern GL_VIDEO_CAPTURE_FRAME_WIDTH_NV = 0x9038 :: GLenum

pattern GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV = 0x903C :: GLenum

pattern GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV = 0x9026 :: GLenum

pattern GL_VIDEO_COLOR_CONVERSION_MATRIX_NV = 0x9029 :: GLenum

pattern GL_VIDEO_COLOR_CONVERSION_MAX_NV = 0x902A :: GLenum

pattern GL_VIDEO_COLOR_CONVERSION_MIN_NV = 0x902B :: GLenum

pattern GL_VIDEO_COLOR_CONVERSION_OFFSET_NV = 0x902C :: GLenum

pattern GL_VIEWPORT = 0x0BA2 :: GLenum

pattern GL_VIEWPORT_BIT = 0x00000800 :: GLbitfield

pattern GL_VIEWPORT_BOUNDS_RANGE = 0x825D :: GLenum

pattern GL_VIEWPORT_BOUNDS_RANGE_EXT = 0x825D :: GLenum

pattern GL_VIEWPORT_BOUNDS_RANGE_NV = 0x825D :: GLenum

pattern GL_VIEWPORT_COMMAND_NV = 0x0010 :: GLenum

pattern GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 0x825F :: GLenum

pattern GL_VIEWPORT_INDEX_PROVOKING_VERTEX_EXT = 0x825F :: GLenum

pattern GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = 0x825F :: GLenum

pattern GL_VIEWPORT_POSITION_W_SCALE_NV = 0x937C :: GLenum

pattern GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV = 0x937D :: GLenum

pattern GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV = 0x937E :: GLenum

pattern GL_VIEWPORT_SUBPIXEL_BITS = 0x825C :: GLenum

pattern GL_VIEWPORT_SUBPIXEL_BITS_EXT = 0x825C :: GLenum

pattern GL_VIEWPORT_SUBPIXEL_BITS_NV = 0x825C :: GLenum

pattern GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV = 0x9357 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV = 0x9351 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV = 0x9353 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV = 0x9355 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV = 0x9356 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV = 0x9350 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV = 0x9352 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV = 0x9354 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_W_NV = 0x935B :: GLenum

pattern GL_VIEWPORT_SWIZZLE_X_NV = 0x9358 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_Y_NV = 0x9359 :: GLenum

pattern GL_VIEWPORT_SWIZZLE_Z_NV = 0x935A :: GLenum

pattern GL_VIEW_CLASS_128_BITS = 0x82C4 :: GLenum

pattern GL_VIEW_CLASS_16_BITS = 0x82CA :: GLenum

pattern GL_VIEW_CLASS_24_BITS = 0x82C9 :: GLenum

pattern GL_VIEW_CLASS_32_BITS = 0x82C8 :: GLenum

pattern GL_VIEW_CLASS_48_BITS = 0x82C7 :: GLenum

pattern GL_VIEW_CLASS_64_BITS = 0x82C6 :: GLenum

pattern GL_VIEW_CLASS_8_BITS = 0x82CB :: GLenum

pattern GL_VIEW_CLASS_96_BITS = 0x82C5 :: GLenum

pattern GL_VIEW_CLASS_BPTC_FLOAT = 0x82D3 :: GLenum

pattern GL_VIEW_CLASS_BPTC_UNORM = 0x82D2 :: GLenum

pattern GL_VIEW_CLASS_RGTC1_RED = 0x82D0 :: GLenum

pattern GL_VIEW_CLASS_RGTC2_RG = 0x82D1 :: GLenum

pattern GL_VIEW_CLASS_S3TC_DXT1_RGB = 0x82CC :: GLenum

pattern GL_VIEW_CLASS_S3TC_DXT1_RGBA = 0x82CD :: GLenum

pattern GL_VIEW_CLASS_S3TC_DXT3_RGBA = 0x82CE :: GLenum

pattern GL_VIEW_CLASS_S3TC_DXT5_RGBA = 0x82CF :: GLenum

pattern GL_VIEW_COMPATIBILITY_CLASS = 0x82B6 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_INDEX_ARB = 0x91A7 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_INDEX_EXT = 0x91A7 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_X_AMD = 0x9195 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_X_ARB = 0x9195 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_X_EXT = 0x9195 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_Y_AMD = 0x9196 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_Y_ARB = 0x9196 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_Y_EXT = 0x9196 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_Z_AMD = 0x9197 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_Z_ARB = 0x9197 :: GLenum

pattern GL_VIRTUAL_PAGE_SIZE_Z_EXT = 0x9197 :: GLenum

pattern GL_VIVIDLIGHT_NV = 0x92A6 :: GLenum

pattern GL_VOLATILE_APPLE = 0x8A1A :: GLenum

pattern GL_WAIT_FAILED = 0x911D :: GLenum

pattern GL_WAIT_FAILED_APPLE = 0x911D :: GLenum

pattern GL_WARPS_PER_SM_NV = 0x933A :: GLenum

pattern GL_WARP_SIZE_NV = 0x9339 :: GLenum

pattern GL_WEIGHTED_AVERAGE_ARB = 0x9367 :: GLenum

pattern GL_WEIGHT_ARRAY_ARB = 0x86AD :: GLenum

pattern GL_WEIGHT_ARRAY_BUFFER_BINDING = 0x889E :: GLenum

pattern GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = 0x889E :: GLenum

pattern GL_WEIGHT_ARRAY_BUFFER_BINDING_OES = 0x889E :: GLenum

pattern GL_WEIGHT_ARRAY_OES = 0x86AD :: GLenum

pattern GL_WEIGHT_ARRAY_POINTER_ARB = 0x86AC :: GLenum

pattern GL_WEIGHT_ARRAY_POINTER_OES = 0x86AC :: GLenum

pattern GL_WEIGHT_ARRAY_SIZE_ARB = 0x86AB :: GLenum

pattern GL_WEIGHT_ARRAY_SIZE_OES = 0x86AB :: GLenum

pattern GL_WEIGHT_ARRAY_STRIDE_ARB = 0x86AA :: GLenum

pattern GL_WEIGHT_ARRAY_STRIDE_OES = 0x86AA :: GLenum

pattern GL_WEIGHT_ARRAY_TYPE_ARB = 0x86A9 :: GLenum

pattern GL_WEIGHT_ARRAY_TYPE_OES = 0x86A9 :: GLenum

pattern GL_WEIGHT_SUM_UNITY_ARB = 0x86A6 :: GLenum

pattern GL_WIDE_LINE_HINT_PGI = 0x1A222 :: GLenum

pattern GL_WINDOW_RECTANGLE_EXT = 0x8F12 :: GLenum

pattern GL_WINDOW_RECTANGLE_MODE_EXT = 0x8F13 :: GLenum

pattern GL_WRAP_BORDER_SUN = 0x81D4 :: GLenum

pattern GL_WRITEONLY_RENDERING_QCOM = 0x8823 :: GLenum

pattern GL_WRITE_DISCARD_NV = 0x88BE :: GLenum

pattern GL_WRITE_ONLY = 0x88B9 :: GLenum

pattern GL_WRITE_ONLY_ARB = 0x88B9 :: GLenum

pattern GL_WRITE_ONLY_OES = 0x88B9 :: GLenum

pattern GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = 0x887A :: GLenum

pattern GL_WRITE_PIXEL_DATA_RANGE_NV = 0x8878 :: GLenum

pattern GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = 0x887C :: GLenum

pattern GL_W_EXT = 0x87D8 :: GLenum

pattern GL_XOR = 0x1506 :: GLenum

pattern GL_XOR_NV = 0x1506 :: GLenum

pattern GL_X_EXT = 0x87D5 :: GLenum

pattern GL_YCBAYCR8A_4224_NV = 0x9032 :: GLenum

pattern GL_YCBCR_422_APPLE = 0x85B9 :: GLenum

pattern GL_YCBCR_MESA = 0x8757 :: GLenum

pattern GL_YCBYCR8_422_NV = 0x9031 :: GLenum

pattern GL_YCRCBA_SGIX = 0x8319 :: GLenum

pattern GL_YCRCB_422_SGIX = 0x81BB :: GLenum

pattern GL_YCRCB_444_SGIX = 0x81BC :: GLenum

pattern GL_YCRCB_SGIX = 0x8318 :: GLenum

pattern GL_Y_EXT = 0x87D6 :: GLenum

pattern GL_Z400_BINARY_AMD = 0x8740 :: GLenum

pattern GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV = 0x9036 :: GLenum

pattern GL_Z4Y12Z4CB12Z4CR12_444_NV = 0x9037 :: GLenum

pattern GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV = 0x9035 :: GLenum

pattern GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV = 0x9034 :: GLenum

pattern GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV = 0x9033 :: GLenum

pattern GL_ZERO = 0 :: GLenum

pattern GL_ZERO_EXT = 0x87DD :: GLenum

pattern GL_ZERO_TO_ONE = 0x935F :: GLenum

pattern GL_ZOOM_X = 0x0D16 :: GLenum

pattern GL_ZOOM_Y = 0x0D17 :: GLenum

pattern GL_Z_EXT = 0x87D7 :: GLenum

