/*
 * Copyright (C) 2000-2011  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "funcions.h"

#include <QtGui>


#include "comuns/configuracio.h"
#include "comuns/constants.h"


QString directoriFiguresPersonals(){
    QDir dirArxiu(QDir::homePath ());
    if (!dirArxiu.exists(DIR_ARXIUS_FIGURES_PERSONALS)){
         dirArxiu.mkdir(DIR_ARXIUS_FIGURES_PERSONALS);
      }
 return QDir::homePath ()+QDir().separator()+DIR_ARXIUS_FIGURES_PERSONALS;
}


QString filtreArxiusConcurs(Configuracio *confJoc){
return confJoc->tradueixCadena("Concurs")+" (*."+
                   confJoc->arxiuDadesFigures.mid(0,
                           confJoc->arxiuDadesFigures.lastIndexOf("."))+
                           QString("%1)").arg(confJoc->nivellJoc) ;
}

QString extensioArxiuConcurs(Configuracio *confJoc){
 return "."+confJoc->arxiuDadesFigures.mid(0,
                           confJoc->arxiuDadesFigures.lastIndexOf("."))+
                           QString("%1").arg(confJoc->nivellJoc);
}


/*
Retorna el icone corresponent al nivel de dificultat
de la figura
*/
QIcon iconeFigura(int tipus){
switch(tipus){
     case 1:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"facil.png");
     //  return QIcon(":/images/facil.png");
       break;
     case 2:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"mitja.png");
      // return QIcon(":/images/mitja.png");
       break;
     case 3:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"dificil.png");
    //   return QIcon(":/images/dificil.png");
       break;
     case 4:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"ok.png");
     //  return QIcon(":/images/ok.png");
       break;
     default:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"facil.png");
      // return QIcon(":/images/facil.png");
   }
}

/*
  Directoris linux
 */
QString directoriLinux(){
/*
 printf(QString("Directori %1 \n").arg(QCoreApplication::applicationDirPath()).toAscii());
QString str=QCoreApplication::applicationDirPath().replace(DIRECTORIS_LINUX_PROGRAMA,"");
printf(QString("Directori modificat %1 \n").arg(str).toAscii());
*/

 QString dirInicial=QCoreApplication::applicationDirPath().replace(DIRECTORIS_LINUX_PROGRAMA,"");
 dirInicial=dirInicial.append(DIRECTORIS_LINUX_AUXILIARS);
 QDir dirArxiu;
    if (dirArxiu.exists(DIRECTORIS_LINUX)){
       return DIRECTORIS_LINUX;
    }
    else if (dirArxiu.exists(dirInicial)){
        return dirInicial;
    }
    else return QCoreApplication::applicationDirPath();
}

/*
  13/02/11
  Carrega el contingut de l'arxiu passat per paràmetre
  a una llista (que retorna)
  */
QStringList llegeixArxiuALlista(QString arxiu){
    //obrim l'arxiu de jocs
    QFile arxiuData(arxiu);
    QStringList  dadesArxiu;
    if (arxiuData.open(QIODevice::ReadOnly | QIODevice::Text)){
     QTextStream entrada(&arxiuData);
     QString linia0 = entrada.readLine();
     while (!linia0.isNull()) {
         if ( ! (linia0.mid(0,1)=="#") ){
            dadesArxiu.append(linia0);
         }
       linia0 = entrada.readLine();
     } //final del while de la lectura de l'arxiu
 }
 return dadesArxiu;
}

QString llegeixLiniaArxiu(QString arxiu, int linia){
    //obrim l'arxiu de jocs
    QFile arxiuData(arxiu);
    QString linia0;
    //QString  dadesArxiu;
    if (arxiuData.open(QIODevice::ReadOnly | QIODevice::Text)){
     QTextStream entrada(&arxiuData);
     linia0 = entrada.readLine();
     int numeroLinia=1;
     while ( (!linia0.isNull())
         && (numeroLinia<linia) ) {
         linia0 = entrada.readLine();
         numeroLinia++;
         }
     } //final del while de la lectura de l'arxiu
 return linia0;
}
