/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspectorpanelframe.h"

#include "gtksimplebutton.h"

#include <gtk/gtklabel.h>


enum {
  LAST_SIGNAL
};

enum {
  PROP_0,
  PROP_VALUE,
};


static void g_inspector_panel_frame_set_property (GObject      *object,
						  guint         prop_id,
						  const GValue *value,
						  GParamSpec   *pspec);
static void g_inspector_panel_frame_get_property (GObject      *object,
						  guint         prop_id,
						  GValue       *value,
						  GParamSpec   *pspec);


#if 0
static guint inspector_panel_frame_signals[LAST_SIGNAL] = { 0 };
#endif


G_DEFINE_TYPE (GInspectorPanelFrame, g_inspector_panel_frame, GTK_TYPE_FRAME);


static void
g_inspector_panel_frame_class_init (GInspectorPanelFrameClass *klass)
{
  GObjectClass *gobject_class;
  GtkFrameClass *frame_class;
  GInspectorPanelFrameClass *inspector_panel_frame_class;

  gobject_class = G_OBJECT_CLASS (klass);
  frame_class = (GtkFrameClass*) klass;
  inspector_panel_frame_class = (GInspectorPanelFrameClass*) klass;

  gobject_class->set_property = g_inspector_panel_frame_set_property;
  gobject_class->get_property = g_inspector_panel_frame_get_property;
}

static void
g_inspector_panel_frame_init (GInspectorPanelFrame *inspector_panel_frame)
{
}

static void
g_inspector_panel_frame_set_property (GObject      *object,
				      guint         prop_id,
				      const GValue *value,
				      GParamSpec   *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
g_inspector_panel_frame_get_property (GObject    *object,
				      guint       prop_id,
				      GValue     *value,
				      GParamSpec *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

GtkWidget *
g_inspector_panel_frame_new (void)
{
  GInspectorPanelFrame *panel_frame;

  panel_frame = g_object_new (G_TYPE_INSPECTOR_PANEL_FRAME,
			      NULL);

  return (GtkWidget *)panel_frame;
}

void
g_inspector_panel_frame_set_title (GInspectorPanelFrame *panel_frame,
				   const gchar          *title)
{
  GtkWidget *simple_button;
  GtkWidget *label;


  g_return_if_fail (panel_frame != NULL);
  g_return_if_fail (G_IS_INSPECTOR_PANEL_FRAME (panel_frame));


  simple_button = gtk_simple_button_new ();

  label = gtk_label_new (title);
  gtk_container_add (GTK_CONTAINER (simple_button), label);

  gtk_frame_set_label_widget (GTK_FRAME (panel_frame),
			      simple_button);
}
